"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticbeanstalk_1 = require("monocdk/aws-elasticbeanstalk");
const monocdk_1 = require("monocdk");
/**
 * Elastic Beanstalk environments have managed updates enabled
 * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-elasticbeanstalkmanagedactions
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticbeanstalk_1.CfnEnvironment) {
        const optionSettings = monocdk_1.Stack.of(node).resolve(node.optionSettings);
        if (optionSettings == undefined) {
            return false;
        }
        let foundEnabled = false;
        let foundLevel = false;
        for (const optionSetting of optionSettings) {
            const resolvedOptionSetting = monocdk_1.Stack.of(node).resolve(optionSetting);
            const namespace = resolvedOptionSetting.namespace;
            const optionName = resolvedOptionSetting.optionName;
            const value = resolvedOptionSetting.value;
            if (namespace === 'aws:elasticbeanstalk:managedactions' &&
                optionName === 'ManagedActionsEnabled' &&
                (value === undefined || value === 'true')) {
                foundEnabled = true;
                if (foundLevel) {
                    break;
                }
            }
            else if (namespace === 'aws:elasticbeanstalk:managedactions:platformupdate' &&
                optionName === 'UpdateLevel' &&
                (value === 'minor' || value === 'patch')) {
                foundLevel = true;
                if (foundEnabled) {
                    break;
                }
            }
        }
        if (!foundEnabled || !foundLevel) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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