"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const nag_pack_1 = require("../../nag-pack");
/**
 * ElastiCache Redis clusters retain automatic backups for at least 15 days
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticache_1.CfnCacheCluster) {
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine.toLowerCase());
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (engine == 'redis' && (retention == undefined || retention < 15)) {
            return false;
        }
    }
    else if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (retention == undefined || retention < 15) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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