"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const nag_pack_1 = require("../../nag-pack");
/**
 * ElastiCache clusters do not use the default endpoint ports
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticache_1.CfnCacheCluster) {
        const port = nag_pack_1.resolveIfPrimitive(node, node.port);
        if (port == undefined) {
            return false;
        }
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine);
        if (engine.toLowerCase() == 'redis' && port == 6379) {
            return false;
        }
        else if (engine.toLowerCase() == 'memcached' && port == 11211) {
            return false;
        }
    }
    else if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        const port = nag_pack_1.resolveIfPrimitive(node, node.port);
        if (port == undefined) {
            return false;
        }
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine);
        if ((engine == undefined || engine.toLowerCase() == 'redis') &&
            port == 6379) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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