"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_elasticache_1 = require("monocdk/aws-elasticache");
/**
 * ElastiCache clusters are provisioned in a VPC
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_elasticache_1.CfnCacheCluster ||
        node instanceof aws_elasticache_1.CfnReplicationGroup) {
        if (node.cacheSubnetGroupName == undefined ||
            node.cacheSubnetGroupName.length == 0) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRWxhc3RpQ2FjaGVDbHVzdGVySW5WUEMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcnVsZXMvZWxhc3RpY2FjaGUvRWxhc3RpQ2FjaGVDbHVzdGVySW5WUEMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRiwrQkFBNkI7QUFDN0IsNkRBQStFO0FBRy9FOzs7R0FHRztBQUNILGtCQUFlLE1BQU0sQ0FBQyxjQUFjLENBQ2xDLENBQUMsSUFBaUIsRUFBVyxFQUFFO0lBQzdCLElBQ0UsSUFBSSxZQUFZLGlDQUFlO1FBQy9CLElBQUksWUFBWSxxQ0FBbUIsRUFDbkM7UUFDQSxJQUNFLElBQUksQ0FBQyxvQkFBb0IsSUFBSSxTQUFTO1lBQ3RDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUNyQztZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQyxFQUNELE1BQU0sRUFDTixFQUFFLEtBQUssRUFBRSxZQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQ2xDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IHBhcnNlIH0gZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBDZm5DYWNoZUNsdXN0ZXIsIENmblJlcGxpY2F0aW9uR3JvdXAgfSBmcm9tICdtb25vY2RrL2F3cy1lbGFzdGljYWNoZSc7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuXG4vKipcbiAqIEVsYXN0aUNhY2hlIGNsdXN0ZXJzIGFyZSBwcm92aXNpb25lZCBpbiBhIFZQQ1xuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IE9iamVjdC5kZWZpbmVQcm9wZXJ0eShcbiAgKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiA9PiB7XG4gICAgaWYgKFxuICAgICAgbm9kZSBpbnN0YW5jZW9mIENmbkNhY2hlQ2x1c3RlciB8fFxuICAgICAgbm9kZSBpbnN0YW5jZW9mIENmblJlcGxpY2F0aW9uR3JvdXBcbiAgICApIHtcbiAgICAgIGlmIChcbiAgICAgICAgbm9kZS5jYWNoZVN1Ym5ldEdyb3VwTmFtZSA9PSB1bmRlZmluZWQgfHxcbiAgICAgICAgbm9kZS5jYWNoZVN1Ym5ldEdyb3VwTmFtZS5sZW5ndGggPT0gMFxuICAgICAgKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHRydWU7XG4gIH0sXG4gICduYW1lJyxcbiAgeyB2YWx1ZTogcGFyc2UoX19maWxlbmFtZSkubmFtZSB9XG4pO1xuIl19