"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
const monocdk_1 = require("monocdk");
/**
 * CloudFront distributions use an origin access identity for S3 origins
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.origins != undefined) {
            const origins = monocdk_1.Stack.of(node).resolve(distributionConfig.origins);
            for (const origin of origins) {
                const resolvedOrigin = monocdk_1.Stack.of(node).resolve(origin);
                const resolvedDomainName = monocdk_1.Stack.of(node).resolve(resolvedOrigin.domainName);
                const s3Regex = /^.+\.s3(?:-website)?(?:\..+)?(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))$/;
                if (s3Regex.test(resolvedDomainName)) {
                    if (resolvedOrigin.s3OriginConfig == undefined) {
                        return false;
                    }
                    const resolvedConfig = monocdk_1.Stack.of(node).resolve(resolvedOrigin.s3OriginConfig);
                    if (resolvedConfig.originAccessIdentity == undefined ||
                        resolvedConfig.originAccessIdentity.replace(/\s/g, '').length == 0) {
                        return false;
                    }
                }
            }
        }
    }
    else if (node instanceof aws_cloudfront_1.CfnStreamingDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.streamingDistributionConfig);
        const resolvedOrigin = monocdk_1.Stack.of(node).resolve(distributionConfig.s3Origin);
        if (resolvedOrigin.originAccessIdentity.replace(/\s/g, '').length == 0) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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