"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * CloudFront distributions do not use SSLv3 or TLSv1 for communication to the origin
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.origins != undefined) {
            const origins = monocdk_1.Stack.of(node).resolve(distributionConfig.origins);
            for (const origin of origins) {
                const resolvedOrigin = monocdk_1.Stack.of(node).resolve(origin);
                if (resolvedOrigin.customOriginConfig != undefined) {
                    const customOriginConfig = monocdk_1.Stack.of(node).resolve(resolvedOrigin.customOriginConfig);
                    const originProtocolPolicy = nag_pack_1.resolveIfPrimitive(node, customOriginConfig.originProtocolPolicy);
                    if (originProtocolPolicy != aws_cloudfront_1.OriginProtocolPolicy.HTTPS_ONLY) {
                        return false;
                    }
                    if (customOriginConfig.originSslProtocols == undefined) {
                        return false;
                    }
                    const outdatedValues = [
                        aws_cloudfront_1.SecurityPolicyProtocol.SSL_V3,
                        aws_cloudfront_1.SecurityPolicyProtocol.TLS_V1,
                    ];
                    const originSslProtocols = (monocdk_1.Stack.of(node).resolve(customOriginConfig.originSslProtocols));
                    const lowerCaseProtocols = originSslProtocols.map((i) => {
                        return i.toLowerCase();
                    });
                    for (const outdated of outdatedValues) {
                        if (lowerCaseProtocols.includes(outdated.toLowerCase())) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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