"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const monocdk_1 = require("monocdk");
/**
 * Auto Scaling Groups have notifications for all scaling events configured
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        if (node.notificationConfigurations == undefined) {
            return false;
        }
        const notificationConfigurations = monocdk_1.Stack.of(node).resolve(node.notificationConfigurations);
        const requiredEvents = [
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH,
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH_ERROR,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE_ERROR,
        ];
        return requiredEvents.every((req) => {
            return notificationConfigurations.some((config) => {
                var _a;
                return (_a = config.notificationTypes) === null || _a === void 0 ? void 0 : _a.includes(req);
            });
        });
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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