"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_athena_1 = require("monocdk/aws-athena");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * Athena workgroups encrypt query results
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_athena_1.CfnWorkGroup) {
        const workGroupConfiguration = monocdk_1.Stack.of(node).resolve(node.workGroupConfiguration);
        if (workGroupConfiguration == undefined) {
            const workGroupConfigurationUpdates = monocdk_1.Stack.of(node).resolve(node.workGroupConfigurationUpdates);
            if (workGroupConfigurationUpdates == undefined) {
                return false;
            }
            const resultConfigurationUpdates = monocdk_1.Stack.of(node).resolve(workGroupConfigurationUpdates.resultConfigurationUpdates);
            if (resultConfigurationUpdates != undefined) {
                const removeEncryptionConfiguration = nag_pack_1.resolveIfPrimitive(node, resultConfigurationUpdates.removeEncryptionConfiguration);
                const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfigurationUpdates.encryptionConfiguration);
                const enforceWorkGroupConfiguration = nag_pack_1.resolveIfPrimitive(node, workGroupConfigurationUpdates.enforceWorkGroupConfiguration);
                if (removeEncryptionConfiguration &&
                    encryptionConfiguration == undefined) {
                    return false;
                }
                else if (encryptionConfiguration != undefined &&
                    !enforceWorkGroupConfiguration) {
                    return false;
                }
            }
        }
        else {
            const enforceWorkGroupConfiguration = nag_pack_1.resolveIfPrimitive(node, workGroupConfiguration.enforceWorkGroupConfiguration);
            if (!enforceWorkGroupConfiguration) {
                return false;
            }
            const resultConfiguration = monocdk_1.Stack.of(node).resolve(workGroupConfiguration.resultConfiguration);
            if (resultConfiguration == undefined) {
                return false;
            }
            const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfiguration.encryptionConfiguration);
            if (encryptionConfiguration == undefined) {
                return false;
            }
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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