"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_appsync_1 = require("monocdk/aws-appsync");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../nag-pack");
/**
 * GraphQL APIs have request leveling logging enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_appsync_1.CfnGraphQLApi) {
        const logConfig = monocdk_1.Stack.of(node).resolve(node.logConfig);
        if (logConfig === undefined) {
            return false;
        }
        const excludeVerboseContent = nag_pack_1.resolveIfPrimitive(node, logConfig.excludeVerboseContent);
        if (logConfig.cloudWatchLogsRoleArn === undefined ||
            excludeVerboseContent === true) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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