"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_apigateway_1 = require("monocdk/aws-apigateway");
const monocdk_1 = require("monocdk");
/**
 * API Gateway stages have logging enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_apigateway_1.CfnStage) {
        if (node.methodSettings == undefined) {
            return false;
        }
        const methodSettings = monocdk_1.Stack.of(node).resolve(node.methodSettings);
        let found = false;
        for (const setting of methodSettings) {
            const resolvedSetting = monocdk_1.Stack.of(node).resolve(setting);
            if ((resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.httpMethod) == '*' &&
                (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.resourcePath) == '/*' &&
                ((resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.loggingLevel) == aws_apigateway_1.MethodLoggingLevel.ERROR ||
                    (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.loggingLevel) == aws_apigateway_1.MethodLoggingLevel.INFO)) {
                found = true;
                break;
            }
        }
        if (!found) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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