"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_apigateway_1 = require("monocdk/aws-apigateway");
const aws_apigatewayv2_1 = require("monocdk/aws-apigatewayv2");
const nag_pack_1 = require("../../nag-pack");
/**
 * APIs implement authorization
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_apigateway_1.CfnMethod || node instanceof aws_apigatewayv2_1.CfnRoute) {
        const authorizationType = nag_pack_1.resolveIfPrimitive(node, node.authorizationType);
        if (authorizationType == undefined ||
            authorizationType == aws_apigateway_1.AuthorizationType.NONE) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVBJR1dBdXRob3JpemF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3J1bGVzL2FwaWd3L0FQSUdXQXV0aG9yaXphdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLCtCQUE2QjtBQUM3QiwyREFBc0U7QUFDdEUsK0RBQW9EO0FBRXBELDZDQUFvRDtBQUVwRDs7O0dBR0c7QUFDSCxrQkFBZSxNQUFNLENBQUMsY0FBYyxDQUNsQyxDQUFDLElBQWlCLEVBQVcsRUFBRTtJQUM3QixJQUFJLElBQUksWUFBWSwwQkFBUyxJQUFJLElBQUksWUFBWSwyQkFBUSxFQUFFO1FBQ3pELE1BQU0saUJBQWlCLEdBQUcsNkJBQWtCLENBQzFDLElBQUksRUFDSixJQUFJLENBQUMsaUJBQWlCLENBQ3ZCLENBQUM7UUFDRixJQUNFLGlCQUFpQixJQUFJLFNBQVM7WUFDOUIsaUJBQWlCLElBQUksa0NBQWlCLENBQUMsSUFBSSxFQUMzQztZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQyxFQUNELE1BQU0sRUFDTixFQUFFLEtBQUssRUFBRSxZQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQ2xDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IHBhcnNlIH0gZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBBdXRob3JpemF0aW9uVHlwZSwgQ2ZuTWV0aG9kIH0gZnJvbSAnbW9ub2Nkay9hd3MtYXBpZ2F0ZXdheSc7XG5pbXBvcnQgeyBDZm5Sb3V0ZSB9IGZyb20gJ21vbm9jZGsvYXdzLWFwaWdhdGV3YXl2Mic7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIEFQSXMgaW1wbGVtZW50IGF1dGhvcml6YXRpb25cbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBPYmplY3QuZGVmaW5lUHJvcGVydHkoXG4gIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4gPT4ge1xuICAgIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuTWV0aG9kIHx8IG5vZGUgaW5zdGFuY2VvZiBDZm5Sb3V0ZSkge1xuICAgICAgY29uc3QgYXV0aG9yaXphdGlvblR5cGUgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICAgIG5vZGUsXG4gICAgICAgIG5vZGUuYXV0aG9yaXphdGlvblR5cGVcbiAgICAgICk7XG4gICAgICBpZiAoXG4gICAgICAgIGF1dGhvcml6YXRpb25UeXBlID09IHVuZGVmaW5lZCB8fFxuICAgICAgICBhdXRob3JpemF0aW9uVHlwZSA9PSBBdXRob3JpemF0aW9uVHlwZS5OT05FXG4gICAgICApIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gdHJ1ZTtcbiAgfSxcbiAgJ25hbWUnLFxuICB7IHZhbHVlOiBwYXJzZShfX2ZpbGVuYW1lKS5uYW1lIH1cbik7XG4iXX0=