"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_apigateway_1 = require("monocdk/aws-apigateway");
const aws_apigatewayv2_1 = require("monocdk/aws-apigatewayv2");
const monocdk_1 = require("monocdk");
/**
 * APIs have access logging enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_apigateway_1.CfnStage) {
        if (node.accessLogSetting == undefined) {
            return false;
        }
        const accessLogSetting = monocdk_1.Stack.of(node).resolve(node.accessLogSetting);
        if (accessLogSetting.destinationArn == undefined ||
            accessLogSetting.format == undefined) {
            return false;
        }
    }
    else if (node instanceof aws_apigatewayv2_1.CfnStage) {
        if (node.accessLogSettings == undefined) {
            return false;
        }
        const accessLogSetting = monocdk_1.Stack.of(node).resolve(node.accessLogSettings);
        if (accessLogSetting.destinationArn == undefined ||
            accessLogSetting.format == undefined) {
            return false;
        }
    }
    return true;
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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