"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwIfNotJSONExt = exports.handleFile = exports.readFromPath = exports.writeToPath = exports.emptyDirectory = void 0;
const path = __importStar(require("path"));
const fs = require('fs-extra');
async function emptyDirectory(directory) {
    const pathExists = await fs.exists(directory);
    if (!pathExists) {
        return;
    }
    const dirStats = await fs.lstat(directory);
    if (!dirStats.isDirectory()) {
        return;
    }
    const files = await fs.readdir(directory);
    for (const fileName of files) {
        const fullPath = path.join(directory, fileName);
        await fs.remove(fullPath);
    }
}
exports.emptyDirectory = emptyDirectory;
async function writeToPath(directory, obj) {
    if (Array.isArray(obj)) {
        await fs.ensureDir(directory);
        for (let i = 0; i < obj.length; i++) {
            const newDir = path.join(directory, `${i}`);
            await writeToPath(newDir, obj[i]);
        }
    }
    else if (typeof obj === 'object') {
        await fs.ensureDir(directory);
        for (const key of Object.keys(obj)) {
            const newDir = path.join(directory, key);
            await writeToPath(newDir, obj[key]);
        }
    }
    else if (typeof obj === 'string') {
        fs.writeFileSync(directory, obj);
    }
}
exports.writeToPath = writeToPath;
async function readFromPath(directory) {
    const pathExists = await fs.exists(directory);
    if (!pathExists) {
        return;
    }
    const dirStats = await fs.lstat(directory);
    if (!dirStats.isDirectory()) {
        const buf = await fs.readFile(directory);
        return buf.toString();
    }
    const files = await fs.readdir(directory);
    const accum = {};
    for (const fileName of files) {
        const fullPath = path.join(directory, fileName);
        const value = await readFromPath(fullPath);
        accum[fileName] = value;
    }
    return accum;
}
exports.readFromPath = readFromPath;
async function handleFile(handler, key, body, backoffMS = 500, numTries = 3) {
    try {
        return await handler({
            Key: key,
            Body: body,
        });
    }
    catch (e) {
        if (numTries > 0) {
            await new Promise((res, rej) => setTimeout(() => res(), backoffMS));
            await handleFile(handler, key, body, backoffMS * 2, numTries - 1);
        }
        throw e;
    }
}
exports.handleFile = handleFile;
function throwIfNotJSONExt(stackFile) {
    const extension = path.extname(stackFile);
    if (extension === '.yaml' || extension === '.yml') {
        throw new Error(`Yaml is not yet supported. Please convert the CloudFormation stack ${stackFile} to json.`);
    }
    if (extension !== '.json') {
        throw new Error(`Invalid extension ${extension} for stack ${stackFile}`);
    }
}
exports.throwIfNotJSONExt = throwIfNotJSONExt;
//# sourceMappingURL=fileUtils.js.map