"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RelationalDBResolverGenerator = void 0;
const cloudform_types_1 = require("cloudform-types");
const appSync_1 = __importDefault(require("cloudform-types/types/appSync"));
const graphql_mapping_template_1 = require("graphql-mapping-template");
const graphql_transformer_common_1 = require("graphql-transformer-common");
const ResourceConstants_1 = require("./ResourceConstants");
const RelationalDBMappingTemplate_1 = require("./RelationalDBMappingTemplate");
const fs = __importStar(require("fs-extra"));
const s3BaseUrl = 's3://${S3DeploymentBucket}/${S3DeploymentRootKey}/resolvers/${ResolverFileName}';
const resolverFileName = 'ResolverFileName';
const rdsResponseErrorMessage = 'Invalid response from RDS DataSource. See info for the full response.';
const rdsResponseErrorType = 'InvalidResponse';
class RelationalDBResolverGenerator {
    constructor(context) {
        this.document = context.schemaDoc;
        this.typePrimaryKeyMap = context.typePrimaryKeyMap;
        this.stringFieldMap = context.stringFieldMap;
        this.intFieldMap = context.intFieldMap;
        this.typePrimaryKeyTypeMap = context.typePrimaryKeyTypeMap;
    }
    createRelationalResolvers(resolverFilePath) {
        let resources = {};
        this.resolverFilePath = resolverFilePath;
        this.typePrimaryKeyMap.forEach((value, key) => {
            const resourceName = key.replace(/[^A-Za-z0-9]/g, '');
            resources = {
                ...resources,
                ...{ [resourceName + 'CreateResolver']: this.makeCreateRelationalResolver(key) },
                ...{ [resourceName + 'GetResolver']: this.makeGetRelationalResolver(key) },
                ...{ [resourceName + 'UpdateResolver']: this.makeUpdateRelationalResolver(key) },
                ...{ [resourceName + 'DeleteResolver']: this.makeDeleteRelationalResolver(key) },
                ...{ [resourceName + 'ListResolver']: this.makeListRelationalResolver(key) },
            };
        });
        return resources;
    }
    makeCreateRelationalResolver(type, mutationTypeName = 'Mutation') {
        const fieldName = graphql_transformer_common_1.graphqlName('create' + graphql_transformer_common_1.toUpper(type));
        let createSql = `INSERT INTO ${type} $colStr VALUES $valStr`;
        let selectSql;
        if (this.typePrimaryKeyTypeMap.get(type).includes('String')) {
            selectSql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=\'$ctx.args.create${graphql_transformer_common_1.toUpper(type)}Input.${this.typePrimaryKeyMap.get(type)}\'`;
        }
        else {
            selectSql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=$ctx.args.create${graphql_transformer_common_1.toUpper(type)}Input.${this.typePrimaryKeyMap.get(type)}`;
        }
        const reqFileName = `${mutationTypeName}.${fieldName}.req.vtl`;
        const resFileName = `${mutationTypeName}.${fieldName}.res.vtl`;
        const reqTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('cols'), graphql_mapping_template_1.list([])),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('vals'), graphql_mapping_template_1.list([])),
            graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('entry'), graphql_mapping_template_1.ref(`ctx.args.create${graphql_transformer_common_1.toUpper(type)}Input.keySet()`), [
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('discard'), graphql_mapping_template_1.ref(`cols.add($entry)`)),
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('discard'), graphql_mapping_template_1.ref(`vals.add("'$ctx.args.create${graphql_transformer_common_1.toUpper(type)}Input[$entry]'")`)),
            ]),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('valStr'), graphql_mapping_template_1.ref('vals.toString().replace("[","(").replace("]",")")')),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('colStr'), graphql_mapping_template_1.ref('cols.toString().replace("[","(").replace("]",")")')),
            RelationalDBMappingTemplate_1.RelationalDBMappingTemplate.rdsQuery({
                statements: graphql_mapping_template_1.list([graphql_mapping_template_1.str(createSql), graphql_mapping_template_1.str(selectSql)]),
            }),
        ]));
        const resTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.ref('utils.toJson($utils.parseJson($utils.rds.toJsonString($ctx.result))[1][0])'));
        fs.writeFileSync(`${this.resolverFilePath}/${reqFileName}`, reqTemplate, 'utf8');
        fs.writeFileSync(`${this.resolverFilePath}/${resFileName}`, resTemplate, 'utf8');
        let resolver = new appSync_1.default.Resolver({
            ApiId: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.AppSyncApiId),
            DataSourceName: cloudform_types_1.Fn.GetAtt(ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource, 'Name'),
            TypeName: mutationTypeName,
            FieldName: fieldName,
            RequestMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: reqFileName,
            }),
            ResponseMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: resFileName,
            }),
        }).dependsOn([ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource]);
        return resolver;
    }
    makeGetRelationalResolver(type, queryTypeName = 'Query') {
        const fieldName = graphql_transformer_common_1.graphqlName('get' + graphql_transformer_common_1.toUpper(type));
        let sql;
        if (this.typePrimaryKeyTypeMap.get(type).includes('String')) {
            sql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=\'$ctx.args.${this.typePrimaryKeyMap.get(type)}\'`;
        }
        else {
            sql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=$ctx.args.${this.typePrimaryKeyMap.get(type)}`;
        }
        const reqFileName = `${queryTypeName}.${fieldName}.req.vtl`;
        const resFileName = `${queryTypeName}.${fieldName}.res.vtl`;
        const reqTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            RelationalDBMappingTemplate_1.RelationalDBMappingTemplate.rdsQuery({
                statements: graphql_mapping_template_1.list([graphql_mapping_template_1.str(sql)]),
            }),
        ]));
        const resTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('output'), graphql_mapping_template_1.ref('utils.rds.toJsonObject($ctx.result)')),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('output.isEmpty()'), graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('util.error'), graphql_mapping_template_1.str(rdsResponseErrorMessage), graphql_mapping_template_1.str(rdsResponseErrorType), graphql_mapping_template_1.obj({}), graphql_mapping_template_1.ref('output'))),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('output'), graphql_mapping_template_1.ref('output[0]')),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('output.isEmpty()'), graphql_mapping_template_1.ret()),
            graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('utils.toJson'), graphql_mapping_template_1.ref('output[0]')),
        ]));
        fs.writeFileSync(`${this.resolverFilePath}/${reqFileName}`, reqTemplate, 'utf8');
        fs.writeFileSync(`${this.resolverFilePath}/${resFileName}`, resTemplate, 'utf8');
        let resolver = new appSync_1.default.Resolver({
            ApiId: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.AppSyncApiId),
            DataSourceName: cloudform_types_1.Fn.GetAtt(ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource, 'Name'),
            FieldName: fieldName,
            TypeName: queryTypeName,
            RequestMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: reqFileName,
            }),
            ResponseMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: resFileName,
            }),
        }).dependsOn([ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource]);
        return resolver;
    }
    makeUpdateRelationalResolver(type, mutationTypeName = 'Mutation') {
        const fieldName = graphql_transformer_common_1.graphqlName('update' + graphql_transformer_common_1.toUpper(type));
        const updateSql = `UPDATE ${type} SET $update WHERE ${this.typePrimaryKeyMap.get(type)}=$ctx.args.update${graphql_transformer_common_1.toUpper(type)}Input.${this.typePrimaryKeyMap.get(type)}`;
        let selectSql;
        if (this.typePrimaryKeyTypeMap.get(type).includes('String')) {
            selectSql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=\'$ctx.args.update${graphql_transformer_common_1.toUpper(type)}Input.${this.typePrimaryKeyMap.get(type)}\'`;
        }
        else {
            selectSql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=$ctx.args.update${graphql_transformer_common_1.toUpper(type)}Input.${this.typePrimaryKeyMap.get(type)}`;
        }
        const reqFileName = `${mutationTypeName}.${fieldName}.req.vtl`;
        const resFileName = `${mutationTypeName}.${fieldName}.res.vtl`;
        const reqTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('updateList'), graphql_mapping_template_1.obj({})),
            graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('entry'), graphql_mapping_template_1.ref(`ctx.args.update${graphql_transformer_common_1.toUpper(type)}Input.keySet()`), [
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('discard'), graphql_mapping_template_1.ref(`updateList.put($entry, "'$ctx.args.update${graphql_transformer_common_1.toUpper(type)}Input[$entry]'")`)),
            ]),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('update'), graphql_mapping_template_1.ref(`updateList.toString().replace("{","").replace("}","")`)),
            RelationalDBMappingTemplate_1.RelationalDBMappingTemplate.rdsQuery({
                statements: graphql_mapping_template_1.list([graphql_mapping_template_1.str(updateSql), graphql_mapping_template_1.str(selectSql)]),
            }),
        ]));
        const resTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('output'), graphql_mapping_template_1.ref('utils.rds.toJsonObject($ctx.result)')),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('output.length() < 2'), graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('util.error'), graphql_mapping_template_1.str(rdsResponseErrorMessage), graphql_mapping_template_1.str(rdsResponseErrorType), graphql_mapping_template_1.obj({}), graphql_mapping_template_1.ref('output'))),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('output'), graphql_mapping_template_1.ref('output[1]')),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('output.isEmpty()'), graphql_mapping_template_1.ret()),
            graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('utils.toJson'), graphql_mapping_template_1.ref('output[0]')),
        ]));
        fs.writeFileSync(`${this.resolverFilePath}/${reqFileName}`, reqTemplate, 'utf8');
        fs.writeFileSync(`${this.resolverFilePath}/${resFileName}`, resTemplate, 'utf8');
        let resolver = new appSync_1.default.Resolver({
            ApiId: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.AppSyncApiId),
            DataSourceName: cloudform_types_1.Fn.GetAtt(ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource, 'Name'),
            TypeName: mutationTypeName,
            FieldName: fieldName,
            RequestMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: reqFileName,
            }),
            ResponseMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: resFileName,
            }),
        }).dependsOn([ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource]);
        return resolver;
    }
    makeDeleteRelationalResolver(type, mutationTypeName = 'Mutation') {
        const fieldName = graphql_transformer_common_1.graphqlName('delete' + graphql_transformer_common_1.toUpper(type));
        let selectSql;
        if (this.typePrimaryKeyTypeMap.get(type).includes('String')) {
            selectSql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=\'$ctx.args.${this.typePrimaryKeyMap.get(type)}\'`;
        }
        else {
            selectSql = `SELECT * FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=$ctx.args.${this.typePrimaryKeyMap.get(type)}`;
        }
        const deleteSql = `DELETE FROM ${type} WHERE ${this.typePrimaryKeyMap.get(type)}=$ctx.args.${this.typePrimaryKeyMap.get(type)}`;
        const reqFileName = `${mutationTypeName}.${fieldName}.req.vtl`;
        const resFileName = `${mutationTypeName}.${fieldName}.res.vtl`;
        const reqTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            RelationalDBMappingTemplate_1.RelationalDBMappingTemplate.rdsQuery({
                statements: graphql_mapping_template_1.list([graphql_mapping_template_1.str(selectSql), graphql_mapping_template_1.str(deleteSql)]),
            }),
        ]));
        const resTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('output'), graphql_mapping_template_1.ref('utils.rds.toJsonObject($ctx.result)')),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('output.isEmpty()'), graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('util.error'), graphql_mapping_template_1.str(rdsResponseErrorMessage), graphql_mapping_template_1.str(rdsResponseErrorType), graphql_mapping_template_1.obj({}), graphql_mapping_template_1.ref('output'))),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('output'), graphql_mapping_template_1.ref('output[0]')),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('output.isEmpty()'), graphql_mapping_template_1.ret()),
            graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('utils.toJson'), graphql_mapping_template_1.ref('output[0]')),
        ]));
        fs.writeFileSync(`${this.resolverFilePath}/${reqFileName}`, reqTemplate, 'utf8');
        fs.writeFileSync(`${this.resolverFilePath}/${resFileName}`, resTemplate, 'utf8');
        let resolver = new appSync_1.default.Resolver({
            ApiId: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.AppSyncApiId),
            DataSourceName: cloudform_types_1.Fn.GetAtt(ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource, 'Name'),
            TypeName: mutationTypeName,
            FieldName: fieldName,
            RequestMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: reqFileName,
            }),
            ResponseMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: resFileName,
            }),
        }).dependsOn([ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource]);
        return resolver;
    }
    makeListRelationalResolver(type, queryTypeName = 'Query') {
        const fieldName = graphql_transformer_common_1.graphqlName('list' + graphql_transformer_common_1.plurality(graphql_transformer_common_1.toUpper(type)));
        const sql = `SELECT * FROM ${type}`;
        const reqFileName = `${queryTypeName}.${fieldName}.req.vtl`;
        const resFileName = `${queryTypeName}.${fieldName}.res.vtl`;
        const reqTemplate = graphql_mapping_template_1.print(RelationalDBMappingTemplate_1.RelationalDBMappingTemplate.rdsQuery({
            statements: graphql_mapping_template_1.list([graphql_mapping_template_1.str(sql)]),
        }));
        const resTemplate = graphql_mapping_template_1.print(graphql_mapping_template_1.ref('utils.toJson($utils.rds.toJsonObject($ctx.result)[0])'));
        fs.writeFileSync(`${this.resolverFilePath}/${reqFileName}`, reqTemplate, 'utf8');
        fs.writeFileSync(`${this.resolverFilePath}/${resFileName}`, resTemplate, 'utf8');
        let resolver = new appSync_1.default.Resolver({
            ApiId: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.AppSyncApiId),
            DataSourceName: cloudform_types_1.Fn.GetAtt(ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource, 'Name'),
            TypeName: queryTypeName,
            FieldName: fieldName,
            RequestMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: reqFileName,
            }),
            ResponseMappingTemplateS3Location: cloudform_types_1.Fn.Sub(s3BaseUrl, {
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                [ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: cloudform_types_1.Fn.Ref(ResourceConstants_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
                [resolverFileName]: resFileName,
            }),
        }).dependsOn([ResourceConstants_1.ResourceConstants.RESOURCES.RelationalDatabaseDataSource]);
        return resolver;
    }
}
exports.RelationalDBResolverGenerator = RelationalDBResolverGenerator;
//# sourceMappingURL=RelationalDBResolverGenerator.js.map