from botty_core.types import PTBHandler, Query, User
from telegram import ext

from botty.buttons import CallbackButton
from botty.errors import CallbackDataError
from botty.keyboards import InlineKeyboard

from .message_or_query import MessageOrQueryHandler


class QueryHandler(MessageOrQueryHandler):
    def __init__(
        self,
        button: CallbackButton | None = None,
        reply_text: str | None = None,
        reply_keyboard: InlineKeyboard | None = None,
    ) -> None:
        if button is None:
            callback_data = None
        else:
            callback_data = button.callback_data
            validate_callback_data(callback_data)

        self.on_callback_data = callback_data
        super().__init__(reply_text, reply_keyboard)

    async def callback(self) -> None:
        await super().callback()
        await self.answer()

    def build(self) -> PTBHandler:
        return ext.CallbackQueryHandler(self.handle, self._filter)

    def _filter(self, callback_data: object) -> bool:
        validate_callback_data(callback_data)
        if self.on_callback_data is None:
            return True
        return callback_data == self.on_callback_data

    async def answer(self, text: str = "", *, show_alert: bool = False) -> bool:
        return await self.query.answer(text, show_alert=show_alert)

    @property
    def query(self) -> Query:
        return self.update.query

    @property
    def user(self) -> User:
        return self.query.user


def validate_callback_data(callback_data: object) -> None:
    if not isinstance(callback_data, str):
        raise CallbackDataError(callback_data)
