# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nislmigrate',
 'nislmigrate.extensibility',
 'nislmigrate.facades',
 'nislmigrate.logs',
 'nislmigrate.migrators',
 'nislmigrate.utility']

package_data = \
{'': ['*']}

install_requires = \
['argparse>=1.4.0,<2.0.0',
 'cryptography>=35.0.0,<36.0.0',
 'pymongo>=3.12.1,<4.0.0']

entry_points = \
{'console_scripts': ['nislmigrate = nislmigrate.migration_tool:main']}

setup_kwargs = {
    'name': 'nislmigrate',
    'version': '1.0.0',
    'description': 'The tool for migrating SystemLink data.',
    'long_description': "# NI-SystemLink-Migration tool `nislmigrate`\n`nislmigrate` is a command line utility for migration, backup, and restore of supported SystemLink services.\n\n### Prerequisites\n#### 1. SystemLink\n- This tool offically supports migration between SystemLink versions 21.0, 21.1, 21.3, & 21.5. Other versions have not been tested.\n- **We assume the server you are migrating to is clean with no data. Migrating to a server with existing data will result in data loss.**\n- Services that are supported with any caveats and exceptions are detailed in the **Supported Services** section below.\n- This tool assumes a single-box SystemLink installation.\n- This tool must be run on the same machines as the SystemLink installations.\n#### 2. Python\n- This tool requires [Python 3.8](https://www.python.org/downloads/release/python-3811/) to run.\n- The documentation in this repository assumes Python has been added to your [**PATH**](https://datatofish.com/add-python-to-windows-path/).\n### Installation\nThe latest released version of the tool can be installed by running:\n```bash\npip install nislmigrate\n```\n# Usage\n### Backup\n\nTo backup the data for a service listed in the **Supported Services** section run the tool with elevated permissions and use the `capture` option with the corresponding flag for each of the services you want to back up (e.g. `--security`):\n```bash\nnislmigrate capture --security\n```\nThis will backup the data corresponding with each service into the default migration directory (`C:\\Users\\[user]\\Documents\\migration\\`). You can specify a different migration directory using the `--dir [path]` option:\n```bash\nnislmigrate capture --security --dir C:\\custom-backup-location\n```\nTo backup the data for all supported services at once, the `--all` flag can be used instead of listing out each individual service. Using `--all` will require that you include the `--secret` flag for services that require encrypting backed up data for security:\n```bash\nnislmigrate capture --all --secret <password>\n```\n\n### Restore\n\n> :warning: Restoring requires the `--force` flag to explicitly allow overwriting the existing data on the server. Without it, the command will fail.\n\nTo restore the data for a service listed in the **Supported Services** section run the tool with elevated permissions and  use the `restore` option with the corresponding flag for each of the services you want to restore (e.g. `--security`):\n```bash\nnislmigrate restore --security\n```\nThis will restore the data corresponding with each service from the default migration directory (`C:\\Users\\[user]\\Documents\\migration\\`). If your captured data is in a different directory that can be specified with the `--dir [path]` option:\n```bash\nnislmigrate restore --security --dir C:\\custom-backup-location\n```\nTo restore the data for all supported services at once, the `--all` flag can be used instead of listing out each individual service. Using `--all` will require that you include the `--secret` flag for services that require encrypting backed up data for security:\n```bash\nnislmigrate restore --all --secret <password>\n```\n\n### Migration\n>:warning: Server A must be a clean SystemLink installation, any existing data will be deleted.\n\nTo migrate from one SystemLink server instance (`server A`) to a different instance (`server B`):\n1. Install the migration tool on `server A` and `server B`.\n1. Follow the backup instructions to backup the data from `server A`.\n1. Copy the data produced by the backup of `server A` on `server B`.\n1. **_Warning:_** Ensure `server B` is a clean SystemLink installation, any existing data will be deleted.\n1. Follow the restore instructions to restore the backed up data onto `server B`.\n\n# Development\nSee `CONTRIBUTING.MD` for detailed instructions on developing, testing, and releasing the tool.\n\n# Supported Services\nThe services that can be migrated with this utility along with short descriptions can be listed by running:\n```bash\nnislmigrate capture -h\n```\n\nMost services require migrating the `--security` service at the same time for the migration to be successful, and some services have additional dependencies which are listed in the table below.  \n\n| **Supported Service**                     | **Argument Flag** | **Also requires migrating** | **Additional Notes**                                                                                                                                                                                                                                                                                                                                                                             |\n|---------------------------------|-------------------|-----------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| Security                        | `--security`      |                             |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| User Data                       | `--userdata`      | `--security`                |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| Notifications                   | `--notification`  | `--security`                |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| File Ingestion                  | `--files`         | `--security`                | - Must migrate file to the same storage location on the new System Link server.<br>- To capture/restore only the database but not the files themselves, use `--files --files-metadata-only`. This could be useful if, for example, files are stored on a file server with separate backup.<br>- If files are stored in Amazon Simple Storage Service (S3), use `--files --files-metadata-only`.<br>- If the file store path is different on the server you are restoring to, use the '--change-file-store-root [NEW_ROOT]' flag to update the metadata during a restore operation.   |\n| Repository                      | `--repo`          | `--security`                | - Feeds may require additional updates if servers used for migration have different domain names                                                                                                                                                                                                                                                                                                 |\n| Dashboards and Web Applications | `--dashboards`    | `--security`                |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| System States                   | `--systemstates`  | `--security`                | - Feeds may require additional updates if servers used for migration have different domain names<br>- Cannot be migrated between 2020R1 and 2020R2 servers                                                                                                                                                                                                                                       |\n| Tag Ingestion and Tag History   | `--tags`          | `--security`                |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| Tag Alarm Rules                 | `--tagrule`       | `--security`<br>`--notification` |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| Alarm Instances                 | `--alarms`        | `--security`<br>`--notification` | - Cannot be migrated between 2020R1 and 2020R2 servers                                                                                                                                                                                                                                                                                                                                           |\n| Asset Alarm Rules               | `--assetrule`     | `--security`<br>`--notification` |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| Asset Management                | `--assets`        | `--security`<br>`--files`<br>`--tags`        |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| Test Monitor                    | `--tests`         | `--security`<br>`--file`         |                                                                                                                                                                                                                                                                                                                                                                                                  |\n| Systems                         | `--systems`       | `--security`<br>`--tags`<br>`--file`  | - _WARNING:_ Captured systems data contains encrypted secret information and should not be copied to a publicly accessible location.<br>- To capture/restore systems, a secret must be provided using the `--secret <SECRET>` command line flag. Captured systems data will require the same secret to be provided as was provided during capture in order to be able to decrypt sensitive data. |\n\nThere are plans to support the following services in the future:\n- OPC UA Client: `--opc`\n- TDM `--tdm`\n- Cloud Connector `--cloud`\n",
    'author': 'cnunnall',
    'author_email': 'christian.nunnally@ni.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.8,<4.0.0',
}


setup(**setup_kwargs)
