import { Construct } from '@aws-cdk/core';
export interface Approvers {
    readonly numberOfApprovalsNeeded: number;
    readonly approvalPoolMembers?: string;
}
export interface Template {
    readonly branches?: string[];
    readonly approvers: Approvers;
}
export interface ApprovalRuleTemplateProps {
    /**
     * The name of the approval rule template.
     */
    readonly approvalRuleTemplateName: string;
    /**
     * The description of the approval rule template
     */
    readonly approvalRuleTemplateDescription?: string;
    /**
     * The content of the approval rule that is created on pull requests in associated repositories.
     */
    readonly template: Template;
}
export declare class ApprovalRuleTemplate extends Construct {
    readonly approvalRuleTemplateName: string;
    constructor(scope: Construct, id: string, props: ApprovalRuleTemplateProps);
}
