"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplateRepositoryAssociation = void 0;
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplateRepositoryAssociation extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repository = props.repository;
        const resourceType = 'Custom::ApprovalRuleTemplateRepositoryAssociation';
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: directories_1.approvalRuleTemplateRepositoryAssociationDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:AssociateApprovalRuleTemplateWithRepository',
                        'codecommit:DisassociateApprovalRuleTemplateFromRepository',
                    ],
                    Resource: this.repository.repositoryArn,
                },
            ],
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType,
            properties: {
                ApprovalRuleTemplateName: props.approvalRuleTemplateName,
                RepositoryName: this.repository.repositoryName,
            },
        });
    }
    onOverridden(id, options) {
        const rule = this.repository.onPullRequestStateChange(id, options);
        rule.addEventPattern({
            detail: {
                event: ['pullRequestApprovalRuleOverridden'],
            },
        });
        return rule;
    }
}
exports.ApprovalRuleTemplateRepositoryAssociation = ApprovalRuleTemplateRepositoryAssociation;
//# sourceMappingURL=data:application/json;base64,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