"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCollaborator = exports.CfnCollaboratorPropsPermission = exports.toJson_CfnCollaboratorProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnCollaboratorProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnCollaboratorProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Owner': obj.owner,
        'Repository': obj.repository,
        'Username': obj.username,
        'Permission': obj.permission,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnCollaboratorProps = toJson_CfnCollaboratorProps;
/* eslint-enable max-len, quote-props */
/**
 * The permission to grant the collaborator. Only valid on organization-owned repositories. In addition to the enumerated values, you can also specify a custom repository role name, if the owning organization has defined any..
 *
 * @schema CfnCollaboratorPropsPermission
 */
var CfnCollaboratorPropsPermission;
(function (CfnCollaboratorPropsPermission) {
    /** pull */
    CfnCollaboratorPropsPermission["PULL"] = "pull";
    /** push */
    CfnCollaboratorPropsPermission["PUSH"] = "push";
    /** admin */
    CfnCollaboratorPropsPermission["ADMIN"] = "admin";
    /** maintain */
    CfnCollaboratorPropsPermission["MAINTAIN"] = "maintain";
    /** triage */
    CfnCollaboratorPropsPermission["TRIAGE"] = "triage";
})(CfnCollaboratorPropsPermission = exports.CfnCollaboratorPropsPermission || (exports.CfnCollaboratorPropsPermission = {}));
/**
 * A CloudFormation `GitHub::Repositories::Collaborator`
 *
 * @cloudformationResource GitHub::Repositories::Collaborator
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnCollaborator extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Repositories::Collaborator`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCollaborator.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnCollaboratorProps(props) });
        this.props = props;
    }
}
exports.CfnCollaborator = CfnCollaborator;
_a = JSII_RTTI_SYMBOL_1;
CfnCollaborator[_a] = { fqn: "@cdk-cloudformation/github-repositories-collaborator.CfnCollaborator", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCollaborator.CFN_RESOURCE_TYPE_NAME = "GitHub::Repositories::Collaborator";
//# sourceMappingURL=data:application/json;base64,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