# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Output Module

"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _output
else:
    import _output

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


MAXFILENAME = _output.MAXFILENAME
MAXELENAME = _output.MAXELENAME

def init() -> "SMO_Handle *":
    r"""
    Initialize pointer for output handle.

    Returns
    -------
    p_handle: SMO_Handle *
        A SWMM output handle

    """
    return _output.init()

def close(p_handle: "SMO_Handle") -> "int":
    r"""
    Close binary output file and perform cleanup. 

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle

    """
    return _output.close(p_handle)

def open(p_handle: "SMO_Handle", path: "char const *") -> "int":
    r"""
    Open binary output file and reads prologue and epilogue.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    path: char const *
        The name of the binary output file to be opened.

    """
    return _output.open(p_handle, path)

def get_version(p_handle: "SMO_Handle") -> "int *":
    r"""
    Get the SWMM version that produced the binary output file. 

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle

    Returns
    -------
    version: int *
        The SWMM version number found in the output file prologue.


    """
    return _output.get_version(p_handle)

def get_proj_size(p_handle: "SMO_Handle") -> "int *":
    r"""
    Project element counts.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle

    Returns
    -------
    elementCount:int **
        Array of element count values
    length:int *
        Array size

    """
    return _output.get_proj_size(p_handle)

def get_units(p_handle: "SMO_Handle") -> "int *":
    r"""
    Project unit flags for unit_system, flow, and pollutants.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle

    Returns
    -------
    unitFlag: int **
        Array of unit flag values
    length: int *
        Array length

    """
    return _output.get_units(p_handle)

def get_start_date(p_handle: "SMO_Handle") -> "double *":
    r"""
    Analysis start date.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle

    Returns
    -------
    date: double *
        SWMM simulation start date (encoded)

    """
    return _output.get_start_date(p_handle)

def get_times(p_handle: "SMO_Handle", code: "SMO_time") -> "int *":
    r"""
    Analysis step size and number of periods.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    code: SMO_time
        A time parameter code (see :ref: SMO_Time)

    Returns
    -------
    time: int *
        Time value

    """
    return _output.get_times(p_handle, code)

def get_elem_name(p_handle: "SMO_Handle", type: "SMO_elementType", elementIndex: "int") -> "int *":
    r"""
    Given an element index returns the element name.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    type: SMO_elementType
        The type of the element being queried
    elementIndex: int
        The index of the element being queried

    Returns
    -------
    name: char **
        Element name array
    length: int *
        Length of array

    """
    return _output.get_elem_name(p_handle, type, elementIndex)

def get_subcatch_series(p_handle: "SMO_Handle", subcatchIndex: "int", attr: "SMO_subcatchAttribute", startPeriod: "int", endPeriod: "int") -> "int *":
    r"""
    Get time series results for particular attribute. Specify series start and 
    length using timeIndex and length respectively.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    subcatchIndex: int
        The subcatchment index for time series
    attr: SMO_subcatchAttribute
        Code for the subcatch attribute to report (see :ref: SMO_subcatchAttribute)
    startPeriod: int
        Time period of series start
    endPeriod: int
        Time period of series end

    Returns
    -------
    outValueArray: float **
        Array of time series values
    length: int *
        Length of array

    """
    return _output.get_subcatch_series(p_handle, subcatchIndex, attr, startPeriod, endPeriod)

def get_node_series(p_handle: "SMO_Handle", nodeIndex: "int", attr: "SMO_nodeAttribute", startPeriod: "int", endPeriod: "int") -> "int *":
    r"""
    Get time series results for particular attribute. Specify series start and 
    length using timeIndex and length respectively.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    nodeIndex: int
        The node index for time series
    attr: SMO_nodeAttribute
        Code for the node attribute to report (see :ref: SMO_nodeAttribute)
    startPeriod: int
        Time period of series start
    endPeriod: int
        Time period of series end

    Returns
    -------
    outValueArray: float **
        Array of time series values
    length: int *
        Length of array

    """
    return _output.get_node_series(p_handle, nodeIndex, attr, startPeriod, endPeriod)

def get_link_series(p_handle: "SMO_Handle", linkIndex: "int", attr: "SMO_linkAttribute", startPeriod: "int", endPeriod: "int") -> "int *":
    r"""
    Get time series results for particular attribute. Specify series start and 
    length using timeIndex and length respectively.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    linkIndex: int
        The link index for time series
    attr: SMO_linkAttribute
        Code for the link attribute to report (see :ref: SMO_linkAttribute)
    startPeriod: int
        Time period of series start
    endPeriod: int
        Time period of series end

    Returns
    -------
    outValueArray: float **
        Array of time series values
    length: int *
        Length of array

    """
    return _output.get_link_series(p_handle, linkIndex, attr, startPeriod, endPeriod)

def get_system_series(p_handle: "SMO_Handle", attr: "SMO_systemAttribute", startPeriod: "int", endPeriod: "int") -> "int *":
    r"""
    Get time series results for particular attribute. Specify series start and 
    length using timeIndex and length respectively.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    attr: SMO_systemAttribute
        Code for the system attribute to report (see :ref: SMO_systemAttribute)
    startPeriod: int
        Time period of series start
    endPeriod: int
        Time period of series end

    Returns
    -------
    outValueArray: float **
        Array of time series values
    length: int *
        Length of array

    """
    return _output.get_system_series(p_handle, attr, startPeriod, endPeriod)

def get_subcatch_attribute(p_handle: "SMO_Handle", timeIndex: "int", attr: "SMO_subcatchAttribute") -> "int *":
    r"""
    For all subcatchments at given time, get a particular attribute.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    attr: SMO_subcatchAttribute
        Code for the subcatchment attribute to report (see :ref: SMO_subcatchAttribute)

    Returns
    -------
    outValueArray: float **
        The array of subcatchment attribute values
    length: int *
        Length of array

    """
    return _output.get_subcatch_attribute(p_handle, timeIndex, attr)

def get_node_attribute(p_handle: "SMO_Handle", timeIndex: "int", attr: "SMO_nodeAttribute") -> "int *":
    r"""
    For all nodes at given time, get a particular attribute.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    attr: SMO_nodeAttribute
        Code for the node attribute to report (see :ref: SMO_nodeAttribute)

    Returns
    -------
    outValueArray: float **
        The array of node attribute values
    length: int *
        Length of array

    """
    return _output.get_node_attribute(p_handle, timeIndex, attr)

def get_link_attribute(p_handle: "SMO_Handle", timeIndex: "int", attr: "SMO_linkAttribute") -> "int *":
    r"""
    For all links at given time, get a particular attribute.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    attr: SMO_linkAttribute
        Code for the link attribute to report (see :ref: SMO_linkAttribute)

    Returns
    -------
    outValueArray: float **
        The array of link attribute values
    length: int *
        Length of array

    """
    return _output.get_link_attribute(p_handle, timeIndex, attr)

def get_system_attribute(p_handle: "SMO_Handle", timeIndex: "int", attr: "SMO_systemAttribute") -> "int *":
    r"""
    For the system at given time, get a particular attribute.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    attr: SMO_systemAttribute
        Code for the system attribute to report (see :ref: SMO_systemAttribute)

    Returns
    -------
    outValueArray: float **
        The array of system attribute values
    length: int *
        Length of array

    """
    return _output.get_system_attribute(p_handle, timeIndex, attr)

def get_subcatch_result(p_handle: "SMO_Handle", timeIndex: "int", subcatchIndex: "int") -> "int *":
    r"""
    For a subcatchment at given time, get all attributes.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    subcatchIndex: int
        The subcatchment index for reporting results

    Returns
    -------
    outValueArray: float **
        The array of subcatchment result values
    length: int *
        Length of array

    """
    return _output.get_subcatch_result(p_handle, timeIndex, subcatchIndex)

def get_node_result(p_handle: "SMO_Handle", timeIndex: "int", nodeIndex: "int") -> "int *":
    r"""
    For a node at given time, get all attributes.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    nodeIndex: int
        The node index for reporting results

    Returns
    -------
    outValueArray: float **
        The array of node result values
    length: int *
        Length of array

    """
    return _output.get_node_result(p_handle, timeIndex, nodeIndex)

def get_link_result(p_handle: "SMO_Handle", timeIndex: "int", linkIndex: "int") -> "int *":
    r"""
    For a link at given time, get all attributes.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    linkIndex: int
        The link index for reporting results

    Returns
    -------
    outValueArray: float **
        The array of link result values
    length: int *
        Length of array

    """
    return _output.get_link_result(p_handle, timeIndex, linkIndex)

def get_system_result(p_handle: "SMO_Handle", timeIndex: "int", dummyIndex: "int") -> "int *":
    r"""
    For the system at given time, get all attributes.

    Parameters
    ----------
    p_handle: SMO_Handle
        A SWMM output handle
    timeIndex: int
        The time period index for reporting results
    dummyIndex: int
        No-op for API consistency

    Returns
    -------
    outValueArray: float **
        The array of system result values
    length: int *
        Length of array

    """
    return _output.get_system_result(p_handle, timeIndex, dummyIndex)


