# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


import inspect
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class AssetRecordingTimes(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'started_at': 'datetime',
        'duration': 'float'
    }

    attribute_map = {
        'started_at': 'started_at',
        'duration': 'duration'
    }

    def __init__(self, started_at=None, duration=None, local_vars_configuration=None):  # noqa: E501
        """AssetRecordingTimes - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._started_at = None
        self._duration = None
        self.discriminator = None

        if started_at is not None:
            self.started_at = started_at
        if duration is not None:
            self.duration = duration

    @property
    def started_at(self):
        """Gets the started_at of this AssetRecordingTimes.  # noqa: E501

        The time at which the recording for the live stream started. The time value is Unix epoch time represented in ISO 8601 format.  # noqa: E501

        :return: The started_at of this AssetRecordingTimes.  # noqa: E501
        :rtype: datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this AssetRecordingTimes.

        The time at which the recording for the live stream started. The time value is Unix epoch time represented in ISO 8601 format.  # noqa: E501

        :param started_at: The started_at of this AssetRecordingTimes.  # noqa: E501
        :type started_at: datetime
        """

        self._started_at = started_at

    @property
    def duration(self):
        """Gets the duration of this AssetRecordingTimes.  # noqa: E501

        The duration of the live stream recorded. The time value is in seconds.  # noqa: E501

        :return: The duration of this AssetRecordingTimes.  # noqa: E501
        :rtype: float
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this AssetRecordingTimes.

        The duration of the live stream recorded. The time value is in seconds.  # noqa: E501

        :param duration: The duration of this AssetRecordingTimes.  # noqa: E501
        :type duration: float
        """

        self._duration = duration

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetRecordingTimes):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetRecordingTimes):
            return True

        return self.to_dict() != other.to_dict()
