"""
update_config.py is used to update the settings/__init__.py from the jenkins job execution.
please copy this module to your project if needed.

the structure of your project should be like this:
your_project_folder
|----  settings/          # settings will be auto-generated by lintest if doesn't exists
|----  common/            # the common libraries
|----  tests/             # all the testcases must be under "tests" package
|----  run.py             # the entry of lintest
|----  update_config.py   # used to update settings/__init__.py for jenkins job execution

e.g:
before update, the content of settings/__init__.py:
----------------------
TESTCASE_TIMEOUT = 120
DEBUG_RUN = True
RERUN_FLAG = False
----------------------

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
run CMD: "python update_config.py TESTCASE_TIMEOUT=10 debug_run=False rerun_flag=True"
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

after update, the content of settings/__init__.py:
---------------------
TESTCASE_TIMEOUT = 10
DEBUG_RUN = False
RERUN_FLAG = True
---------------------

Note:
    the argv must be like "key=val key2=val2", each argv split by white-space and the key is case-insensitive

@author: Wang Lin
"""

import sys
import os

os.environ["LIN_TEST_PROJECT_PATH"] = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from .get_project_info import get_project_info

project_info = get_project_info()

settings_file_path = project_info.project_path + os.sep + "settings" + os.sep + "__init__.py"

argv_list = sys.argv[1:]

if len(argv_list) > 0:
    for argv in argv_list:
        if "=" not in argv:
            raise BaseException("the argv must like: key=val")

    argv_dict = {}
    updated_argv = []

    for argv in argv_list:
        argv_dict[argv.split("=")[0]] = argv.split("=")[1]

    with open(settings_file_path, "r") as settings_file:
        contents = settings_file.readlines()
        i = 0

        while i < len(contents):
            line = contents[i]
            line_remove_whitespace = line.replace(" ", "")

            for argv in argv_dict.keys():
                if line_remove_whitespace.split("=")[0].lower() == argv.lower():
                    contents[i] = "%s = %s \n" % (line_remove_whitespace.split("=")[0], argv_dict[argv])
                    print("UPDATE in settings" + os.sep + "__init__.py: %s " % contents[i])
                    updated_argv.append(argv)
                    break
            i += 1

        with open(settings_file_path, "w") as settings_new_file:
            settings_new_file.writelines(contents)

    if len(updated_argv) < len(argv_list):
        argv_list_not_found = []

        for argv in argv_dict.keys():
            if argv not in updated_argv:
                argv_list_not_found.append(argv)

        print("***************** WARNING: below argv not found in settings/__init__.py *****************")
        print(argv_list_not_found)
