[![CircleCI](https://circleci.com/gh/tokern/dbcat.svg?style=svg)](https://circleci.com/gh/tokern/dbcat)
[![codecov](https://codecov.io/gh/tokern/dbcat/branch/main/graph/badge.svg)](https://codecov.io/gh/tokern/dbcat)
[![PyPI](https://img.shields.io/pypi/v/dbcat.svg)](https://pypi.python.org/pypi/dbcat)
[![image](https://img.shields.io/pypi/l/dbcat.svg)](https://pypi.org/project/dbcat/)
[![image](https://img.shields.io/pypi/pyversions/dbcat.svg)](https://pypi.org/project/dbcat/)

# Data Catalog for Databases and Data Warehouses

## Overview

*dbcat* scans and maintains metadata from all your databases and data warehouses. 
*dbcat* also stores metadata generated by other data governance applications such as 
[PIICatcher](https://github.com/tokern/piicatcher) and [Lineage Engine](https://github.com/tokern/data-lineage).
*dbcat* is typically used alongside other applications. It can also be used stand-alone to generate
a very simple data catalog using the CLI or API.  

*dbcat* stores the catalog in a Postgresql or SQLite database. By default, the catalog is stored in a SQLite
database in `~/.config/tokern/catalog.db`

The catalog can be exported to [Datahub](https://datahubproject.io/) or [Amundsen](https://amundsen.io). This is very 
useful to export PII tags or column lineage generated by PIICatcher or Lineage Engine. 
Check [documentation for detailed instructions](https://tokern.io/docs/catalog/export) to set PII tags and 
column-level lineage.


## Quick Start

*dbcat* is distributed as a python application.

    python3 -m venv .env
    source .env/bin/activate
    pip install piicatcher

    # configure the application
    
    dbcat catalog add-sqlite --name sample --path <path to sqlite db>
    dbcat catalog scan --source-name sample

## Documentation

For advanced usage refer documentation [Catalog Documentation](https://tokern.io/docs/catalog).

## Supported Technologies

The following databases are supported:

* MySQL/Mariadb
* PostgreSQL
* AWS Redshift
* BigQuery
* Snowflake
* AWS Athena

