# coding: utf-8

"""
    Aliro Q.Network

    This is an api for the Aliro Q.Network  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: nick@aliroquantum.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from aliro_quantum_networking.configuration import Configuration


class Request(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'memory_size': 'int',
        'node_from': 'str',
        'node_to': 'str',
        'target_fidelity': 'float',
        'time_beginning': 'float',
        'time_end': 'float'
    }

    attribute_map = {
        'memory_size': 'memorySize',
        'node_from': 'nodeFrom',
        'node_to': 'nodeTo',
        'target_fidelity': 'targetFidelity',
        'time_beginning': 'timeBeginning',
        'time_end': 'timeEnd'
    }

    def __init__(self, memory_size=None, node_from=None, node_to=None, target_fidelity=0, time_beginning=1000000000000, time_end=100000000000000, local_vars_configuration=None):  # noqa: E501
        """Request - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._memory_size = None
        self._node_from = None
        self._node_to = None
        self._target_fidelity = None
        self._time_beginning = None
        self._time_end = None
        self.discriminator = None

        self.memory_size = memory_size
        self.node_from = node_from
        self.node_to = node_to
        if target_fidelity is not None:
            self.target_fidelity = target_fidelity
        if time_beginning is not None:
            self.time_beginning = time_beginning
        if time_end is not None:
            self.time_end = time_end

    @property
    def memory_size(self):
        """Gets the memory_size of this Request.  # noqa: E501


        :return: The memory_size of this Request.  # noqa: E501
        :rtype: int
        """
        return self._memory_size

    @memory_size.setter
    def memory_size(self, memory_size):
        """Sets the memory_size of this Request.


        :param memory_size: The memory_size of this Request.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and memory_size is None:  # noqa: E501
            raise ValueError("Invalid value for `memory_size`, must not be `None`")  # noqa: E501

        self._memory_size = memory_size

    @property
    def node_from(self):
        """Gets the node_from of this Request.  # noqa: E501

        A string matching the name of the sending node  # noqa: E501

        :return: The node_from of this Request.  # noqa: E501
        :rtype: str
        """
        return self._node_from

    @node_from.setter
    def node_from(self, node_from):
        """Sets the node_from of this Request.

        A string matching the name of the sending node  # noqa: E501

        :param node_from: The node_from of this Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and node_from is None:  # noqa: E501
            raise ValueError("Invalid value for `node_from`, must not be `None`")  # noqa: E501

        self._node_from = node_from

    @property
    def node_to(self):
        """Gets the node_to of this Request.  # noqa: E501

        A string matching the name of the receiving node  # noqa: E501

        :return: The node_to of this Request.  # noqa: E501
        :rtype: str
        """
        return self._node_to

    @node_to.setter
    def node_to(self, node_to):
        """Sets the node_to of this Request.

        A string matching the name of the receiving node  # noqa: E501

        :param node_to: The node_to of this Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and node_to is None:  # noqa: E501
            raise ValueError("Invalid value for `node_to`, must not be `None`")  # noqa: E501

        self._node_to = node_to

    @property
    def target_fidelity(self):
        """Gets the target_fidelity of this Request.  # noqa: E501

        The target fidelity of the network  # noqa: E501

        :return: The target_fidelity of this Request.  # noqa: E501
        :rtype: float
        """
        return self._target_fidelity

    @target_fidelity.setter
    def target_fidelity(self, target_fidelity):
        """Sets the target_fidelity of this Request.

        The target fidelity of the network  # noqa: E501

        :param target_fidelity: The target_fidelity of this Request.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                target_fidelity is not None and target_fidelity > 1):  # noqa: E501
            raise ValueError("Invalid value for `target_fidelity`, must be a value less than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                target_fidelity is not None and target_fidelity < 0):  # noqa: E501
            raise ValueError("Invalid value for `target_fidelity`, must be a value greater than or equal to `0`")  # noqa: E501

        self._target_fidelity = target_fidelity

    @property
    def time_beginning(self):
        """Gets the time_beginning of this Request.  # noqa: E501

        Start time for the simulation, in picoseconds (default is 10^12)  # noqa: E501

        :return: The time_beginning of this Request.  # noqa: E501
        :rtype: float
        """
        return self._time_beginning

    @time_beginning.setter
    def time_beginning(self, time_beginning):
        """Sets the time_beginning of this Request.

        Start time for the simulation, in picoseconds (default is 10^12)  # noqa: E501

        :param time_beginning: The time_beginning of this Request.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                time_beginning is not None and time_beginning < 0):  # noqa: E501
            raise ValueError("Invalid value for `time_beginning`, must be a value greater than or equal to `0`")  # noqa: E501

        self._time_beginning = time_beginning

    @property
    def time_end(self):
        """Gets the time_end of this Request.  # noqa: E501

        End time for the simulation, in picoseconds (default is 10^14)  # noqa: E501

        :return: The time_end of this Request.  # noqa: E501
        :rtype: float
        """
        return self._time_end

    @time_end.setter
    def time_end(self, time_end):
        """Sets the time_end of this Request.

        End time for the simulation, in picoseconds (default is 10^14)  # noqa: E501

        :param time_end: The time_end of this Request.  # noqa: E501
        :type: float
        """

        self._time_end = time_end

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Request):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Request):
            return True

        return self.to_dict() != other.to_dict()
