"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentVariablesService = void 0;
const commons_1 = require("@aws-lambda-powertools/commons");
class EnvironmentVariablesService extends commons_1.EnvironmentVariablesService {
    constructor() {
        super(...arguments);
        // Environment variables
        this.awsExecutionEnv = 'AWS_EXECUTION_ENV';
        this.samLocalVariable = 'AWS_SAM_LOCAL';
        this.tracerCaptureErrorVariable = 'POWERTOOLS_TRACER_CAPTURE_ERROR';
        this.tracerCaptureHTTPsRequestsVariable = 'POWERTOOLS_TRACER_CAPTURE_HTTPS_REQUESTS';
        this.tracerCaptureResponseVariable = 'POWERTOOLS_TRACER_CAPTURE_RESPONSE';
        this.tracingEnabledVariable = 'POWERTOOLS_TRACE_ENABLED';
    }
    getAwsExecutionEnv() {
        return this.get(this.awsExecutionEnv);
    }
    getCaptureHTTPsRequests() {
        return this.get(this.tracerCaptureHTTPsRequestsVariable);
    }
    getSamLocal() {
        return this.get(this.samLocalVariable);
    }
    getTracingCaptureError() {
        return this.get(this.tracerCaptureErrorVariable);
    }
    getTracingCaptureResponse() {
        return this.get(this.tracerCaptureResponseVariable);
    }
    getTracingEnabled() {
        return this.get(this.tracingEnabledVariable);
    }
}
exports.EnvironmentVariablesService = EnvironmentVariablesService;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRW52aXJvbm1lbnRWYXJpYWJsZXNTZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NvbmZpZy9FbnZpcm9ubWVudFZhcmlhYmxlc1NlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsNERBQWtIO0FBRWxILE1BQU0sMkJBQTRCLFNBQVEscUNBQWlDO0lBQTNFOztRQUVFLHdCQUF3QjtRQUNoQixvQkFBZSxHQUFHLG1CQUFtQixDQUFDO1FBQ3RDLHFCQUFnQixHQUFHLGVBQWUsQ0FBQztRQUNuQywrQkFBMEIsR0FBRyxpQ0FBaUMsQ0FBQztRQUMvRCx1Q0FBa0MsR0FBRywwQ0FBMEMsQ0FBQztRQUNoRixrQ0FBNkIsR0FBRyxvQ0FBb0MsQ0FBQztRQUNyRSwyQkFBc0IsR0FBRywwQkFBMEIsQ0FBQztJQTBCOUQsQ0FBQztJQXhCUSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRU0sdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBRU0sV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVNLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVNLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDL0MsQ0FBQztDQUVGO0FBR0Msa0VBQTJCIn0=