import { AsyncHandler, LambdaInterface, SyncHandler } from '@aws-lambda-powertools/commons';
import { Handler } from 'aws-lambda';
import { ConfigServiceInterface } from '../config';
import { LogFormatterInterface } from '../formatter';
import { Environment, LogAttributes, LogAttributesWithMessage, LogLevel } from './Log';
declare type ClassThatLogs = {
    [key in 'debug' | 'error' | 'info' | 'warn']: (input: LogItemMessage, ...extraInput: LogItemExtraInput) => void;
};
declare type HandlerOptions = {
    logEvent?: boolean;
    clearState?: boolean;
};
declare type ConstructorOptions = {
    logLevel?: LogLevel;
    serviceName?: string;
    sampleRateValue?: number;
    logFormatter?: LogFormatterInterface;
    customConfigService?: ConfigServiceInterface;
    persistentLogAttributes?: LogAttributes;
    environment?: Environment;
};
declare type LambdaFunctionContext = {
    functionName: string;
    memoryLimitInMB: number;
    functionVersion: string;
    coldStart: boolean;
    invokedFunctionArn: string;
    awsRequestId: string;
};
declare type PowertoolLogData = LogAttributes & {
    environment?: Environment;
    serviceName: string;
    sampleRateValue?: number;
    lambdaFunctionContext: LambdaFunctionContext;
    xRayTraceId?: string;
    awsRegion: string;
};
declare type UnformattedAttributes = {
    environment?: Environment;
    error?: Error;
    serviceName: string;
    sampleRateValue?: number;
    lambdaContext?: LambdaFunctionContext;
    xRayTraceId?: string;
    awsRegion: string;
    logLevel: LogLevel;
    timestamp: Date;
    message: string;
};
declare type LogItemMessage = string | LogAttributesWithMessage;
declare type LogItemExtraInput = [Error | string] | LogAttributes[];
declare type HandlerMethodDecorator = (target: LambdaInterface, propertyKey: string | symbol, descriptor: TypedPropertyDescriptor<SyncHandler<Handler>> | TypedPropertyDescriptor<AsyncHandler<Handler>>) => void;
export { ClassThatLogs, LogItemMessage, LogItemExtraInput, HandlerMethodDecorator, LambdaFunctionContext, UnformattedAttributes, PowertoolLogData, ConstructorOptions, HandlerOptions };
export declare const enum LogJsonIndent {
    PRETTY = 4,
    COMPACT = 0
}
