import { ConfigService } from '.';
/**
 * Class EnvironmentVariablesService
 *
 * This class is used to return environment variables that are available in the runtime of
 * the current Lambda invocation.
 * These variables can be a mix of runtime environment variables set by AWS and
 * variables that can be set by the developer additionally.
 *
 * @class
 * @extends {ConfigService}
 * @see https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime
 * @see https://awslabs.github.io/aws-lambda-powertools-typescript/latest/#environment-variables
 */
declare class EnvironmentVariablesService extends ConfigService {
    /**
     * @see https://awslabs.github.io/aws-lambda-powertools-typescript/latest/#environment-variables
     * @protected
     */
    protected serviceNameVariable: string;
    private xRayTraceIdVariable;
    /**
     * It returns the value of an environment variable that has given name.
     *
     * @param {string} name
     * @returns {string}
     */
    get(name: string): string;
    /**
     * It returns the value of the POWERTOOLS_SERVICE_NAME environment variable.
     *
     * @returns {string}
     */
    getServiceName(): string;
    /**
     * It returns the value of the _X_AMZN_TRACE_ID environment variable.
     *
     * The AWS X-Ray Trace data available in the environment variable has this format:
     * `Root=1-5759e988-bd862e3fe1be46a994272793;Parent=557abcec3ee5a047;Sampled=1`,
     *
     * The actual Trace ID is: `1-5759e988-bd862e3fe1be46a994272793`.
     *
     * @returns {string}
     */
    getXrayTraceId(): string | undefined;
}
export { EnvironmentVariablesService, };
//# sourceMappingURL=EnvironmentVariablesService.d.ts.map