/**
 * Abstract class ConfigService
 *
 * This class defines common methods and variables that can be set by the developer
 * in the runtime.
 *
 * @class
 * @abstract
 */
declare abstract class ConfigService {
    /**
     * It returns the value of an environment variable that has given name.
     *
     * @param {string} name
     * @returns {string}
     */
    abstract get(name: string): string;
    /**
     * It returns the value of the POWERTOOLS_SERVICE_NAME environment variable.
     *
     * @returns {string}
     */
    abstract getServiceName(): string;
}
export { ConfigService, };
//# sourceMappingURL=ConfigService.d.ts.map