# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'ScanConfigErrorCode',
    'ScanConfigExportToSecurityCommandCenter',
    'ScanConfigRiskLevel',
    'ScanConfigTargetPlatformsItem',
    'ScanConfigUserAgent',
    'ScanRunErrorTraceCode',
    'ScanRunExecutionState',
    'ScanRunResultState',
    'ScanRunWarningTraceCode',
]


class ScanConfigErrorCode(str, Enum):
    """
    Indicates the reason code for a configuration failure.
    """
    CODE_UNSPECIFIED = "CODE_UNSPECIFIED"
    """
    There is no error.
    """
    OK = "OK"
    """
    There is no error.
    """
    INTERNAL_ERROR = "INTERNAL_ERROR"
    """
    Indicates an internal server error. Please DO NOT USE THIS ERROR CODE unless the root cause is truly unknown.
    """
    APPENGINE_API_BACKEND_ERROR = "APPENGINE_API_BACKEND_ERROR"
    """
    One of the seed URLs is an App Engine URL but we cannot validate the scan settings due to an App Engine API backend error.
    """
    APPENGINE_API_NOT_ACCESSIBLE = "APPENGINE_API_NOT_ACCESSIBLE"
    """
    One of the seed URLs is an App Engine URL but we cannot access the App Engine API to validate scan settings.
    """
    APPENGINE_DEFAULT_HOST_MISSING = "APPENGINE_DEFAULT_HOST_MISSING"
    """
    One of the seed URLs is an App Engine URL but the Default Host of the App Engine is not set.
    """
    CANNOT_USE_GOOGLE_COM_ACCOUNT = "CANNOT_USE_GOOGLE_COM_ACCOUNT"
    """
    Google corporate accounts can not be used for scanning.
    """
    CANNOT_USE_OWNER_ACCOUNT = "CANNOT_USE_OWNER_ACCOUNT"
    """
    The account of the scan creator can not be used for scanning.
    """
    COMPUTE_API_BACKEND_ERROR = "COMPUTE_API_BACKEND_ERROR"
    """
    This scan targets Compute Engine, but we cannot validate scan settings due to a Compute Engine API backend error.
    """
    COMPUTE_API_NOT_ACCESSIBLE = "COMPUTE_API_NOT_ACCESSIBLE"
    """
    This scan targets Compute Engine, but we cannot access the Compute Engine API to validate the scan settings.
    """
    CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT = "CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT"
    """
    The Custom Login URL does not belong to the current project.
    """
    CUSTOM_LOGIN_URL_MALFORMED = "CUSTOM_LOGIN_URL_MALFORMED"
    """
    The Custom Login URL is malformed (can not be parsed).
    """
    CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS = "CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS"
    """
    The Custom Login URL is mapped to a non-routable IP address in DNS.
    """
    CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS = "CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS"
    """
    The Custom Login URL is mapped to an IP address which is not reserved for the current project.
    """
    CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS = "CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS"
    """
    The Custom Login URL has a non-routable IP address.
    """
    CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS = "CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS"
    """
    The Custom Login URL has an IP address which is not reserved for the current project.
    """
    DUPLICATE_SCAN_NAME = "DUPLICATE_SCAN_NAME"
    """
    Another scan with the same name (case-sensitive) already exists.
    """
    INVALID_FIELD_VALUE = "INVALID_FIELD_VALUE"
    """
    A field is set to an invalid value.
    """
    FAILED_TO_AUTHENTICATE_TO_TARGET = "FAILED_TO_AUTHENTICATE_TO_TARGET"
    """
    There was an error trying to authenticate to the scan target.
    """
    FINDING_TYPE_UNSPECIFIED = "FINDING_TYPE_UNSPECIFIED"
    """
    Finding type value is not specified in the list findings request.
    """
    FORBIDDEN_TO_SCAN_COMPUTE = "FORBIDDEN_TO_SCAN_COMPUTE"
    """
    Scan targets Compute Engine, yet current project was not whitelisted for Google Compute Engine Scanning Alpha access.
    """
    FORBIDDEN_UPDATE_TO_MANAGED_SCAN = "FORBIDDEN_UPDATE_TO_MANAGED_SCAN"
    """
    User tries to update managed scan
    """
    MALFORMED_FILTER = "MALFORMED_FILTER"
    """
    The supplied filter is malformed. For example, it can not be parsed, does not have a filter type in expression, or the same filter type appears more than once.
    """
    MALFORMED_RESOURCE_NAME = "MALFORMED_RESOURCE_NAME"
    """
    The supplied resource name is malformed (can not be parsed).
    """
    PROJECT_INACTIVE = "PROJECT_INACTIVE"
    """
    The current project is not in an active state.
    """
    REQUIRED_FIELD = "REQUIRED_FIELD"
    """
    A required field is not set.
    """
    RESOURCE_NAME_INCONSISTENT = "RESOURCE_NAME_INCONSISTENT"
    """
    Project id, scanconfig id, scanrun id, or finding id are not consistent with each other in resource name.
    """
    SCAN_ALREADY_RUNNING = "SCAN_ALREADY_RUNNING"
    """
    The scan being requested to start is already running.
    """
    SCAN_NOT_RUNNING = "SCAN_NOT_RUNNING"
    """
    The scan that was requested to be stopped is not running.
    """
    SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT = "SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT"
    """
    One of the seed URLs does not belong to the current project.
    """
    SEED_URL_MALFORMED = "SEED_URL_MALFORMED"
    """
    One of the seed URLs is malformed (can not be parsed).
    """
    SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS = "SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS"
    """
    One of the seed URLs is mapped to a non-routable IP address in DNS.
    """
    SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS = "SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS"
    """
    One of the seed URLs is mapped to an IP address which is not reserved for the current project.
    """
    SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS = "SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS"
    """
    One of the seed URLs has on-routable IP address.
    """
    SEED_URL_HAS_UNRESERVED_IP_ADDRESS = "SEED_URL_HAS_UNRESERVED_IP_ADDRESS"
    """
    One of the seed URLs has an IP address that is not reserved for the current project.
    """
    SERVICE_ACCOUNT_NOT_CONFIGURED = "SERVICE_ACCOUNT_NOT_CONFIGURED"
    """
    The Web Security Scanner service account is not configured under the project.
    """
    TOO_MANY_SCANS = "TOO_MANY_SCANS"
    """
    A project has reached the maximum number of scans.
    """
    UNABLE_TO_RESOLVE_PROJECT_INFO = "UNABLE_TO_RESOLVE_PROJECT_INFO"
    """
    Resolving the details of the current project fails.
    """
    UNSUPPORTED_BLACKLIST_PATTERN_FORMAT = "UNSUPPORTED_BLACKLIST_PATTERN_FORMAT"
    """
    One or more blacklist patterns were in the wrong format.
    """
    UNSUPPORTED_FILTER = "UNSUPPORTED_FILTER"
    """
    The supplied filter is not supported.
    """
    UNSUPPORTED_FINDING_TYPE = "UNSUPPORTED_FINDING_TYPE"
    """
    The supplied finding type is not supported. For example, we do not provide findings of the given finding type.
    """
    UNSUPPORTED_URL_SCHEME = "UNSUPPORTED_URL_SCHEME"
    """
    The URL scheme of one or more of the supplied URLs is not supported.
    """


class ScanConfigExportToSecurityCommandCenter(str, Enum):
    """
    Controls export of scan configurations and results to Security Command Center.
    """
    EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED = "EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED"
    """
    Use default, which is ENABLED.
    """
    ENABLED = "ENABLED"
    """
    Export results of this scan to Security Command Center.
    """
    DISABLED = "DISABLED"
    """
    Do not export results of this scan to Security Command Center.
    """


class ScanConfigRiskLevel(str, Enum):
    """
    The risk level selected for the scan
    """
    RISK_LEVEL_UNSPECIFIED = "RISK_LEVEL_UNSPECIFIED"
    """
    Use default, which is NORMAL.
    """
    NORMAL = "NORMAL"
    """
    Normal scanning (Recommended)
    """
    LOW = "LOW"
    """
    Lower impact scanning
    """


class ScanConfigTargetPlatformsItem(str, Enum):
    TARGET_PLATFORM_UNSPECIFIED = "TARGET_PLATFORM_UNSPECIFIED"
    """
    The target platform is unknown. Requests with this enum value will be rejected with INVALID_ARGUMENT error.
    """
    APP_ENGINE = "APP_ENGINE"
    """
    Google App Engine service.
    """
    COMPUTE = "COMPUTE"
    """
    Google Compute Engine service.
    """
    CLOUD_RUN = "CLOUD_RUN"
    """
    Google Cloud Run service.
    """


class ScanConfigUserAgent(str, Enum):
    """
    The user agent used during scanning.
    """
    USER_AGENT_UNSPECIFIED = "USER_AGENT_UNSPECIFIED"
    """
    The user agent is unknown. Service will default to CHROME_LINUX.
    """
    CHROME_LINUX = "CHROME_LINUX"
    """
    Chrome on Linux. This is the service default if unspecified.
    """
    CHROME_ANDROID = "CHROME_ANDROID"
    """
    Chrome on Android.
    """
    SAFARI_IPHONE = "SAFARI_IPHONE"
    """
    Safari on IPhone.
    """


class ScanRunErrorTraceCode(str, Enum):
    """
    Indicates the error reason code.
    """
    CODE_UNSPECIFIED = "CODE_UNSPECIFIED"
    """
    Default value is never used.
    """
    INTERNAL_ERROR = "INTERNAL_ERROR"
    """
    Indicates that the scan run failed due to an internal server error.
    """
    SCAN_CONFIG_ISSUE = "SCAN_CONFIG_ISSUE"
    """
    Indicates a scan configuration error, usually due to outdated ScanConfig settings, such as starting_urls or the DNS configuration.
    """
    AUTHENTICATION_CONFIG_ISSUE = "AUTHENTICATION_CONFIG_ISSUE"
    """
    Indicates an authentication error, usually due to outdated ScanConfig authentication settings.
    """
    TIMED_OUT_WHILE_SCANNING = "TIMED_OUT_WHILE_SCANNING"
    """
    Indicates a scan operation timeout, usually caused by a very large site.
    """
    TOO_MANY_REDIRECTS = "TOO_MANY_REDIRECTS"
    """
    Indicates that a scan encountered excessive redirects, either to authentication or some other page outside of the scan scope.
    """
    TOO_MANY_HTTP_ERRORS = "TOO_MANY_HTTP_ERRORS"
    """
    Indicates that a scan encountered numerous errors from the web site pages. When available, most_common_http_error_code field indicates the most common HTTP error code encountered during the scan.
    """


class ScanRunExecutionState(str, Enum):
    """
    The execution state of the ScanRun.
    """
    EXECUTION_STATE_UNSPECIFIED = "EXECUTION_STATE_UNSPECIFIED"
    """
    Represents an invalid state caused by internal server error. This value should never be returned.
    """
    QUEUED = "QUEUED"
    """
    The scan is waiting in the queue.
    """
    SCANNING = "SCANNING"
    """
    The scan is in progress.
    """
    FINISHED = "FINISHED"
    """
    The scan is either finished or stopped by user.
    """


class ScanRunResultState(str, Enum):
    """
    The result state of the ScanRun. This field is only available after the execution state reaches "FINISHED".
    """
    RESULT_STATE_UNSPECIFIED = "RESULT_STATE_UNSPECIFIED"
    """
    Default value. This value is returned when the ScanRun is not yet finished.
    """
    SUCCESS = "SUCCESS"
    """
    The scan finished without errors.
    """
    ERROR = "ERROR"
    """
    The scan finished with errors.
    """
    KILLED = "KILLED"
    """
    The scan was terminated by user.
    """


class ScanRunWarningTraceCode(str, Enum):
    """
    Indicates the warning code.
    """
    CODE_UNSPECIFIED = "CODE_UNSPECIFIED"
    """
    Default value is never used.
    """
    INSUFFICIENT_CRAWL_RESULTS = "INSUFFICIENT_CRAWL_RESULTS"
    """
    Indicates that a scan discovered an unexpectedly low number of URLs. This is sometimes caused by complex navigation features or by using a single URL for numerous pages.
    """
    TOO_MANY_CRAWL_RESULTS = "TOO_MANY_CRAWL_RESULTS"
    """
    Indicates that a scan discovered too many URLs to test, or excessive redundant URLs.
    """
    TOO_MANY_FUZZ_TASKS = "TOO_MANY_FUZZ_TASKS"
    """
    Indicates that too many tests have been generated for the scan. Customer should try reducing the number of starting URLs, increasing the QPS rate, or narrowing down the scope of the scan using the excluded patterns.
    """
    BLOCKED_BY_IAP = "BLOCKED_BY_IAP"
    """
    Indicates that a scan is blocked by IAP.
    """
    NO_STARTING_URL_FOUND_FOR_MANAGED_SCAN = "NO_STARTING_URL_FOUND_FOR_MANAGED_SCAN"
    """
    Indicates that no seed is found for a scan
    """
