# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['MigratingVmArgs', 'MigratingVm']

@pulumi.input_type
class MigratingVmArgs:
    def __init__(__self__, *,
                 migrating_vm_id: pulumi.Input[str],
                 source_id: pulumi.Input[str],
                 compute_engine_target_defaults: Optional[pulumi.Input['ComputeEngineTargetDefaultsArgs']] = None,
                 compute_engine_vm_defaults: Optional[pulumi.Input['TargetVMDetailsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input['SchedulePolicyArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 source_vm_id: Optional[pulumi.Input[str]] = None,
                 target_defaults: Optional[pulumi.Input['TargetVMDetailsArgs']] = None):
        """
        The set of arguments for constructing a MigratingVm resource.
        :param pulumi.Input[str] migrating_vm_id: Required. The migratingVm identifier.
        :param pulumi.Input['ComputeEngineTargetDefaultsArgs'] compute_engine_target_defaults: Details of the target VM in Compute Engine.
        :param pulumi.Input['TargetVMDetailsArgs'] compute_engine_vm_defaults: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.
        :param pulumi.Input[str] description: The description attached to the migrating VM by the user.
        :param pulumi.Input[str] display_name: The display name attached to the MigratingVm by the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels of the migrating VM.
        :param pulumi.Input['SchedulePolicyArgs'] policy: The replication schedule policy.
        :param pulumi.Input[str] request_id: A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] source_vm_id: The unique ID of the VM in the source. The VM's name in vSphere can be changed, so this is not the VM's name but rather its moRef id. This id is of the form vm-.
        :param pulumi.Input['TargetVMDetailsArgs'] target_defaults: The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.
        """
        pulumi.set(__self__, "migrating_vm_id", migrating_vm_id)
        pulumi.set(__self__, "source_id", source_id)
        if compute_engine_target_defaults is not None:
            pulumi.set(__self__, "compute_engine_target_defaults", compute_engine_target_defaults)
        if compute_engine_vm_defaults is not None:
            warnings.warn("""Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.""", DeprecationWarning)
            pulumi.log.warn("""compute_engine_vm_defaults is deprecated: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.""")
        if compute_engine_vm_defaults is not None:
            pulumi.set(__self__, "compute_engine_vm_defaults", compute_engine_vm_defaults)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)
        if target_defaults is not None:
            warnings.warn("""The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.""", DeprecationWarning)
            pulumi.log.warn("""target_defaults is deprecated: The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.""")
        if target_defaults is not None:
            pulumi.set(__self__, "target_defaults", target_defaults)

    @property
    @pulumi.getter(name="migratingVmId")
    def migrating_vm_id(self) -> pulumi.Input[str]:
        """
        Required. The migratingVm identifier.
        """
        return pulumi.get(self, "migrating_vm_id")

    @migrating_vm_id.setter
    def migrating_vm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "migrating_vm_id", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="computeEngineTargetDefaults")
    def compute_engine_target_defaults(self) -> Optional[pulumi.Input['ComputeEngineTargetDefaultsArgs']]:
        """
        Details of the target VM in Compute Engine.
        """
        return pulumi.get(self, "compute_engine_target_defaults")

    @compute_engine_target_defaults.setter
    def compute_engine_target_defaults(self, value: Optional[pulumi.Input['ComputeEngineTargetDefaultsArgs']]):
        pulumi.set(self, "compute_engine_target_defaults", value)

    @property
    @pulumi.getter(name="computeEngineVmDefaults")
    def compute_engine_vm_defaults(self) -> Optional[pulumi.Input['TargetVMDetailsArgs']]:
        """
        Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.
        """
        return pulumi.get(self, "compute_engine_vm_defaults")

    @compute_engine_vm_defaults.setter
    def compute_engine_vm_defaults(self, value: Optional[pulumi.Input['TargetVMDetailsArgs']]):
        pulumi.set(self, "compute_engine_vm_defaults", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description attached to the migrating VM by the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name attached to the MigratingVm by the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels of the migrating VM.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['SchedulePolicyArgs']]:
        """
        The replication schedule policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['SchedulePolicyArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the VM in the source. The VM's name in vSphere can be changed, so this is not the VM's name but rather its moRef id. This id is of the form vm-.
        """
        return pulumi.get(self, "source_vm_id")

    @source_vm_id.setter
    def source_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_vm_id", value)

    @property
    @pulumi.getter(name="targetDefaults")
    def target_defaults(self) -> Optional[pulumi.Input['TargetVMDetailsArgs']]:
        """
        The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.
        """
        return pulumi.get(self, "target_defaults")

    @target_defaults.setter
    def target_defaults(self, value: Optional[pulumi.Input['TargetVMDetailsArgs']]):
        pulumi.set(self, "target_defaults", value)


class MigratingVm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_engine_target_defaults: Optional[pulumi.Input[pulumi.InputType['ComputeEngineTargetDefaultsArgs']]] = None,
                 compute_engine_vm_defaults: Optional[pulumi.Input[pulumi.InputType['TargetVMDetailsArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 migrating_vm_id: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[pulumi.InputType['SchedulePolicyArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_vm_id: Optional[pulumi.Input[str]] = None,
                 target_defaults: Optional[pulumi.Input[pulumi.InputType['TargetVMDetailsArgs']]] = None,
                 __props__=None):
        """
        Creates a new MigratingVm in a given Source.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ComputeEngineTargetDefaultsArgs']] compute_engine_target_defaults: Details of the target VM in Compute Engine.
        :param pulumi.Input[pulumi.InputType['TargetVMDetailsArgs']] compute_engine_vm_defaults: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.
        :param pulumi.Input[str] description: The description attached to the migrating VM by the user.
        :param pulumi.Input[str] display_name: The display name attached to the MigratingVm by the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels of the migrating VM.
        :param pulumi.Input[str] migrating_vm_id: Required. The migratingVm identifier.
        :param pulumi.Input[pulumi.InputType['SchedulePolicyArgs']] policy: The replication schedule policy.
        :param pulumi.Input[str] request_id: A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] source_vm_id: The unique ID of the VM in the source. The VM's name in vSphere can be changed, so this is not the VM's name but rather its moRef id. This id is of the form vm-.
        :param pulumi.Input[pulumi.InputType['TargetVMDetailsArgs']] target_defaults: The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigratingVmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new MigratingVm in a given Source.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param MigratingVmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigratingVmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_engine_target_defaults: Optional[pulumi.Input[pulumi.InputType['ComputeEngineTargetDefaultsArgs']]] = None,
                 compute_engine_vm_defaults: Optional[pulumi.Input[pulumi.InputType['TargetVMDetailsArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 migrating_vm_id: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[pulumi.InputType['SchedulePolicyArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_vm_id: Optional[pulumi.Input[str]] = None,
                 target_defaults: Optional[pulumi.Input[pulumi.InputType['TargetVMDetailsArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigratingVmArgs.__new__(MigratingVmArgs)

            __props__.__dict__["compute_engine_target_defaults"] = compute_engine_target_defaults
            if compute_engine_vm_defaults is not None and not opts.urn:
                warnings.warn("""Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.""", DeprecationWarning)
                pulumi.log.warn("""compute_engine_vm_defaults is deprecated: Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.""")
            __props__.__dict__["compute_engine_vm_defaults"] = compute_engine_vm_defaults
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            if migrating_vm_id is None and not opts.urn:
                raise TypeError("Missing required property 'migrating_vm_id'")
            __props__.__dict__["migrating_vm_id"] = migrating_vm_id
            __props__.__dict__["policy"] = policy
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            if source_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_id'")
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["source_vm_id"] = source_vm_id
            if target_defaults is not None and not opts.urn:
                warnings.warn("""The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.""", DeprecationWarning)
                pulumi.log.warn("""target_defaults is deprecated: The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.""")
            __props__.__dict__["target_defaults"] = target_defaults
            __props__.__dict__["aws_source_vm_details"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["current_sync_info"] = None
            __props__.__dict__["error"] = None
            __props__.__dict__["group"] = None
            __props__.__dict__["last_sync"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["recent_clone_jobs"] = None
            __props__.__dict__["recent_cutover_jobs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_time"] = None
            __props__.__dict__["update_time"] = None
        super(MigratingVm, __self__).__init__(
            'google-native:vmmigration/v1alpha1:MigratingVm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MigratingVm':
        """
        Get an existing MigratingVm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MigratingVmArgs.__new__(MigratingVmArgs)

        __props__.__dict__["aws_source_vm_details"] = None
        __props__.__dict__["compute_engine_target_defaults"] = None
        __props__.__dict__["compute_engine_vm_defaults"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["current_sync_info"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["error"] = None
        __props__.__dict__["group"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["last_sync"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["policy"] = None
        __props__.__dict__["recent_clone_jobs"] = None
        __props__.__dict__["recent_cutover_jobs"] = None
        __props__.__dict__["source_vm_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["state_time"] = None
        __props__.__dict__["target_defaults"] = None
        __props__.__dict__["update_time"] = None
        return MigratingVm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsSourceVmDetails")
    def aws_source_vm_details(self) -> pulumi.Output['outputs.AwsSourceVmDetailsResponse']:
        """
        Details of the VM from an AWS source.
        """
        return pulumi.get(self, "aws_source_vm_details")

    @property
    @pulumi.getter(name="computeEngineTargetDefaults")
    def compute_engine_target_defaults(self) -> pulumi.Output['outputs.ComputeEngineTargetDefaultsResponse']:
        """
        Details of the target VM in Compute Engine.
        """
        return pulumi.get(self, "compute_engine_target_defaults")

    @property
    @pulumi.getter(name="computeEngineVmDefaults")
    def compute_engine_vm_defaults(self) -> pulumi.Output['outputs.TargetVMDetailsResponse']:
        """
        Details of the VM in Compute Engine. Deprecated: Use compute_engine_target_defaults instead.
        """
        return pulumi.get(self, "compute_engine_vm_defaults")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time the migrating VM was created (this refers to this resource and not to the time it was installed in the source).
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentSyncInfo")
    def current_sync_info(self) -> pulumi.Output['outputs.ReplicationCycleResponse']:
        """
        The percentage progress of the current running replication cycle.
        """
        return pulumi.get(self, "current_sync_info")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description attached to the migrating VM by the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name attached to the MigratingVm by the user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output['outputs.StatusResponse']:
        """
        Provides details on the state of the Migrating VM in case of an error in replication.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[str]:
        """
        The group this migrating vm is included in, if any. The group is represented by the full path of the appropriate Group resource.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The labels of the migrating VM.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastSync")
    def last_sync(self) -> pulumi.Output['outputs.ReplicationSyncResponse']:
        """
        The most updated snapshot created time in the source that finished replication.
        """
        return pulumi.get(self, "last_sync")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier of the MigratingVm.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output['outputs.SchedulePolicyResponse']:
        """
        The replication schedule policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="recentCloneJobs")
    def recent_clone_jobs(self) -> pulumi.Output[Sequence['outputs.CloneJobResponse']]:
        """
        The recent clone jobs performed on the migrating VM. This field holds the vm's last completed clone job and the vm's running clone job, if one exists. Note: To have this field populated you need to explicitly request it via the "view" parameter of the Get/List request.
        """
        return pulumi.get(self, "recent_clone_jobs")

    @property
    @pulumi.getter(name="recentCutoverJobs")
    def recent_cutover_jobs(self) -> pulumi.Output[Sequence['outputs.CutoverJobResponse']]:
        """
        The recent cutover jobs performed on the migrating VM. This field holds the vm's last completed cutover job and the vm's running cutover job, if one exists. Note: To have this field populated you need to explicitly request it via the "view" parameter of the Get/List request.
        """
        return pulumi.get(self, "recent_cutover_jobs")

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the VM in the source. The VM's name in vSphere can be changed, so this is not the VM's name but rather its moRef id. This id is of the form vm-.
        """
        return pulumi.get(self, "source_vm_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the MigratingVm.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> pulumi.Output[str]:
        """
        The last time the migrating VM state was updated.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter(name="targetDefaults")
    def target_defaults(self) -> pulumi.Output['outputs.TargetVMDetailsResponse']:
        """
        The default configuration of the target VM that will be created in GCP as a result of the migration. Deprecated: Use compute_engine_target_defaults instead.
        """
        return pulumi.get(self, "target_defaults")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last time the migrating VM resource was updated.
        """
        return pulumi.get(self, "update_time")

