# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ComputeEngineTargetDefaultsArgs',
    'ComputeSchedulingArgs',
    'NetworkInterfaceArgs',
    'SchedulePolicyArgs',
    'SchedulingNodeAffinityArgs',
    'VmUtilizationInfoArgs',
    'VmUtilizationMetricsArgs',
    'VmwareSourceDetailsArgs',
    'VmwareVmDetailsArgs',
]

@pulumi.input_type
class ComputeEngineTargetDefaultsArgs:
    def __init__(__self__, *,
                 additional_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compute_scheduling: Optional[pulumi.Input['ComputeSchedulingArgs']] = None,
                 disk_type: Optional[pulumi.Input['ComputeEngineTargetDefaultsDiskType']] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 license_type: Optional[pulumi.Input['ComputeEngineTargetDefaultsLicenseType']] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 machine_type_series: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure_boot: Optional[pulumi.Input[bool]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 target_project: Optional[pulumi.Input[str]] = None,
                 vm_name: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        ComputeEngineTargetDefaults is a collection of details for creating a VM in a target Compute Engine project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_licenses: Additional licenses to assign to the VM.
        :param pulumi.Input['ComputeSchedulingArgs'] compute_scheduling: Compute instance scheduling information (if empty default is used).
        :param pulumi.Input['ComputeEngineTargetDefaultsDiskType'] disk_type: The disk type to use in the VM.
        :param pulumi.Input[str] hostname: The hostname to assign to the VM.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A map of labels to associate with the VM.
        :param pulumi.Input['ComputeEngineTargetDefaultsLicenseType'] license_type: The license type to use in OS adaptation.
        :param pulumi.Input[str] machine_type: The machine type to create the VM with.
        :param pulumi.Input[str] machine_type_series: The machine type series to create the VM with.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata key/value pairs to assign to the VM.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]] network_interfaces: List of NICs connected to this VM.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_tags: A map of network tags to associate with the VM.
        :param pulumi.Input[bool] secure_boot: Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        :param pulumi.Input[str] service_account: The service account to associate the VM with.
        :param pulumi.Input[str] target_project: The full path of the resource of type TargetProject which represents the Compute Engine project in which to create this VM.
        :param pulumi.Input[str] vm_name: The name of the VM to create.
        :param pulumi.Input[str] zone: The zone in which to create the VM.
        """
        if additional_licenses is not None:
            pulumi.set(__self__, "additional_licenses", additional_licenses)
        if compute_scheduling is not None:
            pulumi.set(__self__, "compute_scheduling", compute_scheduling)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if machine_type_series is not None:
            pulumi.set(__self__, "machine_type_series", machine_type_series)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if secure_boot is not None:
            pulumi.set(__self__, "secure_boot", secure_boot)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if target_project is not None:
            pulumi.set(__self__, "target_project", target_project)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalLicenses")
    def additional_licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional licenses to assign to the VM.
        """
        return pulumi.get(self, "additional_licenses")

    @additional_licenses.setter
    def additional_licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_licenses", value)

    @property
    @pulumi.getter(name="computeScheduling")
    def compute_scheduling(self) -> Optional[pulumi.Input['ComputeSchedulingArgs']]:
        """
        Compute instance scheduling information (if empty default is used).
        """
        return pulumi.get(self, "compute_scheduling")

    @compute_scheduling.setter
    def compute_scheduling(self, value: Optional[pulumi.Input['ComputeSchedulingArgs']]):
        pulumi.set(self, "compute_scheduling", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input['ComputeEngineTargetDefaultsDiskType']]:
        """
        The disk type to use in the VM.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input['ComputeEngineTargetDefaultsDiskType']]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to assign to the VM.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of labels to associate with the VM.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input['ComputeEngineTargetDefaultsLicenseType']]:
        """
        The license type to use in OS adaptation.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input['ComputeEngineTargetDefaultsLicenseType']]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to create the VM with.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="machineTypeSeries")
    def machine_type_series(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type series to create the VM with.
        """
        return pulumi.get(self, "machine_type_series")

    @machine_type_series.setter
    def machine_type_series(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type_series", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The metadata key/value pairs to assign to the VM.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]:
        """
        List of NICs connected to this VM.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A map of network tags to associate with the VM.
        """
        return pulumi.get(self, "network_tags")

    @network_tags.setter
    def network_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_tags", value)

    @property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has Secure Boot enabled. This can be set to true only if the vm boot option is EFI.
        """
        return pulumi.get(self, "secure_boot")

    @secure_boot.setter
    def secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure_boot", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account to associate the VM with.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="targetProject")
    def target_project(self) -> Optional[pulumi.Input[str]]:
        """
        The full path of the resource of type TargetProject which represents the Compute Engine project in which to create this VM.
        """
        return pulumi.get(self, "target_project")

    @target_project.setter
    def target_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_project", value)

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VM to create.
        """
        return pulumi.get(self, "vm_name")

    @vm_name.setter
    def vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_name", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone in which to create the VM.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class ComputeSchedulingArgs:
    def __init__(__self__, *,
                 min_node_cpus: Optional[pulumi.Input[int]] = None,
                 node_affinities: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]]] = None,
                 on_host_maintenance: Optional[pulumi.Input['ComputeSchedulingOnHostMaintenance']] = None,
                 restart_type: Optional[pulumi.Input['ComputeSchedulingRestartType']] = None):
        """
        Scheduling information for VM on maintenance/restart behaviour and node allocation in sole tenant nodes.
        :param pulumi.Input[int] min_node_cpus: The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node. Ignored if no node_affinites are configured.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]] node_affinities: A set of node affinity and anti-affinity configurations for sole tenant nodes.
        :param pulumi.Input['ComputeSchedulingOnHostMaintenance'] on_host_maintenance: How the instance should behave when the host machine undergoes maintenance that may temporarily impact instance performance.
        :param pulumi.Input['ComputeSchedulingRestartType'] restart_type: Whether the Instance should be automatically restarted whenever it is terminated by Compute Engine (not terminated by user). This configuration is identical to `automaticRestart` field in Compute Engine create instance under scheduling. It was changed to an enum (instead of a boolean) to match the default value in Compute Engine which is automatic restart.
        """
        if min_node_cpus is not None:
            pulumi.set(__self__, "min_node_cpus", min_node_cpus)
        if node_affinities is not None:
            pulumi.set(__self__, "node_affinities", node_affinities)
        if on_host_maintenance is not None:
            pulumi.set(__self__, "on_host_maintenance", on_host_maintenance)
        if restart_type is not None:
            pulumi.set(__self__, "restart_type", restart_type)

    @property
    @pulumi.getter(name="minNodeCpus")
    def min_node_cpus(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node. Ignored if no node_affinites are configured.
        """
        return pulumi.get(self, "min_node_cpus")

    @min_node_cpus.setter
    def min_node_cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_cpus", value)

    @property
    @pulumi.getter(name="nodeAffinities")
    def node_affinities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]]]:
        """
        A set of node affinity and anti-affinity configurations for sole tenant nodes.
        """
        return pulumi.get(self, "node_affinities")

    @node_affinities.setter
    def node_affinities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]]]):
        pulumi.set(self, "node_affinities", value)

    @property
    @pulumi.getter(name="onHostMaintenance")
    def on_host_maintenance(self) -> Optional[pulumi.Input['ComputeSchedulingOnHostMaintenance']]:
        """
        How the instance should behave when the host machine undergoes maintenance that may temporarily impact instance performance.
        """
        return pulumi.get(self, "on_host_maintenance")

    @on_host_maintenance.setter
    def on_host_maintenance(self, value: Optional[pulumi.Input['ComputeSchedulingOnHostMaintenance']]):
        pulumi.set(self, "on_host_maintenance", value)

    @property
    @pulumi.getter(name="restartType")
    def restart_type(self) -> Optional[pulumi.Input['ComputeSchedulingRestartType']]:
        """
        Whether the Instance should be automatically restarted whenever it is terminated by Compute Engine (not terminated by user). This configuration is identical to `automaticRestart` field in Compute Engine create instance under scheduling. It was changed to an enum (instead of a boolean) to match the default value in Compute Engine which is automatic restart.
        """
        return pulumi.get(self, "restart_type")

    @restart_type.setter
    def restart_type(self, value: Optional[pulumi.Input['ComputeSchedulingRestartType']]):
        pulumi.set(self, "restart_type", value)


@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 external_ip: Optional[pulumi.Input[str]] = None,
                 internal_ip: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        NetworkInterface represents a NIC of a VM.
        :param pulumi.Input[str] external_ip: The external IP to define in the NIC.
        :param pulumi.Input[str] internal_ip: The internal IP to define in the NIC. The formats accepted are: `ephemeral` \ ipv4 address \ a named address resource full path.
        :param pulumi.Input[str] network: The network to connect the NIC to.
        :param pulumi.Input[str] subnetwork: The subnetwork to connect the NIC to.
        """
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The external IP to define in the NIC.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_ip", value)

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The internal IP to define in the NIC. The formats accepted are: `ephemeral` \ ipv4 address \ a named address resource full path.
        """
        return pulumi.get(self, "internal_ip")

    @internal_ip.setter
    def internal_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_ip", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The network to connect the NIC to.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The subnetwork to connect the NIC to.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class SchedulePolicyArgs:
    def __init__(__self__, *,
                 idle_duration: Optional[pulumi.Input[str]] = None,
                 skip_os_adaptation: Optional[pulumi.Input[bool]] = None):
        """
        A policy for scheduling replications.
        :param pulumi.Input[str] idle_duration: The idle duration between replication stages.
        :param pulumi.Input[bool] skip_os_adaptation: A flag to indicate whether to skip OS adaptation during the replication sync. OS adaptation is a process where the VM's operating system undergoes changes and adaptations to fully function on Compute Engine.
        """
        if idle_duration is not None:
            pulumi.set(__self__, "idle_duration", idle_duration)
        if skip_os_adaptation is not None:
            pulumi.set(__self__, "skip_os_adaptation", skip_os_adaptation)

    @property
    @pulumi.getter(name="idleDuration")
    def idle_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The idle duration between replication stages.
        """
        return pulumi.get(self, "idle_duration")

    @idle_duration.setter
    def idle_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_duration", value)

    @property
    @pulumi.getter(name="skipOsAdaptation")
    def skip_os_adaptation(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag to indicate whether to skip OS adaptation during the replication sync. OS adaptation is a process where the VM's operating system undergoes changes and adaptations to fully function on Compute Engine.
        """
        return pulumi.get(self, "skip_os_adaptation")

    @skip_os_adaptation.setter
    def skip_os_adaptation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_os_adaptation", value)


@pulumi.input_type
class SchedulingNodeAffinityArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input['SchedulingNodeAffinityOperator']] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled. Based on https://cloud.google.com/compute/docs/reference/rest/v1/instances/setScheduling
        :param pulumi.Input[str] key: The label key of Node resource to reference.
        :param pulumi.Input['SchedulingNodeAffinityOperator'] operator: The operator to use for the node resources specified in the `values` parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Corresponds to the label values of Node resource.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The label key of Node resource to reference.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input['SchedulingNodeAffinityOperator']]:
        """
        The operator to use for the node resources specified in the `values` parameter.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input['SchedulingNodeAffinityOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Corresponds to the label values of Node resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class VmUtilizationInfoArgs:
    def __init__(__self__, *,
                 utilization: Optional[pulumi.Input['VmUtilizationMetricsArgs']] = None,
                 vm_id: Optional[pulumi.Input[str]] = None,
                 vmware_vm_details: Optional[pulumi.Input['VmwareVmDetailsArgs']] = None):
        """
        Utilization information of a single VM.
        :param pulumi.Input['VmUtilizationMetricsArgs'] utilization: Utilization metrics for this VM.
        :param pulumi.Input[str] vm_id: The VM's ID in the source.
        :param pulumi.Input['VmwareVmDetailsArgs'] vmware_vm_details: The description of the VM in a Source of type Vmware.
        """
        if utilization is not None:
            pulumi.set(__self__, "utilization", utilization)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if vmware_vm_details is not None:
            pulumi.set(__self__, "vmware_vm_details", vmware_vm_details)

    @property
    @pulumi.getter
    def utilization(self) -> Optional[pulumi.Input['VmUtilizationMetricsArgs']]:
        """
        Utilization metrics for this VM.
        """
        return pulumi.get(self, "utilization")

    @utilization.setter
    def utilization(self, value: Optional[pulumi.Input['VmUtilizationMetricsArgs']]):
        pulumi.set(self, "utilization", value)

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VM's ID in the source.
        """
        return pulumi.get(self, "vm_id")

    @vm_id.setter
    def vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_id", value)

    @property
    @pulumi.getter(name="vmwareVmDetails")
    def vmware_vm_details(self) -> Optional[pulumi.Input['VmwareVmDetailsArgs']]:
        """
        The description of the VM in a Source of type Vmware.
        """
        return pulumi.get(self, "vmware_vm_details")

    @vmware_vm_details.setter
    def vmware_vm_details(self, value: Optional[pulumi.Input['VmwareVmDetailsArgs']]):
        pulumi.set(self, "vmware_vm_details", value)


@pulumi.input_type
class VmUtilizationMetricsArgs:
    def __init__(__self__, *,
                 cpu_average_percent: Optional[pulumi.Input[int]] = None,
                 cpu_max_percent: Optional[pulumi.Input[int]] = None,
                 disk_io_rate_average_kbps: Optional[pulumi.Input[str]] = None,
                 disk_io_rate_max_kbps: Optional[pulumi.Input[str]] = None,
                 memory_average_percent: Optional[pulumi.Input[int]] = None,
                 memory_max_percent: Optional[pulumi.Input[int]] = None,
                 network_throughput_average_kbps: Optional[pulumi.Input[str]] = None,
                 network_throughput_max_kbps: Optional[pulumi.Input[str]] = None):
        """
        Utilization metrics values for a single VM.
        :param pulumi.Input[int] cpu_average_percent: Average CPU usage, percent.
        :param pulumi.Input[int] cpu_max_percent: Max CPU usage, percent.
        :param pulumi.Input[str] disk_io_rate_average_kbps: Average disk IO rate, in kilobytes per second.
        :param pulumi.Input[str] disk_io_rate_max_kbps: Max disk IO rate, in kilobytes per second.
        :param pulumi.Input[int] memory_average_percent: Average memory usage, percent.
        :param pulumi.Input[int] memory_max_percent: Max memory usage, percent.
        :param pulumi.Input[str] network_throughput_average_kbps: Average network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        :param pulumi.Input[str] network_throughput_max_kbps: Max network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        if cpu_average_percent is not None:
            pulumi.set(__self__, "cpu_average_percent", cpu_average_percent)
        if cpu_max_percent is not None:
            pulumi.set(__self__, "cpu_max_percent", cpu_max_percent)
        if disk_io_rate_average_kbps is not None:
            pulumi.set(__self__, "disk_io_rate_average_kbps", disk_io_rate_average_kbps)
        if disk_io_rate_max_kbps is not None:
            pulumi.set(__self__, "disk_io_rate_max_kbps", disk_io_rate_max_kbps)
        if memory_average_percent is not None:
            pulumi.set(__self__, "memory_average_percent", memory_average_percent)
        if memory_max_percent is not None:
            pulumi.set(__self__, "memory_max_percent", memory_max_percent)
        if network_throughput_average_kbps is not None:
            pulumi.set(__self__, "network_throughput_average_kbps", network_throughput_average_kbps)
        if network_throughput_max_kbps is not None:
            pulumi.set(__self__, "network_throughput_max_kbps", network_throughput_max_kbps)

    @property
    @pulumi.getter(name="cpuAveragePercent")
    def cpu_average_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Average CPU usage, percent.
        """
        return pulumi.get(self, "cpu_average_percent")

    @cpu_average_percent.setter
    def cpu_average_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_average_percent", value)

    @property
    @pulumi.getter(name="cpuMaxPercent")
    def cpu_max_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Max CPU usage, percent.
        """
        return pulumi.get(self, "cpu_max_percent")

    @cpu_max_percent.setter
    def cpu_max_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_max_percent", value)

    @property
    @pulumi.getter(name="diskIoRateAverageKbps")
    def disk_io_rate_average_kbps(self) -> Optional[pulumi.Input[str]]:
        """
        Average disk IO rate, in kilobytes per second.
        """
        return pulumi.get(self, "disk_io_rate_average_kbps")

    @disk_io_rate_average_kbps.setter
    def disk_io_rate_average_kbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_io_rate_average_kbps", value)

    @property
    @pulumi.getter(name="diskIoRateMaxKbps")
    def disk_io_rate_max_kbps(self) -> Optional[pulumi.Input[str]]:
        """
        Max disk IO rate, in kilobytes per second.
        """
        return pulumi.get(self, "disk_io_rate_max_kbps")

    @disk_io_rate_max_kbps.setter
    def disk_io_rate_max_kbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_io_rate_max_kbps", value)

    @property
    @pulumi.getter(name="memoryAveragePercent")
    def memory_average_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Average memory usage, percent.
        """
        return pulumi.get(self, "memory_average_percent")

    @memory_average_percent.setter
    def memory_average_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_average_percent", value)

    @property
    @pulumi.getter(name="memoryMaxPercent")
    def memory_max_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Max memory usage, percent.
        """
        return pulumi.get(self, "memory_max_percent")

    @memory_max_percent.setter
    def memory_max_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_max_percent", value)

    @property
    @pulumi.getter(name="networkThroughputAverageKbps")
    def network_throughput_average_kbps(self) -> Optional[pulumi.Input[str]]:
        """
        Average network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        return pulumi.get(self, "network_throughput_average_kbps")

    @network_throughput_average_kbps.setter
    def network_throughput_average_kbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_throughput_average_kbps", value)

    @property
    @pulumi.getter(name="networkThroughputMaxKbps")
    def network_throughput_max_kbps(self) -> Optional[pulumi.Input[str]]:
        """
        Max network throughput (combined transmit-rates and receive-rates), in kilobytes per second.
        """
        return pulumi.get(self, "network_throughput_max_kbps")

    @network_throughput_max_kbps.setter
    def network_throughput_max_kbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_throughput_max_kbps", value)


@pulumi.input_type
class VmwareSourceDetailsArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vcenter_ip: Optional[pulumi.Input[str]] = None):
        """
        VmwareSourceDetails message describes a specific source details for the vmware source type.
        :param pulumi.Input[str] password: Input only. The credentials password. This is write only and can not be read in a GET operation.
        :param pulumi.Input[str] thumbprint: The thumbprint representing the certificate for the vcenter.
        :param pulumi.Input[str] username: The credentials username.
        :param pulumi.Input[str] vcenter_ip: The ip address of the vcenter this Source represents.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vcenter_ip is not None:
            pulumi.set(__self__, "vcenter_ip", vcenter_ip)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The credentials password. This is write only and can not be read in a GET operation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint representing the certificate for the vcenter.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The credentials username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vcenterIp")
    def vcenter_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the vcenter this Source represents.
        """
        return pulumi.get(self, "vcenter_ip")

    @vcenter_ip.setter
    def vcenter_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_ip", value)


@pulumi.input_type
class VmwareVmDetailsArgs:
    def __init__(__self__, *,
                 committed_storage_mb: Optional[pulumi.Input[str]] = None,
                 cpu_count: Optional[pulumi.Input[int]] = None,
                 datacenter_description: Optional[pulumi.Input[str]] = None,
                 datacenter_id: Optional[pulumi.Input[str]] = None,
                 disk_count: Optional[pulumi.Input[int]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 guest_description: Optional[pulumi.Input[str]] = None,
                 memory_mb: Optional[pulumi.Input[int]] = None,
                 power_state: Optional[pulumi.Input['VmwareVmDetailsPowerState']] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 vm_id: Optional[pulumi.Input[str]] = None):
        """
        VmwareVmDetails describes a VM in vCenter.
        :param pulumi.Input[str] committed_storage_mb: The total size of the storage allocated to the VM in MB.
        :param pulumi.Input[int] cpu_count: The number of cpus in the VM.
        :param pulumi.Input[str] datacenter_description: The descriptive name of the vCenter's datacenter this VM is contained in.
        :param pulumi.Input[str] datacenter_id: The id of the vCenter's datacenter this VM is contained in.
        :param pulumi.Input[int] disk_count: The number of disks the VM has.
        :param pulumi.Input[str] display_name: The display name of the VM. Note that this is not necessarily unique.
        :param pulumi.Input[str] guest_description: The VM's OS. See for example https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html for types of strings this might hold.
        :param pulumi.Input[int] memory_mb: The size of the memory of the VM in MB.
        :param pulumi.Input['VmwareVmDetailsPowerState'] power_state: The power state of the VM at the moment list was taken.
        :param pulumi.Input[str] uuid: The unique identifier of the VM in vCenter.
        :param pulumi.Input[str] vm_id: The VM's id in the source (note that this is not the MigratingVm's id). This is the moref id of the VM.
        """
        if committed_storage_mb is not None:
            pulumi.set(__self__, "committed_storage_mb", committed_storage_mb)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if datacenter_description is not None:
            pulumi.set(__self__, "datacenter_description", datacenter_description)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if guest_description is not None:
            pulumi.set(__self__, "guest_description", guest_description)
        if memory_mb is not None:
            pulumi.set(__self__, "memory_mb", memory_mb)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)

    @property
    @pulumi.getter(name="committedStorageMb")
    def committed_storage_mb(self) -> Optional[pulumi.Input[str]]:
        """
        The total size of the storage allocated to the VM in MB.
        """
        return pulumi.get(self, "committed_storage_mb")

    @committed_storage_mb.setter
    def committed_storage_mb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committed_storage_mb", value)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of cpus in the VM.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_count", value)

    @property
    @pulumi.getter(name="datacenterDescription")
    def datacenter_description(self) -> Optional[pulumi.Input[str]]:
        """
        The descriptive name of the vCenter's datacenter this VM is contained in.
        """
        return pulumi.get(self, "datacenter_description")

    @datacenter_description.setter
    def datacenter_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter_description", value)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the vCenter's datacenter this VM is contained in.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of disks the VM has.
        """
        return pulumi.get(self, "disk_count")

    @disk_count.setter
    def disk_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_count", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the VM. Note that this is not necessarily unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="guestDescription")
    def guest_description(self) -> Optional[pulumi.Input[str]]:
        """
        The VM's OS. See for example https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html for types of strings this might hold.
        """
        return pulumi.get(self, "guest_description")

    @guest_description.setter
    def guest_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest_description", value)

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the memory of the VM in MB.
        """
        return pulumi.get(self, "memory_mb")

    @memory_mb.setter
    def memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_mb", value)

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input['VmwareVmDetailsPowerState']]:
        """
        The power state of the VM at the moment list was taken.
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input['VmwareVmDetailsPowerState']]):
        pulumi.set(self, "power_state", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the VM in vCenter.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VM's id in the source (note that this is not the MigratingVm's id). This is the moref id of the VM.
        """
        return pulumi.get(self, "vm_id")

    @vm_id.setter
    def vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_id", value)


