# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AdBreakArgs',
    'AnimationEndArgs',
    'AnimationFadeArgs',
    'AnimationStaticArgs',
    'AnimationArgs',
    'AudioMappingArgs',
    'AudioStreamArgs',
    'AudioArgs',
    'ColorArgs',
    'CropArgs',
    'DeblockArgs',
    'DenoiseArgs',
    'EditAtomArgs',
    'ElementaryStreamArgs',
    'H264CodecSettingsArgs',
    'H265CodecSettingsArgs',
    'ImageArgs',
    'InputArgs',
    'JobConfigArgs',
    'ManifestArgs',
    'MuxStreamArgs',
    'NormalizedCoordinateArgs',
    'OutputArgs',
    'OverlayArgs',
    'PadArgs',
    'PreprocessingConfigArgs',
    'PubsubDestinationArgs',
    'SegmentSettingsArgs',
    'SpriteSheetArgs',
    'TextMappingArgs',
    'TextStreamArgs',
    'VideoStreamArgs',
    'Vp9CodecSettingsArgs',
]

@pulumi.input_type
class AdBreakArgs:
    def __init__(__self__, *,
                 start_time_offset: Optional[pulumi.Input[str]] = None):
        """
        Ad break.
        :param pulumi.Input[str] start_time_offset: Start time in seconds for the ad break, relative to the output file timeline. The default is `0s`.
        """
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Start time in seconds for the ad break, relative to the output file timeline. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_offset", value)


@pulumi.input_type
class AnimationEndArgs:
    def __init__(__self__, *,
                 start_time_offset: Optional[pulumi.Input[str]] = None):
        """
        End previous overlay animation from the video. Without AnimationEnd, the overlay object will keep the state of previous animation until the end of the video.
        :param pulumi.Input[str] start_time_offset: The time to end overlay object, in seconds. Default: 0
        """
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        The time to end overlay object, in seconds. Default: 0
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_offset", value)


@pulumi.input_type
class AnimationFadeArgs:
    def __init__(__self__, *,
                 fade_type: pulumi.Input['AnimationFadeFadeType'],
                 end_time_offset: Optional[pulumi.Input[str]] = None,
                 start_time_offset: Optional[pulumi.Input[str]] = None,
                 xy: Optional[pulumi.Input['NormalizedCoordinateArgs']] = None):
        """
        Display overlay object with fade animation.
        :param pulumi.Input['AnimationFadeFadeType'] fade_type: Type of fade animation: `FADE_IN` or `FADE_OUT`.
        :param pulumi.Input[str] end_time_offset: The time to end the fade animation, in seconds. Default: `start_time_offset` + 1s
        :param pulumi.Input[str] start_time_offset: The time to start the fade animation, in seconds. Default: 0
        :param pulumi.Input['NormalizedCoordinateArgs'] xy: Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        pulumi.set(__self__, "fade_type", fade_type)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)
        if xy is not None:
            pulumi.set(__self__, "xy", xy)

    @property
    @pulumi.getter(name="fadeType")
    def fade_type(self) -> pulumi.Input['AnimationFadeFadeType']:
        """
        Type of fade animation: `FADE_IN` or `FADE_OUT`.
        """
        return pulumi.get(self, "fade_type")

    @fade_type.setter
    def fade_type(self, value: pulumi.Input['AnimationFadeFadeType']):
        pulumi.set(self, "fade_type", value)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        The time to end the fade animation, in seconds. Default: `start_time_offset` + 1s
        """
        return pulumi.get(self, "end_time_offset")

    @end_time_offset.setter
    def end_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_offset", value)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        The time to start the fade animation, in seconds. Default: 0
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_offset", value)

    @property
    @pulumi.getter
    def xy(self) -> Optional[pulumi.Input['NormalizedCoordinateArgs']]:
        """
        Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        return pulumi.get(self, "xy")

    @xy.setter
    def xy(self, value: Optional[pulumi.Input['NormalizedCoordinateArgs']]):
        pulumi.set(self, "xy", value)


@pulumi.input_type
class AnimationStaticArgs:
    def __init__(__self__, *,
                 start_time_offset: Optional[pulumi.Input[str]] = None,
                 xy: Optional[pulumi.Input['NormalizedCoordinateArgs']] = None):
        """
        Display static overlay object.
        :param pulumi.Input[str] start_time_offset: The time to start displaying the overlay object, in seconds. Default: 0
        :param pulumi.Input['NormalizedCoordinateArgs'] xy: Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)
        if xy is not None:
            pulumi.set(__self__, "xy", xy)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        The time to start displaying the overlay object, in seconds. Default: 0
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_offset", value)

    @property
    @pulumi.getter
    def xy(self) -> Optional[pulumi.Input['NormalizedCoordinateArgs']]:
        """
        Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        return pulumi.get(self, "xy")

    @xy.setter
    def xy(self, value: Optional[pulumi.Input['NormalizedCoordinateArgs']]):
        pulumi.set(self, "xy", value)


@pulumi.input_type
class AnimationArgs:
    def __init__(__self__, *,
                 animation_end: Optional[pulumi.Input['AnimationEndArgs']] = None,
                 animation_fade: Optional[pulumi.Input['AnimationFadeArgs']] = None,
                 animation_static: Optional[pulumi.Input['AnimationStaticArgs']] = None):
        """
        Animation types.
        :param pulumi.Input['AnimationEndArgs'] animation_end: End previous animation.
        :param pulumi.Input['AnimationFadeArgs'] animation_fade: Display overlay object with fade animation.
        :param pulumi.Input['AnimationStaticArgs'] animation_static: Display static overlay object.
        """
        if animation_end is not None:
            pulumi.set(__self__, "animation_end", animation_end)
        if animation_fade is not None:
            pulumi.set(__self__, "animation_fade", animation_fade)
        if animation_static is not None:
            pulumi.set(__self__, "animation_static", animation_static)

    @property
    @pulumi.getter(name="animationEnd")
    def animation_end(self) -> Optional[pulumi.Input['AnimationEndArgs']]:
        """
        End previous animation.
        """
        return pulumi.get(self, "animation_end")

    @animation_end.setter
    def animation_end(self, value: Optional[pulumi.Input['AnimationEndArgs']]):
        pulumi.set(self, "animation_end", value)

    @property
    @pulumi.getter(name="animationFade")
    def animation_fade(self) -> Optional[pulumi.Input['AnimationFadeArgs']]:
        """
        Display overlay object with fade animation.
        """
        return pulumi.get(self, "animation_fade")

    @animation_fade.setter
    def animation_fade(self, value: Optional[pulumi.Input['AnimationFadeArgs']]):
        pulumi.set(self, "animation_fade", value)

    @property
    @pulumi.getter(name="animationStatic")
    def animation_static(self) -> Optional[pulumi.Input['AnimationStaticArgs']]:
        """
        Display static overlay object.
        """
        return pulumi.get(self, "animation_static")

    @animation_static.setter
    def animation_static(self, value: Optional[pulumi.Input['AnimationStaticArgs']]):
        pulumi.set(self, "animation_static", value)


@pulumi.input_type
class AudioMappingArgs:
    def __init__(__self__, *,
                 atom_key: pulumi.Input[str],
                 input_channel: pulumi.Input[int],
                 input_key: pulumi.Input[str],
                 input_track: pulumi.Input[int],
                 output_channel: pulumi.Input[int],
                 gain_db: Optional[pulumi.Input[float]] = None):
        """
        The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
        :param pulumi.Input[str] atom_key: The `EditAtom.key` that references the atom with audio inputs in the `Job.edit_list`.
        :param pulumi.Input[int] input_channel: The zero-based index of the channel in the input audio stream.
        :param pulumi.Input[str] input_key: The `Input.key` that identifies the input file.
        :param pulumi.Input[int] input_track: The zero-based index of the track in the input file.
        :param pulumi.Input[int] output_channel: The zero-based index of the channel in the output audio stream.
        :param pulumi.Input[float] gain_db: Audio volume control in dB. Negative values decrease volume, positive values increase. The default is 0.
        """
        pulumi.set(__self__, "atom_key", atom_key)
        pulumi.set(__self__, "input_channel", input_channel)
        pulumi.set(__self__, "input_key", input_key)
        pulumi.set(__self__, "input_track", input_track)
        pulumi.set(__self__, "output_channel", output_channel)
        if gain_db is not None:
            pulumi.set(__self__, "gain_db", gain_db)

    @property
    @pulumi.getter(name="atomKey")
    def atom_key(self) -> pulumi.Input[str]:
        """
        The `EditAtom.key` that references the atom with audio inputs in the `Job.edit_list`.
        """
        return pulumi.get(self, "atom_key")

    @atom_key.setter
    def atom_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "atom_key", value)

    @property
    @pulumi.getter(name="inputChannel")
    def input_channel(self) -> pulumi.Input[int]:
        """
        The zero-based index of the channel in the input audio stream.
        """
        return pulumi.get(self, "input_channel")

    @input_channel.setter
    def input_channel(self, value: pulumi.Input[int]):
        pulumi.set(self, "input_channel", value)

    @property
    @pulumi.getter(name="inputKey")
    def input_key(self) -> pulumi.Input[str]:
        """
        The `Input.key` that identifies the input file.
        """
        return pulumi.get(self, "input_key")

    @input_key.setter
    def input_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_key", value)

    @property
    @pulumi.getter(name="inputTrack")
    def input_track(self) -> pulumi.Input[int]:
        """
        The zero-based index of the track in the input file.
        """
        return pulumi.get(self, "input_track")

    @input_track.setter
    def input_track(self, value: pulumi.Input[int]):
        pulumi.set(self, "input_track", value)

    @property
    @pulumi.getter(name="outputChannel")
    def output_channel(self) -> pulumi.Input[int]:
        """
        The zero-based index of the channel in the output audio stream.
        """
        return pulumi.get(self, "output_channel")

    @output_channel.setter
    def output_channel(self, value: pulumi.Input[int]):
        pulumi.set(self, "output_channel", value)

    @property
    @pulumi.getter(name="gainDb")
    def gain_db(self) -> Optional[pulumi.Input[float]]:
        """
        Audio volume control in dB. Negative values decrease volume, positive values increase. The default is 0.
        """
        return pulumi.get(self, "gain_db")

    @gain_db.setter
    def gain_db(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "gain_db", value)


@pulumi.input_type
class AudioStreamArgs:
    def __init__(__self__, *,
                 bitrate_bps: pulumi.Input[int],
                 channel_count: Optional[pulumi.Input[int]] = None,
                 channel_layout: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 codec: Optional[pulumi.Input[str]] = None,
                 mapping: Optional[pulumi.Input[Sequence[pulumi.Input['AudioMappingArgs']]]] = None,
                 sample_rate_hertz: Optional[pulumi.Input[int]] = None):
        """
        Audio stream resource.
        :param pulumi.Input[int] bitrate_bps: Audio bitrate in bits per second. Must be between 1 and 10,000,000.
        :param pulumi.Input[int] channel_count: Number of audio channels. Must be between 1 and 6. The default is 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] channel_layout: A list of channel names specifying layout of the audio channels. This only affects the metadata embedded in the container headers, if supported by the specified format. The default is `["fl", "fr"]`. Supported channel names: - `fl` - Front left channel - `fr` - Front right channel - `sl` - Side left channel - `sr` - Side right channel - `fc` - Front center channel - `lfe` - Low frequency
        :param pulumi.Input[str] codec: The codec for this audio stream. The default is `aac`. Supported audio codecs: - `aac` - `aac-he` - `aac-he-v2` - `mp3` - `ac3` - `eac3`
        :param pulumi.Input[Sequence[pulumi.Input['AudioMappingArgs']]] mapping: The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
        :param pulumi.Input[int] sample_rate_hertz: The audio sample rate in Hertz. The default is 48000 Hertz.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        if channel_count is not None:
            pulumi.set(__self__, "channel_count", channel_count)
        if channel_layout is not None:
            pulumi.set(__self__, "channel_layout", channel_layout)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if mapping is not None:
            pulumi.set(__self__, "mapping", mapping)
        if sample_rate_hertz is not None:
            pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> pulumi.Input[int]:
        """
        Audio bitrate in bits per second. Must be between 1 and 10,000,000.
        """
        return pulumi.get(self, "bitrate_bps")

    @bitrate_bps.setter
    def bitrate_bps(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate_bps", value)

    @property
    @pulumi.getter(name="channelCount")
    def channel_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of audio channels. Must be between 1 and 6. The default is 2.
        """
        return pulumi.get(self, "channel_count")

    @channel_count.setter
    def channel_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "channel_count", value)

    @property
    @pulumi.getter(name="channelLayout")
    def channel_layout(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of channel names specifying layout of the audio channels. This only affects the metadata embedded in the container headers, if supported by the specified format. The default is `["fl", "fr"]`. Supported channel names: - `fl` - Front left channel - `fr` - Front right channel - `sl` - Side left channel - `sr` - Side right channel - `fc` - Front center channel - `lfe` - Low frequency
        """
        return pulumi.get(self, "channel_layout")

    @channel_layout.setter
    def channel_layout(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "channel_layout", value)

    @property
    @pulumi.getter
    def codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec for this audio stream. The default is `aac`. Supported audio codecs: - `aac` - `aac-he` - `aac-he-v2` - `mp3` - `ac3` - `eac3`
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter
    def mapping(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AudioMappingArgs']]]]:
        """
        The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
        """
        return pulumi.get(self, "mapping")

    @mapping.setter
    def mapping(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AudioMappingArgs']]]]):
        pulumi.set(self, "mapping", value)

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> Optional[pulumi.Input[int]]:
        """
        The audio sample rate in Hertz. The default is 48000 Hertz.
        """
        return pulumi.get(self, "sample_rate_hertz")

    @sample_rate_hertz.setter
    def sample_rate_hertz(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_rate_hertz", value)


@pulumi.input_type
class AudioArgs:
    def __init__(__self__, *,
                 high_boost: Optional[pulumi.Input[bool]] = None,
                 low_boost: Optional[pulumi.Input[bool]] = None,
                 lufs: Optional[pulumi.Input[float]] = None):
        """
        Audio preprocessing configuration.
        :param pulumi.Input[bool] high_boost: Enable boosting high frequency components. The default is `false`. **Note:** This field is not supported.
        :param pulumi.Input[bool] low_boost: Enable boosting low frequency components. The default is `false`. **Note:** This field is not supported.
        :param pulumi.Input[float] lufs: Specify audio loudness normalization in loudness units relative to full scale (LUFS). Enter a value between -24 and 0 (the default), where: * -24 is the Advanced Television Systems Committee (ATSC A/85) standard * -23 is the EU R128 broadcast standard * -19 is the prior standard for online mono audio * -18 is the ReplayGain standard * -16 is the prior standard for stereo audio * -14 is the new online audio standard recommended by Spotify, as well as Amazon Echo * 0 disables normalization
        """
        if high_boost is not None:
            pulumi.set(__self__, "high_boost", high_boost)
        if low_boost is not None:
            pulumi.set(__self__, "low_boost", low_boost)
        if lufs is not None:
            pulumi.set(__self__, "lufs", lufs)

    @property
    @pulumi.getter(name="highBoost")
    def high_boost(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable boosting high frequency components. The default is `false`. **Note:** This field is not supported.
        """
        return pulumi.get(self, "high_boost")

    @high_boost.setter
    def high_boost(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "high_boost", value)

    @property
    @pulumi.getter(name="lowBoost")
    def low_boost(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable boosting low frequency components. The default is `false`. **Note:** This field is not supported.
        """
        return pulumi.get(self, "low_boost")

    @low_boost.setter
    def low_boost(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "low_boost", value)

    @property
    @pulumi.getter
    def lufs(self) -> Optional[pulumi.Input[float]]:
        """
        Specify audio loudness normalization in loudness units relative to full scale (LUFS). Enter a value between -24 and 0 (the default), where: * -24 is the Advanced Television Systems Committee (ATSC A/85) standard * -23 is the EU R128 broadcast standard * -19 is the prior standard for online mono audio * -18 is the ReplayGain standard * -16 is the prior standard for stereo audio * -14 is the new online audio standard recommended by Spotify, as well as Amazon Echo * 0 disables normalization
        """
        return pulumi.get(self, "lufs")

    @lufs.setter
    def lufs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "lufs", value)


@pulumi.input_type
class ColorArgs:
    def __init__(__self__, *,
                 brightness: Optional[pulumi.Input[float]] = None,
                 contrast: Optional[pulumi.Input[float]] = None,
                 saturation: Optional[pulumi.Input[float]] = None):
        """
        Color preprocessing configuration. **Note:** This configuration is not supported.
        :param pulumi.Input[float] brightness: Control brightness of the video. Enter a value between -1 and 1, where -1 is minimum brightness and 1 is maximum brightness. 0 is no change. The default is 0.
        :param pulumi.Input[float] contrast: Control black and white contrast of the video. Enter a value between -1 and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no change. The default is 0.
        :param pulumi.Input[float] saturation: Control color saturation of the video. Enter a value between -1 and 1, where -1 is fully desaturated and 1 is maximum saturation. 0 is no change. The default is 0.
        """
        if brightness is not None:
            pulumi.set(__self__, "brightness", brightness)
        if contrast is not None:
            pulumi.set(__self__, "contrast", contrast)
        if saturation is not None:
            pulumi.set(__self__, "saturation", saturation)

    @property
    @pulumi.getter
    def brightness(self) -> Optional[pulumi.Input[float]]:
        """
        Control brightness of the video. Enter a value between -1 and 1, where -1 is minimum brightness and 1 is maximum brightness. 0 is no change. The default is 0.
        """
        return pulumi.get(self, "brightness")

    @brightness.setter
    def brightness(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "brightness", value)

    @property
    @pulumi.getter
    def contrast(self) -> Optional[pulumi.Input[float]]:
        """
        Control black and white contrast of the video. Enter a value between -1 and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no change. The default is 0.
        """
        return pulumi.get(self, "contrast")

    @contrast.setter
    def contrast(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "contrast", value)

    @property
    @pulumi.getter
    def saturation(self) -> Optional[pulumi.Input[float]]:
        """
        Control color saturation of the video. Enter a value between -1 and 1, where -1 is fully desaturated and 1 is maximum saturation. 0 is no change. The default is 0.
        """
        return pulumi.get(self, "saturation")

    @saturation.setter
    def saturation(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "saturation", value)


@pulumi.input_type
class CropArgs:
    def __init__(__self__, *,
                 bottom_pixels: Optional[pulumi.Input[int]] = None,
                 left_pixels: Optional[pulumi.Input[int]] = None,
                 right_pixels: Optional[pulumi.Input[int]] = None,
                 top_pixels: Optional[pulumi.Input[int]] = None):
        """
        Video cropping configuration for the input video. The cropped input video is scaled to match the output resolution.
        :param pulumi.Input[int] bottom_pixels: The number of pixels to crop from the bottom. The default is 0.
        :param pulumi.Input[int] left_pixels: The number of pixels to crop from the left. The default is 0.
        :param pulumi.Input[int] right_pixels: The number of pixels to crop from the right. The default is 0.
        :param pulumi.Input[int] top_pixels: The number of pixels to crop from the top. The default is 0.
        """
        if bottom_pixels is not None:
            pulumi.set(__self__, "bottom_pixels", bottom_pixels)
        if left_pixels is not None:
            pulumi.set(__self__, "left_pixels", left_pixels)
        if right_pixels is not None:
            pulumi.set(__self__, "right_pixels", right_pixels)
        if top_pixels is not None:
            pulumi.set(__self__, "top_pixels", top_pixels)

    @property
    @pulumi.getter(name="bottomPixels")
    def bottom_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to crop from the bottom. The default is 0.
        """
        return pulumi.get(self, "bottom_pixels")

    @bottom_pixels.setter
    def bottom_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bottom_pixels", value)

    @property
    @pulumi.getter(name="leftPixels")
    def left_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to crop from the left. The default is 0.
        """
        return pulumi.get(self, "left_pixels")

    @left_pixels.setter
    def left_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "left_pixels", value)

    @property
    @pulumi.getter(name="rightPixels")
    def right_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to crop from the right. The default is 0.
        """
        return pulumi.get(self, "right_pixels")

    @right_pixels.setter
    def right_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "right_pixels", value)

    @property
    @pulumi.getter(name="topPixels")
    def top_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to crop from the top. The default is 0.
        """
        return pulumi.get(self, "top_pixels")

    @top_pixels.setter
    def top_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "top_pixels", value)


@pulumi.input_type
class DeblockArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 strength: Optional[pulumi.Input[float]] = None):
        """
        Deblock preprocessing configuration. **Note:** This configuration is not supported.
        :param pulumi.Input[bool] enabled: Enable deblocker. The default is `false`.
        :param pulumi.Input[float] strength: Set strength of the deblocker. Enter a value between 0 and 1. The higher the value, the stronger the block removal. 0 is no deblocking. The default is 0.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if strength is not None:
            pulumi.set(__self__, "strength", strength)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable deblocker. The default is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def strength(self) -> Optional[pulumi.Input[float]]:
        """
        Set strength of the deblocker. Enter a value between 0 and 1. The higher the value, the stronger the block removal. 0 is no deblocking. The default is 0.
        """
        return pulumi.get(self, "strength")

    @strength.setter
    def strength(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "strength", value)


@pulumi.input_type
class DenoiseArgs:
    def __init__(__self__, *,
                 strength: Optional[pulumi.Input[float]] = None,
                 tune: Optional[pulumi.Input[str]] = None):
        """
        Denoise preprocessing configuration. **Note:** This configuration is not supported.
        :param pulumi.Input[float] strength: Set strength of the denoise. Enter a value between 0 and 1. The higher the value, the smoother the image. 0 is no denoising. The default is 0.
        :param pulumi.Input[str] tune: Set the denoiser mode. The default is `standard`. Supported denoiser modes: - `standard` - `grain`
        """
        if strength is not None:
            pulumi.set(__self__, "strength", strength)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)

    @property
    @pulumi.getter
    def strength(self) -> Optional[pulumi.Input[float]]:
        """
        Set strength of the denoise. Enter a value between 0 and 1. The higher the value, the smoother the image. 0 is no denoising. The default is 0.
        """
        return pulumi.get(self, "strength")

    @strength.setter
    def strength(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "strength", value)

    @property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input[str]]:
        """
        Set the denoiser mode. The default is `standard`. Supported denoiser modes: - `standard` - `grain`
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tune", value)


@pulumi.input_type
class EditAtomArgs:
    def __init__(__self__, *,
                 end_time_offset: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 start_time_offset: Optional[pulumi.Input[str]] = None):
        """
        Edit atom.
        :param pulumi.Input[str] end_time_offset: End time in seconds for the atom, relative to the input file timeline. When `end_time_offset` is not specified, the `inputs` are used until the end of the atom.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inputs: List of `Input.key`s identifying files that should be used in this atom. The listed `inputs` must have the same timeline.
        :param pulumi.Input[str] key: A unique key for this atom. Must be specified when using advanced mapping.
        :param pulumi.Input[str] start_time_offset: Start time in seconds for the atom, relative to the input file timeline. The default is `0s`.
        """
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        End time in seconds for the atom, relative to the input file timeline. When `end_time_offset` is not specified, the `inputs` are used until the end of the atom.
        """
        return pulumi.get(self, "end_time_offset")

    @end_time_offset.setter
    def end_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_offset", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of `Input.key`s identifying files that should be used in this atom. The listed `inputs` must have the same timeline.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A unique key for this atom. Must be specified when using advanced mapping.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Start time in seconds for the atom, relative to the input file timeline. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_offset", value)


@pulumi.input_type
class ElementaryStreamArgs:
    def __init__(__self__, *,
                 audio_stream: Optional[pulumi.Input['AudioStreamArgs']] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 text_stream: Optional[pulumi.Input['TextStreamArgs']] = None,
                 video_stream: Optional[pulumi.Input['VideoStreamArgs']] = None):
        """
        Encoding of an input file such as an audio, video, or text track. Elementary streams must be packaged before mapping and sharing between different output formats.
        :param pulumi.Input['AudioStreamArgs'] audio_stream: Encoding of an audio stream.
        :param pulumi.Input[str] key: A unique key for this elementary stream.
        :param pulumi.Input['TextStreamArgs'] text_stream: Encoding of a text stream. For example, closed captions or subtitles.
        :param pulumi.Input['VideoStreamArgs'] video_stream: Encoding of a video stream.
        """
        if audio_stream is not None:
            pulumi.set(__self__, "audio_stream", audio_stream)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if text_stream is not None:
            pulumi.set(__self__, "text_stream", text_stream)
        if video_stream is not None:
            pulumi.set(__self__, "video_stream", video_stream)

    @property
    @pulumi.getter(name="audioStream")
    def audio_stream(self) -> Optional[pulumi.Input['AudioStreamArgs']]:
        """
        Encoding of an audio stream.
        """
        return pulumi.get(self, "audio_stream")

    @audio_stream.setter
    def audio_stream(self, value: Optional[pulumi.Input['AudioStreamArgs']]):
        pulumi.set(self, "audio_stream", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A unique key for this elementary stream.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="textStream")
    def text_stream(self) -> Optional[pulumi.Input['TextStreamArgs']]:
        """
        Encoding of a text stream. For example, closed captions or subtitles.
        """
        return pulumi.get(self, "text_stream")

    @text_stream.setter
    def text_stream(self, value: Optional[pulumi.Input['TextStreamArgs']]):
        pulumi.set(self, "text_stream", value)

    @property
    @pulumi.getter(name="videoStream")
    def video_stream(self) -> Optional[pulumi.Input['VideoStreamArgs']]:
        """
        Encoding of a video stream.
        """
        return pulumi.get(self, "video_stream")

    @video_stream.setter
    def video_stream(self, value: Optional[pulumi.Input['VideoStreamArgs']]):
        pulumi.set(self, "video_stream", value)


@pulumi.input_type
class H264CodecSettingsArgs:
    def __init__(__self__, *,
                 bitrate_bps: pulumi.Input[int],
                 frame_rate: pulumi.Input[float],
                 allow_open_gop: Optional[pulumi.Input[bool]] = None,
                 aq_strength: Optional[pulumi.Input[float]] = None,
                 b_frame_count: Optional[pulumi.Input[int]] = None,
                 b_pyramid: Optional[pulumi.Input[bool]] = None,
                 crf_level: Optional[pulumi.Input[int]] = None,
                 enable_two_pass: Optional[pulumi.Input[bool]] = None,
                 entropy_coder: Optional[pulumi.Input[str]] = None,
                 gop_duration: Optional[pulumi.Input[str]] = None,
                 gop_frame_count: Optional[pulumi.Input[int]] = None,
                 height_pixels: Optional[pulumi.Input[int]] = None,
                 pixel_format: Optional[pulumi.Input[str]] = None,
                 preset: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 rate_control_mode: Optional[pulumi.Input[str]] = None,
                 tune: Optional[pulumi.Input[str]] = None,
                 vbv_fullness_bits: Optional[pulumi.Input[int]] = None,
                 vbv_size_bits: Optional[pulumi.Input[int]] = None,
                 width_pixels: Optional[pulumi.Input[int]] = None):
        """
        H264 codec settings.
        :param pulumi.Input[int] bitrate_bps: The video bitrate in bits per second. The minimum value is 1,000. The maximum value is 800,000,000.
        :param pulumi.Input[float] frame_rate: The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. See [Calculating frame rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for more information.
        :param pulumi.Input[bool] allow_open_gop: Specifies whether an open Group of Pictures (GOP) structure should be allowed or not. The default is `false`.
        :param pulumi.Input[float] aq_strength: Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A higher value equals a lower bitrate but smoother image. The default is 0.
        :param pulumi.Input[int] b_frame_count: The number of consecutive B-frames. Must be greater than or equal to zero. Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
        :param pulumi.Input[bool] b_pyramid: Allow B-pyramid for reference frame selection. This may not be supported on all decoders. The default is `false`.
        :param pulumi.Input[int] crf_level: Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21.
        :param pulumi.Input[bool] enable_two_pass: Use two-pass encoding strategy to achieve better video quality. `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
        :param pulumi.Input[str] entropy_coder: The entropy coder to use. The default is `cabac`. Supported entropy coders: - `cavlc` - `cabac`
        :param pulumi.Input[str] gop_duration: Select the GOP size based on the specified duration. The default is `3s`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        :param pulumi.Input[int] gop_frame_count: Select the GOP size based on the specified frame count. Must be greater than zero.
        :param pulumi.Input[int] height_pixels: The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        :param pulumi.Input[str] pixel_format: Pixel format to use. The default is `yuv420p`. Supported pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format - `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format - `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR pixel format - `yuv444p12` 12-bit HDR pixel format
        :param pulumi.Input[str] preset: Enforces the specified codec preset. The default is `veryfast`. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset). Note that certain values for this field may cause the transcoder to override other fields you set in the `H264CodecSettings` message.
        :param pulumi.Input[str] profile: Enforces the specified codec profile. The following profiles are supported: * `baseline` * `main` * `high` (default) The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune). Note that certain values for this field may cause the transcoder to override other fields you set in the `H264CodecSettings` message.
        :param pulumi.Input[str] rate_control_mode: Specify the `rate_control_mode`. The default is `vbr`. Supported rate control modes: - `vbr` - variable bitrate - `crf` - constant rate factor
        :param pulumi.Input[str] tune: Enforces the specified codec tune. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune). Note that certain values for this field may cause the transcoder to override other fields you set in the `H264CodecSettings` message.
        :param pulumi.Input[int] vbv_fullness_bits: Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to 90% of `VideoStream.vbv_size_bits`.
        :param pulumi.Input[int] vbv_size_bits: Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to `VideoStream.bitrate_bps`.
        :param pulumi.Input[int] width_pixels: The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "frame_rate", frame_rate)
        if allow_open_gop is not None:
            pulumi.set(__self__, "allow_open_gop", allow_open_gop)
        if aq_strength is not None:
            pulumi.set(__self__, "aq_strength", aq_strength)
        if b_frame_count is not None:
            pulumi.set(__self__, "b_frame_count", b_frame_count)
        if b_pyramid is not None:
            pulumi.set(__self__, "b_pyramid", b_pyramid)
        if crf_level is not None:
            pulumi.set(__self__, "crf_level", crf_level)
        if enable_two_pass is not None:
            pulumi.set(__self__, "enable_two_pass", enable_two_pass)
        if entropy_coder is not None:
            pulumi.set(__self__, "entropy_coder", entropy_coder)
        if gop_duration is not None:
            pulumi.set(__self__, "gop_duration", gop_duration)
        if gop_frame_count is not None:
            pulumi.set(__self__, "gop_frame_count", gop_frame_count)
        if height_pixels is not None:
            pulumi.set(__self__, "height_pixels", height_pixels)
        if pixel_format is not None:
            pulumi.set(__self__, "pixel_format", pixel_format)
        if preset is not None:
            pulumi.set(__self__, "preset", preset)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if vbv_fullness_bits is not None:
            pulumi.set(__self__, "vbv_fullness_bits", vbv_fullness_bits)
        if vbv_size_bits is not None:
            pulumi.set(__self__, "vbv_size_bits", vbv_size_bits)
        if width_pixels is not None:
            pulumi.set(__self__, "width_pixels", width_pixels)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> pulumi.Input[int]:
        """
        The video bitrate in bits per second. The minimum value is 1,000. The maximum value is 800,000,000.
        """
        return pulumi.get(self, "bitrate_bps")

    @bitrate_bps.setter
    def bitrate_bps(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate_bps", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> pulumi.Input[float]:
        """
        The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. See [Calculating frame rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for more information.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: pulumi.Input[float]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter(name="allowOpenGop")
    def allow_open_gop(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an open Group of Pictures (GOP) structure should be allowed or not. The default is `false`.
        """
        return pulumi.get(self, "allow_open_gop")

    @allow_open_gop.setter
    def allow_open_gop(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_open_gop", value)

    @property
    @pulumi.getter(name="aqStrength")
    def aq_strength(self) -> Optional[pulumi.Input[float]]:
        """
        Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A higher value equals a lower bitrate but smoother image. The default is 0.
        """
        return pulumi.get(self, "aq_strength")

    @aq_strength.setter
    def aq_strength(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "aq_strength", value)

    @property
    @pulumi.getter(name="bFrameCount")
    def b_frame_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive B-frames. Must be greater than or equal to zero. Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
        """
        return pulumi.get(self, "b_frame_count")

    @b_frame_count.setter
    def b_frame_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "b_frame_count", value)

    @property
    @pulumi.getter(name="bPyramid")
    def b_pyramid(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow B-pyramid for reference frame selection. This may not be supported on all decoders. The default is `false`.
        """
        return pulumi.get(self, "b_pyramid")

    @b_pyramid.setter
    def b_pyramid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "b_pyramid", value)

    @property
    @pulumi.getter(name="crfLevel")
    def crf_level(self) -> Optional[pulumi.Input[int]]:
        """
        Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21.
        """
        return pulumi.get(self, "crf_level")

    @crf_level.setter
    def crf_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "crf_level", value)

    @property
    @pulumi.getter(name="enableTwoPass")
    def enable_two_pass(self) -> Optional[pulumi.Input[bool]]:
        """
        Use two-pass encoding strategy to achieve better video quality. `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
        """
        return pulumi.get(self, "enable_two_pass")

    @enable_two_pass.setter
    def enable_two_pass(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_two_pass", value)

    @property
    @pulumi.getter(name="entropyCoder")
    def entropy_coder(self) -> Optional[pulumi.Input[str]]:
        """
        The entropy coder to use. The default is `cabac`. Supported entropy coders: - `cavlc` - `cabac`
        """
        return pulumi.get(self, "entropy_coder")

    @entropy_coder.setter
    def entropy_coder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entropy_coder", value)

    @property
    @pulumi.getter(name="gopDuration")
    def gop_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Select the GOP size based on the specified duration. The default is `3s`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        """
        return pulumi.get(self, "gop_duration")

    @gop_duration.setter
    def gop_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gop_duration", value)

    @property
    @pulumi.getter(name="gopFrameCount")
    def gop_frame_count(self) -> Optional[pulumi.Input[int]]:
        """
        Select the GOP size based on the specified frame count. Must be greater than zero.
        """
        return pulumi.get(self, "gop_frame_count")

    @gop_frame_count.setter
    def gop_frame_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gop_frame_count", value)

    @property
    @pulumi.getter(name="heightPixels")
    def height_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        """
        return pulumi.get(self, "height_pixels")

    @height_pixels.setter
    def height_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height_pixels", value)

    @property
    @pulumi.getter(name="pixelFormat")
    def pixel_format(self) -> Optional[pulumi.Input[str]]:
        """
        Pixel format to use. The default is `yuv420p`. Supported pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format - `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format - `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR pixel format - `yuv444p12` 12-bit HDR pixel format
        """
        return pulumi.get(self, "pixel_format")

    @pixel_format.setter
    def pixel_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pixel_format", value)

    @property
    @pulumi.getter
    def preset(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec preset. The default is `veryfast`. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset). Note that certain values for this field may cause the transcoder to override other fields you set in the `H264CodecSettings` message.
        """
        return pulumi.get(self, "preset")

    @preset.setter
    def preset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preset", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec profile. The following profiles are supported: * `baseline` * `main` * `high` (default) The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune). Note that certain values for this field may cause the transcoder to override other fields you set in the `H264CodecSettings` message.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the `rate_control_mode`. The default is `vbr`. Supported rate control modes: - `vbr` - variable bitrate - `crf` - constant rate factor
        """
        return pulumi.get(self, "rate_control_mode")

    @rate_control_mode.setter
    def rate_control_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate_control_mode", value)

    @property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec tune. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune). Note that certain values for this field may cause the transcoder to override other fields you set in the `H264CodecSettings` message.
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tune", value)

    @property
    @pulumi.getter(name="vbvFullnessBits")
    def vbv_fullness_bits(self) -> Optional[pulumi.Input[int]]:
        """
        Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to 90% of `VideoStream.vbv_size_bits`.
        """
        return pulumi.get(self, "vbv_fullness_bits")

    @vbv_fullness_bits.setter
    def vbv_fullness_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vbv_fullness_bits", value)

    @property
    @pulumi.getter(name="vbvSizeBits")
    def vbv_size_bits(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to `VideoStream.bitrate_bps`.
        """
        return pulumi.get(self, "vbv_size_bits")

    @vbv_size_bits.setter
    def vbv_size_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vbv_size_bits", value)

    @property
    @pulumi.getter(name="widthPixels")
    def width_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        return pulumi.get(self, "width_pixels")

    @width_pixels.setter
    def width_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width_pixels", value)


@pulumi.input_type
class H265CodecSettingsArgs:
    def __init__(__self__, *,
                 bitrate_bps: pulumi.Input[int],
                 frame_rate: pulumi.Input[float],
                 allow_open_gop: Optional[pulumi.Input[bool]] = None,
                 aq_strength: Optional[pulumi.Input[float]] = None,
                 b_frame_count: Optional[pulumi.Input[int]] = None,
                 b_pyramid: Optional[pulumi.Input[bool]] = None,
                 crf_level: Optional[pulumi.Input[int]] = None,
                 enable_two_pass: Optional[pulumi.Input[bool]] = None,
                 gop_duration: Optional[pulumi.Input[str]] = None,
                 gop_frame_count: Optional[pulumi.Input[int]] = None,
                 height_pixels: Optional[pulumi.Input[int]] = None,
                 pixel_format: Optional[pulumi.Input[str]] = None,
                 preset: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 rate_control_mode: Optional[pulumi.Input[str]] = None,
                 tune: Optional[pulumi.Input[str]] = None,
                 vbv_fullness_bits: Optional[pulumi.Input[int]] = None,
                 vbv_size_bits: Optional[pulumi.Input[int]] = None,
                 width_pixels: Optional[pulumi.Input[int]] = None):
        """
        H265 codec settings.
        :param pulumi.Input[int] bitrate_bps: The video bitrate in bits per second. The minimum value is 1,000. The maximum value is 800,000,000.
        :param pulumi.Input[float] frame_rate: The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. See [Calculating frame rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for more information.
        :param pulumi.Input[bool] allow_open_gop: Specifies whether an open Group of Pictures (GOP) structure should be allowed or not. The default is `false`.
        :param pulumi.Input[float] aq_strength: Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A higher value equals a lower bitrate but smoother image. The default is 0.
        :param pulumi.Input[int] b_frame_count: The number of consecutive B-frames. Must be greater than or equal to zero. Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
        :param pulumi.Input[bool] b_pyramid: Allow B-pyramid for reference frame selection. This may not be supported on all decoders. The default is `false`.
        :param pulumi.Input[int] crf_level: Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21.
        :param pulumi.Input[bool] enable_two_pass: Use two-pass encoding strategy to achieve better video quality. `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
        :param pulumi.Input[str] gop_duration: Select the GOP size based on the specified duration. The default is `3s`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        :param pulumi.Input[int] gop_frame_count: Select the GOP size based on the specified frame count. Must be greater than zero.
        :param pulumi.Input[int] height_pixels: The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        :param pulumi.Input[str] pixel_format: Pixel format to use. The default is `yuv420p`. Supported pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format - `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format - `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR pixel format - `yuv444p12` 12-bit HDR pixel format
        :param pulumi.Input[str] preset: Enforces the specified codec preset. The default is `veryfast`. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265). Note that certain values for this field may cause the transcoder to override other fields you set in the `H265CodecSettings` message.
        :param pulumi.Input[str] profile: Enforces the specified codec profile. The following profiles are supported: * 8-bit profiles * `main` (default) * `main-intra` * `mainstillpicture` * 10-bit profiles * `main10` (default) * `main10-intra` * `main422-10` * `main422-10-intra` * `main444-10` * `main444-10-intra` * 12-bit profiles * `main12` (default) * `main12-intra` * `main422-12` * `main422-12-intra` * `main444-12` * `main444-12-intra` The available options are [FFmpeg-compatible](https://x265.readthedocs.io/). Note that certain values for this field may cause the transcoder to override other fields you set in the `H265CodecSettings` message.
        :param pulumi.Input[str] rate_control_mode: Specify the `rate_control_mode`. The default is `vbr`. Supported rate control modes: - `vbr` - variable bitrate - `crf` - constant rate factor
        :param pulumi.Input[str] tune: Enforces the specified codec tune. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265). Note that certain values for this field may cause the transcoder to override other fields you set in the `H265CodecSettings` message.
        :param pulumi.Input[int] vbv_fullness_bits: Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to 90% of `VideoStream.vbv_size_bits`.
        :param pulumi.Input[int] vbv_size_bits: Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to `VideoStream.bitrate_bps`.
        :param pulumi.Input[int] width_pixels: The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "frame_rate", frame_rate)
        if allow_open_gop is not None:
            pulumi.set(__self__, "allow_open_gop", allow_open_gop)
        if aq_strength is not None:
            pulumi.set(__self__, "aq_strength", aq_strength)
        if b_frame_count is not None:
            pulumi.set(__self__, "b_frame_count", b_frame_count)
        if b_pyramid is not None:
            pulumi.set(__self__, "b_pyramid", b_pyramid)
        if crf_level is not None:
            pulumi.set(__self__, "crf_level", crf_level)
        if enable_two_pass is not None:
            pulumi.set(__self__, "enable_two_pass", enable_two_pass)
        if gop_duration is not None:
            pulumi.set(__self__, "gop_duration", gop_duration)
        if gop_frame_count is not None:
            pulumi.set(__self__, "gop_frame_count", gop_frame_count)
        if height_pixels is not None:
            pulumi.set(__self__, "height_pixels", height_pixels)
        if pixel_format is not None:
            pulumi.set(__self__, "pixel_format", pixel_format)
        if preset is not None:
            pulumi.set(__self__, "preset", preset)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if vbv_fullness_bits is not None:
            pulumi.set(__self__, "vbv_fullness_bits", vbv_fullness_bits)
        if vbv_size_bits is not None:
            pulumi.set(__self__, "vbv_size_bits", vbv_size_bits)
        if width_pixels is not None:
            pulumi.set(__self__, "width_pixels", width_pixels)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> pulumi.Input[int]:
        """
        The video bitrate in bits per second. The minimum value is 1,000. The maximum value is 800,000,000.
        """
        return pulumi.get(self, "bitrate_bps")

    @bitrate_bps.setter
    def bitrate_bps(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate_bps", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> pulumi.Input[float]:
        """
        The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. See [Calculating frame rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for more information.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: pulumi.Input[float]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter(name="allowOpenGop")
    def allow_open_gop(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an open Group of Pictures (GOP) structure should be allowed or not. The default is `false`.
        """
        return pulumi.get(self, "allow_open_gop")

    @allow_open_gop.setter
    def allow_open_gop(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_open_gop", value)

    @property
    @pulumi.getter(name="aqStrength")
    def aq_strength(self) -> Optional[pulumi.Input[float]]:
        """
        Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A higher value equals a lower bitrate but smoother image. The default is 0.
        """
        return pulumi.get(self, "aq_strength")

    @aq_strength.setter
    def aq_strength(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "aq_strength", value)

    @property
    @pulumi.getter(name="bFrameCount")
    def b_frame_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive B-frames. Must be greater than or equal to zero. Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
        """
        return pulumi.get(self, "b_frame_count")

    @b_frame_count.setter
    def b_frame_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "b_frame_count", value)

    @property
    @pulumi.getter(name="bPyramid")
    def b_pyramid(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow B-pyramid for reference frame selection. This may not be supported on all decoders. The default is `false`.
        """
        return pulumi.get(self, "b_pyramid")

    @b_pyramid.setter
    def b_pyramid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "b_pyramid", value)

    @property
    @pulumi.getter(name="crfLevel")
    def crf_level(self) -> Optional[pulumi.Input[int]]:
        """
        Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21.
        """
        return pulumi.get(self, "crf_level")

    @crf_level.setter
    def crf_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "crf_level", value)

    @property
    @pulumi.getter(name="enableTwoPass")
    def enable_two_pass(self) -> Optional[pulumi.Input[bool]]:
        """
        Use two-pass encoding strategy to achieve better video quality. `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
        """
        return pulumi.get(self, "enable_two_pass")

    @enable_two_pass.setter
    def enable_two_pass(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_two_pass", value)

    @property
    @pulumi.getter(name="gopDuration")
    def gop_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Select the GOP size based on the specified duration. The default is `3s`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        """
        return pulumi.get(self, "gop_duration")

    @gop_duration.setter
    def gop_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gop_duration", value)

    @property
    @pulumi.getter(name="gopFrameCount")
    def gop_frame_count(self) -> Optional[pulumi.Input[int]]:
        """
        Select the GOP size based on the specified frame count. Must be greater than zero.
        """
        return pulumi.get(self, "gop_frame_count")

    @gop_frame_count.setter
    def gop_frame_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gop_frame_count", value)

    @property
    @pulumi.getter(name="heightPixels")
    def height_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        """
        return pulumi.get(self, "height_pixels")

    @height_pixels.setter
    def height_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height_pixels", value)

    @property
    @pulumi.getter(name="pixelFormat")
    def pixel_format(self) -> Optional[pulumi.Input[str]]:
        """
        Pixel format to use. The default is `yuv420p`. Supported pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format - `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format - `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR pixel format - `yuv444p12` 12-bit HDR pixel format
        """
        return pulumi.get(self, "pixel_format")

    @pixel_format.setter
    def pixel_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pixel_format", value)

    @property
    @pulumi.getter
    def preset(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec preset. The default is `veryfast`. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265). Note that certain values for this field may cause the transcoder to override other fields you set in the `H265CodecSettings` message.
        """
        return pulumi.get(self, "preset")

    @preset.setter
    def preset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preset", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec profile. The following profiles are supported: * 8-bit profiles * `main` (default) * `main-intra` * `mainstillpicture` * 10-bit profiles * `main10` (default) * `main10-intra` * `main422-10` * `main422-10-intra` * `main444-10` * `main444-10-intra` * 12-bit profiles * `main12` (default) * `main12-intra` * `main422-12` * `main422-12-intra` * `main444-12` * `main444-12-intra` The available options are [FFmpeg-compatible](https://x265.readthedocs.io/). Note that certain values for this field may cause the transcoder to override other fields you set in the `H265CodecSettings` message.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the `rate_control_mode`. The default is `vbr`. Supported rate control modes: - `vbr` - variable bitrate - `crf` - constant rate factor
        """
        return pulumi.get(self, "rate_control_mode")

    @rate_control_mode.setter
    def rate_control_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate_control_mode", value)

    @property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec tune. The available options are [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265). Note that certain values for this field may cause the transcoder to override other fields you set in the `H265CodecSettings` message.
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tune", value)

    @property
    @pulumi.getter(name="vbvFullnessBits")
    def vbv_fullness_bits(self) -> Optional[pulumi.Input[int]]:
        """
        Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to 90% of `VideoStream.vbv_size_bits`.
        """
        return pulumi.get(self, "vbv_fullness_bits")

    @vbv_fullness_bits.setter
    def vbv_fullness_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vbv_fullness_bits", value)

    @property
    @pulumi.getter(name="vbvSizeBits")
    def vbv_size_bits(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to `VideoStream.bitrate_bps`.
        """
        return pulumi.get(self, "vbv_size_bits")

    @vbv_size_bits.setter
    def vbv_size_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vbv_size_bits", value)

    @property
    @pulumi.getter(name="widthPixels")
    def width_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        return pulumi.get(self, "width_pixels")

    @width_pixels.setter
    def width_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width_pixels", value)


@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 alpha: Optional[pulumi.Input[float]] = None,
                 resolution: Optional[pulumi.Input['NormalizedCoordinateArgs']] = None):
        """
        Overlaid jpeg image.
        :param pulumi.Input[str] uri: URI of the JPEG image in Cloud Storage. For example, `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
        :param pulumi.Input[float] alpha: Target image opacity. Valid values are from `1.0` (solid, default) to `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
        :param pulumi.Input['NormalizedCoordinateArgs'] resolution: Normalized image resolution, based on output video resolution. Valid values: `0.0`–`1.0`. To respect the original image aspect ratio, set either `x` or `y` to `0.0`. To use the original image resolution, set both `x` and `y` to `0.0`.
        """
        pulumi.set(__self__, "uri", uri)
        if alpha is not None:
            pulumi.set(__self__, "alpha", alpha)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI of the JPEG image in Cloud Storage. For example, `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def alpha(self) -> Optional[pulumi.Input[float]]:
        """
        Target image opacity. Valid values are from `1.0` (solid, default) to `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
        """
        return pulumi.get(self, "alpha")

    @alpha.setter
    def alpha(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "alpha", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input['NormalizedCoordinateArgs']]:
        """
        Normalized image resolution, based on output video resolution. Valid values: `0.0`–`1.0`. To respect the original image aspect ratio, set either `x` or `y` to `0.0`. To use the original image resolution, set both `x` and `y` to `0.0`.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input['NormalizedCoordinateArgs']]):
        pulumi.set(self, "resolution", value)


@pulumi.input_type
class InputArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 preprocessing_config: Optional[pulumi.Input['PreprocessingConfigArgs']] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Input asset.
        :param pulumi.Input[str] key: A unique key for this input. Must be specified when using advanced mapping and edit lists.
        :param pulumi.Input['PreprocessingConfigArgs'] preprocessing_config: Preprocessing configurations.
        :param pulumi.Input[str] uri: URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). If empty, the value is populated from `Job.input_uri`. See [Supported input and output formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if preprocessing_config is not None:
            pulumi.set(__self__, "preprocessing_config", preprocessing_config)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A unique key for this input. Must be specified when using advanced mapping and edit lists.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="preprocessingConfig")
    def preprocessing_config(self) -> Optional[pulumi.Input['PreprocessingConfigArgs']]:
        """
        Preprocessing configurations.
        """
        return pulumi.get(self, "preprocessing_config")

    @preprocessing_config.setter
    def preprocessing_config(self, value: Optional[pulumi.Input['PreprocessingConfigArgs']]):
        pulumi.set(self, "preprocessing_config", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). If empty, the value is populated from `Job.input_uri`. See [Supported input and output formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class JobConfigArgs:
    def __init__(__self__, *,
                 ad_breaks: Optional[pulumi.Input[Sequence[pulumi.Input['AdBreakArgs']]]] = None,
                 edit_list: Optional[pulumi.Input[Sequence[pulumi.Input['EditAtomArgs']]]] = None,
                 elementary_streams: Optional[pulumi.Input[Sequence[pulumi.Input['ElementaryStreamArgs']]]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['InputArgs']]]] = None,
                 manifests: Optional[pulumi.Input[Sequence[pulumi.Input['ManifestArgs']]]] = None,
                 mux_streams: Optional[pulumi.Input[Sequence[pulumi.Input['MuxStreamArgs']]]] = None,
                 output: Optional[pulumi.Input['OutputArgs']] = None,
                 overlays: Optional[pulumi.Input[Sequence[pulumi.Input['OverlayArgs']]]] = None,
                 pubsub_destination: Optional[pulumi.Input['PubsubDestinationArgs']] = None,
                 sprite_sheets: Optional[pulumi.Input[Sequence[pulumi.Input['SpriteSheetArgs']]]] = None):
        """
        Job configuration
        :param pulumi.Input[Sequence[pulumi.Input['AdBreakArgs']]] ad_breaks: List of ad breaks. Specifies where to insert ad break tags in the output manifests.
        :param pulumi.Input[Sequence[pulumi.Input['EditAtomArgs']]] edit_list: List of `Edit atom`s. Defines the ultimate timeline of the resulting file or manifest.
        :param pulumi.Input[Sequence[pulumi.Input['ElementaryStreamArgs']]] elementary_streams: List of elementary streams.
        :param pulumi.Input[Sequence[pulumi.Input['InputArgs']]] inputs: List of input assets stored in Cloud Storage.
        :param pulumi.Input[Sequence[pulumi.Input['ManifestArgs']]] manifests: List of output manifests.
        :param pulumi.Input[Sequence[pulumi.Input['MuxStreamArgs']]] mux_streams: List of multiplexing settings for output streams.
        :param pulumi.Input['OutputArgs'] output: Output configuration.
        :param pulumi.Input[Sequence[pulumi.Input['OverlayArgs']]] overlays: List of overlays on the output video, in descending Z-order.
        :param pulumi.Input['PubsubDestinationArgs'] pubsub_destination: Destination on Pub/Sub.
        :param pulumi.Input[Sequence[pulumi.Input['SpriteSheetArgs']]] sprite_sheets: List of output sprite sheets.
        """
        if ad_breaks is not None:
            pulumi.set(__self__, "ad_breaks", ad_breaks)
        if edit_list is not None:
            pulumi.set(__self__, "edit_list", edit_list)
        if elementary_streams is not None:
            pulumi.set(__self__, "elementary_streams", elementary_streams)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if manifests is not None:
            pulumi.set(__self__, "manifests", manifests)
        if mux_streams is not None:
            pulumi.set(__self__, "mux_streams", mux_streams)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if pubsub_destination is not None:
            pulumi.set(__self__, "pubsub_destination", pubsub_destination)
        if sprite_sheets is not None:
            pulumi.set(__self__, "sprite_sheets", sprite_sheets)

    @property
    @pulumi.getter(name="adBreaks")
    def ad_breaks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdBreakArgs']]]]:
        """
        List of ad breaks. Specifies where to insert ad break tags in the output manifests.
        """
        return pulumi.get(self, "ad_breaks")

    @ad_breaks.setter
    def ad_breaks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdBreakArgs']]]]):
        pulumi.set(self, "ad_breaks", value)

    @property
    @pulumi.getter(name="editList")
    def edit_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EditAtomArgs']]]]:
        """
        List of `Edit atom`s. Defines the ultimate timeline of the resulting file or manifest.
        """
        return pulumi.get(self, "edit_list")

    @edit_list.setter
    def edit_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EditAtomArgs']]]]):
        pulumi.set(self, "edit_list", value)

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElementaryStreamArgs']]]]:
        """
        List of elementary streams.
        """
        return pulumi.get(self, "elementary_streams")

    @elementary_streams.setter
    def elementary_streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElementaryStreamArgs']]]]):
        pulumi.set(self, "elementary_streams", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InputArgs']]]]:
        """
        List of input assets stored in Cloud Storage.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def manifests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManifestArgs']]]]:
        """
        List of output manifests.
        """
        return pulumi.get(self, "manifests")

    @manifests.setter
    def manifests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManifestArgs']]]]):
        pulumi.set(self, "manifests", value)

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MuxStreamArgs']]]]:
        """
        List of multiplexing settings for output streams.
        """
        return pulumi.get(self, "mux_streams")

    @mux_streams.setter
    def mux_streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MuxStreamArgs']]]]):
        pulumi.set(self, "mux_streams", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['OutputArgs']]:
        """
        Output configuration.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['OutputArgs']]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter
    def overlays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OverlayArgs']]]]:
        """
        List of overlays on the output video, in descending Z-order.
        """
        return pulumi.get(self, "overlays")

    @overlays.setter
    def overlays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OverlayArgs']]]]):
        pulumi.set(self, "overlays", value)

    @property
    @pulumi.getter(name="pubsubDestination")
    def pubsub_destination(self) -> Optional[pulumi.Input['PubsubDestinationArgs']]:
        """
        Destination on Pub/Sub.
        """
        return pulumi.get(self, "pubsub_destination")

    @pubsub_destination.setter
    def pubsub_destination(self, value: Optional[pulumi.Input['PubsubDestinationArgs']]):
        pulumi.set(self, "pubsub_destination", value)

    @property
    @pulumi.getter(name="spriteSheets")
    def sprite_sheets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpriteSheetArgs']]]]:
        """
        List of output sprite sheets.
        """
        return pulumi.get(self, "sprite_sheets")

    @sprite_sheets.setter
    def sprite_sheets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpriteSheetArgs']]]]):
        pulumi.set(self, "sprite_sheets", value)


@pulumi.input_type
class ManifestArgs:
    def __init__(__self__, *,
                 mux_streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input['ManifestType'],
                 file_name: Optional[pulumi.Input[str]] = None):
        """
        Manifest configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mux_streams: List of user given `MuxStream.key`s that should appear in this manifest. When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key` and `.m3u8` extension is generated for each element of the `Manifest.mux_streams`.
        :param pulumi.Input['ManifestType'] type: Type of the manifest, can be `HLS` or `DASH`.
        :param pulumi.Input[str] file_name: The name of the generated file. The default is `manifest` with the extension suffix corresponding to the `Manifest.type`.
        """
        pulumi.set(__self__, "mux_streams", mux_streams)
        pulumi.set(__self__, "type", type)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of user given `MuxStream.key`s that should appear in this manifest. When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key` and `.m3u8` extension is generated for each element of the `Manifest.mux_streams`.
        """
        return pulumi.get(self, "mux_streams")

    @mux_streams.setter
    def mux_streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "mux_streams", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ManifestType']:
        """
        Type of the manifest, can be `HLS` or `DASH`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ManifestType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the generated file. The default is `manifest` with the extension suffix corresponding to the `Manifest.type`.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)


@pulumi.input_type
class MuxStreamArgs:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input[str]] = None,
                 elementary_streams: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 segment_settings: Optional[pulumi.Input['SegmentSettingsArgs']] = None):
        """
        Multiplexing settings for output stream.
        :param pulumi.Input[str] container: The container format. The default is `mp4` Supported container formats: - `ts` - `fmp4`- the corresponding file extension is `.m4s` - `mp4` - `vtt` See also: [Supported input and output formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elementary_streams: List of `ElementaryStream.key`s multiplexed in this stream.
        :param pulumi.Input[str] file_name: The name of the generated file. The default is `MuxStream.key` with the extension suffix corresponding to the `MuxStream.container`. Individual segments also have an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `mux_stream0000000123.ts`.
        :param pulumi.Input[str] key: A unique key for this multiplexed stream. HLS media manifests will be named `MuxStream.key` with the `.m3u8` extension suffix.
        :param pulumi.Input['SegmentSettingsArgs'] segment_settings: Segment settings for `ts`, `fmp4` and `vtt`.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if elementary_streams is not None:
            pulumi.set(__self__, "elementary_streams", elementary_streams)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if segment_settings is not None:
            pulumi.set(__self__, "segment_settings", segment_settings)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        The container format. The default is `mp4` Supported container formats: - `ts` - `fmp4`- the corresponding file extension is `.m4s` - `mp4` - `vtt` See also: [Supported input and output formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of `ElementaryStream.key`s multiplexed in this stream.
        """
        return pulumi.get(self, "elementary_streams")

    @elementary_streams.setter
    def elementary_streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elementary_streams", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the generated file. The default is `MuxStream.key` with the extension suffix corresponding to the `MuxStream.container`. Individual segments also have an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `mux_stream0000000123.ts`.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A unique key for this multiplexed stream. HLS media manifests will be named `MuxStream.key` with the `.m3u8` extension suffix.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="segmentSettings")
    def segment_settings(self) -> Optional[pulumi.Input['SegmentSettingsArgs']]:
        """
        Segment settings for `ts`, `fmp4` and `vtt`.
        """
        return pulumi.get(self, "segment_settings")

    @segment_settings.setter
    def segment_settings(self, value: Optional[pulumi.Input['SegmentSettingsArgs']]):
        pulumi.set(self, "segment_settings", value)


@pulumi.input_type
class NormalizedCoordinateArgs:
    def __init__(__self__, *,
                 x: Optional[pulumi.Input[float]] = None,
                 y: Optional[pulumi.Input[float]] = None):
        """
        2D normalized coordinates. Default: `{0.0, 0.0}`
        :param pulumi.Input[float] x: Normalized x coordinate.
        :param pulumi.Input[float] y: Normalized y coordinate.
        """
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> Optional[pulumi.Input[float]]:
        """
        Normalized x coordinate.
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def y(self) -> Optional[pulumi.Input[float]]:
        """
        Normalized y coordinate.
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "y", value)


@pulumi.input_type
class OutputArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Location of output file(s) in a Cloud Storage bucket.
        :param pulumi.Input[str] uri: URI for the output file(s). For example, `gs://my-bucket/outputs/`. If empty, the value is populated from `Job.output_uri`. See [Supported input and output formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for the output file(s). For example, `gs://my-bucket/outputs/`. If empty, the value is populated from `Job.output_uri`. See [Supported input and output formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class OverlayArgs:
    def __init__(__self__, *,
                 animations: Optional[pulumi.Input[Sequence[pulumi.Input['AnimationArgs']]]] = None,
                 image: Optional[pulumi.Input['ImageArgs']] = None):
        """
        Overlay configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AnimationArgs']]] animations: List of Animations. The list should be chronological, without any time overlap.
        :param pulumi.Input['ImageArgs'] image: Image overlay.
        """
        if animations is not None:
            pulumi.set(__self__, "animations", animations)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def animations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnimationArgs']]]]:
        """
        List of Animations. The list should be chronological, without any time overlap.
        """
        return pulumi.get(self, "animations")

    @animations.setter
    def animations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnimationArgs']]]]):
        pulumi.set(self, "animations", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ImageArgs']]:
        """
        Image overlay.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ImageArgs']]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class PadArgs:
    def __init__(__self__, *,
                 bottom_pixels: Optional[pulumi.Input[int]] = None,
                 left_pixels: Optional[pulumi.Input[int]] = None,
                 right_pixels: Optional[pulumi.Input[int]] = None,
                 top_pixels: Optional[pulumi.Input[int]] = None):
        """
        Pad filter configuration for the input video. The padded input video is scaled after padding with black to match the output resolution.
        :param pulumi.Input[int] bottom_pixels: The number of pixels to add to the bottom. The default is 0.
        :param pulumi.Input[int] left_pixels: The number of pixels to add to the left. The default is 0.
        :param pulumi.Input[int] right_pixels: The number of pixels to add to the right. The default is 0.
        :param pulumi.Input[int] top_pixels: The number of pixels to add to the top. The default is 0.
        """
        if bottom_pixels is not None:
            pulumi.set(__self__, "bottom_pixels", bottom_pixels)
        if left_pixels is not None:
            pulumi.set(__self__, "left_pixels", left_pixels)
        if right_pixels is not None:
            pulumi.set(__self__, "right_pixels", right_pixels)
        if top_pixels is not None:
            pulumi.set(__self__, "top_pixels", top_pixels)

    @property
    @pulumi.getter(name="bottomPixels")
    def bottom_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to add to the bottom. The default is 0.
        """
        return pulumi.get(self, "bottom_pixels")

    @bottom_pixels.setter
    def bottom_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bottom_pixels", value)

    @property
    @pulumi.getter(name="leftPixels")
    def left_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to add to the left. The default is 0.
        """
        return pulumi.get(self, "left_pixels")

    @left_pixels.setter
    def left_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "left_pixels", value)

    @property
    @pulumi.getter(name="rightPixels")
    def right_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to add to the right. The default is 0.
        """
        return pulumi.get(self, "right_pixels")

    @right_pixels.setter
    def right_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "right_pixels", value)

    @property
    @pulumi.getter(name="topPixels")
    def top_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pixels to add to the top. The default is 0.
        """
        return pulumi.get(self, "top_pixels")

    @top_pixels.setter
    def top_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "top_pixels", value)


@pulumi.input_type
class PreprocessingConfigArgs:
    def __init__(__self__, *,
                 audio: Optional[pulumi.Input['AudioArgs']] = None,
                 color: Optional[pulumi.Input['ColorArgs']] = None,
                 crop: Optional[pulumi.Input['CropArgs']] = None,
                 deblock: Optional[pulumi.Input['DeblockArgs']] = None,
                 denoise: Optional[pulumi.Input['DenoiseArgs']] = None,
                 pad: Optional[pulumi.Input['PadArgs']] = None):
        """
        Preprocessing configurations.
        :param pulumi.Input['AudioArgs'] audio: Audio preprocessing configuration.
        :param pulumi.Input['ColorArgs'] color: Color preprocessing configuration.
        :param pulumi.Input['CropArgs'] crop: Specify the video cropping configuration.
        :param pulumi.Input['DeblockArgs'] deblock: Deblock preprocessing configuration.
        :param pulumi.Input['DenoiseArgs'] denoise: Denoise preprocessing configuration.
        :param pulumi.Input['PadArgs'] pad: Specify the video pad filter configuration.
        """
        if audio is not None:
            pulumi.set(__self__, "audio", audio)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if crop is not None:
            pulumi.set(__self__, "crop", crop)
        if deblock is not None:
            pulumi.set(__self__, "deblock", deblock)
        if denoise is not None:
            pulumi.set(__self__, "denoise", denoise)
        if pad is not None:
            pulumi.set(__self__, "pad", pad)

    @property
    @pulumi.getter
    def audio(self) -> Optional[pulumi.Input['AudioArgs']]:
        """
        Audio preprocessing configuration.
        """
        return pulumi.get(self, "audio")

    @audio.setter
    def audio(self, value: Optional[pulumi.Input['AudioArgs']]):
        pulumi.set(self, "audio", value)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input['ColorArgs']]:
        """
        Color preprocessing configuration.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input['ColorArgs']]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def crop(self) -> Optional[pulumi.Input['CropArgs']]:
        """
        Specify the video cropping configuration.
        """
        return pulumi.get(self, "crop")

    @crop.setter
    def crop(self, value: Optional[pulumi.Input['CropArgs']]):
        pulumi.set(self, "crop", value)

    @property
    @pulumi.getter
    def deblock(self) -> Optional[pulumi.Input['DeblockArgs']]:
        """
        Deblock preprocessing configuration.
        """
        return pulumi.get(self, "deblock")

    @deblock.setter
    def deblock(self, value: Optional[pulumi.Input['DeblockArgs']]):
        pulumi.set(self, "deblock", value)

    @property
    @pulumi.getter
    def denoise(self) -> Optional[pulumi.Input['DenoiseArgs']]:
        """
        Denoise preprocessing configuration.
        """
        return pulumi.get(self, "denoise")

    @denoise.setter
    def denoise(self, value: Optional[pulumi.Input['DenoiseArgs']]):
        pulumi.set(self, "denoise", value)

    @property
    @pulumi.getter
    def pad(self) -> Optional[pulumi.Input['PadArgs']]:
        """
        Specify the video pad filter configuration.
        """
        return pulumi.get(self, "pad")

    @pad.setter
    def pad(self, value: Optional[pulumi.Input['PadArgs']]):
        pulumi.set(self, "pad", value)


@pulumi.input_type
class PubsubDestinationArgs:
    def __init__(__self__, *,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        A Pub/Sub destination.
        :param pulumi.Input[str] topic: The name of the Pub/Sub topic to publish job completion notification to. For example: `projects/{project}/topics/{topic}`.
        """
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Pub/Sub topic to publish job completion notification to. For example: `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class SegmentSettingsArgs:
    def __init__(__self__, *,
                 individual_segments: pulumi.Input[bool],
                 segment_duration: Optional[pulumi.Input[str]] = None):
        """
        Segment settings for `ts`, `fmp4` and `vtt`.
        :param pulumi.Input[bool] individual_segments: Create an individual segment file. The default is `false`.
        :param pulumi.Input[str] segment_duration: Duration of the segments in seconds. The default is `6.0s`. Note that `segmentDuration` must be greater than or equal to [`gopDuration`](#videostream), and `segmentDuration` must be divisible by [`gopDuration`](#videostream).
        """
        pulumi.set(__self__, "individual_segments", individual_segments)
        if segment_duration is not None:
            pulumi.set(__self__, "segment_duration", segment_duration)

    @property
    @pulumi.getter(name="individualSegments")
    def individual_segments(self) -> pulumi.Input[bool]:
        """
        Create an individual segment file. The default is `false`.
        """
        return pulumi.get(self, "individual_segments")

    @individual_segments.setter
    def individual_segments(self, value: pulumi.Input[bool]):
        pulumi.set(self, "individual_segments", value)

    @property
    @pulumi.getter(name="segmentDuration")
    def segment_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Duration of the segments in seconds. The default is `6.0s`. Note that `segmentDuration` must be greater than or equal to [`gopDuration`](#videostream), and `segmentDuration` must be divisible by [`gopDuration`](#videostream).
        """
        return pulumi.get(self, "segment_duration")

    @segment_duration.setter
    def segment_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_duration", value)


@pulumi.input_type
class SpriteSheetArgs:
    def __init__(__self__, *,
                 file_prefix: pulumi.Input[str],
                 sprite_height_pixels: pulumi.Input[int],
                 sprite_width_pixels: pulumi.Input[int],
                 column_count: Optional[pulumi.Input[int]] = None,
                 end_time_offset: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 quality: Optional[pulumi.Input[int]] = None,
                 row_count: Optional[pulumi.Input[int]] = None,
                 start_time_offset: Optional[pulumi.Input[str]] = None,
                 total_count: Optional[pulumi.Input[int]] = None):
        """
        Sprite sheet configuration.
        :param pulumi.Input[str] file_prefix: File name prefix for the generated sprite sheets. Each sprite sheet has an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
        :param pulumi.Input[int] sprite_height_pixels: The height of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_height_pixels field or the SpriteSheet.sprite_width_pixels field, but not both (the API will automatically calculate the missing field).
        :param pulumi.Input[int] sprite_width_pixels: The width of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_width_pixels field or the SpriteSheet.sprite_height_pixels field, but not both (the API will automatically calculate the missing field).
        :param pulumi.Input[int] column_count: The maximum number of sprites per row in a sprite sheet. The default is 0, which indicates no maximum limit.
        :param pulumi.Input[str] end_time_offset: End time in seconds, relative to the output file timeline. When `end_time_offset` is not specified, the sprites are generated until the end of the output file.
        :param pulumi.Input[str] format: Format type. The default is `jpeg`. Supported formats: - `jpeg`
        :param pulumi.Input[str] interval: Starting from `0s`, create sprites at regular intervals. Specify the interval value in seconds.
        :param pulumi.Input[int] quality: The quality of the generated sprite sheet. Enter a value between 1 and 100, where 1 is the lowest quality and 100 is the highest quality. The default is 100. A high quality value corresponds to a low image data compression ratio.
        :param pulumi.Input[int] row_count: The maximum number of rows per sprite sheet. When the sprite sheet is full, a new sprite sheet is created. The default is 0, which indicates no maximum limit.
        :param pulumi.Input[str] start_time_offset: Start time in seconds, relative to the output file timeline. Determines the first sprite to pick. The default is `0s`.
        :param pulumi.Input[int] total_count: Total number of sprites. Create the specified number of sprites distributed evenly across the timeline of the output media. The default is 100.
        """
        pulumi.set(__self__, "file_prefix", file_prefix)
        pulumi.set(__self__, "sprite_height_pixels", sprite_height_pixels)
        pulumi.set(__self__, "sprite_width_pixels", sprite_width_pixels)
        if column_count is not None:
            pulumi.set(__self__, "column_count", column_count)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if row_count is not None:
            pulumi.set(__self__, "row_count", row_count)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)
        if total_count is not None:
            pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> pulumi.Input[str]:
        """
        File name prefix for the generated sprite sheets. Each sprite sheet has an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
        """
        return pulumi.get(self, "file_prefix")

    @file_prefix.setter
    def file_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_prefix", value)

    @property
    @pulumi.getter(name="spriteHeightPixels")
    def sprite_height_pixels(self) -> pulumi.Input[int]:
        """
        The height of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_height_pixels field or the SpriteSheet.sprite_width_pixels field, but not both (the API will automatically calculate the missing field).
        """
        return pulumi.get(self, "sprite_height_pixels")

    @sprite_height_pixels.setter
    def sprite_height_pixels(self, value: pulumi.Input[int]):
        pulumi.set(self, "sprite_height_pixels", value)

    @property
    @pulumi.getter(name="spriteWidthPixels")
    def sprite_width_pixels(self) -> pulumi.Input[int]:
        """
        The width of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_width_pixels field or the SpriteSheet.sprite_height_pixels field, but not both (the API will automatically calculate the missing field).
        """
        return pulumi.get(self, "sprite_width_pixels")

    @sprite_width_pixels.setter
    def sprite_width_pixels(self, value: pulumi.Input[int]):
        pulumi.set(self, "sprite_width_pixels", value)

    @property
    @pulumi.getter(name="columnCount")
    def column_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of sprites per row in a sprite sheet. The default is 0, which indicates no maximum limit.
        """
        return pulumi.get(self, "column_count")

    @column_count.setter
    def column_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "column_count", value)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        End time in seconds, relative to the output file timeline. When `end_time_offset` is not specified, the sprites are generated until the end of the output file.
        """
        return pulumi.get(self, "end_time_offset")

    @end_time_offset.setter
    def end_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_offset", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Format type. The default is `jpeg`. Supported formats: - `jpeg`
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Starting from `0s`, create sprites at regular intervals. Specify the interval value in seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[int]]:
        """
        The quality of the generated sprite sheet. Enter a value between 1 and 100, where 1 is the lowest quality and 100 is the highest quality. The default is 100. A high quality value corresponds to a low image data compression ratio.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter(name="rowCount")
    def row_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of rows per sprite sheet. When the sprite sheet is full, a new sprite sheet is created. The default is 0, which indicates no maximum limit.
        """
        return pulumi.get(self, "row_count")

    @row_count.setter
    def row_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "row_count", value)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Start time in seconds, relative to the output file timeline. Determines the first sprite to pick. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_offset", value)

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of sprites. Create the specified number of sprites distributed evenly across the timeline of the output media. The default is 100.
        """
        return pulumi.get(self, "total_count")

    @total_count.setter
    def total_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_count", value)


@pulumi.input_type
class TextMappingArgs:
    def __init__(__self__, *,
                 atom_key: pulumi.Input[str],
                 input_key: pulumi.Input[str],
                 input_track: pulumi.Input[int]):
        """
        The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
        :param pulumi.Input[str] atom_key: The `EditAtom.key` that references atom with text inputs in the `Job.edit_list`.
        :param pulumi.Input[str] input_key: The `Input.key` that identifies the input file.
        :param pulumi.Input[int] input_track: The zero-based index of the track in the input file.
        """
        pulumi.set(__self__, "atom_key", atom_key)
        pulumi.set(__self__, "input_key", input_key)
        pulumi.set(__self__, "input_track", input_track)

    @property
    @pulumi.getter(name="atomKey")
    def atom_key(self) -> pulumi.Input[str]:
        """
        The `EditAtom.key` that references atom with text inputs in the `Job.edit_list`.
        """
        return pulumi.get(self, "atom_key")

    @atom_key.setter
    def atom_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "atom_key", value)

    @property
    @pulumi.getter(name="inputKey")
    def input_key(self) -> pulumi.Input[str]:
        """
        The `Input.key` that identifies the input file.
        """
        return pulumi.get(self, "input_key")

    @input_key.setter
    def input_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_key", value)

    @property
    @pulumi.getter(name="inputTrack")
    def input_track(self) -> pulumi.Input[int]:
        """
        The zero-based index of the track in the input file.
        """
        return pulumi.get(self, "input_track")

    @input_track.setter
    def input_track(self, value: pulumi.Input[int]):
        pulumi.set(self, "input_track", value)


@pulumi.input_type
class TextStreamArgs:
    def __init__(__self__, *,
                 codec: Optional[pulumi.Input[str]] = None,
                 mapping: Optional[pulumi.Input[Sequence[pulumi.Input['TextMappingArgs']]]] = None):
        """
        Encoding of a text stream. For example, closed captions or subtitles.
        :param pulumi.Input[str] codec: The codec for this text stream. The default is `webvtt`. Supported text codecs: - `srt` - `ttml` - `cea608` - `cea708` - `webvtt`
        :param pulumi.Input[Sequence[pulumi.Input['TextMappingArgs']]] mapping: The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
        """
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if mapping is not None:
            pulumi.set(__self__, "mapping", mapping)

    @property
    @pulumi.getter
    def codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec for this text stream. The default is `webvtt`. Supported text codecs: - `srt` - `ttml` - `cea608` - `cea708` - `webvtt`
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter
    def mapping(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TextMappingArgs']]]]:
        """
        The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
        """
        return pulumi.get(self, "mapping")

    @mapping.setter
    def mapping(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TextMappingArgs']]]]):
        pulumi.set(self, "mapping", value)


@pulumi.input_type
class VideoStreamArgs:
    def __init__(__self__, *,
                 h264: Optional[pulumi.Input['H264CodecSettingsArgs']] = None,
                 h265: Optional[pulumi.Input['H265CodecSettingsArgs']] = None,
                 vp9: Optional[pulumi.Input['Vp9CodecSettingsArgs']] = None):
        """
        Video stream resource.
        :param pulumi.Input['H264CodecSettingsArgs'] h264: H264 codec settings.
        :param pulumi.Input['H265CodecSettingsArgs'] h265: H265 codec settings.
        :param pulumi.Input['Vp9CodecSettingsArgs'] vp9: VP9 codec settings.
        """
        if h264 is not None:
            pulumi.set(__self__, "h264", h264)
        if h265 is not None:
            pulumi.set(__self__, "h265", h265)
        if vp9 is not None:
            pulumi.set(__self__, "vp9", vp9)

    @property
    @pulumi.getter
    def h264(self) -> Optional[pulumi.Input['H264CodecSettingsArgs']]:
        """
        H264 codec settings.
        """
        return pulumi.get(self, "h264")

    @h264.setter
    def h264(self, value: Optional[pulumi.Input['H264CodecSettingsArgs']]):
        pulumi.set(self, "h264", value)

    @property
    @pulumi.getter
    def h265(self) -> Optional[pulumi.Input['H265CodecSettingsArgs']]:
        """
        H265 codec settings.
        """
        return pulumi.get(self, "h265")

    @h265.setter
    def h265(self, value: Optional[pulumi.Input['H265CodecSettingsArgs']]):
        pulumi.set(self, "h265", value)

    @property
    @pulumi.getter
    def vp9(self) -> Optional[pulumi.Input['Vp9CodecSettingsArgs']]:
        """
        VP9 codec settings.
        """
        return pulumi.get(self, "vp9")

    @vp9.setter
    def vp9(self, value: Optional[pulumi.Input['Vp9CodecSettingsArgs']]):
        pulumi.set(self, "vp9", value)


@pulumi.input_type
class Vp9CodecSettingsArgs:
    def __init__(__self__, *,
                 bitrate_bps: pulumi.Input[int],
                 frame_rate: pulumi.Input[float],
                 crf_level: Optional[pulumi.Input[int]] = None,
                 gop_duration: Optional[pulumi.Input[str]] = None,
                 gop_frame_count: Optional[pulumi.Input[int]] = None,
                 height_pixels: Optional[pulumi.Input[int]] = None,
                 pixel_format: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 rate_control_mode: Optional[pulumi.Input[str]] = None,
                 width_pixels: Optional[pulumi.Input[int]] = None):
        """
        VP9 codec settings.
        :param pulumi.Input[int] bitrate_bps: The video bitrate in bits per second. The minimum value is 1,000. The maximum value is 480,000,000.
        :param pulumi.Input[float] frame_rate: The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. See [Calculating frame rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for more information.
        :param pulumi.Input[int] crf_level: Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21. **Note:** This field is not supported.
        :param pulumi.Input[str] gop_duration: Select the GOP size based on the specified duration. The default is `3s`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        :param pulumi.Input[int] gop_frame_count: Select the GOP size based on the specified frame count. Must be greater than zero.
        :param pulumi.Input[int] height_pixels: The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        :param pulumi.Input[str] pixel_format: Pixel format to use. The default is `yuv420p`. Supported pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format - `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format - `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR pixel format - `yuv444p12` 12-bit HDR pixel format
        :param pulumi.Input[str] profile: Enforces the specified codec profile. The following profiles are supported: * `profile0` (default) * `profile1` * `profile2` * `profile3` The available options are [WebM-compatible](https://www.webmproject.org/vp9/profiles/). Note that certain values for this field may cause the transcoder to override other fields you set in the `Vp9CodecSettings` message.
        :param pulumi.Input[str] rate_control_mode: Specify the `rate_control_mode`. The default is `vbr`. Supported rate control modes: - `vbr` - variable bitrate
        :param pulumi.Input[int] width_pixels: The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "frame_rate", frame_rate)
        if crf_level is not None:
            pulumi.set(__self__, "crf_level", crf_level)
        if gop_duration is not None:
            pulumi.set(__self__, "gop_duration", gop_duration)
        if gop_frame_count is not None:
            pulumi.set(__self__, "gop_frame_count", gop_frame_count)
        if height_pixels is not None:
            pulumi.set(__self__, "height_pixels", height_pixels)
        if pixel_format is not None:
            pulumi.set(__self__, "pixel_format", pixel_format)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if width_pixels is not None:
            pulumi.set(__self__, "width_pixels", width_pixels)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> pulumi.Input[int]:
        """
        The video bitrate in bits per second. The minimum value is 1,000. The maximum value is 480,000,000.
        """
        return pulumi.get(self, "bitrate_bps")

    @bitrate_bps.setter
    def bitrate_bps(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate_bps", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> pulumi.Input[float]:
        """
        The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. See [Calculating frame rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for more information.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: pulumi.Input[float]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter(name="crfLevel")
    def crf_level(self) -> Optional[pulumi.Input[int]]:
        """
        Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21. **Note:** This field is not supported.
        """
        return pulumi.get(self, "crf_level")

    @crf_level.setter
    def crf_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "crf_level", value)

    @property
    @pulumi.getter(name="gopDuration")
    def gop_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Select the GOP size based on the specified duration. The default is `3s`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        """
        return pulumi.get(self, "gop_duration")

    @gop_duration.setter
    def gop_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gop_duration", value)

    @property
    @pulumi.getter(name="gopFrameCount")
    def gop_frame_count(self) -> Optional[pulumi.Input[int]]:
        """
        Select the GOP size based on the specified frame count. Must be greater than zero.
        """
        return pulumi.get(self, "gop_frame_count")

    @gop_frame_count.setter
    def gop_frame_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gop_frame_count", value)

    @property
    @pulumi.getter(name="heightPixels")
    def height_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        """
        return pulumi.get(self, "height_pixels")

    @height_pixels.setter
    def height_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height_pixels", value)

    @property
    @pulumi.getter(name="pixelFormat")
    def pixel_format(self) -> Optional[pulumi.Input[str]]:
        """
        Pixel format to use. The default is `yuv420p`. Supported pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format - `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format - `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR pixel format - `yuv444p12` 12-bit HDR pixel format
        """
        return pulumi.get(self, "pixel_format")

    @pixel_format.setter
    def pixel_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pixel_format", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces the specified codec profile. The following profiles are supported: * `profile0` (default) * `profile1` * `profile2` * `profile3` The available options are [WebM-compatible](https://www.webmproject.org/vp9/profiles/). Note that certain values for this field may cause the transcoder to override other fields you set in the `Vp9CodecSettings` message.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the `rate_control_mode`. The default is `vbr`. Supported rate control modes: - `vbr` - variable bitrate
        """
        return pulumi.get(self, "rate_control_mode")

    @rate_control_mode.setter
    def rate_control_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate_control_mode", value)

    @property
    @pulumi.getter(name="widthPixels")
    def width_pixels(self) -> Optional[pulumi.Input[int]]:
        """
        The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        return pulumi.get(self, "width_pixels")

    @width_pixels.setter
    def width_pixels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width_pixels", value)


