# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetStepResult',
    'AwaitableGetStepResult',
    'get_step',
    'get_step_output',
]

@pulumi.output_type
class GetStepResult:
    def __init__(__self__, completion_time=None, creation_time=None, description=None, device_usage_duration=None, dimension_value=None, has_images=None, labels=None, multi_step=None, name=None, outcome=None, run_duration=None, state=None, step_id=None, test_execution_step=None, tool_execution_step=None):
        if completion_time and not isinstance(completion_time, dict):
            raise TypeError("Expected argument 'completion_time' to be a dict")
        pulumi.set(__self__, "completion_time", completion_time)
        if creation_time and not isinstance(creation_time, dict):
            raise TypeError("Expected argument 'creation_time' to be a dict")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_usage_duration and not isinstance(device_usage_duration, dict):
            raise TypeError("Expected argument 'device_usage_duration' to be a dict")
        pulumi.set(__self__, "device_usage_duration", device_usage_duration)
        if dimension_value and not isinstance(dimension_value, list):
            raise TypeError("Expected argument 'dimension_value' to be a list")
        pulumi.set(__self__, "dimension_value", dimension_value)
        if has_images and not isinstance(has_images, bool):
            raise TypeError("Expected argument 'has_images' to be a bool")
        pulumi.set(__self__, "has_images", has_images)
        if labels and not isinstance(labels, list):
            raise TypeError("Expected argument 'labels' to be a list")
        pulumi.set(__self__, "labels", labels)
        if multi_step and not isinstance(multi_step, dict):
            raise TypeError("Expected argument 'multi_step' to be a dict")
        pulumi.set(__self__, "multi_step", multi_step)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outcome and not isinstance(outcome, dict):
            raise TypeError("Expected argument 'outcome' to be a dict")
        pulumi.set(__self__, "outcome", outcome)
        if run_duration and not isinstance(run_duration, dict):
            raise TypeError("Expected argument 'run_duration' to be a dict")
        pulumi.set(__self__, "run_duration", run_duration)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if step_id and not isinstance(step_id, str):
            raise TypeError("Expected argument 'step_id' to be a str")
        pulumi.set(__self__, "step_id", step_id)
        if test_execution_step and not isinstance(test_execution_step, dict):
            raise TypeError("Expected argument 'test_execution_step' to be a dict")
        pulumi.set(__self__, "test_execution_step", test_execution_step)
        if tool_execution_step and not isinstance(tool_execution_step, dict):
            raise TypeError("Expected argument 'tool_execution_step' to be a dict")
        pulumi.set(__self__, "tool_execution_step", tool_execution_step)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> 'outputs.TimestampResponse':
        """
        The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> 'outputs.TimestampResponse':
        """
        The time when the step was created. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceUsageDuration")
    def device_usage_duration(self) -> 'outputs.DurationResponse':
        """
        How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "device_usage_duration")

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> Sequence['outputs.StepDimensionValueEntryResponse']:
        """
        If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        """
        return pulumi.get(self, "dimension_value")

    @property
    @pulumi.getter(name="hasImages")
    def has_images(self) -> bool:
        """
        Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "has_images")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.StepLabelsEntryResponse']:
        """
        Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="multiStep")
    def multi_step(self) -> 'outputs.MultiStepResponse':
        """
        Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        """
        return pulumi.get(self, "multi_step")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outcome(self) -> 'outputs.OutcomeResponse':
        """
        Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "outcome")

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> 'outputs.DurationResponse':
        """
        How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "run_duration")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "step_id")

    @property
    @pulumi.getter(name="testExecutionStep")
    def test_execution_step(self) -> 'outputs.TestExecutionStepResponse':
        """
        An execution of a test runner.
        """
        return pulumi.get(self, "test_execution_step")

    @property
    @pulumi.getter(name="toolExecutionStep")
    def tool_execution_step(self) -> 'outputs.ToolExecutionStepResponse':
        """
        An execution of a tool (used for steps we don't explicitly support).
        """
        return pulumi.get(self, "tool_execution_step")


class AwaitableGetStepResult(GetStepResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStepResult(
            completion_time=self.completion_time,
            creation_time=self.creation_time,
            description=self.description,
            device_usage_duration=self.device_usage_duration,
            dimension_value=self.dimension_value,
            has_images=self.has_images,
            labels=self.labels,
            multi_step=self.multi_step,
            name=self.name,
            outcome=self.outcome,
            run_duration=self.run_duration,
            state=self.state,
            step_id=self.step_id,
            test_execution_step=self.test_execution_step,
            tool_execution_step=self.tool_execution_step)


def get_step(execution_id: Optional[str] = None,
             history_id: Optional[str] = None,
             project: Optional[str] = None,
             step_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStepResult:
    """
    Gets a Step. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to read project - INVALID_ARGUMENT - if the request is malformed - NOT_FOUND - if the Step does not exist
    """
    __args__ = dict()
    __args__['executionId'] = execution_id
    __args__['historyId'] = history_id
    __args__['project'] = project
    __args__['stepId'] = step_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:toolresults/v1beta3:getStep', __args__, opts=opts, typ=GetStepResult).value

    return AwaitableGetStepResult(
        completion_time=__ret__.completion_time,
        creation_time=__ret__.creation_time,
        description=__ret__.description,
        device_usage_duration=__ret__.device_usage_duration,
        dimension_value=__ret__.dimension_value,
        has_images=__ret__.has_images,
        labels=__ret__.labels,
        multi_step=__ret__.multi_step,
        name=__ret__.name,
        outcome=__ret__.outcome,
        run_duration=__ret__.run_duration,
        state=__ret__.state,
        step_id=__ret__.step_id,
        test_execution_step=__ret__.test_execution_step,
        tool_execution_step=__ret__.tool_execution_step)


@_utilities.lift_output_func(get_step)
def get_step_output(execution_id: Optional[pulumi.Input[str]] = None,
                    history_id: Optional[pulumi.Input[str]] = None,
                    project: Optional[pulumi.Input[Optional[str]]] = None,
                    step_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStepResult]:
    """
    Gets a Step. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to read project - INVALID_ARGUMENT - if the request is malformed - NOT_FOUND - if the Step does not exist
    """
    ...
