# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AwsAccessKeyArgs',
    'AwsS3DataArgs',
    'AzureBlobStorageDataArgs',
    'AzureCredentialsArgs',
    'BandwidthLimitArgs',
    'DateArgs',
    'GcsDataArgs',
    'HttpDataArgs',
    'LoggingConfigArgs',
    'MetadataOptionsArgs',
    'NotificationConfigArgs',
    'ObjectConditionsArgs',
    'PosixFilesystemArgs',
    'ScheduleArgs',
    'TimeOfDayArgs',
    'TransferManifestArgs',
    'TransferOptionsArgs',
    'TransferSpecArgs',
]

@pulumi.input_type
class AwsAccessKeyArgs:
    def __init__(__self__, *,
                 access_key_id: pulumi.Input[str],
                 secret_access_key: pulumi.Input[str]):
        """
        AWS access key (see [AWS Security Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)). For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param pulumi.Input[str] access_key_id: AWS access key ID.
        :param pulumi.Input[str] secret_access_key: AWS secret access key. This field is not returned in RPC responses.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Input[str]:
        """
        AWS access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Input[str]:
        """
        AWS secret access key. This field is not returned in RPC responses.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class AwsS3DataArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 aws_access_key: Optional[pulumi.Input['AwsAccessKeyArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        An AwsS3Data resource can be a data source, but not a data sink. In an AwsS3Data resource, an object's name is the S3 object's key name.
        :param pulumi.Input[str] bucket_name: S3 Bucket name (see [Creating a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
        :param pulumi.Input['AwsAccessKeyArgs'] aws_access_key: Input only. AWS access key used to sign the API requests to the AWS S3 bucket. Permissions on the bucket must be granted to the access ID of the AWS access key. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param pulumi.Input[str] path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the role to support temporary credentials via `AssumeRoleWithWebIdentity`. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a `AssumeRoleWithWebIdentity` call for the provided role using the GoogleServiceAccount for this project.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if aws_access_key is not None:
            pulumi.set(__self__, "aws_access_key", aws_access_key)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        S3 Bucket name (see [Creating a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional[pulumi.Input['AwsAccessKeyArgs']]:
        """
        Input only. AWS access key used to sign the API requests to the AWS S3 bucket. Permissions on the bucket must be granted to the access ID of the AWS access key. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        """
        return pulumi.get(self, "aws_access_key")

    @aws_access_key.setter
    def aws_access_key(self, value: Optional[pulumi.Input['AwsAccessKeyArgs']]):
        pulumi.set(self, "aws_access_key", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the role to support temporary credentials via `AssumeRoleWithWebIdentity`. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a `AssumeRoleWithWebIdentity` call for the provided role using the GoogleServiceAccount for this project.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class AzureBlobStorageDataArgs:
    def __init__(__self__, *,
                 azure_credentials: pulumi.Input['AzureCredentialsArgs'],
                 container: pulumi.Input[str],
                 storage_account: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        An AzureBlobStorageData resource can be a data source, but not a data sink. An AzureBlobStorageData resource represents one Azure container. The storage account determines the [Azure endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints). In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob Storage blob's key name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
        :param pulumi.Input['AzureCredentialsArgs'] azure_credentials: Input only. Credentials used to authenticate API requests to Azure. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param pulumi.Input[str] container: The container to transfer from the Azure Storage account.
        :param pulumi.Input[str] storage_account: The name of the Azure Storage account.
        :param pulumi.Input[str] path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "azure_credentials", azure_credentials)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "storage_account", storage_account)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> pulumi.Input['AzureCredentialsArgs']:
        """
        Input only. Credentials used to authenticate API requests to Azure. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        """
        return pulumi.get(self, "azure_credentials")

    @azure_credentials.setter
    def azure_credentials(self, value: pulumi.Input['AzureCredentialsArgs']):
        pulumi.set(self, "azure_credentials", value)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The container to transfer from the Azure Storage account.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> pulumi.Input[str]:
        """
        The name of the Azure Storage account.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class AzureCredentialsArgs:
    def __init__(__self__, *,
                 sas_token: pulumi.Input[str]):
        """
        Azure credentials For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param pulumi.Input[str] sas_token: Azure shared access signature (SAS). For more information about SAS, see [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
        """
        pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> pulumi.Input[str]:
        """
        Azure shared access signature (SAS). For more information about SAS, see [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "sas_token", value)


@pulumi.input_type
class BandwidthLimitArgs:
    def __init__(__self__, *,
                 limit_mbps: Optional[pulumi.Input[str]] = None):
        """
        Specifies a bandwidth limit for an agent pool.
        :param pulumi.Input[str] limit_mbps: Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        if limit_mbps is not None:
            pulumi.set(__self__, "limit_mbps", limit_mbps)

    @property
    @pulumi.getter(name="limitMbps")
    def limit_mbps(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        return pulumi.get(self, "limit_mbps")

    @limit_mbps.setter
    def limit_mbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_mbps", value)


@pulumi.input_type
class DateArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 month: Optional[pulumi.Input[int]] = None,
                 year: Optional[pulumi.Input[int]] = None):
        """
        Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
        :param pulumi.Input[int] day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        :param pulumi.Input[int] month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        :param pulumi.Input[int] year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if year is not None:
            pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def month(self) -> Optional[pulumi.Input[int]]:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        """
        return pulumi.get(self, "month")

    @month.setter
    def month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "month", value)

    @property
    @pulumi.getter
    def year(self) -> Optional[pulumi.Input[int]]:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        return pulumi.get(self, "year")

    @year.setter
    def year(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "year", value)


@pulumi.input_type
class GcsDataArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        In a GcsData resource, an object's name is the Cloud Storage object's name and its "last modification time" refers to the object's `updated` property of Cloud Storage objects, which changes when the content or the metadata of the object is updated.
        :param pulumi.Input[str] bucket_name: Cloud Storage bucket name. Must meet [Bucket Name Requirements](/storage/docs/naming#requirements).
        :param pulumi.Input[str] path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'. The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Cloud Storage bucket name. Must meet [Bucket Name Requirements](/storage/docs/naming#requirements).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'. The root path value must meet [Object Name Requirements](/storage/docs/naming#objectnames).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class HttpDataArgs:
    def __init__(__self__, *,
                 list_url: pulumi.Input[str]):
        """
        An HttpData resource specifies a list of objects on the web to be transferred over HTTP. The information of the objects to be transferred is contained in a file referenced by a URL. The first line in the file must be `"TsvHttpData-1.0"`, which specifies the format of the file. Subsequent lines specify the information of the list of objects, one object per list entry. Each entry has the following tab-delimited fields: * **HTTP URL** — The location of the object. * **Length** — The size of the object in bytes. * **MD5** — The base64-encoded MD5 hash of the object. For an example of a valid TSV file, see [Transferring data from URLs](https://cloud.google.com/storage-transfer/docs/create-url-list). When transferring data based on a URL list, keep the following in mind: * When an object located at `http(s)://hostname:port/` is transferred to a data sink, the name of the object at the data sink is `/`. * If the specified size of an object does not match the actual size of the object fetched, the object is not transferred. * If the specified MD5 does not match the MD5 computed from the transferred bytes, the object transfer fails. * Ensure that each URL you specify is publicly accessible. For example, in Cloud Storage you can [share an object publicly] (/storage/docs/cloud-console#_sharingdata) and get a link to it. * Storage Transfer Service obeys `robots.txt` rules and requires the source HTTP server to support `Range` requests and to return a `Content-Length` header in each response. * ObjectConditions have no effect when filtering objects to transfer.
        :param pulumi.Input[str] list_url: The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> pulumi.Input[str]:
        """
        The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")

    @list_url.setter
    def list_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "list_url", value)


@pulumi.input_type
class LoggingConfigArgs:
    def __init__(__self__, *,
                 enable_onprem_gcs_transfer_logs: Optional[pulumi.Input[bool]] = None,
                 log_action_states: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionStatesItem']]]] = None,
                 log_actions: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionsItem']]]] = None):
        """
        Specifies the logging behavior for transfer operations. For cloud-to-cloud transfers, logs are sent to Cloud Logging. See [Read transfer logs](https://cloud.google.com/storage-transfer/docs/read-transfer-logs) for details. For transfers to or from a POSIX file system, logs are stored in the Cloud Storage bucket that is the source or sink of the transfer. See [Managing Transfer for on-premises jobs] (https://cloud.google.com/storage-transfer/docs/managing-on-prem-jobs#viewing-logs) for details.
        :param pulumi.Input[bool] enable_onprem_gcs_transfer_logs: For transfers with a PosixFilesystem source, this option enables the Cloud Storage transfer logs for this transfer.
        :param pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionStatesItem']]] log_action_states: States in which `log_actions` are logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        :param pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionsItem']]] log_actions: Specifies the actions to be logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        """
        if enable_onprem_gcs_transfer_logs is not None:
            pulumi.set(__self__, "enable_onprem_gcs_transfer_logs", enable_onprem_gcs_transfer_logs)
        if log_action_states is not None:
            pulumi.set(__self__, "log_action_states", log_action_states)
        if log_actions is not None:
            pulumi.set(__self__, "log_actions", log_actions)

    @property
    @pulumi.getter(name="enableOnpremGcsTransferLogs")
    def enable_onprem_gcs_transfer_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        For transfers with a PosixFilesystem source, this option enables the Cloud Storage transfer logs for this transfer.
        """
        return pulumi.get(self, "enable_onprem_gcs_transfer_logs")

    @enable_onprem_gcs_transfer_logs.setter
    def enable_onprem_gcs_transfer_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_onprem_gcs_transfer_logs", value)

    @property
    @pulumi.getter(name="logActionStates")
    def log_action_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionStatesItem']]]]:
        """
        States in which `log_actions` are logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        """
        return pulumi.get(self, "log_action_states")

    @log_action_states.setter
    def log_action_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionStatesItem']]]]):
        pulumi.set(self, "log_action_states", value)

    @property
    @pulumi.getter(name="logActions")
    def log_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionsItem']]]]:
        """
        Specifies the actions to be logged. If empty, no logs are generated. Not supported for transfers with PosixFilesystem data sources; use enable_onprem_gcs_transfer_logs instead.
        """
        return pulumi.get(self, "log_actions")

    @log_actions.setter
    def log_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingConfigLogActionsItem']]]]):
        pulumi.set(self, "log_actions", value)


@pulumi.input_type
class MetadataOptionsArgs:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['MetadataOptionsAcl']] = None,
                 gid: Optional[pulumi.Input['MetadataOptionsGid']] = None,
                 kms_key: Optional[pulumi.Input['MetadataOptionsKmsKey']] = None,
                 mode: Optional[pulumi.Input['MetadataOptionsMode']] = None,
                 storage_class: Optional[pulumi.Input['MetadataOptionsStorageClass']] = None,
                 symlink: Optional[pulumi.Input['MetadataOptionsSymlink']] = None,
                 temporary_hold: Optional[pulumi.Input['MetadataOptionsTemporaryHold']] = None,
                 time_created: Optional[pulumi.Input['MetadataOptionsTimeCreated']] = None,
                 uid: Optional[pulumi.Input['MetadataOptionsUid']] = None):
        """
        Specifies the metadata options for running a transfer.
        :param pulumi.Input['MetadataOptionsAcl'] acl: Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
        :param pulumi.Input['MetadataOptionsGid'] gid: Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        :param pulumi.Input['MetadataOptionsKmsKey'] kms_key: Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
        :param pulumi.Input['MetadataOptionsMode'] mode: Specifies how each file's mode attribute should be handled by the transfer. By default, mode is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        :param pulumi.Input['MetadataOptionsStorageClass'] storage_class: Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets. If unspecified, the default behavior is the same as STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
        :param pulumi.Input['MetadataOptionsSymlink'] symlink: Specifies how symlinks should be handled by the transfer. By default, symlinks are not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        :param pulumi.Input['MetadataOptionsTemporaryHold'] temporary_hold: Specifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TEMPORARY_HOLD_PRESERVE.
        :param pulumi.Input['MetadataOptionsTimeCreated'] time_created: Specifies how each object's `timeCreated` metadata is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TIME_CREATED_SKIP.
        :param pulumi.Input['MetadataOptionsUid'] uid: Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if symlink is not None:
            pulumi.set(__self__, "symlink", symlink)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['MetadataOptionsAcl']]:
        """
        Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as ACL_DESTINATION_BUCKET_DEFAULT.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['MetadataOptionsAcl']]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input['MetadataOptionsGid']]:
        """
        Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer. By default, GID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input['MetadataOptionsGid']]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input['MetadataOptionsKmsKey']]:
        """
        Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as KMS_KEY_DESTINATION_BUCKET_DEFAULT.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input['MetadataOptionsKmsKey']]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['MetadataOptionsMode']]:
        """
        Specifies how each file's mode attribute should be handled by the transfer. By default, mode is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['MetadataOptionsMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input['MetadataOptionsStorageClass']]:
        """
        Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets. If unspecified, the default behavior is the same as STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input['MetadataOptionsStorageClass']]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def symlink(self) -> Optional[pulumi.Input['MetadataOptionsSymlink']]:
        """
        Specifies how symlinks should be handled by the transfer. By default, symlinks are not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "symlink")

    @symlink.setter
    def symlink(self, value: Optional[pulumi.Input['MetadataOptionsSymlink']]):
        pulumi.set(self, "symlink", value)

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[pulumi.Input['MetadataOptionsTemporaryHold']]:
        """
        Specifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TEMPORARY_HOLD_PRESERVE.
        """
        return pulumi.get(self, "temporary_hold")

    @temporary_hold.setter
    def temporary_hold(self, value: Optional[pulumi.Input['MetadataOptionsTemporaryHold']]):
        pulumi.set(self, "temporary_hold", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input['MetadataOptionsTimeCreated']]:
        """
        Specifies how each object's `timeCreated` metadata is preserved for transfers between Google Cloud Storage buckets. If unspecified, the default behavior is the same as TIME_CREATED_SKIP.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input['MetadataOptionsTimeCreated']]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input['MetadataOptionsUid']]:
        """
        Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer. By default, UID is not preserved. Only applicable to transfers involving POSIX file systems, and ignored for other transfers.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input['MetadataOptionsUid']]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class NotificationConfigArgs:
    def __init__(__self__, *,
                 payload_format: pulumi.Input['NotificationConfigPayloadFormat'],
                 pubsub_topic: pulumi.Input[str],
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationConfigEventTypesItem']]]] = None):
        """
        Specification to configure notifications published to Pub/Sub. Notifications are published to the customer-provided topic using the following `PubsubMessage.attributes`: * `"eventType"`: one of the EventType values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`: the project_id of the `TransferOperation` * `"transferJobName"`: the transfer_job_name of the `TransferOperation` * `"transferOperationName"`: the name of the `TransferOperation` The `PubsubMessage.data` contains a TransferOperation resource formatted according to the specified `PayloadFormat`.
        :param pulumi.Input['NotificationConfigPayloadFormat'] payload_format: The desired format of the notification message payloads.
        :param pulumi.Input[str] pubsub_topic: The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of the format: `projects/{project}/topics/{topic}`. Not matching this format results in an INVALID_ARGUMENT error.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationConfigEventTypesItem']]] event_types: Event types for which a notification is desired. If empty, send notifications for all event types.
        """
        pulumi.set(__self__, "payload_format", payload_format)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if event_types is not None:
            pulumi.set(__self__, "event_types", event_types)

    @property
    @pulumi.getter(name="payloadFormat")
    def payload_format(self) -> pulumi.Input['NotificationConfigPayloadFormat']:
        """
        The desired format of the notification message payloads.
        """
        return pulumi.get(self, "payload_format")

    @payload_format.setter
    def payload_format(self, value: pulumi.Input['NotificationConfigPayloadFormat']):
        pulumi.set(self, "payload_format", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Input[str]:
        """
        The `Topic.name` of the Pub/Sub topic to which to publish notifications. Must be of the format: `projects/{project}/topics/{topic}`. Not matching this format results in an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "pubsub_topic", value)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationConfigEventTypesItem']]]]:
        """
        Event types for which a notification is desired. If empty, send notifications for all event types.
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationConfigEventTypesItem']]]]):
        pulumi.set(self, "event_types", value)


@pulumi.input_type
class ObjectConditionsArgs:
    def __init__(__self__, *,
                 exclude_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_modified_before: Optional[pulumi.Input[str]] = None,
                 last_modified_since: Optional[pulumi.Input[str]] = None,
                 max_time_elapsed_since_last_modification: Optional[pulumi.Input[str]] = None,
                 min_time_elapsed_since_last_modification: Optional[pulumi.Input[str]] = None):
        """
        Conditions that determine which objects are transferred. Applies only to Cloud Data Sources such as S3, Azure, and Cloud Storage. The "last modification time" refers to the time of the last change to the object's content or metadata — specifically, this is the `updated` property of Cloud Storage objects, the `LastModified` field of S3 objects, and the `Last-Modified` header of Azure blobs. Transfers with a PosixFilesystem source or destination don't support `ObjectConditions`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_prefixes: If you specify `exclude_prefixes`, Storage Transfer Service uses the items in the `exclude_prefixes` array to determine which objects to exclude from a transfer. Objects must not start with one of the matching `exclude_prefixes` for inclusion in a transfer. The following are requirements of `exclude_prefixes`: * Each exclude-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each exclude-prefix must omit the leading slash. For example, to exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be empty, if specified. * Each exclude-prefix must exclude a distinct portion of the object namespace. No exclude-prefix may be a prefix of another exclude-prefix. * If include_prefixes is specified, then each exclude-prefix must start with the value of a path explicitly included by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_prefixes: If you specify `include_prefixes`, Storage Transfer Service uses the items in the `include_prefixes` array to determine which objects to include in a transfer. Objects must start with one of the matching `include_prefixes` for inclusion in the transfer. If exclude_prefixes is specified, objects must not start with any of the `exclude_prefixes` specified for inclusion in the transfer. The following are requirements of `include_prefixes`: * Each include-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each include-prefix must omit the leading slash. For example, to include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include-prefix as `logs/y=2015/requests.gz`. * None of the include-prefix values can be empty, if specified. * Each include-prefix must include a distinct portion of the object namespace. No include-prefix may be a prefix of another include-prefix. The max size of `include_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        :param pulumi.Input[str] last_modified_before: If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred.
        :param pulumi.Input[str] last_modified_since: If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. The `last_modified_since` and `last_modified_before` fields can be used together for chunked data processing. For example, consider a script that processes each day's worth of data at a time. For that you'd set each of the fields as follows: * `last_modified_since` to the start of the day * `last_modified_before` to the end of the day
        :param pulumi.Input[str] max_time_elapsed_since_last_modification: Ensures that objects are not transferred if a specific maximum time has elapsed since the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation`and the "last modification time" of the object is less than the value of max_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        :param pulumi.Input[str] min_time_elapsed_since_last_modification: Ensures that objects are not transferred until a specific minimum time has elapsed after the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation` and the "last modification time" of the object is equal to or greater than the value of min_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        """
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_prefixes is not None:
            pulumi.set(__self__, "include_prefixes", include_prefixes)
        if last_modified_before is not None:
            pulumi.set(__self__, "last_modified_before", last_modified_before)
        if last_modified_since is not None:
            pulumi.set(__self__, "last_modified_since", last_modified_since)
        if max_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        if min_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If you specify `exclude_prefixes`, Storage Transfer Service uses the items in the `exclude_prefixes` array to determine which objects to exclude from a transfer. Objects must not start with one of the matching `exclude_prefixes` for inclusion in a transfer. The following are requirements of `exclude_prefixes`: * Each exclude-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each exclude-prefix must omit the leading slash. For example, to exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be empty, if specified. * Each exclude-prefix must exclude a distinct portion of the object namespace. No exclude-prefix may be a prefix of another exclude-prefix. * If include_prefixes is specified, then each exclude-prefix must start with the value of a path explicitly included by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        """
        return pulumi.get(self, "exclude_prefixes")

    @exclude_prefixes.setter
    def exclude_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_prefixes", value)

    @property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If you specify `include_prefixes`, Storage Transfer Service uses the items in the `include_prefixes` array to determine which objects to include in a transfer. Objects must start with one of the matching `include_prefixes` for inclusion in the transfer. If exclude_prefixes is specified, objects must not start with any of the `exclude_prefixes` specified for inclusion in the transfer. The following are requirements of `include_prefixes`: * Each include-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each include-prefix must omit the leading slash. For example, to include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include-prefix as `logs/y=2015/requests.gz`. * None of the include-prefix values can be empty, if specified. * Each include-prefix must include a distinct portion of the object namespace. No include-prefix may be a prefix of another include-prefix. The max size of `include_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        """
        return pulumi.get(self, "include_prefixes")

    @include_prefixes.setter
    def include_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_prefixes", value)

    @property
    @pulumi.getter(name="lastModifiedBefore")
    def last_modified_before(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred.
        """
        return pulumi.get(self, "last_modified_before")

    @last_modified_before.setter
    def last_modified_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_before", value)

    @property
    @pulumi.getter(name="lastModifiedSince")
    def last_modified_since(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. The `last_modified_since` and `last_modified_before` fields can be used together for chunked data processing. For example, consider a script that processes each day's worth of data at a time. For that you'd set each of the fields as follows: * `last_modified_since` to the start of the day * `last_modified_before` to the end of the day
        """
        return pulumi.get(self, "last_modified_since")

    @last_modified_since.setter
    def last_modified_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_since", value)

    @property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> Optional[pulumi.Input[str]]:
        """
        Ensures that objects are not transferred if a specific maximum time has elapsed since the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation`and the "last modification time" of the object is less than the value of max_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @max_time_elapsed_since_last_modification.setter
    def max_time_elapsed_since_last_modification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_time_elapsed_since_last_modification", value)

    @property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> Optional[pulumi.Input[str]]:
        """
        Ensures that objects are not transferred until a specific minimum time has elapsed after the "last modification time". When a TransferOperation begins, objects with a "last modification time" are transferred only if the elapsed time between the start_time of the `TransferOperation` and the "last modification time" of the object is equal to or greater than the value of min_time_elapsed_since_last_modification`. Objects that do not have a "last modification time" are also transferred.
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")

    @min_time_elapsed_since_last_modification.setter
    def min_time_elapsed_since_last_modification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_time_elapsed_since_last_modification", value)


@pulumi.input_type
class PosixFilesystemArgs:
    def __init__(__self__, *,
                 root_directory: Optional[pulumi.Input[str]] = None):
        """
        A POSIX filesystem resource.
        :param pulumi.Input[str] root_directory: Root directory path to the filesystem.
        """
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")

    @root_directory.setter
    def root_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_directory", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 schedule_start_date: pulumi.Input['DateArgs'],
                 end_time_of_day: Optional[pulumi.Input['TimeOfDayArgs']] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None,
                 schedule_end_date: Optional[pulumi.Input['DateArgs']] = None,
                 start_time_of_day: Optional[pulumi.Input['TimeOfDayArgs']] = None):
        """
        Transfers can be scheduled to recur or to run just once.
        :param pulumi.Input['DateArgs'] schedule_start_date: The start date of a transfer. Date boundaries are determined relative to UTC time. If `schedule_start_date` and start_time_of_day are in the past relative to the job's creation time, the transfer starts the day after you schedule the transfer request. **Note:** When starting jobs at or near midnight UTC it is possible that a job starts later than expected. For example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and the Storage Transfer Service server receives the request on June 2, then it creates a TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
        :param pulumi.Input['TimeOfDayArgs'] end_time_of_day: The time in UTC that no further transfer operations are scheduled. Combined with schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer operations. This field must be greater than or equal to the timestamp corresponding to the combintation of schedule_start_date and start_time_of_day, and is subject to the following: * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
        :param pulumi.Input[str] repeat_interval: Interval between the start of each scheduled TransferOperation. If unspecified, the default value is 24 hours. This value may not be less than 1 hour.
        :param pulumi.Input['DateArgs'] schedule_end_date: The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs once per 24 hours within the following guidelines: * If `schedule_end_date` and schedule_start_date are the same and in the future relative to UTC, the transfer is executed only one time. * If `schedule_end_date` is later than `schedule_start_date` and `schedule_end_date` is in the future relative to UTC, the job runs each day at start_time_of_day through `schedule_end_date`.
        :param pulumi.Input['TimeOfDayArgs'] start_time_of_day: The time in UTC that a transfer job is scheduled to run. Transfers may start later than this time. If `start_time_of_day` is not specified: * One-time transfers run immediately. * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date. If `start_time_of_day` is specified: * One-time transfers run at the specified time. * Recurring transfers run at the specified time each day, through `schedule_end_date`.
        """
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        if end_time_of_day is not None:
            pulumi.set(__self__, "end_time_of_day", end_time_of_day)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if schedule_end_date is not None:
            pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        if start_time_of_day is not None:
            pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> pulumi.Input['DateArgs']:
        """
        The start date of a transfer. Date boundaries are determined relative to UTC time. If `schedule_start_date` and start_time_of_day are in the past relative to the job's creation time, the transfer starts the day after you schedule the transfer request. **Note:** When starting jobs at or near midnight UTC it is possible that a job starts later than expected. For example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and the Storage Transfer Service server receives the request on June 2, then it creates a TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight UTC. The first scheduled TransferOperation takes place on June 3 at midnight UTC.
        """
        return pulumi.get(self, "schedule_start_date")

    @schedule_start_date.setter
    def schedule_start_date(self, value: pulumi.Input['DateArgs']):
        pulumi.set(self, "schedule_start_date", value)

    @property
    @pulumi.getter(name="endTimeOfDay")
    def end_time_of_day(self) -> Optional[pulumi.Input['TimeOfDayArgs']]:
        """
        The time in UTC that no further transfer operations are scheduled. Combined with schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer operations. This field must be greater than or equal to the timestamp corresponding to the combintation of schedule_start_date and start_time_of_day, and is subject to the following: * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
        """
        return pulumi.get(self, "end_time_of_day")

    @end_time_of_day.setter
    def end_time_of_day(self, value: Optional[pulumi.Input['TimeOfDayArgs']]):
        pulumi.set(self, "end_time_of_day", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Interval between the start of each scheduled TransferOperation. If unspecified, the default value is 24 hours. This value may not be less than 1 hour.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)

    @property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> Optional[pulumi.Input['DateArgs']]:
        """
        The last day a transfer runs. Date boundaries are determined relative to UTC time. A job runs once per 24 hours within the following guidelines: * If `schedule_end_date` and schedule_start_date are the same and in the future relative to UTC, the transfer is executed only one time. * If `schedule_end_date` is later than `schedule_start_date` and `schedule_end_date` is in the future relative to UTC, the job runs each day at start_time_of_day through `schedule_end_date`.
        """
        return pulumi.get(self, "schedule_end_date")

    @schedule_end_date.setter
    def schedule_end_date(self, value: Optional[pulumi.Input['DateArgs']]):
        pulumi.set(self, "schedule_end_date", value)

    @property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> Optional[pulumi.Input['TimeOfDayArgs']]:
        """
        The time in UTC that a transfer job is scheduled to run. Transfers may start later than this time. If `start_time_of_day` is not specified: * One-time transfers run immediately. * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date. If `start_time_of_day` is specified: * One-time transfers run at the specified time. * Recurring transfers run at the specified time each day, through `schedule_end_date`.
        """
        return pulumi.get(self, "start_time_of_day")

    @start_time_of_day.setter
    def start_time_of_day(self, value: Optional[pulumi.Input['TimeOfDayArgs']]):
        pulumi.set(self, "start_time_of_day", value)


@pulumi.input_type
class TimeOfDayArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class TransferManifestArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Specifies where the manifest is located.
        :param pulumi.Input[str] location: Specifies the path to the manifest in Cloud Storage. The Google-managed service account for the transfer must have `storage.objects.get` permission for this object. An example path is `gs://bucket_name/path/manifest.csv`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path to the manifest in Cloud Storage. The Google-managed service account for the transfer must have `storage.objects.get` permission for this object. An example path is `gs://bucket_name/path/manifest.csv`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class TransferOptionsArgs:
    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: Optional[pulumi.Input[bool]] = None,
                 delete_objects_unique_in_sink: Optional[pulumi.Input[bool]] = None,
                 metadata_options: Optional[pulumi.Input['MetadataOptionsArgs']] = None,
                 overwrite_objects_already_existing_in_sink: Optional[pulumi.Input[bool]] = None,
                 overwrite_when: Optional[pulumi.Input['TransferOptionsOverwriteWhen']] = None):
        """
        TransferOptions define the actions to be performed on objects in a transfer.
        :param pulumi.Input[bool] delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. **Note:** This option and delete_objects_unique_in_sink are mutually exclusive.
        :param pulumi.Input[bool] delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. **Note:** This option and delete_objects_from_source_after_transfer are mutually exclusive.
        :param pulumi.Input['MetadataOptionsArgs'] metadata_options: Represents the selected metadata options for a transfer job. This feature is in Preview.
        :param pulumi.Input[bool] overwrite_objects_already_existing_in_sink: When to overwrite objects that already exist in the sink. The default is that only objects that are different from the source are ovewritten. If true, all objects in the sink whose name matches an object in the source are overwritten with the source object.
        :param pulumi.Input['TransferOptionsOverwriteWhen'] overwrite_when: When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by overwrite_objects_already_existing_in_sink.
        """
        if delete_objects_from_source_after_transfer is not None:
            pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        if delete_objects_unique_in_sink is not None:
            pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if overwrite_objects_already_existing_in_sink is not None:
            pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)
        if overwrite_when is not None:
            pulumi.set(__self__, "overwrite_when", overwrite_when)

    @property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. **Note:** This option and delete_objects_unique_in_sink are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @delete_objects_from_source_after_transfer.setter
    def delete_objects_from_source_after_transfer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_objects_from_source_after_transfer", value)

    @property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether objects that exist only in the sink should be deleted. **Note:** This option and delete_objects_from_source_after_transfer are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @delete_objects_unique_in_sink.setter
    def delete_objects_unique_in_sink(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_objects_unique_in_sink", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['MetadataOptionsArgs']]:
        """
        Represents the selected metadata options for a transfer job. This feature is in Preview.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['MetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> Optional[pulumi.Input[bool]]:
        """
        When to overwrite objects that already exist in the sink. The default is that only objects that are different from the source are ovewritten. If true, all objects in the sink whose name matches an object in the source are overwritten with the source object.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    @overwrite_objects_already_existing_in_sink.setter
    def overwrite_objects_already_existing_in_sink(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_objects_already_existing_in_sink", value)

    @property
    @pulumi.getter(name="overwriteWhen")
    def overwrite_when(self) -> Optional[pulumi.Input['TransferOptionsOverwriteWhen']]:
        """
        When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by overwrite_objects_already_existing_in_sink.
        """
        return pulumi.get(self, "overwrite_when")

    @overwrite_when.setter
    def overwrite_when(self, value: Optional[pulumi.Input['TransferOptionsOverwriteWhen']]):
        pulumi.set(self, "overwrite_when", value)


@pulumi.input_type
class TransferSpecArgs:
    def __init__(__self__, *,
                 aws_s3_data_source: Optional[pulumi.Input['AwsS3DataArgs']] = None,
                 azure_blob_storage_data_source: Optional[pulumi.Input['AzureBlobStorageDataArgs']] = None,
                 gcs_data_sink: Optional[pulumi.Input['GcsDataArgs']] = None,
                 gcs_data_source: Optional[pulumi.Input['GcsDataArgs']] = None,
                 gcs_intermediate_data_location: Optional[pulumi.Input['GcsDataArgs']] = None,
                 http_data_source: Optional[pulumi.Input['HttpDataArgs']] = None,
                 object_conditions: Optional[pulumi.Input['ObjectConditionsArgs']] = None,
                 posix_data_sink: Optional[pulumi.Input['PosixFilesystemArgs']] = None,
                 posix_data_source: Optional[pulumi.Input['PosixFilesystemArgs']] = None,
                 sink_agent_pool_name: Optional[pulumi.Input[str]] = None,
                 source_agent_pool_name: Optional[pulumi.Input[str]] = None,
                 transfer_manifest: Optional[pulumi.Input['TransferManifestArgs']] = None,
                 transfer_options: Optional[pulumi.Input['TransferOptionsArgs']] = None):
        """
        Configuration for running a transfer.
        :param pulumi.Input['AwsS3DataArgs'] aws_s3_data_source: An AWS S3 data source.
        :param pulumi.Input['AzureBlobStorageDataArgs'] azure_blob_storage_data_source: An Azure Blob Storage data source.
        :param pulumi.Input['GcsDataArgs'] gcs_data_sink: A Cloud Storage data sink.
        :param pulumi.Input['GcsDataArgs'] gcs_data_source: A Cloud Storage data source.
        :param pulumi.Input['GcsDataArgs'] gcs_intermediate_data_location: Cloud Storage intermediate data location.
        :param pulumi.Input['HttpDataArgs'] http_data_source: An HTTP URL data source.
        :param pulumi.Input['ObjectConditionsArgs'] object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' "last modification time" do not exclude objects in a data sink.
        :param pulumi.Input['PosixFilesystemArgs'] posix_data_sink: A POSIX Filesystem data sink.
        :param pulumi.Input['PosixFilesystemArgs'] posix_data_source: A POSIX Filesystem data source.
        :param pulumi.Input[str] sink_agent_pool_name: Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        :param pulumi.Input[str] source_agent_pool_name: Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        :param pulumi.Input['TransferManifestArgs'] transfer_manifest: A manifest file provides a list of objects to be transferred from the data source. This field points to the location of the manifest file. Otherwise, the entire source bucket is used. ObjectConditions still apply.
        :param pulumi.Input['TransferOptionsArgs'] transfer_options: If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
        """
        if aws_s3_data_source is not None:
            pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        if azure_blob_storage_data_source is not None:
            pulumi.set(__self__, "azure_blob_storage_data_source", azure_blob_storage_data_source)
        if gcs_data_sink is not None:
            pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        if gcs_data_source is not None:
            pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        if gcs_intermediate_data_location is not None:
            pulumi.set(__self__, "gcs_intermediate_data_location", gcs_intermediate_data_location)
        if http_data_source is not None:
            pulumi.set(__self__, "http_data_source", http_data_source)
        if object_conditions is not None:
            pulumi.set(__self__, "object_conditions", object_conditions)
        if posix_data_sink is not None:
            pulumi.set(__self__, "posix_data_sink", posix_data_sink)
        if posix_data_source is not None:
            pulumi.set(__self__, "posix_data_source", posix_data_source)
        if sink_agent_pool_name is not None:
            pulumi.set(__self__, "sink_agent_pool_name", sink_agent_pool_name)
        if source_agent_pool_name is not None:
            pulumi.set(__self__, "source_agent_pool_name", source_agent_pool_name)
        if transfer_manifest is not None:
            pulumi.set(__self__, "transfer_manifest", transfer_manifest)
        if transfer_options is not None:
            pulumi.set(__self__, "transfer_options", transfer_options)

    @property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> Optional[pulumi.Input['AwsS3DataArgs']]:
        """
        An AWS S3 data source.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @aws_s3_data_source.setter
    def aws_s3_data_source(self, value: Optional[pulumi.Input['AwsS3DataArgs']]):
        pulumi.set(self, "aws_s3_data_source", value)

    @property
    @pulumi.getter(name="azureBlobStorageDataSource")
    def azure_blob_storage_data_source(self) -> Optional[pulumi.Input['AzureBlobStorageDataArgs']]:
        """
        An Azure Blob Storage data source.
        """
        return pulumi.get(self, "azure_blob_storage_data_source")

    @azure_blob_storage_data_source.setter
    def azure_blob_storage_data_source(self, value: Optional[pulumi.Input['AzureBlobStorageDataArgs']]):
        pulumi.set(self, "azure_blob_storage_data_source", value)

    @property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> Optional[pulumi.Input['GcsDataArgs']]:
        """
        A Cloud Storage data sink.
        """
        return pulumi.get(self, "gcs_data_sink")

    @gcs_data_sink.setter
    def gcs_data_sink(self, value: Optional[pulumi.Input['GcsDataArgs']]):
        pulumi.set(self, "gcs_data_sink", value)

    @property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> Optional[pulumi.Input['GcsDataArgs']]:
        """
        A Cloud Storage data source.
        """
        return pulumi.get(self, "gcs_data_source")

    @gcs_data_source.setter
    def gcs_data_source(self, value: Optional[pulumi.Input['GcsDataArgs']]):
        pulumi.set(self, "gcs_data_source", value)

    @property
    @pulumi.getter(name="gcsIntermediateDataLocation")
    def gcs_intermediate_data_location(self) -> Optional[pulumi.Input['GcsDataArgs']]:
        """
        Cloud Storage intermediate data location.
        """
        return pulumi.get(self, "gcs_intermediate_data_location")

    @gcs_intermediate_data_location.setter
    def gcs_intermediate_data_location(self, value: Optional[pulumi.Input['GcsDataArgs']]):
        pulumi.set(self, "gcs_intermediate_data_location", value)

    @property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> Optional[pulumi.Input['HttpDataArgs']]:
        """
        An HTTP URL data source.
        """
        return pulumi.get(self, "http_data_source")

    @http_data_source.setter
    def http_data_source(self, value: Optional[pulumi.Input['HttpDataArgs']]):
        pulumi.set(self, "http_data_source", value)

    @property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> Optional[pulumi.Input['ObjectConditionsArgs']]:
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' "last modification time" do not exclude objects in a data sink.
        """
        return pulumi.get(self, "object_conditions")

    @object_conditions.setter
    def object_conditions(self, value: Optional[pulumi.Input['ObjectConditionsArgs']]):
        pulumi.set(self, "object_conditions", value)

    @property
    @pulumi.getter(name="posixDataSink")
    def posix_data_sink(self) -> Optional[pulumi.Input['PosixFilesystemArgs']]:
        """
        A POSIX Filesystem data sink.
        """
        return pulumi.get(self, "posix_data_sink")

    @posix_data_sink.setter
    def posix_data_sink(self, value: Optional[pulumi.Input['PosixFilesystemArgs']]):
        pulumi.set(self, "posix_data_sink", value)

    @property
    @pulumi.getter(name="posixDataSource")
    def posix_data_source(self) -> Optional[pulumi.Input['PosixFilesystemArgs']]:
        """
        A POSIX Filesystem data source.
        """
        return pulumi.get(self, "posix_data_source")

    @posix_data_source.setter
    def posix_data_source(self, value: Optional[pulumi.Input['PosixFilesystemArgs']]):
        pulumi.set(self, "posix_data_source", value)

    @property
    @pulumi.getter(name="sinkAgentPoolName")
    def sink_agent_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        """
        return pulumi.get(self, "sink_agent_pool_name")

    @sink_agent_pool_name.setter
    def sink_agent_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sink_agent_pool_name", value)

    @property
    @pulumi.getter(name="sourceAgentPoolName")
    def source_agent_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        """
        return pulumi.get(self, "source_agent_pool_name")

    @source_agent_pool_name.setter
    def source_agent_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_agent_pool_name", value)

    @property
    @pulumi.getter(name="transferManifest")
    def transfer_manifest(self) -> Optional[pulumi.Input['TransferManifestArgs']]:
        """
        A manifest file provides a list of objects to be transferred from the data source. This field points to the location of the manifest file. Otherwise, the entire source bucket is used. ObjectConditions still apply.
        """
        return pulumi.get(self, "transfer_manifest")

    @transfer_manifest.setter
    def transfer_manifest(self, value: Optional[pulumi.Input['TransferManifestArgs']]):
        pulumi.set(self, "transfer_manifest", value)

    @property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> Optional[pulumi.Input['TransferOptionsArgs']]:
        """
        If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "transfer_options")

    @transfer_options.setter
    def transfer_options(self, value: Optional[pulumi.Input['TransferOptionsArgs']]):
        pulumi.set(self, "transfer_options", value)


