# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketObjectArgs', 'BucketObject']

@pulumi.input_type
class BucketObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 component_count: Optional[pulumi.Input[int]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 crc32c: Optional[pulumi.Input[str]] = None,
                 custom_time: Optional[pulumi.Input[str]] = None,
                 customer_encryption: Optional[pulumi.Input['BucketObjectCustomerEncryptionArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 if_generation_match: Optional[pulumi.Input[str]] = None,
                 if_generation_not_match: Optional[pulumi.Input[str]] = None,
                 if_metageneration_match: Optional[pulumi.Input[str]] = None,
                 if_metageneration_not_match: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 md5_hash: Optional[pulumi.Input[str]] = None,
                 media_link: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input['BucketObjectOwnerArgs']] = None,
                 predefined_acl: Optional[pulumi.Input[str]] = None,
                 projection: Optional[pulumi.Input[str]] = None,
                 retention_expiration_time: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_deleted: Optional[pulumi.Input[str]] = None,
                 time_storage_class_updated: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BucketObject resource.
        :param pulumi.Input[str] bucket: The name of the bucket containing this object.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]] acl: Access controls on the object.
        :param pulumi.Input[str] cache_control: Cache-Control directive for the object data. If omitted, and the object is accessible to all anonymous users, the default will be public, max-age=3600.
        :param pulumi.Input[int] component_count: Number of underlying components that make up this object. Components are accumulated by compose operations.
        :param pulumi.Input[str] content_disposition: Content-Disposition of the object data.
        :param pulumi.Input[str] content_encoding: Content-Encoding of the object data.
        :param pulumi.Input[str] content_language: Content-Language of the object data.
        :param pulumi.Input[str] content_type: Content-Type of the object data. If an object is stored without a Content-Type, it is served as application/octet-stream.
        :param pulumi.Input[str] crc32c: CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte order. For more information about using the CRC32c checksum, see Hashes and ETags: Best Practices.
        :param pulumi.Input[str] custom_time: A timestamp in RFC 3339 format specified by the user for an object.
        :param pulumi.Input['BucketObjectCustomerEncryptionArgs'] customer_encryption: Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the object.
        :param pulumi.Input[bool] event_based_hold: Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is the loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false.
        :param pulumi.Input[str] generation: The content generation of this object. Used for object versioning.
        :param pulumi.Input[str] id: The ID of the object, including the bucket name, object name, and generation number.
        :param pulumi.Input[str] if_generation_match: Makes the operation conditional on whether the object's current generation matches the given value. Setting to 0 makes the operation succeed only if there are no live versions of the object.
        :param pulumi.Input[str] if_generation_not_match: Makes the operation conditional on whether the object's current generation does not match the given value. If no live object exists, the precondition fails. Setting to 0 makes the operation succeed only if there is a live version of the object.
        :param pulumi.Input[str] if_metageneration_match: Makes the operation conditional on whether the object's current metageneration matches the given value.
        :param pulumi.Input[str] if_metageneration_not_match: Makes the operation conditional on whether the object's current metageneration does not match the given value.
        :param pulumi.Input[str] kind: The kind of item this is. For objects, this is always storage#object.
        :param pulumi.Input[str] kms_key_name: Not currently supported. Specifying the parameter causes the request to fail with status code 400 - Bad Request.
        :param pulumi.Input[str] md5_hash: MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see Hashes and ETags: Best Practices.
        :param pulumi.Input[str] media_link: Media download link.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: User-provided metadata, in key/value pairs.
        :param pulumi.Input[str] metageneration: The version of the metadata for this object at this generation. Used for preconditions and for detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular object.
        :param pulumi.Input[str] name: The name of the object. Required if not specified by URL parameter.
        :param pulumi.Input['BucketObjectOwnerArgs'] owner: The owner of the object. This will always be the uploader of the object.
        :param pulumi.Input[str] predefined_acl: Apply a predefined set of access controls to this object.
        :param pulumi.Input[str] projection: Set of properties to return. Defaults to noAcl, unless the object resource specifies the acl property, when it defaults to full.
        :param pulumi.Input[str] retention_expiration_time: A server-determined value that specifies the earliest time that the object's retention period expires. This value is in RFC 3339 format. Note 1: This field is not provided for objects with an active event-based hold, since retention expiration is unknown until the hold is removed. Note 2: This value can be provided even when temporary hold is set (so that the user can reason about policy without having to first unset the temporary hold).
        :param pulumi.Input[str] self_link: The link to this object.
        :param pulumi.Input[str] size: Content-Length of the data in bytes.
        :param pulumi.Input[str] storage_class: Storage class of the object.
        :param pulumi.Input[bool] temporary_hold: Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and overwrites. A common use case of this flag is regulatory investigations where objects need to be retained while the investigation is ongoing. Note that unlike event-based hold, temporary hold does not impact retention expiration time of an object.
        :param pulumi.Input[str] time_created: The creation time of the object in RFC 3339 format.
        :param pulumi.Input[str] time_deleted: The deletion time of the object in RFC 3339 format. Will be returned if and only if this version of the object has been deleted.
        :param pulumi.Input[str] time_storage_class_updated: The time at which the object's storage class was last changed. When the object is initially created, it will be set to timeCreated.
        :param pulumi.Input[str] updated: The modification time of the object metadata in RFC 3339 format.
        :param pulumi.Input[str] user_project: The project to be billed for this request. Required for Requester Pays buckets.
        """
        pulumi.set(__self__, "bucket", bucket)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if component_count is not None:
            pulumi.set(__self__, "component_count", component_count)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if crc32c is not None:
            pulumi.set(__self__, "crc32c", crc32c)
        if custom_time is not None:
            pulumi.set(__self__, "custom_time", custom_time)
        if customer_encryption is not None:
            pulumi.set(__self__, "customer_encryption", customer_encryption)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if event_based_hold is not None:
            pulumi.set(__self__, "event_based_hold", event_based_hold)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if if_generation_match is not None:
            pulumi.set(__self__, "if_generation_match", if_generation_match)
        if if_generation_not_match is not None:
            pulumi.set(__self__, "if_generation_not_match", if_generation_not_match)
        if if_metageneration_match is not None:
            pulumi.set(__self__, "if_metageneration_match", if_metageneration_match)
        if if_metageneration_not_match is not None:
            pulumi.set(__self__, "if_metageneration_not_match", if_metageneration_not_match)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if md5_hash is not None:
            pulumi.set(__self__, "md5_hash", md5_hash)
        if media_link is not None:
            pulumi.set(__self__, "media_link", media_link)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metageneration is not None:
            pulumi.set(__self__, "metageneration", metageneration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if predefined_acl is not None:
            pulumi.set(__self__, "predefined_acl", predefined_acl)
        if projection is not None:
            pulumi.set(__self__, "projection", projection)
        if retention_expiration_time is not None:
            pulumi.set(__self__, "retention_expiration_time", retention_expiration_time)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_storage_class_updated is not None:
            pulumi.set(__self__, "time_storage_class_updated", time_storage_class_updated)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if user_project is not None:
            pulumi.set(__self__, "user_project", user_project)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket containing this object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]]]:
        """
        Access controls on the object.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[str]]:
        """
        Cache-Control directive for the object data. If omitted, and the object is accessible to all anonymous users, the default will be public, max-age=3600.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter(name="componentCount")
    def component_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of underlying components that make up this object. Components are accumulated by compose operations.
        """
        return pulumi.get(self, "component_count")

    @component_count.setter
    def component_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "component_count", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Content-Disposition of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Content-Encoding of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[str]]:
        """
        Content-Language of the object data.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Content-Type of the object data. If an object is stored without a Content-Type, it is served as application/octet-stream.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def crc32c(self) -> Optional[pulumi.Input[str]]:
        """
        CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte order. For more information about using the CRC32c checksum, see Hashes and ETags: Best Practices.
        """
        return pulumi.get(self, "crc32c")

    @crc32c.setter
    def crc32c(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crc32c", value)

    @property
    @pulumi.getter(name="customTime")
    def custom_time(self) -> Optional[pulumi.Input[str]]:
        """
        A timestamp in RFC 3339 format specified by the user for an object.
        """
        return pulumi.get(self, "custom_time")

    @custom_time.setter
    def custom_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_time", value)

    @property
    @pulumi.getter(name="customerEncryption")
    def customer_encryption(self) -> Optional[pulumi.Input['BucketObjectCustomerEncryptionArgs']]:
        """
        Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
        """
        return pulumi.get(self, "customer_encryption")

    @customer_encryption.setter
    def customer_encryption(self, value: Optional[pulumi.Input['BucketObjectCustomerEncryptionArgs']]):
        pulumi.set(self, "customer_encryption", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP 1.1 Entity tag for the object.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is the loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false.
        """
        return pulumi.get(self, "event_based_hold")

    @event_based_hold.setter
    def event_based_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_based_hold", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        The content generation of this object. Used for object versioning.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the object, including the bucket name, object name, and generation number.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ifGenerationMatch")
    def if_generation_match(self) -> Optional[pulumi.Input[str]]:
        """
        Makes the operation conditional on whether the object's current generation matches the given value. Setting to 0 makes the operation succeed only if there are no live versions of the object.
        """
        return pulumi.get(self, "if_generation_match")

    @if_generation_match.setter
    def if_generation_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "if_generation_match", value)

    @property
    @pulumi.getter(name="ifGenerationNotMatch")
    def if_generation_not_match(self) -> Optional[pulumi.Input[str]]:
        """
        Makes the operation conditional on whether the object's current generation does not match the given value. If no live object exists, the precondition fails. Setting to 0 makes the operation succeed only if there is a live version of the object.
        """
        return pulumi.get(self, "if_generation_not_match")

    @if_generation_not_match.setter
    def if_generation_not_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "if_generation_not_match", value)

    @property
    @pulumi.getter(name="ifMetagenerationMatch")
    def if_metageneration_match(self) -> Optional[pulumi.Input[str]]:
        """
        Makes the operation conditional on whether the object's current metageneration matches the given value.
        """
        return pulumi.get(self, "if_metageneration_match")

    @if_metageneration_match.setter
    def if_metageneration_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "if_metageneration_match", value)

    @property
    @pulumi.getter(name="ifMetagenerationNotMatch")
    def if_metageneration_not_match(self) -> Optional[pulumi.Input[str]]:
        """
        Makes the operation conditional on whether the object's current metageneration does not match the given value.
        """
        return pulumi.get(self, "if_metageneration_not_match")

    @if_metageneration_not_match.setter
    def if_metageneration_not_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "if_metageneration_not_match", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of item this is. For objects, this is always storage#object.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Not currently supported. Specifying the parameter causes the request to fail with status code 400 - Bad Request.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="md5Hash")
    def md5_hash(self) -> Optional[pulumi.Input[str]]:
        """
        MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see Hashes and ETags: Best Practices.
        """
        return pulumi.get(self, "md5_hash")

    @md5_hash.setter
    def md5_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5_hash", value)

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> Optional[pulumi.Input[str]]:
        """
        Media download link.
        """
        return pulumi.get(self, "media_link")

    @media_link.setter
    def media_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_link", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-provided metadata, in key/value pairs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def metageneration(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the metadata for this object at this generation. Used for preconditions and for detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular object.
        """
        return pulumi.get(self, "metageneration")

    @metageneration.setter
    def metageneration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metageneration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the object. Required if not specified by URL parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input['BucketObjectOwnerArgs']]:
        """
        The owner of the object. This will always be the uploader of the object.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input['BucketObjectOwnerArgs']]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="predefinedAcl")
    def predefined_acl(self) -> Optional[pulumi.Input[str]]:
        """
        Apply a predefined set of access controls to this object.
        """
        return pulumi.get(self, "predefined_acl")

    @predefined_acl.setter
    def predefined_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predefined_acl", value)

    @property
    @pulumi.getter
    def projection(self) -> Optional[pulumi.Input[str]]:
        """
        Set of properties to return. Defaults to noAcl, unless the object resource specifies the acl property, when it defaults to full.
        """
        return pulumi.get(self, "projection")

    @projection.setter
    def projection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "projection", value)

    @property
    @pulumi.getter(name="retentionExpirationTime")
    def retention_expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        A server-determined value that specifies the earliest time that the object's retention period expires. This value is in RFC 3339 format. Note 1: This field is not provided for objects with an active event-based hold, since retention expiration is unknown until the hold is removed. Note 2: This value can be provided even when temporary hold is set (so that the user can reason about policy without having to first unset the temporary hold).
        """
        return pulumi.get(self, "retention_expiration_time")

    @retention_expiration_time.setter
    def retention_expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_expiration_time", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The link to this object.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Content-Length of the data in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        Storage class of the object.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and overwrites. A common use case of this flag is regulatory investigations where objects need to be retained while the investigation is ongoing. Note that unlike event-based hold, temporary hold does not impact retention expiration time of an object.
        """
        return pulumi.get(self, "temporary_hold")

    @temporary_hold.setter
    def temporary_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporary_hold", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the object in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[pulumi.Input[str]]:
        """
        The deletion time of the object in RFC 3339 format. Will be returned if and only if this version of the object has been deleted.
        """
        return pulumi.get(self, "time_deleted")

    @time_deleted.setter
    def time_deleted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_deleted", value)

    @property
    @pulumi.getter(name="timeStorageClassUpdated")
    def time_storage_class_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the object's storage class was last changed. When the object is initially created, it will be set to timeCreated.
        """
        return pulumi.get(self, "time_storage_class_updated")

    @time_storage_class_updated.setter
    def time_storage_class_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_storage_class_updated", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        The modification time of the object metadata in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter(name="userProject")
    def user_project(self) -> Optional[pulumi.Input[str]]:
        """
        The project to be billed for this request. Required for Requester Pays buckets.
        """
        return pulumi.get(self, "user_project")

    @user_project.setter
    def user_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_project", value)


class BucketObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 component_count: Optional[pulumi.Input[int]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 crc32c: Optional[pulumi.Input[str]] = None,
                 custom_time: Optional[pulumi.Input[str]] = None,
                 customer_encryption: Optional[pulumi.Input[pulumi.InputType['BucketObjectCustomerEncryptionArgs']]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 if_generation_match: Optional[pulumi.Input[str]] = None,
                 if_generation_not_match: Optional[pulumi.Input[str]] = None,
                 if_metageneration_match: Optional[pulumi.Input[str]] = None,
                 if_metageneration_not_match: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 md5_hash: Optional[pulumi.Input[str]] = None,
                 media_link: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[pulumi.InputType['BucketObjectOwnerArgs']]] = None,
                 predefined_acl: Optional[pulumi.Input[str]] = None,
                 projection: Optional[pulumi.Input[str]] = None,
                 retention_expiration_time: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_deleted: Optional[pulumi.Input[str]] = None,
                 time_storage_class_updated: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Stores a new object and metadata.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]] acl: Access controls on the object.
        :param pulumi.Input[str] bucket: The name of the bucket containing this object.
        :param pulumi.Input[str] cache_control: Cache-Control directive for the object data. If omitted, and the object is accessible to all anonymous users, the default will be public, max-age=3600.
        :param pulumi.Input[int] component_count: Number of underlying components that make up this object. Components are accumulated by compose operations.
        :param pulumi.Input[str] content_disposition: Content-Disposition of the object data.
        :param pulumi.Input[str] content_encoding: Content-Encoding of the object data.
        :param pulumi.Input[str] content_language: Content-Language of the object data.
        :param pulumi.Input[str] content_type: Content-Type of the object data. If an object is stored without a Content-Type, it is served as application/octet-stream.
        :param pulumi.Input[str] crc32c: CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte order. For more information about using the CRC32c checksum, see Hashes and ETags: Best Practices.
        :param pulumi.Input[str] custom_time: A timestamp in RFC 3339 format specified by the user for an object.
        :param pulumi.Input[pulumi.InputType['BucketObjectCustomerEncryptionArgs']] customer_encryption: Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the object.
        :param pulumi.Input[bool] event_based_hold: Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is the loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false.
        :param pulumi.Input[str] generation: The content generation of this object. Used for object versioning.
        :param pulumi.Input[str] id: The ID of the object, including the bucket name, object name, and generation number.
        :param pulumi.Input[str] if_generation_match: Makes the operation conditional on whether the object's current generation matches the given value. Setting to 0 makes the operation succeed only if there are no live versions of the object.
        :param pulumi.Input[str] if_generation_not_match: Makes the operation conditional on whether the object's current generation does not match the given value. If no live object exists, the precondition fails. Setting to 0 makes the operation succeed only if there is a live version of the object.
        :param pulumi.Input[str] if_metageneration_match: Makes the operation conditional on whether the object's current metageneration matches the given value.
        :param pulumi.Input[str] if_metageneration_not_match: Makes the operation conditional on whether the object's current metageneration does not match the given value.
        :param pulumi.Input[str] kind: The kind of item this is. For objects, this is always storage#object.
        :param pulumi.Input[str] kms_key_name: Not currently supported. Specifying the parameter causes the request to fail with status code 400 - Bad Request.
        :param pulumi.Input[str] md5_hash: MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see Hashes and ETags: Best Practices.
        :param pulumi.Input[str] media_link: Media download link.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: User-provided metadata, in key/value pairs.
        :param pulumi.Input[str] metageneration: The version of the metadata for this object at this generation. Used for preconditions and for detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular object.
        :param pulumi.Input[str] name: The name of the object. Required if not specified by URL parameter.
        :param pulumi.Input[pulumi.InputType['BucketObjectOwnerArgs']] owner: The owner of the object. This will always be the uploader of the object.
        :param pulumi.Input[str] predefined_acl: Apply a predefined set of access controls to this object.
        :param pulumi.Input[str] projection: Set of properties to return. Defaults to noAcl, unless the object resource specifies the acl property, when it defaults to full.
        :param pulumi.Input[str] retention_expiration_time: A server-determined value that specifies the earliest time that the object's retention period expires. This value is in RFC 3339 format. Note 1: This field is not provided for objects with an active event-based hold, since retention expiration is unknown until the hold is removed. Note 2: This value can be provided even when temporary hold is set (so that the user can reason about policy without having to first unset the temporary hold).
        :param pulumi.Input[str] self_link: The link to this object.
        :param pulumi.Input[str] size: Content-Length of the data in bytes.
        :param pulumi.Input[str] storage_class: Storage class of the object.
        :param pulumi.Input[bool] temporary_hold: Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and overwrites. A common use case of this flag is regulatory investigations where objects need to be retained while the investigation is ongoing. Note that unlike event-based hold, temporary hold does not impact retention expiration time of an object.
        :param pulumi.Input[str] time_created: The creation time of the object in RFC 3339 format.
        :param pulumi.Input[str] time_deleted: The deletion time of the object in RFC 3339 format. Will be returned if and only if this version of the object has been deleted.
        :param pulumi.Input[str] time_storage_class_updated: The time at which the object's storage class was last changed. When the object is initially created, it will be set to timeCreated.
        :param pulumi.Input[str] updated: The modification time of the object metadata in RFC 3339 format.
        :param pulumi.Input[str] user_project: The project to be billed for this request. Required for Requester Pays buckets.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Stores a new object and metadata.

        :param str resource_name: The name of the resource.
        :param BucketObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 component_count: Optional[pulumi.Input[int]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 crc32c: Optional[pulumi.Input[str]] = None,
                 custom_time: Optional[pulumi.Input[str]] = None,
                 customer_encryption: Optional[pulumi.Input[pulumi.InputType['BucketObjectCustomerEncryptionArgs']]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 if_generation_match: Optional[pulumi.Input[str]] = None,
                 if_generation_not_match: Optional[pulumi.Input[str]] = None,
                 if_metageneration_match: Optional[pulumi.Input[str]] = None,
                 if_metageneration_not_match: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 md5_hash: Optional[pulumi.Input[str]] = None,
                 media_link: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[pulumi.InputType['BucketObjectOwnerArgs']]] = None,
                 predefined_acl: Optional[pulumi.Input[str]] = None,
                 projection: Optional[pulumi.Input[str]] = None,
                 retention_expiration_time: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_deleted: Optional[pulumi.Input[str]] = None,
                 time_storage_class_updated: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketObjectArgs.__new__(BucketObjectArgs)

            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["component_count"] = component_count
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_language"] = content_language
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["crc32c"] = crc32c
            __props__.__dict__["custom_time"] = custom_time
            __props__.__dict__["customer_encryption"] = customer_encryption
            __props__.__dict__["etag"] = etag
            __props__.__dict__["event_based_hold"] = event_based_hold
            __props__.__dict__["generation"] = generation
            __props__.__dict__["id"] = id
            __props__.__dict__["if_generation_match"] = if_generation_match
            __props__.__dict__["if_generation_not_match"] = if_generation_not_match
            __props__.__dict__["if_metageneration_match"] = if_metageneration_match
            __props__.__dict__["if_metageneration_not_match"] = if_metageneration_not_match
            __props__.__dict__["kind"] = kind
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["md5_hash"] = md5_hash
            __props__.__dict__["media_link"] = media_link
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metageneration"] = metageneration
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["predefined_acl"] = predefined_acl
            __props__.__dict__["projection"] = projection
            __props__.__dict__["retention_expiration_time"] = retention_expiration_time
            __props__.__dict__["self_link"] = self_link
            __props__.__dict__["size"] = size
            __props__.__dict__["source"] = source
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["temporary_hold"] = temporary_hold
            __props__.__dict__["time_created"] = time_created
            __props__.__dict__["time_deleted"] = time_deleted
            __props__.__dict__["time_storage_class_updated"] = time_storage_class_updated
            __props__.__dict__["updated"] = updated
            __props__.__dict__["user_project"] = user_project
        super(BucketObject, __self__).__init__(
            'google-native:storage/v1:BucketObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BucketObject':
        """
        Get an existing BucketObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BucketObjectArgs.__new__(BucketObjectArgs)

        __props__.__dict__["acl"] = None
        __props__.__dict__["bucket"] = None
        __props__.__dict__["cache_control"] = None
        __props__.__dict__["component_count"] = None
        __props__.__dict__["content_disposition"] = None
        __props__.__dict__["content_encoding"] = None
        __props__.__dict__["content_language"] = None
        __props__.__dict__["content_type"] = None
        __props__.__dict__["crc32c"] = None
        __props__.__dict__["custom_time"] = None
        __props__.__dict__["customer_encryption"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["event_based_hold"] = None
        __props__.__dict__["generation"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["kms_key_name"] = None
        __props__.__dict__["md5_hash"] = None
        __props__.__dict__["media_link"] = None
        __props__.__dict__["metadata"] = None
        __props__.__dict__["metageneration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["owner"] = None
        __props__.__dict__["retention_expiration_time"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["size"] = None
        __props__.__dict__["storage_class"] = None
        __props__.__dict__["temporary_hold"] = None
        __props__.__dict__["time_created"] = None
        __props__.__dict__["time_deleted"] = None
        __props__.__dict__["time_storage_class_updated"] = None
        __props__.__dict__["updated"] = None
        return BucketObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Sequence['outputs.ObjectAccessControlResponse']]:
        """
        Access controls on the object.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the bucket containing this object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[str]:
        """
        Cache-Control directive for the object data. If omitted, and the object is accessible to all anonymous users, the default will be public, max-age=3600.
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter(name="componentCount")
    def component_count(self) -> pulumi.Output[int]:
        """
        Number of underlying components that make up this object. Components are accumulated by compose operations.
        """
        return pulumi.get(self, "component_count")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[str]:
        """
        Content-Disposition of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[str]:
        """
        Content-Encoding of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> pulumi.Output[str]:
        """
        Content-Language of the object data.
        """
        return pulumi.get(self, "content_language")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        Content-Type of the object data. If an object is stored without a Content-Type, it is served as application/octet-stream.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def crc32c(self) -> pulumi.Output[str]:
        """
        CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte order. For more information about using the CRC32c checksum, see Hashes and ETags: Best Practices.
        """
        return pulumi.get(self, "crc32c")

    @property
    @pulumi.getter(name="customTime")
    def custom_time(self) -> pulumi.Output[str]:
        """
        A timestamp in RFC 3339 format specified by the user for an object.
        """
        return pulumi.get(self, "custom_time")

    @property
    @pulumi.getter(name="customerEncryption")
    def customer_encryption(self) -> pulumi.Output['outputs.BucketObjectCustomerEncryptionResponse']:
        """
        Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
        """
        return pulumi.get(self, "customer_encryption")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        HTTP 1.1 Entity tag for the object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> pulumi.Output[bool]:
        """
        Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is the loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false.
        """
        return pulumi.get(self, "event_based_hold")

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Output[str]:
        """
        The content generation of this object. Used for object versioning.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        The kind of item this is. For objects, this is always storage#object.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[str]:
        """
        Not currently supported. Specifying the parameter causes the request to fail with status code 400 - Bad Request.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="md5Hash")
    def md5_hash(self) -> pulumi.Output[str]:
        """
        MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see Hashes and ETags: Best Practices.
        """
        return pulumi.get(self, "md5_hash")

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> pulumi.Output[str]:
        """
        Media download link.
        """
        return pulumi.get(self, "media_link")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User-provided metadata, in key/value pairs.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def metageneration(self) -> pulumi.Output[str]:
        """
        The version of the metadata for this object at this generation. Used for preconditions and for detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular object.
        """
        return pulumi.get(self, "metageneration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the object. Required if not specified by URL parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output['outputs.BucketObjectOwnerResponse']:
        """
        The owner of the object. This will always be the uploader of the object.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="retentionExpirationTime")
    def retention_expiration_time(self) -> pulumi.Output[str]:
        """
        A server-determined value that specifies the earliest time that the object's retention period expires. This value is in RFC 3339 format. Note 1: This field is not provided for objects with an active event-based hold, since retention expiration is unknown until the hold is removed. Note 2: This value can be provided even when temporary hold is set (so that the user can reason about policy without having to first unset the temporary hold).
        """
        return pulumi.get(self, "retention_expiration_time")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The link to this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        Content-Length of the data in bytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[str]:
        """
        Storage class of the object.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> pulumi.Output[bool]:
        """
        Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and overwrites. A common use case of this flag is regulatory investigations where objects need to be retained while the investigation is ongoing. Note that unlike event-based hold, temporary hold does not impact retention expiration time of an object.
        """
        return pulumi.get(self, "temporary_hold")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The creation time of the object in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> pulumi.Output[str]:
        """
        The deletion time of the object in RFC 3339 format. Will be returned if and only if this version of the object has been deleted.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeStorageClassUpdated")
    def time_storage_class_updated(self) -> pulumi.Output[str]:
        """
        The time at which the object's storage class was last changed. When the object is initially created, it will be set to timeCreated.
        """
        return pulumi.get(self, "time_storage_class_updated")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The modification time of the object metadata in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

