# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudRetailV2AudienceResponse',
    'GoogleCloudRetailV2ColorInfoResponse',
    'GoogleCloudRetailV2FulfillmentInfoResponse',
    'GoogleCloudRetailV2ImageResponse',
    'GoogleCloudRetailV2IntervalResponse',
    'GoogleCloudRetailV2PriceInfoPriceRangeResponse',
    'GoogleCloudRetailV2PriceInfoResponse',
    'GoogleCloudRetailV2ProductResponse',
    'GoogleCloudRetailV2PromotionResponse',
    'GoogleCloudRetailV2RatingResponse',
]

@pulumi.output_type
class GoogleCloudRetailV2AudienceResponse(dict):
    """
    An intended audience of the Product for whom it's sold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ageGroups":
            suggest = "age_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2AudienceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2AudienceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2AudienceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 age_groups: Sequence[str],
                 genders: Sequence[str]):
        """
        An intended audience of the Product for whom it's sold.
        :param Sequence[str] age_groups: The age groups of the audience. Strongly encouraged to use the standard values: "newborn" (up to 3 months old), "infant" (3–12 months old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically teens or older). At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [age_group](https://support.google.com/merchants/answer/6324463). Schema.org property [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        :param Sequence[str] genders: The genders of the audience. Strongly encouraged to use the standard values: "male", "female", "unisex". At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [gender](https://support.google.com/merchants/answer/6324479). Schema.org property [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        """
        pulumi.set(__self__, "age_groups", age_groups)
        pulumi.set(__self__, "genders", genders)

    @property
    @pulumi.getter(name="ageGroups")
    def age_groups(self) -> Sequence[str]:
        """
        The age groups of the audience. Strongly encouraged to use the standard values: "newborn" (up to 3 months old), "infant" (3–12 months old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically teens or older). At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [age_group](https://support.google.com/merchants/answer/6324463). Schema.org property [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        """
        return pulumi.get(self, "age_groups")

    @property
    @pulumi.getter
    def genders(self) -> Sequence[str]:
        """
        The genders of the audience. Strongly encouraged to use the standard values: "male", "female", "unisex". At most 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [gender](https://support.google.com/merchants/answer/6324479). Schema.org property [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        """
        return pulumi.get(self, "genders")


@pulumi.output_type
class GoogleCloudRetailV2ColorInfoResponse(dict):
    """
    The color information of a Product.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colorFamilies":
            suggest = "color_families"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2ColorInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2ColorInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2ColorInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color_families: Sequence[str],
                 colors: Sequence[str]):
        """
        The color information of a Product.
        :param Sequence[str] color_families: The standard color families. Strongly recommended to use the following standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed". Normally it is expected to have only 1 color family. May consider using single "Mixed" instead of multiple values. A maximum of 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        :param Sequence[str] colors: The color display names, which may be different from standard color family names, such as the color aliases used in the website frontend. Normally it is expected to have only 1 color. May consider using single "Mixed" instead of multiple values. A maximum of 25 colors are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        pulumi.set(__self__, "color_families", color_families)
        pulumi.set(__self__, "colors", colors)

    @property
    @pulumi.getter(name="colorFamilies")
    def color_families(self) -> Sequence[str]:
        """
        The standard color families. Strongly recommended to use the following standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed". Normally it is expected to have only 1 color family. May consider using single "Mixed" instead of multiple values. A maximum of 5 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "color_families")

    @property
    @pulumi.getter
    def colors(self) -> Sequence[str]:
        """
        The color display names, which may be different from standard color family names, such as the color aliases used in the website frontend. Normally it is expected to have only 1 color. May consider using single "Mixed" instead of multiple values. A maximum of 25 colors are allowed. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "colors")


@pulumi.output_type
class GoogleCloudRetailV2FulfillmentInfoResponse(dict):
    """
    Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "placeIds":
            suggest = "place_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2FulfillmentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2FulfillmentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2FulfillmentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 place_ids: Sequence[str],
                 type: str):
        """
        Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods.
        :param Sequence[str] place_ids: The IDs for this type, such as the store IDs for FulfillmentInfo.type.pickup-in-store or the region IDs for FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are allowed. Each value must be a string with a length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
        :param str type: The fulfillment type, including commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned.
        """
        pulumi.set(__self__, "place_ids", place_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="placeIds")
    def place_ids(self) -> Sequence[str]:
        """
        The IDs for this type, such as the store IDs for FulfillmentInfo.type.pickup-in-store or the region IDs for FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are allowed. Each value must be a string with a length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "place_ids")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The fulfillment type, including commonly used types (such as pickup in store and same day delivery), and custom types. Customers have to map custom types to their display names before rendering UI. Supported values: * "pickup-in-store" * "ship-to-store" * "same-day-delivery" * "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5" If this field is set to an invalid value other than these, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudRetailV2ImageResponse(dict):
    """
    Product image. Recommendations AI and Retail Search do not use product images to improve prediction and search results. However, product images can be returned in results, and are shown in prediction or search previews in the console.
    """
    def __init__(__self__, *,
                 height: int,
                 uri: str,
                 width: int):
        """
        Product image. Recommendations AI and Retail Search do not use product images to improve prediction and search results. However, product images can be returned in results, and are shown in prediction or search previews in the console.
        :param int height: Height of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        :param str uri: URI of the image. This field must be a valid UTF-8 encoded URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        :param int width: Width of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> int:
        """
        Height of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the image. This field must be a valid UTF-8 encoded URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def width(self) -> int:
        """
        Width of the image in number of pixels. This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class GoogleCloudRetailV2IntervalResponse(dict):
    """
    A floating point interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusiveMaximum":
            suggest = "exclusive_maximum"
        elif key == "exclusiveMinimum":
            suggest = "exclusive_minimum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2IntervalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2IntervalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2IntervalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusive_maximum: float,
                 exclusive_minimum: float,
                 maximum: float,
                 minimum: float):
        """
        A floating point interval.
        :param float exclusive_maximum: Exclusive upper bound.
        :param float exclusive_minimum: Exclusive lower bound.
        :param float maximum: Inclusive upper bound.
        :param float minimum: Inclusive lower bound.
        """
        pulumi.set(__self__, "exclusive_maximum", exclusive_maximum)
        pulumi.set(__self__, "exclusive_minimum", exclusive_minimum)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter(name="exclusiveMaximum")
    def exclusive_maximum(self) -> float:
        """
        Exclusive upper bound.
        """
        return pulumi.get(self, "exclusive_maximum")

    @property
    @pulumi.getter(name="exclusiveMinimum")
    def exclusive_minimum(self) -> float:
        """
        Exclusive lower bound.
        """
        return pulumi.get(self, "exclusive_minimum")

    @property
    @pulumi.getter
    def maximum(self) -> float:
        """
        Inclusive upper bound.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> float:
        """
        Inclusive lower bound.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GoogleCloudRetailV2PriceInfoPriceRangeResponse(dict):
    """
    The price range of all variant Product having the same Product.primary_product_id.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originalPrice":
            suggest = "original_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2PriceInfoPriceRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2PriceInfoPriceRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2PriceInfoPriceRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 original_price: 'outputs.GoogleCloudRetailV2IntervalResponse',
                 price: 'outputs.GoogleCloudRetailV2IntervalResponse'):
        """
        The price range of all variant Product having the same Product.primary_product_id.
        :param 'GoogleCloudRetailV2IntervalResponse' original_price: The inclusive Product.pricing_info.original_price internal of all variant Product having the same Product.primary_product_id.
        :param 'GoogleCloudRetailV2IntervalResponse' price: The inclusive Product.pricing_info.price interval of all variant Product having the same Product.primary_product_id.
        """
        pulumi.set(__self__, "original_price", original_price)
        pulumi.set(__self__, "price", price)

    @property
    @pulumi.getter(name="originalPrice")
    def original_price(self) -> 'outputs.GoogleCloudRetailV2IntervalResponse':
        """
        The inclusive Product.pricing_info.original_price internal of all variant Product having the same Product.primary_product_id.
        """
        return pulumi.get(self, "original_price")

    @property
    @pulumi.getter
    def price(self) -> 'outputs.GoogleCloudRetailV2IntervalResponse':
        """
        The inclusive Product.pricing_info.price interval of all variant Product having the same Product.primary_product_id.
        """
        return pulumi.get(self, "price")


@pulumi.output_type
class GoogleCloudRetailV2PriceInfoResponse(dict):
    """
    The price information of a Product.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currencyCode":
            suggest = "currency_code"
        elif key == "originalPrice":
            suggest = "original_price"
        elif key == "priceEffectiveTime":
            suggest = "price_effective_time"
        elif key == "priceExpireTime":
            suggest = "price_expire_time"
        elif key == "priceRange":
            suggest = "price_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2PriceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2PriceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2PriceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cost: float,
                 currency_code: str,
                 original_price: float,
                 price: float,
                 price_effective_time: str,
                 price_expire_time: str,
                 price_range: 'outputs.GoogleCloudRetailV2PriceInfoPriceRangeResponse'):
        """
        The price information of a Product.
        :param float cost: The costs associated with the sale of a particular product. Used for gross profit reporting. * Profit = price - cost Google Merchant Center property [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        :param str currency_code: The 3-letter currency code defined in [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html). If this field is an unrecognizable currency code, an INVALID_ARGUMENT error is returned. The Product.Type.VARIANT Products with the same Product.primary_product_id must share the same currency_code. Otherwise, a FAILED_PRECONDITION error is returned.
        :param float original_price: Price of the product without any discount. If zero, by default set to be the price. If set, original_price should be greater than or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
        :param float price: Price of the product. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371). Schema.org property [Offer.price](https://schema.org/price).
        :param str price_effective_time: The timestamp when the price starts to be effective. This can be set as a future timestamp, and the price is only used for search after price_effective_time. If so, the original_price must be set and original_price is used before price_effective_time. Do not set if price is always effective because it will cause additional latency during search.
        :param str price_expire_time: The timestamp when the price stops to be effective. The price is used for search before price_expire_time. If this field is set, the original_price must be set and original_price is used after price_expire_time. Do not set if price is always effective because it will cause additional latency during search.
        :param 'GoogleCloudRetailV2PriceInfoPriceRangeResponse' price_range: The price range of all the child Product.Type.VARIANT Products grouped together on the Product.Type.PRIMARY Product. Only populated for Product.Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        pulumi.set(__self__, "cost", cost)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "original_price", original_price)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "price_effective_time", price_effective_time)
        pulumi.set(__self__, "price_expire_time", price_expire_time)
        pulumi.set(__self__, "price_range", price_range)

    @property
    @pulumi.getter
    def cost(self) -> float:
        """
        The costs associated with the sale of a particular product. Used for gross profit reporting. * Profit = price - cost Google Merchant Center property [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        """
        return pulumi.get(self, "cost")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        The 3-letter currency code defined in [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html). If this field is an unrecognizable currency code, an INVALID_ARGUMENT error is returned. The Product.Type.VARIANT Products with the same Product.primary_product_id must share the same currency_code. Otherwise, a FAILED_PRECONDITION error is returned.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="originalPrice")
    def original_price(self) -> float:
        """
        Price of the product without any discount. If zero, by default set to be the price. If set, original_price should be greater than or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "original_price")

    @property
    @pulumi.getter
    def price(self) -> float:
        """
        Price of the product. Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371). Schema.org property [Offer.price](https://schema.org/price).
        """
        return pulumi.get(self, "price")

    @property
    @pulumi.getter(name="priceEffectiveTime")
    def price_effective_time(self) -> str:
        """
        The timestamp when the price starts to be effective. This can be set as a future timestamp, and the price is only used for search after price_effective_time. If so, the original_price must be set and original_price is used before price_effective_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        return pulumi.get(self, "price_effective_time")

    @property
    @pulumi.getter(name="priceExpireTime")
    def price_expire_time(self) -> str:
        """
        The timestamp when the price stops to be effective. The price is used for search before price_expire_time. If this field is set, the original_price must be set and original_price is used after price_expire_time. Do not set if price is always effective because it will cause additional latency during search.
        """
        return pulumi.get(self, "price_expire_time")

    @property
    @pulumi.getter(name="priceRange")
    def price_range(self) -> 'outputs.GoogleCloudRetailV2PriceInfoPriceRangeResponse':
        """
        The price range of all the child Product.Type.VARIANT Products grouped together on the Product.Type.PRIMARY Product. Only populated for Product.Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        return pulumi.get(self, "price_range")


@pulumi.output_type
class GoogleCloudRetailV2ProductResponse(dict):
    """
    Product captures all metadata information of items to be recommended or searched.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableQuantity":
            suggest = "available_quantity"
        elif key == "availableTime":
            suggest = "available_time"
        elif key == "collectionMemberIds":
            suggest = "collection_member_ids"
        elif key == "colorInfo":
            suggest = "color_info"
        elif key == "expireTime":
            suggest = "expire_time"
        elif key == "fulfillmentInfo":
            suggest = "fulfillment_info"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "priceInfo":
            suggest = "price_info"
        elif key == "primaryProductId":
            suggest = "primary_product_id"
        elif key == "publishTime":
            suggest = "publish_time"
        elif key == "retrievableFields":
            suggest = "retrievable_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2ProductResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2ProductResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2ProductResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: Mapping[str, str],
                 audience: 'outputs.GoogleCloudRetailV2AudienceResponse',
                 availability: str,
                 available_quantity: int,
                 available_time: str,
                 brands: Sequence[str],
                 categories: Sequence[str],
                 collection_member_ids: Sequence[str],
                 color_info: 'outputs.GoogleCloudRetailV2ColorInfoResponse',
                 conditions: Sequence[str],
                 description: str,
                 expire_time: str,
                 fulfillment_info: Sequence['outputs.GoogleCloudRetailV2FulfillmentInfoResponse'],
                 gtin: str,
                 images: Sequence['outputs.GoogleCloudRetailV2ImageResponse'],
                 language_code: str,
                 materials: Sequence[str],
                 name: str,
                 patterns: Sequence[str],
                 price_info: 'outputs.GoogleCloudRetailV2PriceInfoResponse',
                 primary_product_id: str,
                 promotions: Sequence['outputs.GoogleCloudRetailV2PromotionResponse'],
                 publish_time: str,
                 rating: 'outputs.GoogleCloudRetailV2RatingResponse',
                 retrievable_fields: str,
                 sizes: Sequence[str],
                 tags: Sequence[str],
                 title: str,
                 ttl: str,
                 type: str,
                 uri: str,
                 variants: Sequence['outputs.GoogleCloudRetailV2ProductResponse']):
        """
        Product captures all metadata information of items to be recommended or searched.
        :param Mapping[str, str] attributes: Highly encouraged. Extra product attributes to be included. For example, for products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the attributes here. Features that can take on one of a limited number of possible values. Two types of features can be set are: Textual features. some examples would be the brand/maker of a product, or country of a customer. Numerical features. Some examples would be the height/weight of a product, or age of a customer. For example: `{ "vendor": {"text": ["vendor123", "vendor456"]}, "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]} }`. This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT error is returned: * Max entries count: 200. * The key must be a UTF-8 encoded string with a length limit of 128 characters. * For indexable attribute, the key must match the pattern: `a-zA-Z0-9*`. For example, `key0LikeThis` or `KEY_1_LIKE_THIS`. * For text attributes, at most 400 values are allowed. Empty values are not allowed. Each value must be a non-empty UTF-8 encoded string with a length limit of 256 characters. * For number attributes, at most 400 values are allowed.
        :param 'GoogleCloudRetailV2AudienceResponse' audience: The target group associated with a given audience (e.g. male, veterans, car owners, musicians, etc.) of the product.
        :param str availability: The online availability of the Product. Default to Availability.IN_STOCK. Corresponding properties: Google Merchant Center property [availability](https://support.google.com/merchants/answer/6324448). Schema.org property [Offer.availability](https://schema.org/availability).
        :param int available_quantity: The available quantity of the item.
        :param str available_time: The timestamp when this Product becomes available for SearchService.Search.
        :param Sequence[str] brands: The brands of the product. A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [brand](https://support.google.com/merchants/answer/6324351). Schema.org property [Product.brand](https://schema.org/brand).
        :param Sequence[str] categories: Product categories. This field is repeated for supporting one product belonging to several parallel categories. Strongly recommended using the full path for better search / recommendation quality. To represent full path of category, use '>' sign to separate different hierarchies. If '>' is part of the category name, please replace it with other character(s). For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categories": [ "Shoes & Accessories > Shoes", "Sports & Fitness > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product otherwise an INVALID_ARGUMENT error is returned. At most 250 values are allowed per Product. Empty values are not allowed. Each value must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property google_product_category. Schema.org property [Product.category] (https://schema.org/category). [mc_google_product_category]: https://support.google.com/merchants/answer/6324436
        :param Sequence[str] collection_member_ids: The id of the collection members when type is Type.COLLECTION. Non-existent product ids are allowed. The type of the members must be either Type.PRIMARY or Type.VARIANT otherwise and INVALID_ARGUMENT error is thrown. Should not set it for other types. A maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is return.
        :param 'GoogleCloudRetailV2ColorInfoResponse' color_info: The color of the product. Corresponding properties: Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        :param Sequence[str] conditions: The condition of the product. Strongly encouraged to use the standard values: "new", "refurbished", "used". A maximum of 1 value is allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [condition](https://support.google.com/merchants/answer/6324469). Schema.org property [Offer.itemCondition](https://schema.org/itemCondition).
        :param str description: Product description. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [description](https://support.google.com/merchants/answer/6324468). Schema.org property [Product.description](https://schema.org/description).
        :param str expire_time: The timestamp when this product becomes unavailable for SearchService.Search. If it is set, the Product is not available for SearchService.Search after expire_time. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts. expire_time must be later than available_time and publish_time, otherwise an INVALID_ARGUMENT error is thrown. Corresponding properties: Google Merchant Center property [expiration_date](https://support.google.com/merchants/answer/6324499).
        :param Sequence['GoogleCloudRetailV2FulfillmentInfoResponse'] fulfillment_info: Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods. All the elements must have distinct FulfillmentInfo.type. Otherwise, an INVALID_ARGUMENT error is returned.
        :param str gtin: The Global Trade Item Number (GTIN) of the product. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [gtin](https://support.google.com/merchants/answer/6324461). Schema.org property [Product.isbn](https://schema.org/isbn), [Product.gtin8](https://schema.org/gtin8), [Product.gtin12](https://schema.org/gtin12), [Product.gtin13](https://schema.org/gtin13), or [Product.gtin14](https://schema.org/gtin14). If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
        :param Sequence['GoogleCloudRetailV2ImageResponse'] images: Product images for the product. We highly recommend putting the main image first. A maximum of 300 images are allowed. Corresponding properties: Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        :param str language_code: Language of the title/description and other string attributes. Use language tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). For product prediction, this field is ignored and the model automatically detects the text language. The Product can include text in different languages, but duplicating Products to provide text in multiple languages can result in degraded model performance. For product search this field is in use. It defaults to "en-US" if unset.
        :param Sequence[str] materials: The material of the product. For example, "leather", "wooden". A maximum of 20 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 200 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [material](https://support.google.com/merchants/answer/6324410). Schema.org property [Product.material](https://schema.org/material).
        :param str name: Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
        :param Sequence[str] patterns: The pattern or graphic print of the product. For example, "striped", "polka dot", "paisley". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [pattern](https://support.google.com/merchants/answer/6324483). Schema.org property [Product.pattern](https://schema.org/pattern).
        :param 'GoogleCloudRetailV2PriceInfoResponse' price_info: Product price and cost information. Corresponding properties: Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371).
        :param str primary_product_id: Variant group identifier. Must be an id, with the same parent branch with this product. Otherwise, an error is thrown. For Type.PRIMARY Products, this field can only be empty or set to the same value as id. For VARIANT Products, this field cannot be empty. A maximum of 2,000 products are allowed to share the same Type.PRIMARY Product. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [item_group_id](https://support.google.com/merchants/answer/6324507). Schema.org property [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
        :param Sequence['GoogleCloudRetailV2PromotionResponse'] promotions: The promotions applied to the product. A maximum of 10 values are allowed per Product. Only Promotion.promotion_id will be used, other fields will be ignored if set.
        :param str publish_time: The timestamp when the product is published by the retailer for the first time, which indicates the freshness of the products. Note that this field is different from available_time, given it purely describes product freshness regardless of when it is available on search and recommendation.
        :param 'GoogleCloudRetailV2RatingResponse' rating: The rating of this product.
        :param str retrievable_fields: Indicates which fields in the Products are returned in SearchResponse. Supported fields for all types: * audience * availability * brands * color_info * conditions * gtin * materials * name * patterns * price_info * rating * sizes * title * uri Supported fields only for Type.PRIMARY and Type.COLLECTION: * categories * description * images Supported fields only for Type.VARIANT: * Only the first image in images To mark attributes as retrievable, include paths of the form "attributes.key" where "key" is the key of a custom attribute, as specified in attributes. For Type.PRIMARY and Type.COLLECTION, the following fields are always returned in SearchResponse by default: * name For Type.VARIANT, the following fields are always returned in by default: * name * color_info The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is returned. Note: Returning more fields in SearchResponse can increase response payload size and serving latency.
        :param Sequence[str] sizes: The size of the product. To represent different size systems or size types, consider using this format: [[[size_system:]size_type:]size_value]. For example, in "US:MENS:M", "US" represents size system; "MENS" represents size type; "M" represents size value. In "GIRLS:27", size system is empty; "GIRLS" represents size type; "27" represents size value. In "32 inches", both size system and size type are empty, while size value is "32 inches". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [size](https://support.google.com/merchants/answer/6324492), [size_type](https://support.google.com/merchants/answer/6324497), and [size_system](https://support.google.com/merchants/answer/6324502). Schema.org property [Product.size](https://schema.org/size).
        :param Sequence[str] tags: Custom tags associated with the product. At most 250 values are allowed per Product. This value must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. This tag can be used for filtering recommendation results by passing the tag as part of the PredictRequest.filter. Corresponding properties: Google Merchant Center property [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
        :param str title: Product title. This field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [title](https://support.google.com/merchants/answer/6324415). Schema.org property [Product.name](https://schema.org/name).
        :param str ttl: Input only. The TTL (time to live) of the product. If it is set, it must be a non-negative value, and expire_time is set as current timestamp plus ttl. The derived expire_time is returned in the output and ttl is left blank when retrieving the Product. If it is set, the product is not available for SearchService.Search after current timestamp plus ttl. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts.
        :param str type: Immutable. The type of the product. Default to Catalog.product_level_config.ingestion_product_type if unset.
        :param str uri: Canonical URL directly linking to the product detail page. It is strongly recommended to provide a valid uri for the product, otherwise the service performance could be significantly degraded. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [link](https://support.google.com/merchants/answer/6324416). Schema.org property [Offer.url](https://schema.org/url).
        :param Sequence['GoogleCloudRetailV2ProductResponse'] variants: Product variants grouped together on primary product which share similar product attributes. It's automatically grouped by primary_product_id for all the product variants. Only populated for Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "available_quantity", available_quantity)
        pulumi.set(__self__, "available_time", available_time)
        pulumi.set(__self__, "brands", brands)
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "collection_member_ids", collection_member_ids)
        pulumi.set(__self__, "color_info", color_info)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "fulfillment_info", fulfillment_info)
        pulumi.set(__self__, "gtin", gtin)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "price_info", price_info)
        pulumi.set(__self__, "primary_product_id", primary_product_id)
        pulumi.set(__self__, "promotions", promotions)
        pulumi.set(__self__, "publish_time", publish_time)
        pulumi.set(__self__, "rating", rating)
        pulumi.set(__self__, "retrievable_fields", retrievable_fields)
        pulumi.set(__self__, "sizes", sizes)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter
    def attributes(self) -> Mapping[str, str]:
        """
        Highly encouraged. Extra product attributes to be included. For example, for products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the attributes here. Features that can take on one of a limited number of possible values. Two types of features can be set are: Textual features. some examples would be the brand/maker of a product, or country of a customer. Numerical features. Some examples would be the height/weight of a product, or age of a customer. For example: `{ "vendor": {"text": ["vendor123", "vendor456"]}, "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]} }`. This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT error is returned: * Max entries count: 200. * The key must be a UTF-8 encoded string with a length limit of 128 characters. * For indexable attribute, the key must match the pattern: `a-zA-Z0-9*`. For example, `key0LikeThis` or `KEY_1_LIKE_THIS`. * For text attributes, at most 400 values are allowed. Empty values are not allowed. Each value must be a non-empty UTF-8 encoded string with a length limit of 256 characters. * For number attributes, at most 400 values are allowed.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def audience(self) -> 'outputs.GoogleCloudRetailV2AudienceResponse':
        """
        The target group associated with a given audience (e.g. male, veterans, car owners, musicians, etc.) of the product.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def availability(self) -> str:
        """
        The online availability of the Product. Default to Availability.IN_STOCK. Corresponding properties: Google Merchant Center property [availability](https://support.google.com/merchants/answer/6324448). Schema.org property [Offer.availability](https://schema.org/availability).
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> int:
        """
        The available quantity of the item.
        """
        return pulumi.get(self, "available_quantity")

    @property
    @pulumi.getter(name="availableTime")
    def available_time(self) -> str:
        """
        The timestamp when this Product becomes available for SearchService.Search.
        """
        return pulumi.get(self, "available_time")

    @property
    @pulumi.getter
    def brands(self) -> Sequence[str]:
        """
        The brands of the product. A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [brand](https://support.google.com/merchants/answer/6324351). Schema.org property [Product.brand](https://schema.org/brand).
        """
        return pulumi.get(self, "brands")

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Product categories. This field is repeated for supporting one product belonging to several parallel categories. Strongly recommended using the full path for better search / recommendation quality. To represent full path of category, use '>' sign to separate different hierarchies. If '>' is part of the category name, please replace it with other character(s). For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categories": [ "Shoes & Accessories > Shoes", "Sports & Fitness > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product otherwise an INVALID_ARGUMENT error is returned. At most 250 values are allowed per Product. Empty values are not allowed. Each value must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property google_product_category. Schema.org property [Product.category] (https://schema.org/category). [mc_google_product_category]: https://support.google.com/merchants/answer/6324436
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="collectionMemberIds")
    def collection_member_ids(self) -> Sequence[str]:
        """
        The id of the collection members when type is Type.COLLECTION. Non-existent product ids are allowed. The type of the members must be either Type.PRIMARY or Type.VARIANT otherwise and INVALID_ARGUMENT error is thrown. Should not set it for other types. A maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is return.
        """
        return pulumi.get(self, "collection_member_ids")

    @property
    @pulumi.getter(name="colorInfo")
    def color_info(self) -> 'outputs.GoogleCloudRetailV2ColorInfoResponse':
        """
        The color of the product. Corresponding properties: Google Merchant Center property [color](https://support.google.com/merchants/answer/6324487). Schema.org property [Product.color](https://schema.org/color).
        """
        return pulumi.get(self, "color_info")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence[str]:
        """
        The condition of the product. Strongly encouraged to use the standard values: "new", "refurbished", "used". A maximum of 1 value is allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [condition](https://support.google.com/merchants/answer/6324469). Schema.org property [Offer.itemCondition](https://schema.org/itemCondition).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Product description. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [description](https://support.google.com/merchants/answer/6324468). Schema.org property [Product.description](https://schema.org/description).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The timestamp when this product becomes unavailable for SearchService.Search. If it is set, the Product is not available for SearchService.Search after expire_time. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts. expire_time must be later than available_time and publish_time, otherwise an INVALID_ARGUMENT error is thrown. Corresponding properties: Google Merchant Center property [expiration_date](https://support.google.com/merchants/answer/6324499).
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="fulfillmentInfo")
    def fulfillment_info(self) -> Sequence['outputs.GoogleCloudRetailV2FulfillmentInfoResponse']:
        """
        Fulfillment information, such as the store IDs for in-store pickup or region IDs for different shipping methods. All the elements must have distinct FulfillmentInfo.type. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "fulfillment_info")

    @property
    @pulumi.getter
    def gtin(self) -> str:
        """
        The Global Trade Item Number (GTIN) of the product. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [gtin](https://support.google.com/merchants/answer/6324461). Schema.org property [Product.isbn](https://schema.org/isbn), [Product.gtin8](https://schema.org/gtin8), [Product.gtin12](https://schema.org/gtin12), [Product.gtin13](https://schema.org/gtin13), or [Product.gtin14](https://schema.org/gtin14). If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "gtin")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GoogleCloudRetailV2ImageResponse']:
        """
        Product images for the product. We highly recommend putting the main image first. A maximum of 300 images are allowed. Corresponding properties: Google Merchant Center property [image_link](https://support.google.com/merchants/answer/6324350). Schema.org property [Product.image](https://schema.org/image).
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Language of the title/description and other string attributes. Use language tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). For product prediction, this field is ignored and the model automatically detects the text language. The Product can include text in different languages, but duplicating Products to provide text in multiple languages can result in degraded model performance. For product search this field is in use. It defaults to "en-US" if unset.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def materials(self) -> Sequence[str]:
        """
        The material of the product. For example, "leather", "wooden". A maximum of 20 values are allowed. Each value must be a UTF-8 encoded string with a length limit of 200 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [material](https://support.google.com/merchants/answer/6324410). Schema.org property [Product.material](https://schema.org/material).
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence[str]:
        """
        The pattern or graphic print of the product. For example, "striped", "polka dot", "paisley". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [pattern](https://support.google.com/merchants/answer/6324483). Schema.org property [Product.pattern](https://schema.org/pattern).
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="priceInfo")
    def price_info(self) -> 'outputs.GoogleCloudRetailV2PriceInfoResponse':
        """
        Product price and cost information. Corresponding properties: Google Merchant Center property [price](https://support.google.com/merchants/answer/6324371).
        """
        return pulumi.get(self, "price_info")

    @property
    @pulumi.getter(name="primaryProductId")
    def primary_product_id(self) -> str:
        """
        Variant group identifier. Must be an id, with the same parent branch with this product. Otherwise, an error is thrown. For Type.PRIMARY Products, this field can only be empty or set to the same value as id. For VARIANT Products, this field cannot be empty. A maximum of 2,000 products are allowed to share the same Type.PRIMARY Product. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [item_group_id](https://support.google.com/merchants/answer/6324507). Schema.org property [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
        """
        return pulumi.get(self, "primary_product_id")

    @property
    @pulumi.getter
    def promotions(self) -> Sequence['outputs.GoogleCloudRetailV2PromotionResponse']:
        """
        The promotions applied to the product. A maximum of 10 values are allowed per Product. Only Promotion.promotion_id will be used, other fields will be ignored if set.
        """
        return pulumi.get(self, "promotions")

    @property
    @pulumi.getter(name="publishTime")
    def publish_time(self) -> str:
        """
        The timestamp when the product is published by the retailer for the first time, which indicates the freshness of the products. Note that this field is different from available_time, given it purely describes product freshness regardless of when it is available on search and recommendation.
        """
        return pulumi.get(self, "publish_time")

    @property
    @pulumi.getter
    def rating(self) -> 'outputs.GoogleCloudRetailV2RatingResponse':
        """
        The rating of this product.
        """
        return pulumi.get(self, "rating")

    @property
    @pulumi.getter(name="retrievableFields")
    def retrievable_fields(self) -> str:
        """
        Indicates which fields in the Products are returned in SearchResponse. Supported fields for all types: * audience * availability * brands * color_info * conditions * gtin * materials * name * patterns * price_info * rating * sizes * title * uri Supported fields only for Type.PRIMARY and Type.COLLECTION: * categories * description * images Supported fields only for Type.VARIANT: * Only the first image in images To mark attributes as retrievable, include paths of the form "attributes.key" where "key" is the key of a custom attribute, as specified in attributes. For Type.PRIMARY and Type.COLLECTION, the following fields are always returned in SearchResponse by default: * name For Type.VARIANT, the following fields are always returned in by default: * name * color_info The maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is returned. Note: Returning more fields in SearchResponse can increase response payload size and serving latency.
        """
        return pulumi.get(self, "retrievable_fields")

    @property
    @pulumi.getter
    def sizes(self) -> Sequence[str]:
        """
        The size of the product. To represent different size systems or size types, consider using this format: [[[size_system:]size_type:]size_value]. For example, in "US:MENS:M", "US" represents size system; "MENS" represents size type; "M" represents size value. In "GIRLS:27", size system is empty; "GIRLS" represents size type; "27" represents size value. In "32 inches", both size system and size type are empty, while size value is "32 inches". A maximum of 20 values are allowed per Product. Each value must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [size](https://support.google.com/merchants/answer/6324492), [size_type](https://support.google.com/merchants/answer/6324497), and [size_system](https://support.google.com/merchants/answer/6324502). Schema.org property [Product.size](https://schema.org/size).
        """
        return pulumi.get(self, "sizes")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Custom tags associated with the product. At most 250 values are allowed per Product. This value must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. This tag can be used for filtering recommendation results by passing the tag as part of the PredictRequest.filter. Corresponding properties: Google Merchant Center property [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Product title. This field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [title](https://support.google.com/merchants/answer/6324415). Schema.org property [Product.name](https://schema.org/name).
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Input only. The TTL (time to live) of the product. If it is set, it must be a non-negative value, and expire_time is set as current timestamp plus ttl. The derived expire_time is returned in the output and ttl is left blank when retrieving the Product. If it is set, the product is not available for SearchService.Search after current timestamp plus ttl. However, the product can still be retrieved by ProductService.GetProduct and ProductService.ListProducts.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. The type of the product. Default to Catalog.product_level_config.ingestion_product_type if unset.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Canonical URL directly linking to the product detail page. It is strongly recommended to provide a valid uri for the product, otherwise the service performance could be significantly degraded. This field must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. Corresponding properties: Google Merchant Center property [link](https://support.google.com/merchants/answer/6324416). Schema.org property [Offer.url](https://schema.org/url).
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def variants(self) -> Sequence['outputs.GoogleCloudRetailV2ProductResponse']:
        """
        Product variants grouped together on primary product which share similar product attributes. It's automatically grouped by primary_product_id for all the product variants. Only populated for Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API requests.
        """
        return pulumi.get(self, "variants")


@pulumi.output_type
class GoogleCloudRetailV2PromotionResponse(dict):
    """
    Promotion information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionId":
            suggest = "promotion_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2PromotionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2PromotionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2PromotionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 promotion_id: str):
        """
        Promotion information.
        :param str promotion_id: ID of the promotion. For example, "free gift". The value must be a UTF-8 encoded string with a length limit of 128 characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [promotion](https://support.google.com/merchants/answer/7050148).
        """
        pulumi.set(__self__, "promotion_id", promotion_id)

    @property
    @pulumi.getter(name="promotionId")
    def promotion_id(self) -> str:
        """
        ID of the promotion. For example, "free gift". The value must be a UTF-8 encoded string with a length limit of 128 characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center property [promotion](https://support.google.com/merchants/answer/7050148).
        """
        return pulumi.get(self, "promotion_id")


@pulumi.output_type
class GoogleCloudRetailV2RatingResponse(dict):
    """
    The rating of a Product.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageRating":
            suggest = "average_rating"
        elif key == "ratingCount":
            suggest = "rating_count"
        elif key == "ratingHistogram":
            suggest = "rating_histogram"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRetailV2RatingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRetailV2RatingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRetailV2RatingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_rating: float,
                 rating_count: int,
                 rating_histogram: Sequence[int]):
        """
        The rating of a Product.
        :param float average_rating: The average rating of the Product. The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
        :param int rating_count: The total number of ratings. This value is independent of the value of rating_histogram. This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        :param Sequence[int] rating_histogram: List of rating counts per rating value (index = rating - 1). The list is empty if there is no rating. If the list is non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings with 1 star, 14 ratings with 2 star, and so on.
        """
        pulumi.set(__self__, "average_rating", average_rating)
        pulumi.set(__self__, "rating_count", rating_count)
        pulumi.set(__self__, "rating_histogram", rating_histogram)

    @property
    @pulumi.getter(name="averageRating")
    def average_rating(self) -> float:
        """
        The average rating of the Product. The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "average_rating")

    @property
    @pulumi.getter(name="ratingCount")
    def rating_count(self) -> int:
        """
        The total number of ratings. This value is independent of the value of rating_histogram. This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
        """
        return pulumi.get(self, "rating_count")

    @property
    @pulumi.getter(name="ratingHistogram")
    def rating_histogram(self) -> Sequence[int]:
        """
        List of rating counts per rating value (index = rating - 1). The list is empty if there is no rating. If the list is non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings with 1 star, 14 ratings with 2 star, and so on.
        """
        return pulumi.get(self, "rating_histogram")


