# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AptRepositoryArgs',
    'AptSettingsArgs',
    'AssignmentGroupLabelArgs',
    'AssignmentOsTypeArgs',
    'AssignmentArgs',
    'ExecStepConfigArgs',
    'ExecStepArgs',
    'FixedOrPercentArgs',
    'GcsObjectArgs',
    'GooRepositoryArgs',
    'GooSettingsArgs',
    'MonthlyScheduleArgs',
    'OneTimeScheduleArgs',
    'PackageRepositoryArgs',
    'PackageArgs',
    'PatchConfigArgs',
    'PatchInstanceFilterGroupLabelArgs',
    'PatchInstanceFilterArgs',
    'PatchRolloutArgs',
    'RecurringScheduleArgs',
    'SoftwareRecipeArtifactGcsArgs',
    'SoftwareRecipeArtifactRemoteArgs',
    'SoftwareRecipeArtifactArgs',
    'SoftwareRecipeStepCopyFileArgs',
    'SoftwareRecipeStepExecFileArgs',
    'SoftwareRecipeStepExtractArchiveArgs',
    'SoftwareRecipeStepInstallDpkgArgs',
    'SoftwareRecipeStepInstallMsiArgs',
    'SoftwareRecipeStepInstallRpmArgs',
    'SoftwareRecipeStepRunScriptArgs',
    'SoftwareRecipeStepArgs',
    'SoftwareRecipeArgs',
    'TimeOfDayArgs',
    'TimeZoneArgs',
    'WeekDayOfMonthArgs',
    'WeeklyScheduleArgs',
    'WindowsUpdateSettingsArgs',
    'YumRepositoryArgs',
    'YumSettingsArgs',
    'ZypperRepositoryArgs',
    'ZypperSettingsArgs',
]

@pulumi.input_type
class AptRepositoryArgs:
    def __init__(__self__, *,
                 components: pulumi.Input[Sequence[pulumi.Input[str]]],
                 distribution: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 archive_type: Optional[pulumi.Input['AptRepositoryArchiveType']] = None,
                 gpg_key: Optional[pulumi.Input[str]] = None):
        """
        Represents a single Apt package repository. This repository is added to a repo file that is stored at `/etc/apt/sources.list.d/google_osconfig.list`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] components: List of components for this repository. Must contain at least one item.
        :param pulumi.Input[str] distribution: Distribution of this repository.
        :param pulumi.Input[str] uri: URI for this repository.
        :param pulumi.Input['AptRepositoryArchiveType'] archive_type: Type of archive files in this repository. The default behavior is DEB.
        :param pulumi.Input[str] gpg_key: URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing all the keys in any applied guest policy.
        """
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "uri", uri)
        if archive_type is not None:
            pulumi.set(__self__, "archive_type", archive_type)
        if gpg_key is not None:
            pulumi.set(__self__, "gpg_key", gpg_key)

    @property
    @pulumi.getter
    def components(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter
    def distribution(self) -> pulumi.Input[str]:
        """
        Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI for this repository.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> Optional[pulumi.Input['AptRepositoryArchiveType']]:
        """
        Type of archive files in this repository. The default behavior is DEB.
        """
        return pulumi.get(self, "archive_type")

    @archive_type.setter
    def archive_type(self, value: Optional[pulumi.Input['AptRepositoryArchiveType']]):
        pulumi.set(self, "archive_type", value)

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing all the keys in any applied guest policy.
        """
        return pulumi.get(self, "gpg_key")

    @gpg_key.setter
    def gpg_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpg_key", value)


@pulumi.input_type
class AptSettingsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input['AptSettingsType']] = None):
        """
        Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of packages to exclude from update. These packages will be excluded
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        :param pulumi.Input['AptSettingsType'] type: By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages to exclude from update. These packages will be excluded
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @exclusive_packages.setter
    def exclusive_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_packages", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AptSettingsType']]:
        """
        By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AptSettingsType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AssignmentGroupLabelArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Represents a group of VM intances that can be identified as having all these labels, for example "env=prod and app=web".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class AssignmentOsTypeArgs:
    def __init__(__self__, *,
                 os_architecture: Optional[pulumi.Input[str]] = None,
                 os_short_name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None):
        """
        Defines the criteria for selecting VM Instances by OS type.
        :param pulumi.Input[str] os_architecture: Targets VM instances with OS Inventory enabled and having the following OS architecture.
        :param pulumi.Input[str] os_short_name: Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        :param pulumi.Input[str] os_version: Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        if os_architecture is not None:
            pulumi.set(__self__, "os_architecture", os_architecture)
        if os_short_name is not None:
            pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Targets VM instances with OS Inventory enabled and having the following OS architecture.
        """
        return pulumi.get(self, "os_architecture")

    @os_architecture.setter
    def os_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_architecture", value)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> Optional[pulumi.Input[str]]:
        """
        Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        """
        return pulumi.get(self, "os_short_name")

    @os_short_name.setter
    def os_short_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_short_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class AssignmentArgs:
    def __init__(__self__, *,
                 group_labels: Optional[pulumi.Input[Sequence[pulumi.Input['AssignmentGroupLabelArgs']]]] = None,
                 instance_name_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_types: Optional[pulumi.Input[Sequence[pulumi.Input['AssignmentOsTypeArgs']]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An assignment represents the group or groups of VM instances that the policy applies to. If an assignment is empty, it applies to all VM instances. Otherwise, the targeted VM instances must meet all the criteria specified. So if both labels and zones are specified, the policy applies to VM instances with those labels and in those zones.
        :param pulumi.Input[Sequence[pulumi.Input['AssignmentGroupLabelArgs']]] group_labels: Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups, for example "env=prod or env=staging".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_name_prefixes: Targets VM instances whose name starts with one of these prefixes. Like labels, this is another way to group VM instances when targeting configs, for example prefix="prod-". Only supported for project-level policies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Targets any of the instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`. Instance targeting is uncommon and is supported to facilitate the management of changes by the instance or to target specific VM instances for development and testing. Only supported for project-level policies and must reference instances within this project.
        :param pulumi.Input[Sequence[pulumi.Input['AssignmentOsTypeArgs']]] os_types: Targets VM instances matching at least one of the following OS types. VM instances must match all supplied criteria for a given OsType to be included.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Targets instances in any of these zones. Leave empty to target instances in any zone. Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if os_types is not None:
            pulumi.set(__self__, "os_types", os_types)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssignmentGroupLabelArgs']]]]:
        """
        Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups, for example "env=prod or env=staging".
        """
        return pulumi.get(self, "group_labels")

    @group_labels.setter
    def group_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssignmentGroupLabelArgs']]]]):
        pulumi.set(self, "group_labels", value)

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VM instances whose name starts with one of these prefixes. Like labels, this is another way to group VM instances when targeting configs, for example prefix="prod-". Only supported for project-level policies.
        """
        return pulumi.get(self, "instance_name_prefixes")

    @instance_name_prefixes.setter
    def instance_name_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_name_prefixes", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets any of the instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`. Instance targeting is uncommon and is supported to facilitate the management of changes by the instance or to target specific VM instances for development and testing. Only supported for project-level policies and must reference instances within this project.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="osTypes")
    def os_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssignmentOsTypeArgs']]]]:
        """
        Targets VM instances matching at least one of the following OS types. VM instances must match all supplied criteria for a given OsType to be included.
        """
        return pulumi.get(self, "os_types")

    @os_types.setter
    def os_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssignmentOsTypeArgs']]]]):
        pulumi.set(self, "os_types", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets instances in any of these zones. Leave empty to target instances in any zone. Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class ExecStepConfigArgs:
    def __init__(__self__, *,
                 allowed_success_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 gcs_object: Optional[pulumi.Input['GcsObjectArgs']] = None,
                 interpreter: Optional[pulumi.Input['ExecStepConfigInterpreter']] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        Common configurations for an ExecStep.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param pulumi.Input['GcsObjectArgs'] gcs_object: A Google Cloud Storage object containing the executable.
        :param pulumi.Input['ExecStepConfigInterpreter'] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        :param pulumi.Input[str] local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @allowed_success_codes.setter
    def allowed_success_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_success_codes", value)

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional[pulumi.Input['GcsObjectArgs']]:
        """
        A Google Cloud Storage object containing the executable.
        """
        return pulumi.get(self, "gcs_object")

    @gcs_object.setter
    def gcs_object(self, value: Optional[pulumi.Input['GcsObjectArgs']]):
        pulumi.set(self, "gcs_object", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input['ExecStepConfigInterpreter']]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input['ExecStepConfigInterpreter']]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class ExecStepArgs:
    def __init__(__self__, *,
                 linux_exec_step_config: Optional[pulumi.Input['ExecStepConfigArgs']] = None,
                 windows_exec_step_config: Optional[pulumi.Input['ExecStepConfigArgs']] = None):
        """
        A step that runs an executable for a PatchJob.
        :param pulumi.Input['ExecStepConfigArgs'] linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        :param pulumi.Input['ExecStepConfigArgs'] windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        if linux_exec_step_config is not None:
            pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        if windows_exec_step_config is not None:
            pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> Optional[pulumi.Input['ExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @linux_exec_step_config.setter
    def linux_exec_step_config(self, value: Optional[pulumi.Input['ExecStepConfigArgs']]):
        pulumi.set(self, "linux_exec_step_config", value)

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> Optional[pulumi.Input['ExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "windows_exec_step_config")

    @windows_exec_step_config.setter
    def windows_exec_step_config(self, value: Optional[pulumi.Input['ExecStepConfigArgs']]):
        pulumi.set(self, "windows_exec_step_config", value)


@pulumi.input_type
class FixedOrPercentArgs:
    def __init__(__self__, *,
                 fixed: Optional[pulumi.Input[int]] = None,
                 percent: Optional[pulumi.Input[int]] = None):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param pulumi.Input[int] fixed: Specifies a fixed value.
        :param pulumi.Input[int] percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @fixed.setter
    def fixed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed", value)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)


@pulumi.input_type
class GcsObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 generation_number: pulumi.Input[str],
                 object: pulumi.Input[str]):
        """
        Google Cloud Storage object representation.
        :param pulumi.Input[str] bucket: Bucket of the Google Cloud Storage object.
        :param pulumi.Input[str] generation_number: Generation number of the Google Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param pulumi.Input[str] object: Name of the Google Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket of the Google Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> pulumi.Input[str]:
        """
        Generation number of the Google Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @generation_number.setter
    def generation_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_number", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the Google Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class GooRepositoryArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        Represents a Goo package repository. These is added to a repo file that is stored at C:/ProgramData/GooGet/repos/google_osconfig.repo.
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[str] url: The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The url of the repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class GooSettingsArgs:
    def __init__(__self__):
        """
        Googet patching is performed by running `googet update`.
        """
        pass


@pulumi.input_type
class MonthlyScheduleArgs:
    def __init__(__self__, *,
                 month_day: pulumi.Input[int],
                 week_day_of_month: pulumi.Input['WeekDayOfMonthArgs']):
        """
        Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
        :param pulumi.Input[int] month_day: One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        :param pulumi.Input['WeekDayOfMonthArgs'] week_day_of_month: Week day in a month.
        """
        pulumi.set(__self__, "month_day", month_day)
        pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> pulumi.Input[int]:
        """
        One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @month_day.setter
    def month_day(self, value: pulumi.Input[int]):
        pulumi.set(self, "month_day", value)

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> pulumi.Input['WeekDayOfMonthArgs']:
        """
        Week day in a month.
        """
        return pulumi.get(self, "week_day_of_month")

    @week_day_of_month.setter
    def week_day_of_month(self, value: pulumi.Input['WeekDayOfMonthArgs']):
        pulumi.set(self, "week_day_of_month", value)


@pulumi.input_type
class OneTimeScheduleArgs:
    def __init__(__self__, *,
                 execute_time: pulumi.Input[str]):
        """
        Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param pulumi.Input[str] execute_time: The desired patch job execution time.
        """
        pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> pulumi.Input[str]:
        """
        The desired patch job execution time.
        """
        return pulumi.get(self, "execute_time")

    @execute_time.setter
    def execute_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "execute_time", value)


@pulumi.input_type
class PackageRepositoryArgs:
    def __init__(__self__, *,
                 apt: Optional[pulumi.Input['AptRepositoryArgs']] = None,
                 goo: Optional[pulumi.Input['GooRepositoryArgs']] = None,
                 yum: Optional[pulumi.Input['YumRepositoryArgs']] = None,
                 zypper: Optional[pulumi.Input['ZypperRepositoryArgs']] = None):
        """
        A package repository.
        :param pulumi.Input['AptRepositoryArgs'] apt: An Apt Repository.
        :param pulumi.Input['GooRepositoryArgs'] goo: A Goo Repository.
        :param pulumi.Input['YumRepositoryArgs'] yum: A Yum Repository.
        :param pulumi.Input['ZypperRepositoryArgs'] zypper: A Zypper Repository.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['AptRepositoryArgs']]:
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['AptRepositoryArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def goo(self) -> Optional[pulumi.Input['GooRepositoryArgs']]:
        """
        A Goo Repository.
        """
        return pulumi.get(self, "goo")

    @goo.setter
    def goo(self, value: Optional[pulumi.Input['GooRepositoryArgs']]):
        pulumi.set(self, "goo", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['YumRepositoryArgs']]:
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['YumRepositoryArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['ZypperRepositoryArgs']]:
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['ZypperRepositoryArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class PackageArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 desired_state: Optional[pulumi.Input['PackageDesiredState']] = None,
                 manager: Optional[pulumi.Input['PackageManager']] = None):
        """
        Package is a reference to the software package to be installed or removed. The agent on the VM instance uses the system package manager to apply the config. These are the commands that the agent uses to install or remove packages. Apt install: `apt-get update && apt-get -y install package1 package2 package3` remove: `apt-get -y remove package1 package2 package3` Yum install: `yum -y install package1 package2 package3` remove: `yum -y remove package1 package2 package3` Zypper install: `zypper install package1 package2 package3` remove: `zypper rm package1 package2` Googet install: `googet -noconfirm install package1 package2 package3` remove: `googet -noconfirm remove package1 package2 package3`
        :param pulumi.Input[str] name: The name of the package. A package is uniquely identified for conflict validation by checking the package name and the manager(s) that the package targets.
        :param pulumi.Input['PackageDesiredState'] desired_state: The desired_state the agent should maintain for this package. The default is to ensure the package is installed.
        :param pulumi.Input['PackageManager'] manager: Type of package manager that can be used to install this package. If a system does not have the package manager, the package is not installed or removed no error message is returned. By default, or if you specify `ANY`, the agent attempts to install and remove this package using the default package manager. This is useful when creating a policy that applies to different types of systems. The default behavior is ANY.
        """
        pulumi.set(__self__, "name", name)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the package. A package is uniquely identified for conflict validation by checking the package name and the manager(s) that the package targets.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input['PackageDesiredState']]:
        """
        The desired_state the agent should maintain for this package. The default is to ensure the package is installed.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input['PackageDesiredState']]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def manager(self) -> Optional[pulumi.Input['PackageManager']]:
        """
        Type of package manager that can be used to install this package. If a system does not have the package manager, the package is not installed or removed no error message is returned. By default, or if you specify `ANY`, the agent attempts to install and remove this package using the default package manager. This is useful when creating a policy that applies to different types of systems. The default behavior is ANY.
        """
        return pulumi.get(self, "manager")

    @manager.setter
    def manager(self, value: Optional[pulumi.Input['PackageManager']]):
        pulumi.set(self, "manager", value)


@pulumi.input_type
class PatchConfigArgs:
    def __init__(__self__, *,
                 apt: Optional[pulumi.Input['AptSettingsArgs']] = None,
                 goo: Optional[pulumi.Input['GooSettingsArgs']] = None,
                 mig_instances_allowed: Optional[pulumi.Input[bool]] = None,
                 post_step: Optional[pulumi.Input['ExecStepArgs']] = None,
                 pre_step: Optional[pulumi.Input['ExecStepArgs']] = None,
                 reboot_config: Optional[pulumi.Input['PatchConfigRebootConfig']] = None,
                 windows_update: Optional[pulumi.Input['WindowsUpdateSettingsArgs']] = None,
                 yum: Optional[pulumi.Input['YumSettingsArgs']] = None,
                 zypper: Optional[pulumi.Input['ZypperSettingsArgs']] = None):
        """
        Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
        :param pulumi.Input['AptSettingsArgs'] apt: Apt update settings. Use this setting to override the default `apt` patch rules.
        :param pulumi.Input['GooSettingsArgs'] goo: Goo update settings. Use this setting to override the default `goo` patch rules.
        :param pulumi.Input[bool] mig_instances_allowed: Allows the patch job to run on Managed instance groups (MIGs).
        :param pulumi.Input['ExecStepArgs'] post_step: The `ExecStep` to run after the patch update.
        :param pulumi.Input['ExecStepArgs'] pre_step: The `ExecStep` to run before the patch update.
        :param pulumi.Input['PatchConfigRebootConfig'] reboot_config: Post-patch reboot settings.
        :param pulumi.Input['WindowsUpdateSettingsArgs'] windows_update: Windows update settings. Use this override the default windows patch rules.
        :param pulumi.Input['YumSettingsArgs'] yum: Yum update settings. Use this setting to override the default `yum` patch rules.
        :param pulumi.Input['ZypperSettingsArgs'] zypper: Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if mig_instances_allowed is not None:
            pulumi.set(__self__, "mig_instances_allowed", mig_instances_allowed)
        if post_step is not None:
            pulumi.set(__self__, "post_step", post_step)
        if pre_step is not None:
            pulumi.set(__self__, "pre_step", pre_step)
        if reboot_config is not None:
            pulumi.set(__self__, "reboot_config", reboot_config)
        if windows_update is not None:
            pulumi.set(__self__, "windows_update", windows_update)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['AptSettingsArgs']]:
        """
        Apt update settings. Use this setting to override the default `apt` patch rules.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['AptSettingsArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def goo(self) -> Optional[pulumi.Input['GooSettingsArgs']]:
        """
        Goo update settings. Use this setting to override the default `goo` patch rules.
        """
        return pulumi.get(self, "goo")

    @goo.setter
    def goo(self, value: Optional[pulumi.Input['GooSettingsArgs']]):
        pulumi.set(self, "goo", value)

    @property
    @pulumi.getter(name="migInstancesAllowed")
    def mig_instances_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows the patch job to run on Managed instance groups (MIGs).
        """
        return pulumi.get(self, "mig_instances_allowed")

    @mig_instances_allowed.setter
    def mig_instances_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mig_instances_allowed", value)

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> Optional[pulumi.Input['ExecStepArgs']]:
        """
        The `ExecStep` to run after the patch update.
        """
        return pulumi.get(self, "post_step")

    @post_step.setter
    def post_step(self, value: Optional[pulumi.Input['ExecStepArgs']]):
        pulumi.set(self, "post_step", value)

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> Optional[pulumi.Input['ExecStepArgs']]:
        """
        The `ExecStep` to run before the patch update.
        """
        return pulumi.get(self, "pre_step")

    @pre_step.setter
    def pre_step(self, value: Optional[pulumi.Input['ExecStepArgs']]):
        pulumi.set(self, "pre_step", value)

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> Optional[pulumi.Input['PatchConfigRebootConfig']]:
        """
        Post-patch reboot settings.
        """
        return pulumi.get(self, "reboot_config")

    @reboot_config.setter
    def reboot_config(self, value: Optional[pulumi.Input['PatchConfigRebootConfig']]):
        pulumi.set(self, "reboot_config", value)

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> Optional[pulumi.Input['WindowsUpdateSettingsArgs']]:
        """
        Windows update settings. Use this override the default windows patch rules.
        """
        return pulumi.get(self, "windows_update")

    @windows_update.setter
    def windows_update(self, value: Optional[pulumi.Input['WindowsUpdateSettingsArgs']]):
        pulumi.set(self, "windows_update", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['YumSettingsArgs']]:
        """
        Yum update settings. Use this setting to override the default `yum` patch rules.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['YumSettingsArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['ZypperSettingsArgs']]:
        """
        Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['ZypperSettingsArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class PatchInstanceFilterGroupLabelArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Represents a group of VMs that can be identified as having all these labels, for example "env=prod and app=web".
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class PatchInstanceFilterArgs:
    def __init__(__self__, *,
                 all: Optional[pulumi.Input[bool]] = None,
                 group_labels: Optional[pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]]] = None,
                 instance_name_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
        :param pulumi.Input[bool] all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]] group_labels: Targets VM instances matching at least one of these label sets. This allows targeting of disparate groups, for example "env=prod or env=staging".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> Optional[pulumi.Input[bool]]:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]]]:
        """
        Targets VM instances matching at least one of these label sets. This allows targeting of disparate groups, for example "env=prod or env=staging".
        """
        return pulumi.get(self, "group_labels")

    @group_labels.setter
    def group_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]]]):
        pulumi.set(self, "group_labels", value)

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @instance_name_prefixes.setter
    def instance_name_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_name_prefixes", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class PatchRolloutArgs:
    def __init__(__self__, *,
                 disruption_budget: Optional[pulumi.Input['FixedOrPercentArgs']] = None,
                 mode: Optional[pulumi.Input['PatchRolloutMode']] = None):
        """
        Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
        :param pulumi.Input['FixedOrPercentArgs'] disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        :param pulumi.Input['PatchRolloutMode'] mode: Mode of the patch rollout.
        """
        if disruption_budget is not None:
            pulumi.set(__self__, "disruption_budget", disruption_budget)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        """
        return pulumi.get(self, "disruption_budget")

    @disruption_budget.setter
    def disruption_budget(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "disruption_budget", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['PatchRolloutMode']]:
        """
        Mode of the patch rollout.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['PatchRolloutMode']]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class RecurringScheduleArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input['RecurringScheduleFrequency'],
                 monthly: pulumi.Input['MonthlyScheduleArgs'],
                 time_of_day: pulumi.Input['TimeOfDayArgs'],
                 time_zone: pulumi.Input['TimeZoneArgs'],
                 weekly: pulumi.Input['WeeklyScheduleArgs'],
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Sets the time for recurring patch deployments.
        :param pulumi.Input['RecurringScheduleFrequency'] frequency: The frequency unit of this recurring schedule.
        :param pulumi.Input['MonthlyScheduleArgs'] monthly: Schedule with monthly executions.
        :param pulumi.Input['TimeOfDayArgs'] time_of_day: Time of the day to run a recurring deployment.
        :param pulumi.Input['TimeZoneArgs'] time_zone: Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        :param pulumi.Input['WeeklyScheduleArgs'] weekly: Schedule with weekly executions.
        :param pulumi.Input[str] end_time: Optional. The end time at which a recurring patch deployment schedule is no longer active.
        :param pulumi.Input[str] start_time: Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "monthly", monthly)
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "weekly", weekly)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input['RecurringScheduleFrequency']:
        """
        The frequency unit of this recurring schedule.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input['RecurringScheduleFrequency']):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def monthly(self) -> pulumi.Input['MonthlyScheduleArgs']:
        """
        Schedule with monthly executions.
        """
        return pulumi.get(self, "monthly")

    @monthly.setter
    def monthly(self, value: pulumi.Input['MonthlyScheduleArgs']):
        pulumi.set(self, "monthly", value)

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> pulumi.Input['TimeOfDayArgs']:
        """
        Time of the day to run a recurring deployment.
        """
        return pulumi.get(self, "time_of_day")

    @time_of_day.setter
    def time_of_day(self, value: pulumi.Input['TimeOfDayArgs']):
        pulumi.set(self, "time_of_day", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input['TimeZoneArgs']:
        """
        Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input['TimeZoneArgs']):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def weekly(self) -> pulumi.Input['WeeklyScheduleArgs']:
        """
        Schedule with weekly executions.
        """
        return pulumi.get(self, "weekly")

    @weekly.setter
    def weekly(self, value: pulumi.Input['WeeklyScheduleArgs']):
        pulumi.set(self, "weekly", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The end time at which a recurring patch deployment schedule is no longer active.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class SoftwareRecipeArtifactGcsArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        Specifies an artifact available as a Google Cloud Storage object.
        :param pulumi.Input[str] bucket: Bucket of the Google Cloud Storage object. Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `my-bucket`.
        :param pulumi.Input[str] generation: Must be provided if allow_insecure is false. Generation number of the Google Cloud Storage object. `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `1234567`.
        :param pulumi.Input[str] object: Name of the Google Cloud Storage object. As specified [here] (https://cloud.google.com/storage/docs/naming#objectnames) Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `foo/bar`.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket of the Google Cloud Storage object. Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `my-bucket`.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Must be provided if allow_insecure is false. Generation number of the Google Cloud Storage object. `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `1234567`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Google Cloud Storage object. As specified [here] (https://cloud.google.com/storage/docs/naming#objectnames) Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `foo/bar`.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class SoftwareRecipeArtifactRemoteArgs:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Specifies an artifact available via some URI.
        :param pulumi.Input[str] checksum: Must be provided if `allow_insecure` is `false`. SHA256 checksum in hex format, to compare to the checksum of the artifact. If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any of the steps.
        :param pulumi.Input[str] uri: URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        """
        Must be provided if `allow_insecure` is `false`. SHA256 checksum in hex format, to compare to the checksum of the artifact. If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any of the steps.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class SoftwareRecipeArtifactArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 gcs: Optional[pulumi.Input['SoftwareRecipeArtifactGcsArgs']] = None,
                 remote: Optional[pulumi.Input['SoftwareRecipeArtifactRemoteArgs']] = None):
        """
        Specifies a resource to be used in the recipe.
        :param pulumi.Input[str] id: Id of the artifact, which the installation and update steps of this recipe can reference. Artifacts in a recipe cannot have the same id.
        :param pulumi.Input[bool] allow_insecure: Defaults to false. When false, recipes are subject to validations based on the artifact type: Remote: A checksum must be specified, and only protocols with transport-layer security are permitted. GCS: An object generation number must be specified.
        :param pulumi.Input['SoftwareRecipeArtifactGcsArgs'] gcs: A Google Cloud Storage artifact.
        :param pulumi.Input['SoftwareRecipeArtifactRemoteArgs'] remote: A generic remote artifact.
        """
        pulumi.set(__self__, "id", id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference. Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false. When false, recipes are subject to validations based on the artifact type: Remote: A checksum must be specified, and only protocols with transport-layer security are permitted. GCS: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter
    def gcs(self) -> Optional[pulumi.Input['SoftwareRecipeArtifactGcsArgs']]:
        """
        A Google Cloud Storage artifact.
        """
        return pulumi.get(self, "gcs")

    @gcs.setter
    def gcs(self, value: Optional[pulumi.Input['SoftwareRecipeArtifactGcsArgs']]):
        pulumi.set(self, "gcs", value)

    @property
    @pulumi.getter
    def remote(self) -> Optional[pulumi.Input['SoftwareRecipeArtifactRemoteArgs']]:
        """
        A generic remote artifact.
        """
        return pulumi.get(self, "remote")

    @remote.setter
    def remote(self, value: Optional[pulumi.Input['SoftwareRecipeArtifactRemoteArgs']]):
        pulumi.set(self, "remote", value)


@pulumi.input_type
class SoftwareRecipeStepCopyFileArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input[str]] = None):
        """
        Copies the artifact to the specified path on the instance.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] destination: The absolute path on the instance to put the file.
        :param pulumi.Input[bool] overwrite: Whether to allow this step to overwrite existing files. If this is false and the file already exists the file is not overwritten and the step is considered a success. Defaults to false.
        :param pulumi.Input[str] permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        The absolute path on the instance to put the file.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow this step to overwrite existing files. If this is false and the file already exists the file is not overwritten and the step is considered a success. Defaults to false.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class SoftwareRecipeStepExecFileArgs:
    def __init__(__self__, *,
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        Executes an artifact or local file.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Defaults to [0]. A list of possible return values that the program can return to indicate a success.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to be passed to the provided executable.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] local_path: The absolute path of the file on the local filesystem.
        """
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the program can return to indicate a success.
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to be passed to the provided executable.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path of the file on the local filesystem.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class SoftwareRecipeStepExtractArchiveArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 type: pulumi.Input['SoftwareRecipeStepExtractArchiveType'],
                 destination: Optional[pulumi.Input[str]] = None):
        """
        Extracts an archive of the type specified in the specified directory.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input['SoftwareRecipeStepExtractArchiveType'] type: The type of the archive to extract.
        :param pulumi.Input[str] destination: Directory to extract archive to. Defaults to `/` on Linux or `C:\` on Windows.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "type", type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['SoftwareRecipeStepExtractArchiveType']:
        """
        The type of the archive to extract.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['SoftwareRecipeStepExtractArchiveType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Directory to extract archive to. Defaults to `/` on Linux or `C:\` on Windows.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)


@pulumi.input_type
class SoftwareRecipeStepInstallDpkgArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str]):
        """
        Installs a deb via dpkg.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)


@pulumi.input_type
class SoftwareRecipeStepInstallMsiArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 flags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Installs an MSI file.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] flags: The flags to use when installing the MSI defaults to ["/i"] (i.e. the install flag).
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The flags to use when installing the MSI defaults to ["/i"] (i.e. the install flag).
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "flags", value)


@pulumi.input_type
class SoftwareRecipeStepInstallRpmArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str]):
        """
        Installs an rpm file via the rpm utility.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)


@pulumi.input_type
class SoftwareRecipeStepRunScriptArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[str],
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 interpreter: Optional[pulumi.Input['SoftwareRecipeStepRunScriptInterpreter']] = None):
        """
        Runs a script through an interpreter.
        :param pulumi.Input[str] script: The shell script to be executed.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input['SoftwareRecipeStepRunScriptInterpreter'] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script is executed directly, which likely only succeed for scripts with [shebang lines](https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        pulumi.set(__self__, "script", script)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[str]:
        """
        The shell script to be executed.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input['SoftwareRecipeStepRunScriptInterpreter']]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script is executed directly, which likely only succeed for scripts with [shebang lines](https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input['SoftwareRecipeStepRunScriptInterpreter']]):
        pulumi.set(self, "interpreter", value)


@pulumi.input_type
class SoftwareRecipeStepArgs:
    def __init__(__self__, *,
                 archive_extraction: Optional[pulumi.Input['SoftwareRecipeStepExtractArchiveArgs']] = None,
                 dpkg_installation: Optional[pulumi.Input['SoftwareRecipeStepInstallDpkgArgs']] = None,
                 file_copy: Optional[pulumi.Input['SoftwareRecipeStepCopyFileArgs']] = None,
                 file_exec: Optional[pulumi.Input['SoftwareRecipeStepExecFileArgs']] = None,
                 msi_installation: Optional[pulumi.Input['SoftwareRecipeStepInstallMsiArgs']] = None,
                 rpm_installation: Optional[pulumi.Input['SoftwareRecipeStepInstallRpmArgs']] = None,
                 script_run: Optional[pulumi.Input['SoftwareRecipeStepRunScriptArgs']] = None):
        """
        An action that can be taken as part of installing or updating a recipe.
        :param pulumi.Input['SoftwareRecipeStepExtractArchiveArgs'] archive_extraction: Extracts an archive into the specified directory.
        :param pulumi.Input['SoftwareRecipeStepInstallDpkgArgs'] dpkg_installation: Installs a deb file via dpkg.
        :param pulumi.Input['SoftwareRecipeStepCopyFileArgs'] file_copy: Copies a file onto the instance.
        :param pulumi.Input['SoftwareRecipeStepExecFileArgs'] file_exec: Executes an artifact or local file.
        :param pulumi.Input['SoftwareRecipeStepInstallMsiArgs'] msi_installation: Installs an MSI file.
        :param pulumi.Input['SoftwareRecipeStepInstallRpmArgs'] rpm_installation: Installs an rpm file via the rpm utility.
        :param pulumi.Input['SoftwareRecipeStepRunScriptArgs'] script_run: Runs commands in a shell.
        """
        if archive_extraction is not None:
            pulumi.set(__self__, "archive_extraction", archive_extraction)
        if dpkg_installation is not None:
            pulumi.set(__self__, "dpkg_installation", dpkg_installation)
        if file_copy is not None:
            pulumi.set(__self__, "file_copy", file_copy)
        if file_exec is not None:
            pulumi.set(__self__, "file_exec", file_exec)
        if msi_installation is not None:
            pulumi.set(__self__, "msi_installation", msi_installation)
        if rpm_installation is not None:
            pulumi.set(__self__, "rpm_installation", rpm_installation)
        if script_run is not None:
            pulumi.set(__self__, "script_run", script_run)

    @property
    @pulumi.getter(name="archiveExtraction")
    def archive_extraction(self) -> Optional[pulumi.Input['SoftwareRecipeStepExtractArchiveArgs']]:
        """
        Extracts an archive into the specified directory.
        """
        return pulumi.get(self, "archive_extraction")

    @archive_extraction.setter
    def archive_extraction(self, value: Optional[pulumi.Input['SoftwareRecipeStepExtractArchiveArgs']]):
        pulumi.set(self, "archive_extraction", value)

    @property
    @pulumi.getter(name="dpkgInstallation")
    def dpkg_installation(self) -> Optional[pulumi.Input['SoftwareRecipeStepInstallDpkgArgs']]:
        """
        Installs a deb file via dpkg.
        """
        return pulumi.get(self, "dpkg_installation")

    @dpkg_installation.setter
    def dpkg_installation(self, value: Optional[pulumi.Input['SoftwareRecipeStepInstallDpkgArgs']]):
        pulumi.set(self, "dpkg_installation", value)

    @property
    @pulumi.getter(name="fileCopy")
    def file_copy(self) -> Optional[pulumi.Input['SoftwareRecipeStepCopyFileArgs']]:
        """
        Copies a file onto the instance.
        """
        return pulumi.get(self, "file_copy")

    @file_copy.setter
    def file_copy(self, value: Optional[pulumi.Input['SoftwareRecipeStepCopyFileArgs']]):
        pulumi.set(self, "file_copy", value)

    @property
    @pulumi.getter(name="fileExec")
    def file_exec(self) -> Optional[pulumi.Input['SoftwareRecipeStepExecFileArgs']]:
        """
        Executes an artifact or local file.
        """
        return pulumi.get(self, "file_exec")

    @file_exec.setter
    def file_exec(self, value: Optional[pulumi.Input['SoftwareRecipeStepExecFileArgs']]):
        pulumi.set(self, "file_exec", value)

    @property
    @pulumi.getter(name="msiInstallation")
    def msi_installation(self) -> Optional[pulumi.Input['SoftwareRecipeStepInstallMsiArgs']]:
        """
        Installs an MSI file.
        """
        return pulumi.get(self, "msi_installation")

    @msi_installation.setter
    def msi_installation(self, value: Optional[pulumi.Input['SoftwareRecipeStepInstallMsiArgs']]):
        pulumi.set(self, "msi_installation", value)

    @property
    @pulumi.getter(name="rpmInstallation")
    def rpm_installation(self) -> Optional[pulumi.Input['SoftwareRecipeStepInstallRpmArgs']]:
        """
        Installs an rpm file via the rpm utility.
        """
        return pulumi.get(self, "rpm_installation")

    @rpm_installation.setter
    def rpm_installation(self, value: Optional[pulumi.Input['SoftwareRecipeStepInstallRpmArgs']]):
        pulumi.set(self, "rpm_installation", value)

    @property
    @pulumi.getter(name="scriptRun")
    def script_run(self) -> Optional[pulumi.Input['SoftwareRecipeStepRunScriptArgs']]:
        """
        Runs commands in a shell.
        """
        return pulumi.get(self, "script_run")

    @script_run.setter
    def script_run(self, value: Optional[pulumi.Input['SoftwareRecipeStepRunScriptArgs']]):
        pulumi.set(self, "script_run", value)


@pulumi.input_type
class SoftwareRecipeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeArtifactArgs']]]] = None,
                 desired_state: Optional[pulumi.Input['SoftwareRecipeDesiredState']] = None,
                 install_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]]] = None,
                 update_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        A software recipe is a set of instructions for installing and configuring a piece of software. It consists of a set of artifacts that are downloaded, and a set of steps that install, configure, and/or update the software. Recipes support installing and updating software from artifacts in the following formats: Zip archive, Tar archive, Windows MSI, Debian package, and RPM package. Additionally, recipes support executing a script (either defined in a file or directly in this api) in bash, sh, cmd, and powershell. Updating a software recipe If a recipe is assigned to an instance and there is a recipe with the same name but a lower version already installed and the assigned state of the recipe is `UPDATED`, then the recipe is updated to the new version. Script Working Directories Each script or execution step is run in its own temporary directory which is deleted after completing the step.
        :param pulumi.Input[str] name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance. Names are also used to identify resources which helps to determine whether guest policies have conflicts. This means that requests to create multiple recipes with the same name and version are rejected since they could potentially have conflicting assignments.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeArtifactArgs']]] artifacts: Resources available to be used in the steps in the recipe.
        :param pulumi.Input['SoftwareRecipeDesiredState'] desired_state: Default is INSTALLED. The desired state the agent should maintain for this recipe. INSTALLED: The software recipe is installed on the instance but won't be updated to new versions. UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version, if a higher version of the recipe is assigned to this instance. REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]] install_steps: Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation. Any steps taken (including partially completed steps) are not rolled back.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]] update_steps: Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe. Any steps taken (including partially completed steps) are not rolled back.
        :param pulumi.Input[str] version: The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        pulumi.set(__self__, "name", name)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if install_steps is not None:
            pulumi.set(__self__, "install_steps", install_steps)
        if update_steps is not None:
            pulumi.set(__self__, "update_steps", update_steps)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance. Names are also used to identify resources which helps to determine whether guest policies have conflicts. This means that requests to create multiple recipes with the same name and version are rejected since they could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeArtifactArgs']]]]:
        """
        Resources available to be used in the steps in the recipe.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeArtifactArgs']]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input['SoftwareRecipeDesiredState']]:
        """
        Default is INSTALLED. The desired state the agent should maintain for this recipe. INSTALLED: The software recipe is installed on the instance but won't be updated to new versions. UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version, if a higher version of the recipe is assigned to this instance. REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input['SoftwareRecipeDesiredState']]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="installSteps")
    def install_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]]]:
        """
        Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation. Any steps taken (including partially completed steps) are not rolled back.
        """
        return pulumi.get(self, "install_steps")

    @install_steps.setter
    def install_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]]]):
        pulumi.set(self, "install_steps", value)

    @property
    @pulumi.getter(name="updateSteps")
    def update_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]]]:
        """
        Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe. Any steps taken (including partially completed steps) are not rolled back.
        """
        return pulumi.get(self, "update_steps")

    @update_steps.setter
    def update_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareRecipeStepArgs']]]]):
        pulumi.set(self, "update_steps", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class TimeOfDayArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class TimeZoneArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
        :param pulumi.Input[str] id: IANA Time Zone Database time zone, e.g. "America/New_York".
        :param pulumi.Input[str] version: Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        IANA Time Zone Database time zone, e.g. "America/New_York".
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class WeekDayOfMonthArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input['WeekDayOfMonthDayOfWeek'],
                 week_ordinal: pulumi.Input[int],
                 day_offset: Optional[pulumi.Input[int]] = None):
        """
        Represents one week day in a month. An example is "the 4th Sunday".
        :param pulumi.Input['WeekDayOfMonthDayOfWeek'] day_of_week: A day of the week.
        :param pulumi.Input[int] week_ordinal: Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        :param pulumi.Input[int] day_offset: Optional. Represents the number of days before or after the given week day of month that the patch deployment is scheduled for. For example if `week_ordinal` and `day_of_week` values point to the second day of the month and this `day_offset` value is set to `3`, the patch deployment takes place three days after the second Tuesday of the month. If this value is negative, for example -5, the patches are deployed five days before before the second Tuesday of the month. Allowed values are in range [-30, 30].
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_ordinal", week_ordinal)
        if day_offset is not None:
            pulumi.set(__self__, "day_offset", day_offset)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input['WeekDayOfMonthDayOfWeek']:
        """
        A day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input['WeekDayOfMonthDayOfWeek']):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> pulumi.Input[int]:
        """
        Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")

    @week_ordinal.setter
    def week_ordinal(self, value: pulumi.Input[int]):
        pulumi.set(self, "week_ordinal", value)

    @property
    @pulumi.getter(name="dayOffset")
    def day_offset(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Represents the number of days before or after the given week day of month that the patch deployment is scheduled for. For example if `week_ordinal` and `day_of_week` values point to the second day of the month and this `day_offset` value is set to `3`, the patch deployment takes place three days after the second Tuesday of the month. If this value is negative, for example -5, the patches are deployed five days before before the second Tuesday of the month. Allowed values are in range [-30, 30].
        """
        return pulumi.get(self, "day_offset")

    @day_offset.setter
    def day_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day_offset", value)


@pulumi.input_type
class WeeklyScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input['WeeklyScheduleDayOfWeek']):
        """
        Represents a weekly schedule.
        :param pulumi.Input['WeeklyScheduleDayOfWeek'] day_of_week: Day of the week.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input['WeeklyScheduleDayOfWeek']:
        """
        Day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input['WeeklyScheduleDayOfWeek']):
        pulumi.set(self, "day_of_week", value)


@pulumi.input_type
class WindowsUpdateSettingsArgs:
    def __init__(__self__, *,
                 classifications: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsUpdateSettingsClassificationsItem']]]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Windows patching is performed using the Windows Update Agent.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsUpdateSettingsClassificationsItem']]] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of KBs to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        if classifications is not None:
            pulumi.set(__self__, "classifications", classifications)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsUpdateSettingsClassificationsItem']]]]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        """
        return pulumi.get(self, "classifications")

    @classifications.setter
    def classifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsUpdateSettingsClassificationsItem']]]]):
        pulumi.set(self, "classifications", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")

    @exclusive_patches.setter
    def exclusive_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_patches", value)


@pulumi.input_type
class YumRepositoryArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[str],
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 gpg_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a single Yum package repository. This repository is added to a repo file that is stored at `/etc/yum.repos.d/google_osconfig.repo`.
        :param pulumi.Input[str] base_url: The location of the repository directory.
        :param pulumi.Input[str] id: A one word, unique name for this repository. This is the `repo id` in the Yum config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.
        :param pulumi.Input[str] display_name: The display name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[str]:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A one word, unique name for this repository. This is the `repo id` in the Yum config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")

    @gpg_keys.setter
    def gpg_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gpg_keys", value)


@pulumi.input_type
class YumSettingsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 minimal: Optional[pulumi.Input[bool]] = None,
                 security: Optional[pulumi.Input[bool]] = None):
        """
        Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        :param pulumi.Input[bool] minimal: Will cause patch to run `yum update-minimal` instead.
        :param pulumi.Input[bool] security: Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if minimal is not None:
            pulumi.set(__self__, "minimal", minimal)
        if security is not None:
            pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @exclusive_packages.setter
    def exclusive_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_packages", value)

    @property
    @pulumi.getter
    def minimal(self) -> Optional[pulumi.Input[bool]]:
        """
        Will cause patch to run `yum update-minimal` instead.
        """
        return pulumi.get(self, "minimal")

    @minimal.setter
    def minimal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "minimal", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security", value)


@pulumi.input_type
class ZypperRepositoryArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[str],
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 gpg_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a single Zypper package repository. This repository is added to a repo file that is stored at `/etc/zypp/repos.d/google_osconfig.repo`.
        :param pulumi.Input[str] base_url: The location of the repository directory.
        :param pulumi.Input[str] id: A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.
        :param pulumi.Input[str] display_name: The display name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[str]:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")

    @gpg_keys.setter
    def gpg_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gpg_keys", value)


@pulumi.input_type
class ZypperSettingsArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 severities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 with_optional: Optional[pulumi.Input[bool]] = None,
                 with_update: Optional[pulumi.Input[bool]] = None):
        """
        Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of patches to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_patches: An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param pulumi.Input[bool] with_optional: Adds the `--with-optional` flag to `zypper patch`.
        :param pulumi.Input[bool] with_update: Adds the `--with-update` flag, to `zypper patch`.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)
        if with_optional is not None:
            pulumi.set(__self__, "with_optional", with_optional)
        if with_update is not None:
            pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of patches to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_patches")

    @exclusive_patches.setter
    def exclusive_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_patches", value)

    @property
    @pulumi.getter
    def severities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @severities.setter
    def severities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "severities", value)

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the `--with-optional` flag to `zypper patch`.
        """
        return pulumi.get(self, "with_optional")

    @with_optional.setter
    def with_optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_optional", value)

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the `--with-update` flag, to `zypper patch`.
        """
        return pulumi.get(self, "with_update")

    @with_update.setter
    def with_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_update", value)


