# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAlertPolicyResult',
    'AwaitableGetAlertPolicyResult',
    'get_alert_policy',
    'get_alert_policy_output',
]

@pulumi.output_type
class GetAlertPolicyResult:
    def __init__(__self__, alert_strategy=None, combiner=None, conditions=None, creation_record=None, display_name=None, documentation=None, enabled=None, mutation_record=None, name=None, notification_channels=None, user_labels=None, validity=None):
        if alert_strategy and not isinstance(alert_strategy, dict):
            raise TypeError("Expected argument 'alert_strategy' to be a dict")
        pulumi.set(__self__, "alert_strategy", alert_strategy)
        if combiner and not isinstance(combiner, str):
            raise TypeError("Expected argument 'combiner' to be a str")
        pulumi.set(__self__, "combiner", combiner)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if creation_record and not isinstance(creation_record, dict):
            raise TypeError("Expected argument 'creation_record' to be a dict")
        pulumi.set(__self__, "creation_record", creation_record)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if documentation and not isinstance(documentation, dict):
            raise TypeError("Expected argument 'documentation' to be a dict")
        pulumi.set(__self__, "documentation", documentation)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if mutation_record and not isinstance(mutation_record, dict):
            raise TypeError("Expected argument 'mutation_record' to be a dict")
        pulumi.set(__self__, "mutation_record", mutation_record)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_channels and not isinstance(notification_channels, list):
            raise TypeError("Expected argument 'notification_channels' to be a list")
        pulumi.set(__self__, "notification_channels", notification_channels)
        if user_labels and not isinstance(user_labels, dict):
            raise TypeError("Expected argument 'user_labels' to be a dict")
        pulumi.set(__self__, "user_labels", user_labels)
        if validity and not isinstance(validity, dict):
            raise TypeError("Expected argument 'validity' to be a dict")
        pulumi.set(__self__, "validity", validity)

    @property
    @pulumi.getter(name="alertStrategy")
    def alert_strategy(self) -> 'outputs.AlertStrategyResponse':
        """
        Control over how this alert policy's notification channels are notified.
        """
        return pulumi.get(self, "alert_strategy")

    @property
    @pulumi.getter
    def combiner(self) -> str:
        """
        How to combine the results of multiple conditions to determine if an incident should be opened. If condition_time_series_query_language is present, this must be COMBINE_UNSPECIFIED.
        """
        return pulumi.get(self, "combiner")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ConditionResponse']:
        """
        A list of conditions for the policy. The conditions are combined by AND or OR according to the combiner field. If the combined conditions evaluate to true, then an incident is created. A policy can have from one to six conditions. If condition_time_series_query_language is present, it must be the only condition.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="creationRecord")
    def creation_record(self) -> 'outputs.MutationRecordResponse':
        """
        A read-only record of the creation of the alerting policy. If provided in a call to create or update, this field will be ignored.
        """
        return pulumi.get(self, "creation_record")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A short name or phrase used to identify the policy in dashboards, notifications, and incidents. To avoid confusion, don't use the same display name for multiple policies in the same project. The name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def documentation(self) -> 'outputs.DocumentationResponse':
        """
        Documentation that is included with notifications and incidents related to this policy. Best practice is for the documentation to include information to help responders understand, mitigate, escalate, and correct the underlying problems detected by the alerting policy. Notification channels that have limited capacity might not show this documentation.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether or not the policy is enabled. On write, the default interpretation if unset is that the policy is enabled. On read, clients should not make any assumption about the state if it has not been populated. The field should always be populated on List and Get operations, unless a field projection has been specified that strips it out.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="mutationRecord")
    def mutation_record(self) -> 'outputs.MutationRecordResponse':
        """
        A read-only record of the most recent change to the alerting policy. If provided in a call to create or update, this field will be ignored.
        """
        return pulumi.get(self, "mutation_record")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required if the policy exists. The resource name for this policy. The format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by Cloud Monitoring when the policy is created. When calling the alertPolicies.create method, do not include the name field in the alerting policy passed as part of the request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> Sequence[str]:
        """
        Identifies the notification channels to which notifications should be sent when incidents are opened or closed or when new violations occur on an already opened incident. Each element of this array corresponds to the name field in each of the NotificationChannel objects that are returned from the ListNotificationChannels method. The format of the entries in this field is: projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID] 
        """
        return pulumi.get(self, "notification_channels")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        """
        User-supplied key/value data to be used for organizing and identifying the AlertPolicy objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def validity(self) -> 'outputs.StatusResponse':
        """
        Read-only description of how the alert policy is invalid. OK if the alert policy is valid. If not OK, the alert policy will not generate incidents.
        """
        return pulumi.get(self, "validity")


class AwaitableGetAlertPolicyResult(GetAlertPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertPolicyResult(
            alert_strategy=self.alert_strategy,
            combiner=self.combiner,
            conditions=self.conditions,
            creation_record=self.creation_record,
            display_name=self.display_name,
            documentation=self.documentation,
            enabled=self.enabled,
            mutation_record=self.mutation_record,
            name=self.name,
            notification_channels=self.notification_channels,
            user_labels=self.user_labels,
            validity=self.validity)


def get_alert_policy(alert_policy_id: Optional[str] = None,
                     project: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertPolicyResult:
    """
    Gets a single alerting policy.
    """
    __args__ = dict()
    __args__['alertPolicyId'] = alert_policy_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:monitoring/v3:getAlertPolicy', __args__, opts=opts, typ=GetAlertPolicyResult).value

    return AwaitableGetAlertPolicyResult(
        alert_strategy=__ret__.alert_strategy,
        combiner=__ret__.combiner,
        conditions=__ret__.conditions,
        creation_record=__ret__.creation_record,
        display_name=__ret__.display_name,
        documentation=__ret__.documentation,
        enabled=__ret__.enabled,
        mutation_record=__ret__.mutation_record,
        name=__ret__.name,
        notification_channels=__ret__.notification_channels,
        user_labels=__ret__.user_labels,
        validity=__ret__.validity)


@_utilities.lift_output_func(get_alert_policy)
def get_alert_policy_output(alert_policy_id: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertPolicyResult]:
    """
    Gets a single alerting policy.
    """
    ...
