# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudMemcacheV1MaintenancePolicyResponse',
    'InstanceMessageResponse',
    'MaintenanceScheduleResponse',
    'MemcacheParametersResponse',
    'NodeConfigResponse',
    'NodeResponse',
    'TimeOfDayResponse',
    'WeeklyMaintenanceWindowResponse',
]

@pulumi.output_type
class GoogleCloudMemcacheV1MaintenancePolicyResponse(dict):
    """
    Maintenance policy per instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "weeklyMaintenanceWindow":
            suggest = "weekly_maintenance_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudMemcacheV1MaintenancePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudMemcacheV1MaintenancePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudMemcacheV1MaintenancePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 update_time: str,
                 weekly_maintenance_window: Sequence['outputs.WeeklyMaintenanceWindowResponse']):
        """
        Maintenance policy per instance.
        :param str create_time: The time when the policy was created.
        :param str description: Description of what this policy is for. Create/Update methods return INVALID_ARGUMENT if the length is greater than 512.
        :param str update_time: The time when the policy was updated.
        :param Sequence['WeeklyMaintenanceWindowResponse'] weekly_maintenance_window: Maintenance window that is applied to resources covered by this policy. Minimum 1. For the current version, the maximum number of weekly_maintenance_windows is expected to be one.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "weekly_maintenance_window", weekly_maintenance_window)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the policy was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of what this policy is for. Create/Update methods return INVALID_ARGUMENT if the length is greater than 512.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the policy was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindow")
    def weekly_maintenance_window(self) -> Sequence['outputs.WeeklyMaintenanceWindowResponse']:
        """
        Maintenance window that is applied to resources covered by this policy. Minimum 1. For the current version, the maximum number of weekly_maintenance_windows is expected to be one.
        """
        return pulumi.get(self, "weekly_maintenance_window")


@pulumi.output_type
class InstanceMessageResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        :param str code: A code that correspond to one type of user-facing message.
        :param str message: Message on memcached instance which will be exposed to users.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A code that correspond to one type of user-facing message.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message on memcached instance which will be exposed to users.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class MaintenanceScheduleResponse(dict):
    """
    Upcoming maintenance schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 schedule_deadline_time: str,
                 start_time: str):
        """
        Upcoming maintenance schedule.
        :param str end_time: The end time of any upcoming scheduled maintenance for this instance.
        :param str schedule_deadline_time: The deadline that the maintenance schedule start time can not go beyond, including reschedule.
        :param str start_time: The start time of any upcoming scheduled maintenance for this instance.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> str:
        """
        The deadline that the maintenance schedule start time can not go beyond, including reschedule.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class MemcacheParametersResponse(dict):
    def __init__(__self__, *,
                 params: Mapping[str, str]):
        """
        :param Mapping[str, str] params: User defined set of parameters to use in the memcached process.
        """
        pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, str]:
        """
        User defined set of parameters to use in the memcached process.
        """
        return pulumi.get(self, "params")


@pulumi.output_type
class NodeConfigResponse(dict):
    """
    Configuration for a Memcached Node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"
        elif key == "memorySizeMb":
            suggest = "memory_size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: int,
                 memory_size_mb: int):
        """
        Configuration for a Memcached Node.
        :param int cpu_count: Number of cpus per Memcached node.
        :param int memory_size_mb: Memory size in MiB for each Memcached node.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "memory_size_mb", memory_size_mb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> int:
        """
        Number of cpus per Memcached node.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="memorySizeMb")
    def memory_size_mb(self) -> int:
        """
        Memory size in MiB for each Memcached node.
        """
        return pulumi.get(self, "memory_size_mb")


@pulumi.output_type
class NodeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 node_id: str,
                 parameters: 'outputs.MemcacheParametersResponse',
                 port: int,
                 state: str,
                 zone: str):
        """
        :param str host: Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        :param str node_id: Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        :param 'MemcacheParametersResponse' parameters: User defined parameters currently applied to the node.
        :param int port: The port number of the Memcached server on this node.
        :param str state: Current state of the Memcached node.
        :param str zone: Location (GCP Zone) for the Memcached node.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Hostname or IP address of the Memcached node used by the clients to connect to the Memcached server on this node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Identifier of the Memcached node. The node id does not include project or location like the Memcached instance name.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.MemcacheParametersResponse':
        """
        User defined parameters currently applied to the node.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the Memcached server on this node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the Memcached node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Location (GCP Zone) for the Memcached node.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class WeeklyMaintenanceWindowResponse(dict):
    """
    Time window specified for weekly operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyMaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyMaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyMaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 duration: str,
                 start_time: 'outputs.TimeOfDayResponse'):
        """
        Time window specified for weekly operations.
        :param str day: Allows to define schedule that runs specified day of the week.
        :param str duration: Duration of the time window.
        :param 'TimeOfDayResponse' start_time: Start time of the window in UTC.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Allows to define schedule that runs specified day of the week.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration of the time window.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.TimeOfDayResponse':
        """
        Start time of the window in UTC.
        """
        return pulumi.get(self, "start_time")


