# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetProviderResult',
    'AwaitableGetProviderResult',
    'get_provider',
    'get_provider_output',
]

@pulumi.output_type
class GetProviderResult:
    def __init__(__self__, attribute_condition=None, attribute_mapping=None, aws=None, description=None, disabled=None, display_name=None, name=None, oidc=None, saml=None, state=None):
        if attribute_condition and not isinstance(attribute_condition, str):
            raise TypeError("Expected argument 'attribute_condition' to be a str")
        pulumi.set(__self__, "attribute_condition", attribute_condition)
        if attribute_mapping and not isinstance(attribute_mapping, dict):
            raise TypeError("Expected argument 'attribute_mapping' to be a dict")
        pulumi.set(__self__, "attribute_mapping", attribute_mapping)
        if aws and not isinstance(aws, dict):
            raise TypeError("Expected argument 'aws' to be a dict")
        pulumi.set(__self__, "aws", aws)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oidc and not isinstance(oidc, dict):
            raise TypeError("Expected argument 'oidc' to be a dict")
        pulumi.set(__self__, "oidc", oidc)
        if saml and not isinstance(saml, dict):
            raise TypeError("Expected argument 'saml' to be a dict")
        pulumi.set(__self__, "saml", saml)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> str:
        """
        [A Common Expression Language](https://opensource.google/projects/cel) expression, in plain text, to restrict what otherwise valid authentication credentials issued by the provider should not be accepted. The expression must output a boolean representing whether to allow the federation. The following keywords may be referenced in the expressions: * `assertion`: JSON representing the authentication credential issued by the provider. * `google`: The Google attributes mapped from the assertion in the `attribute_mappings`. * `attribute`: The custom attributes mapped from the assertion in the `attribute_mappings`. The maximum length of the attribute condition expression is 4096 characters. If unspecified, all valid authentication credential are accepted. The following example shows how to only allow credentials with a mapped `google.groups` value of `admins`: ``` "'admins' in google.groups" ```
        """
        return pulumi.get(self, "attribute_condition")

    @property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> Mapping[str, str]:
        """
        Maps attributes from authentication credentials issued by an external identity provider to Google Cloud attributes, such as `subject` and `segment`. Each key must be a string specifying the Google Cloud IAM attribute to map to. The following keys are supported: * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings. This is also the subject that appears in Cloud Logging logs. Cannot exceed 127 bytes. * `google.groups`: Groups the external identity belongs to. You can grant groups access to resources using an IAM `principalSet` binding; access applies to all members of the group. You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where `{custom_attribute}` is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes. The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_]. You can reference these attributes in IAM policies to define fine-grained access for a workload to Google Cloud resources. For example: * `google.subject`: `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}` * `google.groups`: `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}` * `attribute.{custom_attribute}`: `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}` Each value must be a [Common Expression Language] (https://opensource.google/projects/cel) function that maps an identity provider credential to the normalized attribute specified by the corresponding map key. You can use the `assertion` keyword in the expression to access a JSON representation of the authentication credential issued by the provider. The maximum length of an attribute mapping expression is 2048 characters. When evaluated, the total size of all mapped attributes must not exceed 8KB. For AWS providers, if no attribute mapping is defined, the following default mapping applies: ``` { "google.subject":"assertion.arn", "attribute.aws_role": "assertion.arn.contains('assumed-role')" " ? assertion.arn.extract('{account_arn}assumed-role/')" " + 'assumed-role/'" " + assertion.arn.extract('assumed-role/{role_name}/')" " : assertion.arn", } ``` If any custom attribute mappings are defined, they must include a mapping to the `google.subject` attribute. For OIDC providers, you must supply a custom mapping, which must include the `google.subject` attribute. For example, the following maps the `sub` claim of the incoming credential to the `subject` attribute on a Google token: ``` {"google.subject": "assertion.sub"} ```
        """
        return pulumi.get(self, "attribute_mapping")

    @property
    @pulumi.getter
    def aws(self) -> 'outputs.AwsResponse':
        """
        An Amazon Web Services identity provider.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens. However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def oidc(self) -> 'outputs.OidcResponse':
        """
        An OpenId Connect 1.0 identity provider.
        """
        return pulumi.get(self, "oidc")

    @property
    @pulumi.getter
    def saml(self) -> 'outputs.SamlResponse':
        """
        An SAML 2.0 identity provider.
        """
        return pulumi.get(self, "saml")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the provider.
        """
        return pulumi.get(self, "state")


class AwaitableGetProviderResult(GetProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProviderResult(
            attribute_condition=self.attribute_condition,
            attribute_mapping=self.attribute_mapping,
            aws=self.aws,
            description=self.description,
            disabled=self.disabled,
            display_name=self.display_name,
            name=self.name,
            oidc=self.oidc,
            saml=self.saml,
            state=self.state)


def get_provider(location: Optional[str] = None,
                 project: Optional[str] = None,
                 provider_id: Optional[str] = None,
                 workload_identity_pool_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProviderResult:
    """
    Gets an individual WorkloadIdentityPoolProvider.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['providerId'] = provider_id
    __args__['workloadIdentityPoolId'] = workload_identity_pool_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:iam/v1:getProvider', __args__, opts=opts, typ=GetProviderResult).value

    return AwaitableGetProviderResult(
        attribute_condition=__ret__.attribute_condition,
        attribute_mapping=__ret__.attribute_mapping,
        aws=__ret__.aws,
        description=__ret__.description,
        disabled=__ret__.disabled,
        display_name=__ret__.display_name,
        name=__ret__.name,
        oidc=__ret__.oidc,
        saml=__ret__.saml,
        state=__ret__.state)


@_utilities.lift_output_func(get_provider)
def get_provider_output(location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        provider_id: Optional[pulumi.Input[str]] = None,
                        workload_identity_pool_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProviderResult]:
    """
    Gets an individual WorkloadIdentityPoolProvider.
    """
    ...
