# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AttributeArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'ExprArgs',
    'FieldArgs',
    'GoogleCloudHealthcareV1ConsentPolicyArgs',
    'GoogleCloudHealthcareV1FhirBigQueryDestinationArgs',
    'Hl7SchemaConfigArgs',
    'Hl7TypesConfigArgs',
    'Hl7V2NotificationConfigArgs',
    'ImageArgs',
    'NotificationConfigArgs',
    'ParserConfigArgs',
    'PatientIdArgs',
    'SchemaConfigArgs',
    'SchemaPackageArgs',
    'SchematizedDataArgs',
    'SignatureArgs',
    'StreamConfigArgs',
    'TypeArgs',
    'ValidationConfigArgs',
    'VersionSourceArgs',
]

@pulumi.input_type
class AttributeArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attribute_definition_id: Optional[pulumi.Input[str]] = None):
        """
        An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding AttributeDefinition in the consent store that defines the default and allowed values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        :param pulumi.Input[str] attribute_definition_id: Indicates the name of an attribute defined in the consent store.
        """
        pulumi.set(__self__, "values", values)
        if attribute_definition_id is not None:
            pulumi.set(__self__, "attribute_definition_id", attribute_definition_id)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter(name="attributeDefinitionId")
    def attribute_definition_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the name of an attribute defined in the consent store.
        """
        return pulumi.get(self, "attribute_definition_id")

    @attribute_definition_id.setter
    def attribute_definition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribute_definition_id", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FieldArgs:
    def __init__(__self__, *,
                 max_occurs: Optional[pulumi.Input[int]] = None,
                 min_occurs: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A (sub) field of a type.
        :param pulumi.Input[int] max_occurs: The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        :param pulumi.Input[int] min_occurs: The minimum number of times this field must be present/repeated.
        :param pulumi.Input[str] name: The name of the field. For example, "PID-1" or just "1".
        :param pulumi.Input[str] table: The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        :param pulumi.Input[str] type: The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        if max_occurs is not None:
            pulumi.set(__self__, "max_occurs", max_occurs)
        if min_occurs is not None:
            pulumi.set(__self__, "min_occurs", min_occurs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="maxOccurs")
    def max_occurs(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        """
        return pulumi.get(self, "max_occurs")

    @max_occurs.setter
    def max_occurs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_occurs", value)

    @property
    @pulumi.getter(name="minOccurs")
    def min_occurs(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of times this field must be present/repeated.
        """
        return pulumi.get(self, "min_occurs")

    @min_occurs.setter
    def min_occurs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_occurs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field. For example, "PID-1" or just "1".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudHealthcareV1ConsentPolicyArgs:
    def __init__(__self__, *,
                 authorization_rule: pulumi.Input['ExprArgs'],
                 resource_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]]] = None):
        """
        Represents a user's consent in terms of the resources that can be accessed and under what conditions.
        :param pulumi.Input['ExprArgs'] authorization_rule: The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        :param pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]] resource_attributes: The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        pulumi.set(__self__, "authorization_rule", authorization_rule)
        if resource_attributes is not None:
            pulumi.set(__self__, "resource_attributes", resource_attributes)

    @property
    @pulumi.getter(name="authorizationRule")
    def authorization_rule(self) -> pulumi.Input['ExprArgs']:
        """
        The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        """
        return pulumi.get(self, "authorization_rule")

    @authorization_rule.setter
    def authorization_rule(self, value: pulumi.Input['ExprArgs']):
        pulumi.set(self, "authorization_rule", value)

    @property
    @pulumi.getter(name="resourceAttributes")
    def resource_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]]]:
        """
        The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        return pulumi.get(self, "resource_attributes")

    @resource_attributes.setter
    def resource_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttributeArgs']]]]):
        pulumi.set(self, "resource_attributes", value)


@pulumi.input_type
class GoogleCloudHealthcareV1FhirBigQueryDestinationArgs:
    def __init__(__self__, *,
                 dataset_uri: Optional[pulumi.Input[str]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 schema_config: Optional[pulumi.Input['SchemaConfigArgs']] = None,
                 write_disposition: Optional[pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationWriteDisposition']] = None):
        """
        The configuration for exporting to BigQuery.
        :param pulumi.Input[str] dataset_uri: BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        :param pulumi.Input[bool] force: If this flag is `TRUE`, all tables are deleted from the dataset before the new exported tables are written. If the flag is not set and the destination dataset contains tables, the export call returns an error. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        :param pulumi.Input['SchemaConfigArgs'] schema_config: The configuration for the exported BigQuery schema.
        :param pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationWriteDisposition'] write_disposition: Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        if dataset_uri is not None:
            pulumi.set(__self__, "dataset_uri", dataset_uri)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if schema_config is not None:
            pulumi.set(__self__, "schema_config", schema_config)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="datasetUri")
    def dataset_uri(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        """
        return pulumi.get(self, "dataset_uri")

    @dataset_uri.setter
    def dataset_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_uri", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        If this flag is `TRUE`, all tables are deleted from the dataset before the new exported tables are written. If the flag is not set and the destination dataset contains tables, the export call returns an error. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="schemaConfig")
    def schema_config(self) -> Optional[pulumi.Input['SchemaConfigArgs']]:
        """
        The configuration for the exported BigQuery schema.
        """
        return pulumi.get(self, "schema_config")

    @schema_config.setter
    def schema_config(self, value: Optional[pulumi.Input['SchemaConfigArgs']]):
        pulumi.set(self, "schema_config", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationWriteDisposition']]:
        """
        Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationWriteDisposition']]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class Hl7SchemaConfigArgs:
    def __init__(__self__, *,
                 message_schema_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]] = None):
        """
        Root config message for HL7v2 schema. This contains a schema structure of groups and segments, and filters that determine which messages to apply the schema structure to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] message_schema_configs: Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        :param pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]] version: Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        if message_schema_configs is not None:
            pulumi.set(__self__, "message_schema_configs", message_schema_configs)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="messageSchemaConfigs")
    def message_schema_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        """
        return pulumi.get(self, "message_schema_configs")

    @message_schema_configs.setter
    def message_schema_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "message_schema_configs", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]:
        """
        Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class Hl7TypesConfigArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]] = None):
        """
        Root config for HL7v2 datatype definitions for a specific HL7v2 version.
        :param pulumi.Input[Sequence[pulumi.Input['TypeArgs']]] type: The HL7v2 type definitions.
        :param pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]] version: The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]:
        """
        The HL7v2 type definitions.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TypeArgs']]]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]:
        """
        The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VersionSourceArgs']]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class Hl7V2NotificationConfigArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input[str]] = None,
                 pubsub_topic: Optional[pulumi.Input[str]] = None):
        """
        Specifies where and whether to send notifications upon changes to a data store.
        :param pulumi.Input[str] filter: Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. The following fields and functions are available for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        :param pulumi.Input[str] pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It's guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification cannot be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. The following fields and functions are available for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It's guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification cannot be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)


@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 gcs_uri: Optional[pulumi.Input[str]] = None,
                 raw_bytes: Optional[pulumi.Input[str]] = None):
        """
        Raw bytes representing consent artifact content.
        :param pulumi.Input[str] gcs_uri: Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        :param pulumi.Input[str] raw_bytes: Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        if gcs_uri is not None:
            pulumi.set(__self__, "gcs_uri", gcs_uri)
        if raw_bytes is not None:
            pulumi.set(__self__, "raw_bytes", raw_bytes)

    @property
    @pulumi.getter(name="gcsUri")
    def gcs_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        """
        return pulumi.get(self, "gcs_uri")

    @gcs_uri.setter
    def gcs_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcs_uri", value)

    @property
    @pulumi.getter(name="rawBytes")
    def raw_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        return pulumi.get(self, "raw_bytes")

    @raw_bytes.setter
    def raw_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_bytes", value)


@pulumi.input_type
class NotificationConfigArgs:
    def __init__(__self__, *,
                 pubsub_topic: Optional[pulumi.Input[str]] = None):
        """
        Specifies where to send notifications upon changes to a data store.
        :param pulumi.Input[str] pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        """
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)


@pulumi.input_type
class ParserConfigArgs:
    def __init__(__self__, *,
                 allow_null_header: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input['SchemaPackageArgs']] = None,
                 segment_terminator: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['ParserConfigVersion']] = None):
        """
        The configuration for the parser. It determines how the server parses the messages.
        :param pulumi.Input[bool] allow_null_header: Determines whether messages with no header are allowed.
        :param pulumi.Input['SchemaPackageArgs'] schema: Schemas used to parse messages in this store, if schematized parsing is desired.
        :param pulumi.Input[str] segment_terminator: Byte(s) to use as the segment terminator. If this is unset, '\r' is used as segment terminator, matching the HL7 version 2 specification.
        :param pulumi.Input['ParserConfigVersion'] version: Immutable. Determines the version of both the default parser to be used when `schema` is not given, as well as the schematized parser used when `schema` is specified. This field is immutable after HL7v2 store creation.
        """
        if allow_null_header is not None:
            pulumi.set(__self__, "allow_null_header", allow_null_header)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if segment_terminator is not None:
            pulumi.set(__self__, "segment_terminator", segment_terminator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="allowNullHeader")
    def allow_null_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether messages with no header are allowed.
        """
        return pulumi.get(self, "allow_null_header")

    @allow_null_header.setter
    def allow_null_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_null_header", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['SchemaPackageArgs']]:
        """
        Schemas used to parse messages in this store, if schematized parsing is desired.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['SchemaPackageArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> Optional[pulumi.Input[str]]:
        """
        Byte(s) to use as the segment terminator. If this is unset, '\r' is used as segment terminator, matching the HL7 version 2 specification.
        """
        return pulumi.get(self, "segment_terminator")

    @segment_terminator.setter
    def segment_terminator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_terminator", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['ParserConfigVersion']]:
        """
        Immutable. Determines the version of both the default parser to be used when `schema` is not given, as well as the schematized parser used when `schema` is specified. This field is immutable after HL7v2 store creation.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['ParserConfigVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PatientIdArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A patient identifier and associated type.
        :param pulumi.Input[str] type: ID type. For example, MRN or NHS.
        :param pulumi.Input[str] value: The patient's unique identifier.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        ID type. For example, MRN or NHS.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The patient's unique identifier.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SchemaConfigArgs:
    def __init__(__self__, *,
                 recursive_structure_depth: Optional[pulumi.Input[str]] = None,
                 schema_type: Optional[pulumi.Input['SchemaConfigSchemaType']] = None):
        """
        Configuration for the FHIR BigQuery schema. Determines how the server generates the schema.
        :param pulumi.Input[str] recursive_structure_depth: The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        :param pulumi.Input['SchemaConfigSchemaType'] schema_type: Specifies the output schema type. Schema type is required.
        """
        if recursive_structure_depth is not None:
            pulumi.set(__self__, "recursive_structure_depth", recursive_structure_depth)
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="recursiveStructureDepth")
    def recursive_structure_depth(self) -> Optional[pulumi.Input[str]]:
        """
        The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        """
        return pulumi.get(self, "recursive_structure_depth")

    @recursive_structure_depth.setter
    def recursive_structure_depth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recursive_structure_depth", value)

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[pulumi.Input['SchemaConfigSchemaType']]:
        """
        Specifies the output schema type. Schema type is required.
        """
        return pulumi.get(self, "schema_type")

    @schema_type.setter
    def schema_type(self, value: Optional[pulumi.Input['SchemaConfigSchemaType']]):
        pulumi.set(self, "schema_type", value)


@pulumi.input_type
class SchemaPackageArgs:
    def __init__(__self__, *,
                 ignore_min_occurs: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]]] = None,
                 schematized_parsing_type: Optional[pulumi.Input['SchemaPackageSchematizedParsingType']] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]]] = None,
                 unexpected_segment_handling: Optional[pulumi.Input['SchemaPackageUnexpectedSegmentHandling']] = None):
        """
        A schema package contains a set of schemas and type definitions.
        :param pulumi.Input[bool] ignore_min_occurs: Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        :param pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]] schemas: Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        :param pulumi.Input['SchemaPackageSchematizedParsingType'] schematized_parsing_type: Determines how messages that fail to parse are handled.
        :param pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]] types: Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        :param pulumi.Input['SchemaPackageUnexpectedSegmentHandling'] unexpected_segment_handling: Determines how unexpected segments (segments not matched to the schema) are handled.
        """
        if ignore_min_occurs is not None:
            pulumi.set(__self__, "ignore_min_occurs", ignore_min_occurs)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if schematized_parsing_type is not None:
            pulumi.set(__self__, "schematized_parsing_type", schematized_parsing_type)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if unexpected_segment_handling is not None:
            pulumi.set(__self__, "unexpected_segment_handling", unexpected_segment_handling)

    @property
    @pulumi.getter(name="ignoreMinOccurs")
    def ignore_min_occurs(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        """
        return pulumi.get(self, "ignore_min_occurs")

    @ignore_min_occurs.setter
    def ignore_min_occurs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_min_occurs", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]]]:
        """
        Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7SchemaConfigArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="schematizedParsingType")
    def schematized_parsing_type(self) -> Optional[pulumi.Input['SchemaPackageSchematizedParsingType']]:
        """
        Determines how messages that fail to parse are handled.
        """
        return pulumi.get(self, "schematized_parsing_type")

    @schematized_parsing_type.setter
    def schematized_parsing_type(self, value: Optional[pulumi.Input['SchemaPackageSchematizedParsingType']]):
        pulumi.set(self, "schematized_parsing_type", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]]]:
        """
        Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Hl7TypesConfigArgs']]]]):
        pulumi.set(self, "types", value)

    @property
    @pulumi.getter(name="unexpectedSegmentHandling")
    def unexpected_segment_handling(self) -> Optional[pulumi.Input['SchemaPackageUnexpectedSegmentHandling']]:
        """
        Determines how unexpected segments (segments not matched to the schema) are handled.
        """
        return pulumi.get(self, "unexpected_segment_handling")

    @unexpected_segment_handling.setter
    def unexpected_segment_handling(self, value: Optional[pulumi.Input['SchemaPackageUnexpectedSegmentHandling']]):
        pulumi.set(self, "unexpected_segment_handling", value)


@pulumi.input_type
class SchematizedDataArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 error: Optional[pulumi.Input[str]] = None):
        """
        The content of an HL7v2 message in a structured format as specified by a schema.
        :param pulumi.Input[str] data: JSON output of the parser.
        :param pulumi.Input[str] error: The error output of the parser.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        JSON output of the parser.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        The error output of the parser.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)


@pulumi.input_type
class SignatureArgs:
    def __init__(__self__, *,
                 user_id: pulumi.Input[str],
                 image: Optional[pulumi.Input['ImageArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 signature_time: Optional[pulumi.Input[str]] = None):
        """
        User signature.
        :param pulumi.Input[str] user_id: User's UUID provided by the client.
        :param pulumi.Input['ImageArgs'] image: Optional. An image of the user's signature.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        :param pulumi.Input[str] signature_time: Optional. Timestamp of the signature.
        """
        pulumi.set(__self__, "user_id", user_id)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if signature_time is not None:
            pulumi.set(__self__, "signature_time", signature_time)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        User's UUID provided by the client.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ImageArgs']]:
        """
        Optional. An image of the user's signature.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="signatureTime")
    def signature_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Timestamp of the signature.
        """
        return pulumi.get(self, "signature_time")

    @signature_time.setter
    def signature_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_time", value)


@pulumi.input_type
class StreamConfigArgs:
    def __init__(__self__, *,
                 bigquery_destination: Optional[pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationArgs']] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Contains configuration for streaming FHIR export.
        :param pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationArgs'] bigquery_destination: The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types. For example, "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data is not streamed. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. Results are written to BigQuery tables according to the parameters in BigQueryDestination.WriteDisposition. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        if bigquery_destination is not None:
            pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> Optional[pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationArgs']]:
        """
        The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types. For example, "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data is not streamed. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. Results are written to BigQuery tables according to the parameters in BigQueryDestination.WriteDisposition. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "bigquery_destination")

    @bigquery_destination.setter
    def bigquery_destination(self, value: Optional[pulumi.Input['GoogleCloudHealthcareV1FhirBigQueryDestinationArgs']]):
        pulumi.set(self, "bigquery_destination", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_types", value)


@pulumi.input_type
class TypeArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primitive: Optional[pulumi.Input['TypePrimitive']] = None):
        """
        A type definition for some HL7v2 type (incl. Segments and Datatypes).
        :param pulumi.Input[Sequence[pulumi.Input['FieldArgs']]] fields: The (sub) fields this type has (if not primitive).
        :param pulumi.Input[str] name: The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        :param pulumi.Input['TypePrimitive'] primitive: If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primitive is not None:
            pulumi.set(__self__, "primitive", primitive)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]]:
        """
        The (sub) fields this type has (if not primitive).
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primitive(self) -> Optional[pulumi.Input['TypePrimitive']]:
        """
        If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        return pulumi.get(self, "primitive")

    @primitive.setter
    def primitive(self, value: Optional[pulumi.Input['TypePrimitive']]):
        pulumi.set(self, "primitive", value)


@pulumi.input_type
class ValidationConfigArgs:
    def __init__(__self__, *,
                 disable_fhirpath_validation: Optional[pulumi.Input[bool]] = None,
                 disable_profile_validation: Optional[pulumi.Input[bool]] = None,
                 disable_reference_type_validation: Optional[pulumi.Input[bool]] = None,
                 disable_required_field_validation: Optional[pulumi.Input[bool]] = None,
                 enabled_implementation_guides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Contains the configuration for FHIR profiles and validation.
        :param pulumi.Input[bool] disable_fhirpath_validation: Whether to disable FHIRPath validation for incoming resources. Set this to true to disable checking incoming resources for conformance against FHIRPath requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param pulumi.Input[bool] disable_profile_validation: Whether to disable profile validation for this FHIR store. Set this to true to disable checking incoming resources for conformance against structure definitions in this FHIR store.
        :param pulumi.Input[bool] disable_reference_type_validation: Whether to disable reference type validation for incoming resources. Set this to true to disable checking incoming resources for conformance against reference type requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param pulumi.Input[bool] disable_required_field_validation: Whether to disable required fields validation for incoming resources. Set this to true to disable checking incoming resources for conformance against required fields requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_implementation_guides: A list of implementation guide URLs in this FHIR store that are used to configure the profiles to use for validation. For example, to use the US Core profiles for validation, set `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If `enabled_implementation_guides` is empty or omitted, then incoming resources are only required to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud Healthcare API does not currently enforce all of the rules in a StructureDefinition. The following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] - pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL cannot be resolved (for example, in a type assertion), the server does not return an error.
        """
        if disable_fhirpath_validation is not None:
            pulumi.set(__self__, "disable_fhirpath_validation", disable_fhirpath_validation)
        if disable_profile_validation is not None:
            pulumi.set(__self__, "disable_profile_validation", disable_profile_validation)
        if disable_reference_type_validation is not None:
            pulumi.set(__self__, "disable_reference_type_validation", disable_reference_type_validation)
        if disable_required_field_validation is not None:
            pulumi.set(__self__, "disable_required_field_validation", disable_required_field_validation)
        if enabled_implementation_guides is not None:
            pulumi.set(__self__, "enabled_implementation_guides", enabled_implementation_guides)

    @property
    @pulumi.getter(name="disableFhirpathValidation")
    def disable_fhirpath_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable FHIRPath validation for incoming resources. Set this to true to disable checking incoming resources for conformance against FHIRPath requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_fhirpath_validation")

    @disable_fhirpath_validation.setter
    def disable_fhirpath_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_fhirpath_validation", value)

    @property
    @pulumi.getter(name="disableProfileValidation")
    def disable_profile_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable profile validation for this FHIR store. Set this to true to disable checking incoming resources for conformance against structure definitions in this FHIR store.
        """
        return pulumi.get(self, "disable_profile_validation")

    @disable_profile_validation.setter
    def disable_profile_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_profile_validation", value)

    @property
    @pulumi.getter(name="disableReferenceTypeValidation")
    def disable_reference_type_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable reference type validation for incoming resources. Set this to true to disable checking incoming resources for conformance against reference type requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_reference_type_validation")

    @disable_reference_type_validation.setter
    def disable_reference_type_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_reference_type_validation", value)

    @property
    @pulumi.getter(name="disableRequiredFieldValidation")
    def disable_required_field_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable required fields validation for incoming resources. Set this to true to disable checking incoming resources for conformance against required fields requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_required_field_validation")

    @disable_required_field_validation.setter
    def disable_required_field_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_required_field_validation", value)

    @property
    @pulumi.getter(name="enabledImplementationGuides")
    def enabled_implementation_guides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of implementation guide URLs in this FHIR store that are used to configure the profiles to use for validation. For example, to use the US Core profiles for validation, set `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If `enabled_implementation_guides` is empty or omitted, then incoming resources are only required to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud Healthcare API does not currently enforce all of the rules in a StructureDefinition. The following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] - pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL cannot be resolved (for example, in a type assertion), the server does not return an error.
        """
        return pulumi.get(self, "enabled_implementation_guides")

    @enabled_implementation_guides.setter
    def enabled_implementation_guides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_implementation_guides", value)


@pulumi.input_type
class VersionSourceArgs:
    def __init__(__self__, *,
                 msh_field: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes a selector for extracting and matching an MSH field to a value.
        :param pulumi.Input[str] msh_field: The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        :param pulumi.Input[str] value: The value to match with the field. For example, "My Application Name" or "2.3".
        """
        if msh_field is not None:
            pulumi.set(__self__, "msh_field", msh_field)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="mshField")
    def msh_field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        """
        return pulumi.get(self, "msh_field")

    @msh_field.setter
    def msh_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msh_field", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to match with the field. For example, "My Application Name" or "2.3".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


