# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BackupConfigResponse',
    'BindingResponse',
    'ClusterMetadataResponse',
    'ClusterResourceRestoreScopeResponse',
    'EncryptionKeyResponse',
    'ExprResponse',
    'GroupKindResponse',
    'NamespacedNameResponse',
    'NamespacedNamesResponse',
    'NamespacesResponse',
    'RestoreConfigResponse',
    'RetentionPolicyResponse',
    'ScheduleResponse',
    'SubstitutionRuleResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BackupConfigResponse(dict):
    """
    BackupConfig defines the configuration of Backups created via this BackupPlan.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNamespaces":
            suggest = "all_namespaces"
        elif key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "includeSecrets":
            suggest = "include_secrets"
        elif key == "includeVolumeData":
            suggest = "include_volume_data"
        elif key == "selectedApplications":
            suggest = "selected_applications"
        elif key == "selectedNamespaces":
            suggest = "selected_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_namespaces: bool,
                 encryption_key: 'outputs.EncryptionKeyResponse',
                 include_secrets: bool,
                 include_volume_data: bool,
                 selected_applications: 'outputs.NamespacedNamesResponse',
                 selected_namespaces: 'outputs.NamespacesResponse'):
        """
        BackupConfig defines the configuration of Backups created via this BackupPlan.
        :param bool all_namespaces: If True, include all namespaced resources
        :param 'EncryptionKeyResponse' encryption_key: This defines a customer managed encryption key that will be used to encrypt the "config" portion (the Kubernetes resources) of Backups created via this plan. Default (empty): Config backup artifacts will not be encrypted.
        :param bool include_secrets: This flag specifies whether Kubernetes Secret resources should be included when they fall into the scope of Backups. Default: False
        :param bool include_volume_data: This flag specifies whether volume data should be backed up when PVCs are included in the scope of a Backup. Default: False
        :param 'NamespacedNamesResponse' selected_applications: If set, include just the resources referenced by the listed ProtectedApplications.
        :param 'NamespacesResponse' selected_namespaces: If set, include just the resources in the listed namespaces.
        """
        pulumi.set(__self__, "all_namespaces", all_namespaces)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "include_secrets", include_secrets)
        pulumi.set(__self__, "include_volume_data", include_volume_data)
        pulumi.set(__self__, "selected_applications", selected_applications)
        pulumi.set(__self__, "selected_namespaces", selected_namespaces)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> bool:
        """
        If True, include all namespaced resources
        """
        return pulumi.get(self, "all_namespaces")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> 'outputs.EncryptionKeyResponse':
        """
        This defines a customer managed encryption key that will be used to encrypt the "config" portion (the Kubernetes resources) of Backups created via this plan. Default (empty): Config backup artifacts will not be encrypted.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="includeSecrets")
    def include_secrets(self) -> bool:
        """
        This flag specifies whether Kubernetes Secret resources should be included when they fall into the scope of Backups. Default: False
        """
        return pulumi.get(self, "include_secrets")

    @property
    @pulumi.getter(name="includeVolumeData")
    def include_volume_data(self) -> bool:
        """
        This flag specifies whether volume data should be backed up when PVCs are included in the scope of a Backup. Default: False
        """
        return pulumi.get(self, "include_volume_data")

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> 'outputs.NamespacedNamesResponse':
        """
        If set, include just the resources referenced by the listed ProtectedApplications.
        """
        return pulumi.get(self, "selected_applications")

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> 'outputs.NamespacesResponse':
        """
        If set, include just the resources in the listed namespaces.
        """
        return pulumi.get(self, "selected_namespaces")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ClusterMetadataResponse(dict):
    """
    Information about the GKE cluster from which this Backup was created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anthosVersion":
            suggest = "anthos_version"
        elif key == "backupCrdVersions":
            suggest = "backup_crd_versions"
        elif key == "gkeVersion":
            suggest = "gke_version"
        elif key == "k8sVersion":
            suggest = "k8s_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anthos_version: str,
                 backup_crd_versions: Mapping[str, str],
                 cluster: str,
                 gke_version: str,
                 k8s_version: str):
        """
        Information about the GKE cluster from which this Backup was created.
        :param str anthos_version: Anthos version
        :param Mapping[str, str] backup_crd_versions: A list of the Backup for GKE CRD versions found in the cluster.
        :param str cluster: The source cluster from which this Backup was created. Valid formats: - projects/*/locations/*/clusters/* - projects/*/zones/*/clusters/* This is inherited from the parent BackupPlan's cluster field.
        :param str gke_version: GKE version
        :param str k8s_version: The Kubernetes server version of the source cluster.
        """
        pulumi.set(__self__, "anthos_version", anthos_version)
        pulumi.set(__self__, "backup_crd_versions", backup_crd_versions)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "gke_version", gke_version)
        pulumi.set(__self__, "k8s_version", k8s_version)

    @property
    @pulumi.getter(name="anthosVersion")
    def anthos_version(self) -> str:
        """
        Anthos version
        """
        return pulumi.get(self, "anthos_version")

    @property
    @pulumi.getter(name="backupCrdVersions")
    def backup_crd_versions(self) -> Mapping[str, str]:
        """
        A list of the Backup for GKE CRD versions found in the cluster.
        """
        return pulumi.get(self, "backup_crd_versions")

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        The source cluster from which this Backup was created. Valid formats: - projects/*/locations/*/clusters/* - projects/*/zones/*/clusters/* This is inherited from the parent BackupPlan's cluster field.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="gkeVersion")
    def gke_version(self) -> str:
        """
        GKE version
        """
        return pulumi.get(self, "gke_version")

    @property
    @pulumi.getter(name="k8sVersion")
    def k8s_version(self) -> str:
        """
        The Kubernetes server version of the source cluster.
        """
        return pulumi.get(self, "k8s_version")


@pulumi.output_type
class ClusterResourceRestoreScopeResponse(dict):
    """
    Identifies the cluster-scoped resources to restore from the Backup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectedGroupKinds":
            suggest = "selected_group_kinds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterResourceRestoreScopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterResourceRestoreScopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterResourceRestoreScopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selected_group_kinds: Sequence['outputs.GroupKindResponse']):
        """
        Identifies the cluster-scoped resources to restore from the Backup.
        :param Sequence['GroupKindResponse'] selected_group_kinds: A list of "types" of cluster-scoped resources to be restored from the Backup. An empty list means that NO cluster-scoped resources will be restored. Note that Namespaces and PersistentVolume restoration is handled separately and is not governed by this field.
        """
        pulumi.set(__self__, "selected_group_kinds", selected_group_kinds)

    @property
    @pulumi.getter(name="selectedGroupKinds")
    def selected_group_kinds(self) -> Sequence['outputs.GroupKindResponse']:
        """
        A list of "types" of cluster-scoped resources to be restored from the Backup. An empty list means that NO cluster-scoped resources will be restored. Note that Namespaces and PersistentVolume restoration is handled separately and is not governed by this field.
        """
        return pulumi.get(self, "selected_group_kinds")


@pulumi.output_type
class EncryptionKeyResponse(dict):
    """
    Defined a customer managed encryption key that will be used to encrypt Backup artifacts.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpKmsEncryptionKey":
            suggest = "gcp_kms_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_kms_encryption_key: str):
        """
        Defined a customer managed encryption key that will be used to encrypt Backup artifacts.
        :param str gcp_kms_encryption_key: Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "gcp_kms_encryption_key", gcp_kms_encryption_key)

    @property
    @pulumi.getter(name="gcpKmsEncryptionKey")
    def gcp_kms_encryption_key(self) -> str:
        """
        Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "gcp_kms_encryption_key")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GroupKindResponse(dict):
    """
    This is a direct map to the Kubernetes GroupKind type [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind) and is used for identifying specific "types" of resources to restore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceKind":
            suggest = "resource_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupKindResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupKindResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupKindResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: str,
                 resource_kind: str):
        """
        This is a direct map to the Kubernetes GroupKind type [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind) and is used for identifying specific "types" of resources to restore.
        :param str resource_group: API group string of a Kubernetes resource, e.g. "apiextensions.k8s.io", "storage.k8s.io", etc. Note: use empty string for core API group
        :param str resource_kind: Kind of a Kubernetes resource, e.g. "CustomResourceDefinition", "StorageClass", etc.
        """
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "resource_kind", resource_kind)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        API group string of a Kubernetes resource, e.g. "apiextensions.k8s.io", "storage.k8s.io", etc. Note: use empty string for core API group
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> str:
        """
        Kind of a Kubernetes resource, e.g. "CustomResourceDefinition", "StorageClass", etc.
        """
        return pulumi.get(self, "resource_kind")


@pulumi.output_type
class NamespacedNameResponse(dict):
    """
    A reference to a namespaced resource in Kubernetes.
    """
    def __init__(__self__, *,
                 name: str,
                 namespace: str):
        """
        A reference to a namespaced resource in Kubernetes.
        :param str name: The name of the Kubernetes resource.
        :param str namespace: The Namespace of the Kubernetes resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Kubernetes resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Namespace of the Kubernetes resource.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class NamespacedNamesResponse(dict):
    """
    A list of namespaced Kubernetes resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacedNames":
            suggest = "namespaced_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespacedNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespacedNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespacedNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespaced_names: Sequence['outputs.NamespacedNameResponse']):
        """
        A list of namespaced Kubernetes resources.
        :param Sequence['NamespacedNameResponse'] namespaced_names: A list of namespaced Kubernetes resources.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> Sequence['outputs.NamespacedNameResponse']:
        """
        A list of namespaced Kubernetes resources.
        """
        return pulumi.get(self, "namespaced_names")


@pulumi.output_type
class NamespacesResponse(dict):
    """
    A list of Kubernetes Namespaces
    """
    def __init__(__self__, *,
                 namespaces: Sequence[str]):
        """
        A list of Kubernetes Namespaces
        :param Sequence[str] namespaces: A list of Kubernetes Namespaces
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> Sequence[str]:
        """
        A list of Kubernetes Namespaces
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class RestoreConfigResponse(dict):
    """
    Configuration of a restore. Next id: 9
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNamespaces":
            suggest = "all_namespaces"
        elif key == "clusterResourceConflictPolicy":
            suggest = "cluster_resource_conflict_policy"
        elif key == "clusterResourceRestoreScope":
            suggest = "cluster_resource_restore_scope"
        elif key == "namespacedResourceRestoreMode":
            suggest = "namespaced_resource_restore_mode"
        elif key == "selectedApplications":
            suggest = "selected_applications"
        elif key == "selectedNamespaces":
            suggest = "selected_namespaces"
        elif key == "substitutionRules":
            suggest = "substitution_rules"
        elif key == "volumeDataRestorePolicy":
            suggest = "volume_data_restore_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_namespaces: bool,
                 cluster_resource_conflict_policy: str,
                 cluster_resource_restore_scope: 'outputs.ClusterResourceRestoreScopeResponse',
                 namespaced_resource_restore_mode: str,
                 selected_applications: 'outputs.NamespacedNamesResponse',
                 selected_namespaces: 'outputs.NamespacesResponse',
                 substitution_rules: Sequence['outputs.SubstitutionRuleResponse'],
                 volume_data_restore_policy: str):
        """
        Configuration of a restore. Next id: 9
        :param bool all_namespaces: Restore all namespaced resources in the Backup if set to "True". Specifying this field to "False" is an error.
        :param str cluster_resource_conflict_policy: Defines the behavior for handling the situation where cluster-scoped resources being restored already exist in the target cluster. This MUST be set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if cluster_resource_restore_scope is not empty.
        :param 'ClusterResourceRestoreScopeResponse' cluster_resource_restore_scope: Identifies the cluster-scoped resources to restore from the Backup. Not specifying it means NO cluster resource will be restored.
        :param str namespaced_resource_restore_mode: Defines the behavior for handling the situation where sets of namespaced resources being restored already exist in the target cluster. This MUST be set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
        :param 'NamespacedNamesResponse' selected_applications: A list of selected ProtectedApplications to restore. The listed ProtectedApplications and all the resources to which they refer will be restored.
        :param 'NamespacesResponse' selected_namespaces: A list of selected Namespaces to restore from the Backup. The listed Namespaces and all resources contained in them will be restored.
        :param Sequence['SubstitutionRuleResponse'] substitution_rules: A list of transformation rules to be applied against Kubernetes resources as they are selected for restoration from a Backup. Rules are executed in order defined - this order matters, as changes made by a rule may impact the filtering logic of subsequent rules. An empty list means no substitution will occur.
        :param str volume_data_restore_policy: Specifies the mechanism to be used to restore volume data. Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as NO_VOLUME_DATA_RESTORATION).
        """
        pulumi.set(__self__, "all_namespaces", all_namespaces)
        pulumi.set(__self__, "cluster_resource_conflict_policy", cluster_resource_conflict_policy)
        pulumi.set(__self__, "cluster_resource_restore_scope", cluster_resource_restore_scope)
        pulumi.set(__self__, "namespaced_resource_restore_mode", namespaced_resource_restore_mode)
        pulumi.set(__self__, "selected_applications", selected_applications)
        pulumi.set(__self__, "selected_namespaces", selected_namespaces)
        pulumi.set(__self__, "substitution_rules", substitution_rules)
        pulumi.set(__self__, "volume_data_restore_policy", volume_data_restore_policy)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> bool:
        """
        Restore all namespaced resources in the Backup if set to "True". Specifying this field to "False" is an error.
        """
        return pulumi.get(self, "all_namespaces")

    @property
    @pulumi.getter(name="clusterResourceConflictPolicy")
    def cluster_resource_conflict_policy(self) -> str:
        """
        Defines the behavior for handling the situation where cluster-scoped resources being restored already exist in the target cluster. This MUST be set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if cluster_resource_restore_scope is not empty.
        """
        return pulumi.get(self, "cluster_resource_conflict_policy")

    @property
    @pulumi.getter(name="clusterResourceRestoreScope")
    def cluster_resource_restore_scope(self) -> 'outputs.ClusterResourceRestoreScopeResponse':
        """
        Identifies the cluster-scoped resources to restore from the Backup. Not specifying it means NO cluster resource will be restored.
        """
        return pulumi.get(self, "cluster_resource_restore_scope")

    @property
    @pulumi.getter(name="namespacedResourceRestoreMode")
    def namespaced_resource_restore_mode(self) -> str:
        """
        Defines the behavior for handling the situation where sets of namespaced resources being restored already exist in the target cluster. This MUST be set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
        """
        return pulumi.get(self, "namespaced_resource_restore_mode")

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> 'outputs.NamespacedNamesResponse':
        """
        A list of selected ProtectedApplications to restore. The listed ProtectedApplications and all the resources to which they refer will be restored.
        """
        return pulumi.get(self, "selected_applications")

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> 'outputs.NamespacesResponse':
        """
        A list of selected Namespaces to restore from the Backup. The listed Namespaces and all resources contained in them will be restored.
        """
        return pulumi.get(self, "selected_namespaces")

    @property
    @pulumi.getter(name="substitutionRules")
    def substitution_rules(self) -> Sequence['outputs.SubstitutionRuleResponse']:
        """
        A list of transformation rules to be applied against Kubernetes resources as they are selected for restoration from a Backup. Rules are executed in order defined - this order matters, as changes made by a rule may impact the filtering logic of subsequent rules. An empty list means no substitution will occur.
        """
        return pulumi.get(self, "substitution_rules")

    @property
    @pulumi.getter(name="volumeDataRestorePolicy")
    def volume_data_restore_policy(self) -> str:
        """
        Specifies the mechanism to be used to restore volume data. Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as NO_VOLUME_DATA_RESTORATION).
        """
        return pulumi.get(self, "volume_data_restore_policy")


@pulumi.output_type
class RetentionPolicyResponse(dict):
    """
    RetentionPolicy defines a Backup retention policy for a BackupPlan.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupDeleteLockDays":
            suggest = "backup_delete_lock_days"
        elif key == "backupRetainDays":
            suggest = "backup_retain_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_delete_lock_days: int,
                 backup_retain_days: int,
                 locked: bool):
        """
        RetentionPolicy defines a Backup retention policy for a BackupPlan.
        :param int backup_delete_lock_days: Minimum age for Backups created via this BackupPlan (in days). This field MUST be an integer value between 0-90 (inclusive). A Backup created under this BackupPlan will NOT be deletable until it reaches Backup's (create_time + backup_delete_lock_days). Updating this field of a BackupPlan does NOT affect existing Backups under it. Backups created AFTER a successful update will inherit the new value. Default: 0 (no delete blocking)
        :param int backup_retain_days: The default maximum age of a Backup created via this BackupPlan. This field MUST be an integer value >= 0. If specified, a Backup created under this BackupPlan will be automatically deleted after its age reaches (create_time + backup_retain_days). If not specified, Backups created under this BackupPlan will NOT be subject to automatic deletion. Updating this field does NOT affect existing Backups under it. Backups created AFTER a successful update will automatically pick up the new value. NOTE: backup_retain_days must be >= backup_delete_lock_days. Default: 0 (no automatic deletion)
        :param bool locked: This flag denotes whether the retention policy of this BackupPlan is locked. If set to True, no further update is allowed on this policy, including the `locked` field itself. Default: False
        """
        pulumi.set(__self__, "backup_delete_lock_days", backup_delete_lock_days)
        pulumi.set(__self__, "backup_retain_days", backup_retain_days)
        pulumi.set(__self__, "locked", locked)

    @property
    @pulumi.getter(name="backupDeleteLockDays")
    def backup_delete_lock_days(self) -> int:
        """
        Minimum age for Backups created via this BackupPlan (in days). This field MUST be an integer value between 0-90 (inclusive). A Backup created under this BackupPlan will NOT be deletable until it reaches Backup's (create_time + backup_delete_lock_days). Updating this field of a BackupPlan does NOT affect existing Backups under it. Backups created AFTER a successful update will inherit the new value. Default: 0 (no delete blocking)
        """
        return pulumi.get(self, "backup_delete_lock_days")

    @property
    @pulumi.getter(name="backupRetainDays")
    def backup_retain_days(self) -> int:
        """
        The default maximum age of a Backup created via this BackupPlan. This field MUST be an integer value >= 0. If specified, a Backup created under this BackupPlan will be automatically deleted after its age reaches (create_time + backup_retain_days). If not specified, Backups created under this BackupPlan will NOT be subject to automatic deletion. Updating this field does NOT affect existing Backups under it. Backups created AFTER a successful update will automatically pick up the new value. NOTE: backup_retain_days must be >= backup_delete_lock_days. Default: 0 (no automatic deletion)
        """
        return pulumi.get(self, "backup_retain_days")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        This flag denotes whether the retention policy of this BackupPlan is locked. If set to True, no further update is allowed on this policy, including the `locked` field itself. Default: False
        """
        return pulumi.get(self, "locked")


@pulumi.output_type
class ScheduleResponse(dict):
    """
    Schedule defines scheduling parameters for automatically creating Backups via this BackupPlan.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronSchedule":
            suggest = "cron_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_schedule: str,
                 paused: bool):
        """
        Schedule defines scheduling parameters for automatically creating Backups via this BackupPlan.
        :param str cron_schedule: A standard [cron](https://wikipedia.com/wiki/cron) string that defines a repeating schedule for creating Backups via this BackupPlan. Default (empty): no automatic backup creation will occur.
        :param bool paused: This flag denotes whether automatic Backup creation is paused for this BackupPlan. Default: False
        """
        pulumi.set(__self__, "cron_schedule", cron_schedule)
        pulumi.set(__self__, "paused", paused)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> str:
        """
        A standard [cron](https://wikipedia.com/wiki/cron) string that defines a repeating schedule for creating Backups via this BackupPlan. Default (empty): no automatic backup creation will occur.
        """
        return pulumi.get(self, "cron_schedule")

    @property
    @pulumi.getter
    def paused(self) -> bool:
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan. Default: False
        """
        return pulumi.get(self, "paused")


@pulumi.output_type
class SubstitutionRuleResponse(dict):
    """
    A transformation rule to be applied against Kubernetes resources as they are selected for restoration from a Backup. A rule contains both filtering logic (which resources are subject to substitution) and substitution logic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newValue":
            suggest = "new_value"
        elif key == "originalValuePattern":
            suggest = "original_value_pattern"
        elif key == "targetGroupKinds":
            suggest = "target_group_kinds"
        elif key == "targetJsonPath":
            suggest = "target_json_path"
        elif key == "targetNamespaces":
            suggest = "target_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubstitutionRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubstitutionRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubstitutionRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_value: str,
                 original_value_pattern: str,
                 target_group_kinds: Sequence['outputs.GroupKindResponse'],
                 target_json_path: str,
                 target_namespaces: Sequence[str]):
        """
        A transformation rule to be applied against Kubernetes resources as they are selected for restoration from a Backup. A rule contains both filtering logic (which resources are subject to substitution) and substitution logic.
        :param str new_value: This is the new value to set for any fields that pass the filtering and selection criteria. To remove a value from a Kubernetes resource, either leave this field unspecified, or set it to the empty string ("").
        :param str original_value_pattern: (Filtering parameter) This is a [regular expression] (https://en.wikipedia.org/wiki/Regular_expression) that is compared against the fields matched by the target_json_path expression (and must also have passed the previous filters). Substitution will not be performed against fields whose value does not match this expression. If this field is NOT specified, then ALL fields matched by the target_json_path expression will undergo substitution. Note that an empty (e.g., "", rather than unspecified) value for for this field will only match empty fields.
        :param Sequence['GroupKindResponse'] target_group_kinds: (Filtering parameter) Any resource subject to substitution must belong to one of the listed "types". If this field is not provided, no type filtering will be performed (all resources of all types matching previous filtering parameters will be candidates for substitution).
        :param str target_json_path: This is a [JSONPath] (https://kubernetes.io/docs/reference/kubectl/jsonpath/) expression that matches specific fields of candidate resources and it operates as both a filtering parameter (resources that are not matched with this expression will not be candidates for substitution) as well as a field identifier (identifies exactly which fields out of the candidate resources will be modified).
        :param Sequence[str] target_namespaces: (Filtering parameter) Any resource subject to substitution must be contained within one of the listed Kubernetes Namespace in the Backup. If this field is not provided, no namespace filtering will be performed (all resources in all Namespaces, including all cluster-scoped resources, will be candidates for substitution). To mix cluster-scoped and namespaced resources in the same rule, use an empty string ("") as one of the target namespaces.
        """
        pulumi.set(__self__, "new_value", new_value)
        pulumi.set(__self__, "original_value_pattern", original_value_pattern)
        pulumi.set(__self__, "target_group_kinds", target_group_kinds)
        pulumi.set(__self__, "target_json_path", target_json_path)
        pulumi.set(__self__, "target_namespaces", target_namespaces)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> str:
        """
        This is the new value to set for any fields that pass the filtering and selection criteria. To remove a value from a Kubernetes resource, either leave this field unspecified, or set it to the empty string ("").
        """
        return pulumi.get(self, "new_value")

    @property
    @pulumi.getter(name="originalValuePattern")
    def original_value_pattern(self) -> str:
        """
        (Filtering parameter) This is a [regular expression] (https://en.wikipedia.org/wiki/Regular_expression) that is compared against the fields matched by the target_json_path expression (and must also have passed the previous filters). Substitution will not be performed against fields whose value does not match this expression. If this field is NOT specified, then ALL fields matched by the target_json_path expression will undergo substitution. Note that an empty (e.g., "", rather than unspecified) value for for this field will only match empty fields.
        """
        return pulumi.get(self, "original_value_pattern")

    @property
    @pulumi.getter(name="targetGroupKinds")
    def target_group_kinds(self) -> Sequence['outputs.GroupKindResponse']:
        """
        (Filtering parameter) Any resource subject to substitution must belong to one of the listed "types". If this field is not provided, no type filtering will be performed (all resources of all types matching previous filtering parameters will be candidates for substitution).
        """
        return pulumi.get(self, "target_group_kinds")

    @property
    @pulumi.getter(name="targetJsonPath")
    def target_json_path(self) -> str:
        """
        This is a [JSONPath] (https://kubernetes.io/docs/reference/kubectl/jsonpath/) expression that matches specific fields of candidate resources and it operates as both a filtering parameter (resources that are not matched with this expression will not be candidates for substitution) as well as a field identifier (identifies exactly which fields out of the candidate resources will be modified).
        """
        return pulumi.get(self, "target_json_path")

    @property
    @pulumi.getter(name="targetNamespaces")
    def target_namespaces(self) -> Sequence[str]:
        """
        (Filtering parameter) Any resource subject to substitution must be contained within one of the listed Kubernetes Namespace in the Backup. If this field is not provided, no namespace filtering will be performed (all resources in all Namespaces, including all cluster-scoped resources, will be candidates for substitution). To mix cluster-scoped and namespaced resources in the same rule, use an empty string ("") as one of the target namespaces.
        """
        return pulumi.get(self, "target_namespaces")


