# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetBackupResult',
    'AwaitableGetBackupResult',
    'get_backup',
    'get_backup_output',
]

@pulumi.output_type
class GetBackupResult:
    def __init__(__self__, all_namespaces=None, cluster_metadata=None, complete_time=None, config_backup_size_bytes=None, contains_secrets=None, contains_volume_data=None, create_time=None, delete_lock_days=None, delete_lock_expire_time=None, description=None, encryption_key=None, etag=None, labels=None, manual=None, name=None, pod_count=None, resource_count=None, retain_days=None, retain_expire_time=None, selected_applications=None, selected_namespaces=None, size_bytes=None, state=None, state_reason=None, uid=None, update_time=None, volume_count=None):
        if all_namespaces and not isinstance(all_namespaces, bool):
            raise TypeError("Expected argument 'all_namespaces' to be a bool")
        pulumi.set(__self__, "all_namespaces", all_namespaces)
        if cluster_metadata and not isinstance(cluster_metadata, dict):
            raise TypeError("Expected argument 'cluster_metadata' to be a dict")
        pulumi.set(__self__, "cluster_metadata", cluster_metadata)
        if complete_time and not isinstance(complete_time, str):
            raise TypeError("Expected argument 'complete_time' to be a str")
        pulumi.set(__self__, "complete_time", complete_time)
        if config_backup_size_bytes and not isinstance(config_backup_size_bytes, str):
            raise TypeError("Expected argument 'config_backup_size_bytes' to be a str")
        pulumi.set(__self__, "config_backup_size_bytes", config_backup_size_bytes)
        if contains_secrets and not isinstance(contains_secrets, bool):
            raise TypeError("Expected argument 'contains_secrets' to be a bool")
        pulumi.set(__self__, "contains_secrets", contains_secrets)
        if contains_volume_data and not isinstance(contains_volume_data, bool):
            raise TypeError("Expected argument 'contains_volume_data' to be a bool")
        pulumi.set(__self__, "contains_volume_data", contains_volume_data)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delete_lock_days and not isinstance(delete_lock_days, int):
            raise TypeError("Expected argument 'delete_lock_days' to be a int")
        pulumi.set(__self__, "delete_lock_days", delete_lock_days)
        if delete_lock_expire_time and not isinstance(delete_lock_expire_time, str):
            raise TypeError("Expected argument 'delete_lock_expire_time' to be a str")
        pulumi.set(__self__, "delete_lock_expire_time", delete_lock_expire_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if encryption_key and not isinstance(encryption_key, dict):
            raise TypeError("Expected argument 'encryption_key' to be a dict")
        pulumi.set(__self__, "encryption_key", encryption_key)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if manual and not isinstance(manual, bool):
            raise TypeError("Expected argument 'manual' to be a bool")
        pulumi.set(__self__, "manual", manual)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pod_count and not isinstance(pod_count, int):
            raise TypeError("Expected argument 'pod_count' to be a int")
        pulumi.set(__self__, "pod_count", pod_count)
        if resource_count and not isinstance(resource_count, int):
            raise TypeError("Expected argument 'resource_count' to be a int")
        pulumi.set(__self__, "resource_count", resource_count)
        if retain_days and not isinstance(retain_days, int):
            raise TypeError("Expected argument 'retain_days' to be a int")
        pulumi.set(__self__, "retain_days", retain_days)
        if retain_expire_time and not isinstance(retain_expire_time, str):
            raise TypeError("Expected argument 'retain_expire_time' to be a str")
        pulumi.set(__self__, "retain_expire_time", retain_expire_time)
        if selected_applications and not isinstance(selected_applications, dict):
            raise TypeError("Expected argument 'selected_applications' to be a dict")
        pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces and not isinstance(selected_namespaces, dict):
            raise TypeError("Expected argument 'selected_namespaces' to be a dict")
        pulumi.set(__self__, "selected_namespaces", selected_namespaces)
        if size_bytes and not isinstance(size_bytes, str):
            raise TypeError("Expected argument 'size_bytes' to be a str")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_reason and not isinstance(state_reason, str):
            raise TypeError("Expected argument 'state_reason' to be a str")
        pulumi.set(__self__, "state_reason", state_reason)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if volume_count and not isinstance(volume_count, int):
            raise TypeError("Expected argument 'volume_count' to be a int")
        pulumi.set(__self__, "volume_count", volume_count)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> bool:
        """
        If True, all namespaces were included in the Backup.
        """
        return pulumi.get(self, "all_namespaces")

    @property
    @pulumi.getter(name="clusterMetadata")
    def cluster_metadata(self) -> 'outputs.ClusterMetadataResponse':
        """
        Information about the GKE cluster from which this Backup was created.
        """
        return pulumi.get(self, "cluster_metadata")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> str:
        """
        Completion time of the Backup
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="configBackupSizeBytes")
    def config_backup_size_bytes(self) -> str:
        """
        The size of the config backup in bytes.
        """
        return pulumi.get(self, "config_backup_size_bytes")

    @property
    @pulumi.getter(name="containsSecrets")
    def contains_secrets(self) -> bool:
        """
        Whether or not the Backup contains Kubernetes Secrets. Controlled by the parent BackupPlan's include_secrets value.
        """
        return pulumi.get(self, "contains_secrets")

    @property
    @pulumi.getter(name="containsVolumeData")
    def contains_volume_data(self) -> bool:
        """
        Whether or not the Backup contains volume data. Controlled by the parent BackupPlan's include_volume_data value.
        """
        return pulumi.get(self, "contains_volume_data")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The timestamp when this Backup resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteLockDays")
    def delete_lock_days(self) -> int:
        """
        Minimum age for this Backup (in days). If this field is set to a non-zero value, the Backup will be "locked" against deletion (either manual or automatic deletion) for the number of days provided (measured from the creation time of the Backup). MUST be an integer value between 0-90 (inclusive). Defaults to parent BackupPlan's backup_delete_lock_days setting and may only be increased (either at creation time or in a subsequent update).
        """
        return pulumi.get(self, "delete_lock_days")

    @property
    @pulumi.getter(name="deleteLockExpireTime")
    def delete_lock_expire_time(self) -> str:
        """
        The time at which an existing delete lock will expire for this backup (calculated from create_time + delete_lock_days).
        """
        return pulumi.get(self, "delete_lock_expire_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User specified descriptive string for this Backup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> 'outputs.EncryptionKeyResponse':
        """
        The customer managed encryption key that was used to encrypt the Backup's artifacts. Inherited from the parent BackupPlan's encryption_key value.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a backup from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform backup updates in order to avoid race conditions: An `etag` is returned in the response to `GetBackup`, and systems are expected to put that etag in the request to `UpdateBackup` or `DeleteBackup` to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of custom labels supplied by user.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def manual(self) -> bool:
        """
        This flag indicates whether this Backup resource was created manually by a user or via a schedule in the BackupPlan. A value of True means that the Backup was created manually.
        """
        return pulumi.get(self, "manual")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully qualified name of the Backup. projects/*/locations/*/backupPlans/*/backups/*
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="podCount")
    def pod_count(self) -> int:
        """
        The total number of Kubernetes Pods contained in the Backup.
        """
        return pulumi.get(self, "pod_count")

    @property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> int:
        """
        The total number of Kubernetes resources included in the Backup.
        """
        return pulumi.get(self, "resource_count")

    @property
    @pulumi.getter(name="retainDays")
    def retain_days(self) -> int:
        """
        The age (in days) after which this Backup will be automatically deleted. Must be an integer value >= 0: - If 0, no automatic deletion will occur for this Backup. - If not 0, this must be >= delete_lock_days. Once a Backup is created, this value may only be increased. Defaults to the parent BackupPlan's backup_retain_days value.
        """
        return pulumi.get(self, "retain_days")

    @property
    @pulumi.getter(name="retainExpireTime")
    def retain_expire_time(self) -> str:
        """
        The time at which this Backup will be automatically deleted (calculated from create_time + retain_days).
        """
        return pulumi.get(self, "retain_expire_time")

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> 'outputs.NamespacedNamesResponse':
        """
        If set, the list of ProtectedApplications whose resources were included in the Backup.
        """
        return pulumi.get(self, "selected_applications")

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> 'outputs.NamespacesResponse':
        """
        If set, the list of namespaces that were included in the Backup.
        """
        return pulumi.get(self, "selected_namespaces")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> str:
        """
        The total size of the Backup in bytes = config backup size + sum(volume backup sizes)
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the Backup
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> str:
        """
        Human-readable description of why the backup is in the current `state`.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Server generated global unique identifier of [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The timestamp when this Backup resource was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="volumeCount")
    def volume_count(self) -> int:
        """
        The total number of volume backups contained in the Backup.
        """
        return pulumi.get(self, "volume_count")


class AwaitableGetBackupResult(GetBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupResult(
            all_namespaces=self.all_namespaces,
            cluster_metadata=self.cluster_metadata,
            complete_time=self.complete_time,
            config_backup_size_bytes=self.config_backup_size_bytes,
            contains_secrets=self.contains_secrets,
            contains_volume_data=self.contains_volume_data,
            create_time=self.create_time,
            delete_lock_days=self.delete_lock_days,
            delete_lock_expire_time=self.delete_lock_expire_time,
            description=self.description,
            encryption_key=self.encryption_key,
            etag=self.etag,
            labels=self.labels,
            manual=self.manual,
            name=self.name,
            pod_count=self.pod_count,
            resource_count=self.resource_count,
            retain_days=self.retain_days,
            retain_expire_time=self.retain_expire_time,
            selected_applications=self.selected_applications,
            selected_namespaces=self.selected_namespaces,
            size_bytes=self.size_bytes,
            state=self.state,
            state_reason=self.state_reason,
            uid=self.uid,
            update_time=self.update_time,
            volume_count=self.volume_count)


def get_backup(backup_id: Optional[str] = None,
               backup_plan_id: Optional[str] = None,
               location: Optional[str] = None,
               project: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupResult:
    """
    Retrieve the details of a single Backup.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['backupPlanId'] = backup_plan_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:gkebackup/v1:getBackup', __args__, opts=opts, typ=GetBackupResult).value

    return AwaitableGetBackupResult(
        all_namespaces=__ret__.all_namespaces,
        cluster_metadata=__ret__.cluster_metadata,
        complete_time=__ret__.complete_time,
        config_backup_size_bytes=__ret__.config_backup_size_bytes,
        contains_secrets=__ret__.contains_secrets,
        contains_volume_data=__ret__.contains_volume_data,
        create_time=__ret__.create_time,
        delete_lock_days=__ret__.delete_lock_days,
        delete_lock_expire_time=__ret__.delete_lock_expire_time,
        description=__ret__.description,
        encryption_key=__ret__.encryption_key,
        etag=__ret__.etag,
        labels=__ret__.labels,
        manual=__ret__.manual,
        name=__ret__.name,
        pod_count=__ret__.pod_count,
        resource_count=__ret__.resource_count,
        retain_days=__ret__.retain_days,
        retain_expire_time=__ret__.retain_expire_time,
        selected_applications=__ret__.selected_applications,
        selected_namespaces=__ret__.selected_namespaces,
        size_bytes=__ret__.size_bytes,
        state=__ret__.state,
        state_reason=__ret__.state_reason,
        uid=__ret__.uid,
        update_time=__ret__.update_time,
        volume_count=__ret__.volume_count)


@_utilities.lift_output_func(get_backup)
def get_backup_output(backup_id: Optional[pulumi.Input[str]] = None,
                      backup_plan_id: Optional[pulumi.Input[str]] = None,
                      location: Optional[pulumi.Input[str]] = None,
                      project: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupResult]:
    """
    Retrieve the details of a single Backup.
    """
    ...
