# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetFlowResult',
    'AwaitableGetFlowResult',
    'get_flow',
    'get_flow_output',
]

@pulumi.output_type
class GetFlowResult:
    def __init__(__self__, description=None, display_name=None, event_handlers=None, name=None, nlu_settings=None, transition_route_groups=None, transition_routes=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if event_handlers and not isinstance(event_handlers, list):
            raise TypeError("Expected argument 'event_handlers' to be a list")
        pulumi.set(__self__, "event_handlers", event_handlers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nlu_settings and not isinstance(nlu_settings, dict):
            raise TypeError("Expected argument 'nlu_settings' to be a dict")
        pulumi.set(__self__, "nlu_settings", nlu_settings)
        if transition_route_groups and not isinstance(transition_route_groups, list):
            raise TypeError("Expected argument 'transition_route_groups' to be a list")
        pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        if transition_routes and not isinstance(transition_routes, list):
            raise TypeError("Expected argument 'transition_routes' to be a list")
        pulumi.set(__self__, "transition_routes", transition_routes)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name of the flow.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3EventHandlerResponse']:
        """
        A flow's event handlers serve two purposes: * They are responsible for handling events (e.g. no match, webhook errors) in the flow. * They are inherited by every page's event handlers, which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow. Unlike transition_routes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
        """
        return pulumi.get(self, "event_handlers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of the flow. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nluSettings")
    def nlu_settings(self) -> 'outputs.GoogleCloudDialogflowCxV3NluSettingsResponse':
        """
        NLU related settings of the flow.
        """
        return pulumi.get(self, "nlu_settings")

    @property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Sequence[str]:
        """
        A flow's transition route group serve two purposes: * They are responsible for matching the user's first utterances in the flow. * They are inherited by every page's transition route groups. Transition route groups defined in the page have higher priority than those defined in the flow. Format:`projects//locations//agents//flows//transitionRouteGroups/`.
        """
        return pulumi.get(self, "transition_route_groups")

    @property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3TransitionRouteResponse']:
        """
        A flow's transition routes serve two purposes: * They are responsible for matching the user's first utterances in the flow. * They are inherited by every page's transition routes and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow. TransitionRoutes are evalauted in the following order: * TransitionRoutes with intent specified. * TransitionRoutes with only condition specified. TransitionRoutes with intent specified are inherited by pages in the flow.
        """
        return pulumi.get(self, "transition_routes")


class AwaitableGetFlowResult(GetFlowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowResult(
            description=self.description,
            display_name=self.display_name,
            event_handlers=self.event_handlers,
            name=self.name,
            nlu_settings=self.nlu_settings,
            transition_route_groups=self.transition_route_groups,
            transition_routes=self.transition_routes)


def get_flow(agent_id: Optional[str] = None,
             flow_id: Optional[str] = None,
             language_code: Optional[str] = None,
             location: Optional[str] = None,
             project: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowResult:
    """
    Retrieves the specified flow.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['flowId'] = flow_id
    __args__['languageCode'] = language_code
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dialogflow/v3:getFlow', __args__, opts=opts, typ=GetFlowResult).value

    return AwaitableGetFlowResult(
        description=__ret__.description,
        display_name=__ret__.display_name,
        event_handlers=__ret__.event_handlers,
        name=__ret__.name,
        nlu_settings=__ret__.nlu_settings,
        transition_route_groups=__ret__.transition_route_groups,
        transition_routes=__ret__.transition_routes)


@_utilities.lift_output_func(get_flow)
def get_flow_output(agent_id: Optional[pulumi.Input[str]] = None,
                    flow_id: Optional[pulumi.Input[str]] = None,
                    language_code: Optional[pulumi.Input[Optional[str]]] = None,
                    location: Optional[pulumi.Input[str]] = None,
                    project: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlowResult]:
    """
    Retrieves the specified flow.
    """
    ...
