# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
    'get_group_output',
]

@pulumi.output_type
class GetGroupResult:
    def __init__(__self__, create_time=None, description=None, display_name=None, dynamic_group_metadata=None, group_key=None, labels=None, name=None, parent=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dynamic_group_metadata and not isinstance(dynamic_group_metadata, dict):
            raise TypeError("Expected argument 'dynamic_group_metadata' to be a dict")
        pulumi.set(__self__, "dynamic_group_metadata", dynamic_group_metadata)
        if group_key and not isinstance(group_key, dict):
            raise TypeError("Expected argument 'group_key' to be a dict")
        pulumi.set(__self__, "group_key", group_key)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the `Group` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An extended description to help users determine the purpose of a `Group`. Must not be longer than 4,096 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the `Group`.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dynamicGroupMetadata")
    def dynamic_group_metadata(self) -> 'outputs.DynamicGroupMetadataResponse':
        """
        Optional. Dynamic group metadata like queries and status.
        """
        return pulumi.get(self, "dynamic_group_metadata")

    @property
    @pulumi.getter(name="groupKey")
    def group_key(self) -> 'outputs.EntityKeyResponse':
        """
        The `EntityKey` of the `Group`.
        """
        return pulumi.get(self, "group_key")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        One or more label entries that apply to the Group. Currently supported labels contain a key with an empty value. Google Groups are the default type of group and have a label with a key of `cloudidentity.googleapis.com/groups.discussion_forum` and an empty value. Existing Google Groups can have an additional label with a key of `cloudidentity.googleapis.com/groups.security` and an empty value added to them. **This is an immutable change and the security label cannot be removed once added.** Dynamic groups have a label with a key of `cloudidentity.googleapis.com/groups.dynamic`. Identity-mapped groups for Cloud Search have a label with a key of `system/groups/external` and an empty value.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall be of the form `groups/{group}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> str:
        """
        Immutable. The resource name of the entity under which this `Group` resides in the Cloud Identity resource hierarchy. Must be of the form `identitysources/{identity_source}` for external- identity-mapped groups or `customers/{customer}` for Google Groups. The `customer` must begin with "C" (for example, 'C046psxkn').
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the `Group` was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            create_time=self.create_time,
            description=self.description,
            display_name=self.display_name,
            dynamic_group_metadata=self.dynamic_group_metadata,
            group_key=self.group_key,
            labels=self.labels,
            name=self.name,
            parent=self.parent,
            update_time=self.update_time)


def get_group(group_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Retrieves a `Group`.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudidentity/v1:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        display_name=__ret__.display_name,
        dynamic_group_metadata=__ret__.dynamic_group_metadata,
        group_key=__ret__.group_key,
        labels=__ret__.labels,
        name=__ret__.name,
        parent=__ret__.parent,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_group)
def get_group_output(group_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGroupResult]:
    """
    Retrieves a `Group`.
    """
    ...
