# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudChannelV1AssociationInfoResponse',
    'GoogleCloudChannelV1CloudIdentityInfoResponse',
    'GoogleCloudChannelV1CommitmentSettingsResponse',
    'GoogleCloudChannelV1ContactInfoResponse',
    'GoogleCloudChannelV1EduDataResponse',
    'GoogleCloudChannelV1ParameterResponse',
    'GoogleCloudChannelV1PercentageAdjustmentResponse',
    'GoogleCloudChannelV1PeriodResponse',
    'GoogleCloudChannelV1ProvisionedServiceResponse',
    'GoogleCloudChannelV1RenewalSettingsResponse',
    'GoogleCloudChannelV1RepricingAdjustmentResponse',
    'GoogleCloudChannelV1RepricingConfigChannelPartnerGranularityResponse',
    'GoogleCloudChannelV1RepricingConfigEntitlementGranularityResponse',
    'GoogleCloudChannelV1RepricingConfigResponse',
    'GoogleCloudChannelV1TrialSettingsResponse',
    'GoogleCloudChannelV1ValueResponse',
    'GoogleTypeDateResponse',
    'GoogleTypeDecimalResponse',
    'GoogleTypePostalAddressResponse',
]

@pulumi.output_type
class GoogleCloudChannelV1AssociationInfoResponse(dict):
    """
    Association links that an entitlement has to other entitlements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseEntitlement":
            suggest = "base_entitlement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1AssociationInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1AssociationInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1AssociationInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_entitlement: str):
        """
        Association links that an entitlement has to other entitlements.
        :param str base_entitlement: The name of the base entitlement, for which this entitlement is an add-on.
        """
        pulumi.set(__self__, "base_entitlement", base_entitlement)

    @property
    @pulumi.getter(name="baseEntitlement")
    def base_entitlement(self) -> str:
        """
        The name of the base entitlement, for which this entitlement is an add-on.
        """
        return pulumi.get(self, "base_entitlement")


@pulumi.output_type
class GoogleCloudChannelV1CloudIdentityInfoResponse(dict):
    """
    Cloud Identity information for the Cloud Channel Customer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminConsoleUri":
            suggest = "admin_console_uri"
        elif key == "alternateEmail":
            suggest = "alternate_email"
        elif key == "customerType":
            suggest = "customer_type"
        elif key == "eduData":
            suggest = "edu_data"
        elif key == "isDomainVerified":
            suggest = "is_domain_verified"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "primaryDomain":
            suggest = "primary_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1CloudIdentityInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1CloudIdentityInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1CloudIdentityInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_console_uri: str,
                 alternate_email: str,
                 customer_type: str,
                 edu_data: 'outputs.GoogleCloudChannelV1EduDataResponse',
                 is_domain_verified: bool,
                 language_code: str,
                 phone_number: str,
                 primary_domain: str):
        """
        Cloud Identity information for the Cloud Channel Customer.
        :param str admin_console_uri: URI of Customer's Admin console dashboard.
        :param str alternate_email: The alternate email.
        :param str customer_type: CustomerType indicates verification type needed for using services.
        :param 'GoogleCloudChannelV1EduDataResponse' edu_data: Edu information about the customer.
        :param bool is_domain_verified: Whether the domain is verified. This field is not returned for a Customer's cloud_identity_info resource. Partners can use the domains.get() method of the Workspace SDK's Directory API, or listen to the PRIMARY_DOMAIN_VERIFIED Pub/Sub event in to track domain verification of their resolve Workspace customers.
        :param str language_code: Language code.
        :param str phone_number: Phone number associated with the Cloud Identity.
        :param str primary_domain: The primary domain name.
        """
        pulumi.set(__self__, "admin_console_uri", admin_console_uri)
        pulumi.set(__self__, "alternate_email", alternate_email)
        pulumi.set(__self__, "customer_type", customer_type)
        pulumi.set(__self__, "edu_data", edu_data)
        pulumi.set(__self__, "is_domain_verified", is_domain_verified)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "primary_domain", primary_domain)

    @property
    @pulumi.getter(name="adminConsoleUri")
    def admin_console_uri(self) -> str:
        """
        URI of Customer's Admin console dashboard.
        """
        return pulumi.get(self, "admin_console_uri")

    @property
    @pulumi.getter(name="alternateEmail")
    def alternate_email(self) -> str:
        """
        The alternate email.
        """
        return pulumi.get(self, "alternate_email")

    @property
    @pulumi.getter(name="customerType")
    def customer_type(self) -> str:
        """
        CustomerType indicates verification type needed for using services.
        """
        return pulumi.get(self, "customer_type")

    @property
    @pulumi.getter(name="eduData")
    def edu_data(self) -> 'outputs.GoogleCloudChannelV1EduDataResponse':
        """
        Edu information about the customer.
        """
        return pulumi.get(self, "edu_data")

    @property
    @pulumi.getter(name="isDomainVerified")
    def is_domain_verified(self) -> bool:
        """
        Whether the domain is verified. This field is not returned for a Customer's cloud_identity_info resource. Partners can use the domains.get() method of the Workspace SDK's Directory API, or listen to the PRIMARY_DOMAIN_VERIFIED Pub/Sub event in to track domain verification of their resolve Workspace customers.
        """
        return pulumi.get(self, "is_domain_verified")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Language code.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Phone number associated with the Cloud Identity.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="primaryDomain")
    def primary_domain(self) -> str:
        """
        The primary domain name.
        """
        return pulumi.get(self, "primary_domain")


@pulumi.output_type
class GoogleCloudChannelV1CommitmentSettingsResponse(dict):
    """
    Commitment settings for commitment-based offers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "renewalSettings":
            suggest = "renewal_settings"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1CommitmentSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1CommitmentSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1CommitmentSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 renewal_settings: 'outputs.GoogleCloudChannelV1RenewalSettingsResponse',
                 start_time: str):
        """
        Commitment settings for commitment-based offers.
        :param str end_time: Commitment end timestamp.
        :param 'GoogleCloudChannelV1RenewalSettingsResponse' renewal_settings: Optional. Renewal settings applicable for a commitment-based Offer.
        :param str start_time: Commitment start timestamp.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "renewal_settings", renewal_settings)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Commitment end timestamp.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="renewalSettings")
    def renewal_settings(self) -> 'outputs.GoogleCloudChannelV1RenewalSettingsResponse':
        """
        Optional. Renewal settings applicable for a commitment-based Offer.
        """
        return pulumi.get(self, "renewal_settings")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Commitment start timestamp.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GoogleCloudChannelV1ContactInfoResponse(dict):
    """
    Contact information for a customer account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1ContactInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1ContactInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1ContactInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 email: str,
                 first_name: str,
                 last_name: str,
                 phone: str,
                 title: str):
        """
        Contact information for a customer account.
        :param str display_name: The customer account contact's display name, formatted as a combination of the customer's first and last name.
        :param str email: The customer account's contact email. Required for entitlements that create admin.google.com accounts, and serves as the customer's username for those accounts. Use this email to invite Team customers.
        :param str first_name: The customer account contact's first name. Optional for Team customers.
        :param str last_name: The customer account contact's last name. Optional for Team customers.
        :param str phone: The customer account's contact phone number.
        :param str title: Optional. The customer account contact's job title.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The customer account contact's display name, formatted as a combination of the customer's first and last name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The customer account's contact email. Required for entitlements that create admin.google.com accounts, and serves as the customer's username for those accounts. Use this email to invite Team customers.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The customer account contact's first name. Optional for Team customers.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The customer account contact's last name. Optional for Team customers.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def phone(self) -> str:
        """
        The customer account's contact phone number.
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. The customer account contact's job title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudChannelV1EduDataResponse(dict):
    """
    Required Edu Attributes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instituteSize":
            suggest = "institute_size"
        elif key == "instituteType":
            suggest = "institute_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1EduDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1EduDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1EduDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 institute_size: str,
                 institute_type: str,
                 website: str):
        """
        Required Edu Attributes
        :param str institute_size: Size of the institute.
        :param str institute_type: Designated institute type of customer.
        :param str website: Web address for the edu customer's institution.
        """
        pulumi.set(__self__, "institute_size", institute_size)
        pulumi.set(__self__, "institute_type", institute_type)
        pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter(name="instituteSize")
    def institute_size(self) -> str:
        """
        Size of the institute.
        """
        return pulumi.get(self, "institute_size")

    @property
    @pulumi.getter(name="instituteType")
    def institute_type(self) -> str:
        """
        Designated institute type of customer.
        """
        return pulumi.get(self, "institute_type")

    @property
    @pulumi.getter
    def website(self) -> str:
        """
        Web address for the edu customer's institution.
        """
        return pulumi.get(self, "website")


@pulumi.output_type
class GoogleCloudChannelV1ParameterResponse(dict):
    """
    Definition for extended entitlement parameters.
    """
    def __init__(__self__, *,
                 editable: bool,
                 name: str,
                 value: 'outputs.GoogleCloudChannelV1ValueResponse'):
        """
        Definition for extended entitlement parameters.
        :param bool editable: Specifies whether this parameter is allowed to be changed. For example, for a Google Workspace Business Starter entitlement in commitment plan, num_units is editable when entitlement is active.
        :param str name: Name of the parameter.
        :param 'GoogleCloudChannelV1ValueResponse' value: Value of the parameter.
        """
        pulumi.set(__self__, "editable", editable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def editable(self) -> bool:
        """
        Specifies whether this parameter is allowed to be changed. For example, for a Google Workspace Business Starter entitlement in commitment plan, num_units is editable when entitlement is active.
        """
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.GoogleCloudChannelV1ValueResponse':
        """
        Value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudChannelV1PercentageAdjustmentResponse(dict):
    """
    An adjustment that applies a flat markup or markdown to an entire bill.
    """
    def __init__(__self__, *,
                 percentage: 'outputs.GoogleTypeDecimalResponse'):
        """
        An adjustment that applies a flat markup or markdown to an entire bill.
        :param 'GoogleTypeDecimalResponse' percentage: The percentage of the bill to adjust. For example: Mark down by 1% => "-1.00" Mark up by 1% => "1.00" Pass-Through => "0.00"
        """
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def percentage(self) -> 'outputs.GoogleTypeDecimalResponse':
        """
        The percentage of the bill to adjust. For example: Mark down by 1% => "-1.00" Mark up by 1% => "1.00" Pass-Through => "0.00"
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class GoogleCloudChannelV1PeriodResponse(dict):
    """
    Represents period in days/months/years.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "periodType":
            suggest = "period_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1PeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1PeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1PeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 period_type: str):
        """
        Represents period in days/months/years.
        :param int duration: Total duration of Period Type defined.
        :param str period_type: Period Type.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "period_type", period_type)

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Total duration of Period Type defined.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> str:
        """
        Period Type.
        """
        return pulumi.get(self, "period_type")


@pulumi.output_type
class GoogleCloudChannelV1ProvisionedServiceResponse(dict):
    """
    Service provisioned for an entitlement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "productId":
            suggest = "product_id"
        elif key == "provisioningId":
            suggest = "provisioning_id"
        elif key == "skuId":
            suggest = "sku_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1ProvisionedServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1ProvisionedServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1ProvisionedServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 product_id: str,
                 provisioning_id: str,
                 sku_id: str):
        """
        Service provisioned for an entitlement.
        :param str product_id: The product pertaining to the provisioning resource as specified in the Offer.
        :param str provisioning_id: Provisioning ID of the entitlement. For Google Workspace, this is the underlying Subscription ID. For Google Cloud Platform, this is the Billing Account ID of the billing subaccount."
        :param str sku_id: The SKU pertaining to the provisioning resource as specified in the Offer.
        """
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "provisioning_id", provisioning_id)
        pulumi.set(__self__, "sku_id", sku_id)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> str:
        """
        The product pertaining to the provisioning resource as specified in the Offer.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="provisioningId")
    def provisioning_id(self) -> str:
        """
        Provisioning ID of the entitlement. For Google Workspace, this is the underlying Subscription ID. For Google Cloud Platform, this is the Billing Account ID of the billing subaccount."
        """
        return pulumi.get(self, "provisioning_id")

    @property
    @pulumi.getter(name="skuId")
    def sku_id(self) -> str:
        """
        The SKU pertaining to the provisioning resource as specified in the Offer.
        """
        return pulumi.get(self, "sku_id")


@pulumi.output_type
class GoogleCloudChannelV1RenewalSettingsResponse(dict):
    """
    Renewal settings for renewable Offers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableRenewal":
            suggest = "enable_renewal"
        elif key == "paymentCycle":
            suggest = "payment_cycle"
        elif key == "paymentPlan":
            suggest = "payment_plan"
        elif key == "resizeUnitCount":
            suggest = "resize_unit_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1RenewalSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1RenewalSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1RenewalSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_renewal: bool,
                 payment_cycle: 'outputs.GoogleCloudChannelV1PeriodResponse',
                 payment_plan: str,
                 resize_unit_count: bool):
        """
        Renewal settings for renewable Offers.
        :param bool enable_renewal: If false, the plan will be completed at the end date.
        :param 'GoogleCloudChannelV1PeriodResponse' payment_cycle: Describes how frequently the reseller will be billed, such as once per month.
        :param str payment_plan: Describes how a reseller will be billed.
        :param bool resize_unit_count: If true and enable_renewal = true, the unit (for example seats or licenses) will be set to the number of active units at renewal time.
        """
        pulumi.set(__self__, "enable_renewal", enable_renewal)
        pulumi.set(__self__, "payment_cycle", payment_cycle)
        pulumi.set(__self__, "payment_plan", payment_plan)
        pulumi.set(__self__, "resize_unit_count", resize_unit_count)

    @property
    @pulumi.getter(name="enableRenewal")
    def enable_renewal(self) -> bool:
        """
        If false, the plan will be completed at the end date.
        """
        return pulumi.get(self, "enable_renewal")

    @property
    @pulumi.getter(name="paymentCycle")
    def payment_cycle(self) -> 'outputs.GoogleCloudChannelV1PeriodResponse':
        """
        Describes how frequently the reseller will be billed, such as once per month.
        """
        return pulumi.get(self, "payment_cycle")

    @property
    @pulumi.getter(name="paymentPlan")
    def payment_plan(self) -> str:
        """
        Describes how a reseller will be billed.
        """
        return pulumi.get(self, "payment_plan")

    @property
    @pulumi.getter(name="resizeUnitCount")
    def resize_unit_count(self) -> bool:
        """
        If true and enable_renewal = true, the unit (for example seats or licenses) will be set to the number of active units at renewal time.
        """
        return pulumi.get(self, "resize_unit_count")


@pulumi.output_type
class GoogleCloudChannelV1RepricingAdjustmentResponse(dict):
    """
    A type that represents the various adjustments you can apply to a bill.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "percentageAdjustment":
            suggest = "percentage_adjustment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1RepricingAdjustmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1RepricingAdjustmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1RepricingAdjustmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percentage_adjustment: 'outputs.GoogleCloudChannelV1PercentageAdjustmentResponse'):
        """
        A type that represents the various adjustments you can apply to a bill.
        :param 'GoogleCloudChannelV1PercentageAdjustmentResponse' percentage_adjustment: Flat markup or markdown on an entire bill.
        """
        pulumi.set(__self__, "percentage_adjustment", percentage_adjustment)

    @property
    @pulumi.getter(name="percentageAdjustment")
    def percentage_adjustment(self) -> 'outputs.GoogleCloudChannelV1PercentageAdjustmentResponse':
        """
        Flat markup or markdown on an entire bill.
        """
        return pulumi.get(self, "percentage_adjustment")


@pulumi.output_type
class GoogleCloudChannelV1RepricingConfigChannelPartnerGranularityResponse(dict):
    """
    Applies the repricing configuration at the channel partner level. The channel partner value is derived from the resource name. Takes an empty json object.
    """
    def __init__(__self__):
        """
        Applies the repricing configuration at the channel partner level. The channel partner value is derived from the resource name. Takes an empty json object.
        """
        pass


@pulumi.output_type
class GoogleCloudChannelV1RepricingConfigEntitlementGranularityResponse(dict):
    """
    Applies the repricing configuration at the entitlement level.
    """
    def __init__(__self__, *,
                 entitlement: str):
        """
        Applies the repricing configuration at the entitlement level.
        :param str entitlement: Resource name of the entitlement. Format: accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
        """
        pulumi.set(__self__, "entitlement", entitlement)

    @property
    @pulumi.getter
    def entitlement(self) -> str:
        """
        Resource name of the entitlement. Format: accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
        """
        return pulumi.get(self, "entitlement")


@pulumi.output_type
class GoogleCloudChannelV1RepricingConfigResponse(dict):
    """
    Configuration for repricing a Google bill over a period of time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelPartnerGranularity":
            suggest = "channel_partner_granularity"
        elif key == "effectiveInvoiceMonth":
            suggest = "effective_invoice_month"
        elif key == "entitlementGranularity":
            suggest = "entitlement_granularity"
        elif key == "rebillingBasis":
            suggest = "rebilling_basis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1RepricingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1RepricingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1RepricingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adjustment: 'outputs.GoogleCloudChannelV1RepricingAdjustmentResponse',
                 channel_partner_granularity: 'outputs.GoogleCloudChannelV1RepricingConfigChannelPartnerGranularityResponse',
                 effective_invoice_month: 'outputs.GoogleTypeDateResponse',
                 entitlement_granularity: 'outputs.GoogleCloudChannelV1RepricingConfigEntitlementGranularityResponse',
                 rebilling_basis: str):
        """
        Configuration for repricing a Google bill over a period of time.
        :param 'GoogleCloudChannelV1RepricingAdjustmentResponse' adjustment: Information about the adjustment.
        :param 'GoogleCloudChannelV1RepricingConfigChannelPartnerGranularityResponse' channel_partner_granularity: Applies the repricing configuration at the channel partner level. This is the only supported value for ChannelPartnerRepricingConfig.
        :param 'GoogleTypeDateResponse' effective_invoice_month: The YearMonth when these adjustments activate. The Day field needs to be "0" since we only accept YearMonth repricing boundaries.
        :param 'GoogleCloudChannelV1RepricingConfigEntitlementGranularityResponse' entitlement_granularity: Applies the repricing configuration at the entitlement level. This is the only supported value for CustomerRepricingConfig.
        :param str rebilling_basis: The RebillingBasis to use for this bill. Specifies the relative cost based on repricing costs you will apply.
        """
        pulumi.set(__self__, "adjustment", adjustment)
        pulumi.set(__self__, "channel_partner_granularity", channel_partner_granularity)
        pulumi.set(__self__, "effective_invoice_month", effective_invoice_month)
        pulumi.set(__self__, "entitlement_granularity", entitlement_granularity)
        pulumi.set(__self__, "rebilling_basis", rebilling_basis)

    @property
    @pulumi.getter
    def adjustment(self) -> 'outputs.GoogleCloudChannelV1RepricingAdjustmentResponse':
        """
        Information about the adjustment.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter(name="channelPartnerGranularity")
    def channel_partner_granularity(self) -> 'outputs.GoogleCloudChannelV1RepricingConfigChannelPartnerGranularityResponse':
        """
        Applies the repricing configuration at the channel partner level. This is the only supported value for ChannelPartnerRepricingConfig.
        """
        return pulumi.get(self, "channel_partner_granularity")

    @property
    @pulumi.getter(name="effectiveInvoiceMonth")
    def effective_invoice_month(self) -> 'outputs.GoogleTypeDateResponse':
        """
        The YearMonth when these adjustments activate. The Day field needs to be "0" since we only accept YearMonth repricing boundaries.
        """
        return pulumi.get(self, "effective_invoice_month")

    @property
    @pulumi.getter(name="entitlementGranularity")
    def entitlement_granularity(self) -> 'outputs.GoogleCloudChannelV1RepricingConfigEntitlementGranularityResponse':
        """
        Applies the repricing configuration at the entitlement level. This is the only supported value for CustomerRepricingConfig.
        """
        return pulumi.get(self, "entitlement_granularity")

    @property
    @pulumi.getter(name="rebillingBasis")
    def rebilling_basis(self) -> str:
        """
        The RebillingBasis to use for this bill. Specifies the relative cost based on repricing costs you will apply.
        """
        return pulumi.get(self, "rebilling_basis")


@pulumi.output_type
class GoogleCloudChannelV1TrialSettingsResponse(dict):
    """
    Settings for trial offers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1TrialSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1TrialSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1TrialSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 trial: bool):
        """
        Settings for trial offers.
        :param str end_time: Date when the trial ends. The value is in milliseconds using the UNIX Epoch format. See an example [Epoch converter](https://www.epochconverter.com).
        :param bool trial: Determines if the entitlement is in a trial or not: * `true` - The entitlement is in trial. * `false` - The entitlement is not in trial.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Date when the trial ends. The value is in milliseconds using the UNIX Epoch format. See an example [Epoch converter](https://www.epochconverter.com).
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def trial(self) -> bool:
        """
        Determines if the entitlement is in a trial or not: * `true` - The entitlement is in trial. * `false` - The entitlement is not in trial.
        """
        return pulumi.get(self, "trial")


@pulumi.output_type
class GoogleCloudChannelV1ValueResponse(dict):
    """
    Data type and value of a parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolValue":
            suggest = "bool_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "int64Value":
            suggest = "int64_value"
        elif key == "protoValue":
            suggest = "proto_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudChannelV1ValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudChannelV1ValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudChannelV1ValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_value: bool,
                 double_value: float,
                 int64_value: str,
                 proto_value: Mapping[str, str],
                 string_value: str):
        """
        Data type and value of a parameter.
        :param bool bool_value: Represents a boolean value.
        :param float double_value: Represents a double value.
        :param str int64_value: Represents an int64 value.
        :param Mapping[str, str] proto_value: Represents an 'Any' proto value.
        :param str string_value: Represents a string value.
        """
        pulumi.set(__self__, "bool_value", bool_value)
        pulumi.set(__self__, "double_value", double_value)
        pulumi.set(__self__, "int64_value", int64_value)
        pulumi.set(__self__, "proto_value", proto_value)
        pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> bool:
        """
        Represents a boolean value.
        """
        return pulumi.get(self, "bool_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> float:
        """
        Represents a double value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="int64Value")
    def int64_value(self) -> str:
        """
        Represents an int64 value.
        """
        return pulumi.get(self, "int64_value")

    @property
    @pulumi.getter(name="protoValue")
    def proto_value(self) -> Mapping[str, str]:
        """
        Represents an 'Any' proto value.
        """
        return pulumi.get(self, "proto_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> str:
        """
        Represents a string value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class GoogleTypeDateResponse(dict):
    """
    Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
    """
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class GoogleTypeDecimalResponse(dict):
    """
    A representation of a decimal value, such as 2.5. Clients may convert values into language-native decimal formats, such as Java's BigDecimal or Python's decimal.Decimal. [BigDecimal]: https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html [decimal.Decimal]: https://docs.python.org/3/library/decimal.html
    """
    def __init__(__self__, *,
                 value: str):
        """
        A representation of a decimal value, such as 2.5. Clients may convert values into language-native decimal formats, such as Java's BigDecimal or Python's decimal.Decimal. [BigDecimal]: https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html [decimal.Decimal]: https://docs.python.org/3/library/decimal.html
        :param str value: The decimal value, as a string. The string representation consists of an optional sign, `+` (`U+002B`) or `-` (`U+002D`), followed by a sequence of zero or more decimal digits ("the integer"), optionally followed by a fraction, optionally followed by an exponent. The fraction consists of a decimal point followed by zero or more decimal digits. The string must contain at least one digit in either the integer or the fraction. The number formed by the sign, the integer and the fraction is referred to as the significand. The exponent consists of the character `e` (`U+0065`) or `E` (`U+0045`) followed by one or more decimal digits. Services **should** normalize decimal values before storing them by: - Removing an explicitly-provided `+` sign (`+2.5` -> `2.5`). - Replacing a zero-length integer value with `0` (`.5` -> `0.5`). - Coercing the exponent character to lower-case (`2.5E8` -> `2.5e8`). - Removing an explicitly-provided zero exponent (`2.5e0` -> `2.5`). Services **may** perform additional normalization based on its own needs and the internal decimal implementation selected, such as shifting the decimal point and exponent value together (example: `2.5e-1` <-> `0.25`). Additionally, services **may** preserve trailing zeroes in the fraction to indicate increased precision, but are not required to do so. Note that only the `.` character is supported to divide the integer and the fraction; `,` **should not** be supported regardless of locale. Additionally, thousand separators **should not** be supported. If a service does support them, values **must** be normalized. The ENBF grammar is: DecimalString = [Sign] Significand [Exponent]; Sign = '+' | '-'; Significand = Digits '.' | [Digits] '.' Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = { '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' }; Services **should** clearly document the range of supported values, the maximum supported precision (total number of digits), and, if applicable, the scale (number of digits after the decimal point), as well as how it behaves when receiving out-of-bounds values. Services **may** choose to accept values passed as input even when the value has a higher precision or scale than the service supports, and **should** round the value to fit the supported scale. Alternatively, the service **may** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if precision would be lost. Services **should** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if the service receives a value outside of the supported range.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The decimal value, as a string. The string representation consists of an optional sign, `+` (`U+002B`) or `-` (`U+002D`), followed by a sequence of zero or more decimal digits ("the integer"), optionally followed by a fraction, optionally followed by an exponent. The fraction consists of a decimal point followed by zero or more decimal digits. The string must contain at least one digit in either the integer or the fraction. The number formed by the sign, the integer and the fraction is referred to as the significand. The exponent consists of the character `e` (`U+0065`) or `E` (`U+0045`) followed by one or more decimal digits. Services **should** normalize decimal values before storing them by: - Removing an explicitly-provided `+` sign (`+2.5` -> `2.5`). - Replacing a zero-length integer value with `0` (`.5` -> `0.5`). - Coercing the exponent character to lower-case (`2.5E8` -> `2.5e8`). - Removing an explicitly-provided zero exponent (`2.5e0` -> `2.5`). Services **may** perform additional normalization based on its own needs and the internal decimal implementation selected, such as shifting the decimal point and exponent value together (example: `2.5e-1` <-> `0.25`). Additionally, services **may** preserve trailing zeroes in the fraction to indicate increased precision, but are not required to do so. Note that only the `.` character is supported to divide the integer and the fraction; `,` **should not** be supported regardless of locale. Additionally, thousand separators **should not** be supported. If a service does support them, values **must** be normalized. The ENBF grammar is: DecimalString = [Sign] Significand [Exponent]; Sign = '+' | '-'; Significand = Digits '.' | [Digits] '.' Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = { '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' }; Services **should** clearly document the range of supported values, the maximum supported precision (total number of digits), and, if applicable, the scale (number of digits after the decimal point), as well as how it behaves when receiving out-of-bounds values. Services **may** choose to accept values passed as input even when the value has a higher precision or scale than the service supports, and **should** round the value to fit the supported scale. Alternatively, the service **may** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if precision would be lost. Services **should** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if the service receives a value outside of the supported range.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleTypePostalAddressResponse(dict):
    """
    Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an i18n-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLines":
            suggest = "address_lines"
        elif key == "administrativeArea":
            suggest = "administrative_area"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "regionCode":
            suggest = "region_code"
        elif key == "sortingCode":
            suggest = "sorting_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleTypePostalAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleTypePostalAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleTypePostalAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_lines: Sequence[str],
                 administrative_area: str,
                 language_code: str,
                 locality: str,
                 organization: str,
                 postal_code: str,
                 recipients: Sequence[str],
                 region_code: str,
                 revision: int,
                 sorting_code: str,
                 sublocality: str):
        """
        Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an i18n-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
        :param Sequence[str] address_lines: Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        :param str administrative_area: Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        :param str language_code: Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        :param str locality: Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        :param str organization: Optional. The name of the organization at the address.
        :param str postal_code: Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param Sequence[str] recipients: Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        :param str region_code: CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param int revision: The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        :param str sorting_code: Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        :param str sublocality: Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        pulumi.set(__self__, "address_lines", address_lines)
        pulumi.set(__self__, "administrative_area", administrative_area)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "region_code", region_code)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "sorting_code", sorting_code)
        pulumi.set(__self__, "sublocality", sublocality)

    @property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Sequence[str]:
        """
        Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        """
        return pulumi.get(self, "address_lines")

    @property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> str:
        """
        Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def locality(self) -> str:
        """
        Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Optional. The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> str:
        """
        Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def recipients(self) -> Sequence[str]:
        """
        Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> str:
        """
        CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sortingCode")
    def sorting_code(self) -> str:
        """
        Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        """
        return pulumi.get(self, "sorting_code")

    @property
    @pulumi.getter
    def sublocality(self) -> str:
        """
        Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        return pulumi.get(self, "sublocality")


