# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ChannelPartnerRepricingConfigArgs', 'ChannelPartnerRepricingConfig']

@pulumi.input_type
class ChannelPartnerRepricingConfigArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 channel_partner_link_id: pulumi.Input[str],
                 repricing_config: pulumi.Input['GoogleCloudChannelV1RepricingConfigArgs']):
        """
        The set of arguments for constructing a ChannelPartnerRepricingConfig resource.
        :param pulumi.Input['GoogleCloudChannelV1RepricingConfigArgs'] repricing_config: The configuration for bill modifications made by a reseller before sending it to ChannelPartner.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "channel_partner_link_id", channel_partner_link_id)
        pulumi.set(__self__, "repricing_config", repricing_config)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="channelPartnerLinkId")
    def channel_partner_link_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "channel_partner_link_id")

    @channel_partner_link_id.setter
    def channel_partner_link_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_partner_link_id", value)

    @property
    @pulumi.getter(name="repricingConfig")
    def repricing_config(self) -> pulumi.Input['GoogleCloudChannelV1RepricingConfigArgs']:
        """
        The configuration for bill modifications made by a reseller before sending it to ChannelPartner.
        """
        return pulumi.get(self, "repricing_config")

    @repricing_config.setter
    def repricing_config(self, value: pulumi.Input['GoogleCloudChannelV1RepricingConfigArgs']):
        pulumi.set(self, "repricing_config", value)


class ChannelPartnerRepricingConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 channel_partner_link_id: Optional[pulumi.Input[str]] = None,
                 repricing_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudChannelV1RepricingConfigArgs']]] = None,
                 __props__=None):
        """
        Creates a ChannelPartnerRepricingConfig. Call this method to set modifications for a specific ChannelPartner's bill. You can only create configs if the RepricingConfig.effective_invoice_month is a future month. If needed, you can create a config for the current month, with some restrictions. When creating a config for a future month, make sure there are no existing configs for that RepricingConfig.effective_invoice_month. The following restrictions are for creating configs in the current month. * This functionality is reserved for recovering from an erroneous config, and should not be used for regular business cases. * The new config will not modify exports used with other configs. Changes to the config may be immediate, but may take up to 24 hours. * There is a limit of ten configs for any ChannelPartner or RepricingConfig.effective_invoice_month. * The contained ChannelPartnerRepricingConfig.repricing_config vaule must be different from the value used in the current config for a ChannelPartner. Possible Error Codes: * PERMISSION_DENIED: If the account making the request and the account being queried are different. * INVALID_ARGUMENT: Missing or invalid required parameters in the request. Also displays if the updated config is for the current month or past months. * NOT_FOUND: The ChannelPartnerRepricingConfig specified does not exist or is not associated with the given account. * INTERNAL: Any non-user error related to technical issues in the backend. In this case, contact Cloud Channel support. Return Value: If successful, the updated ChannelPartnerRepricingConfig resource, otherwise returns an error.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudChannelV1RepricingConfigArgs']] repricing_config: The configuration for bill modifications made by a reseller before sending it to ChannelPartner.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelPartnerRepricingConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a ChannelPartnerRepricingConfig. Call this method to set modifications for a specific ChannelPartner's bill. You can only create configs if the RepricingConfig.effective_invoice_month is a future month. If needed, you can create a config for the current month, with some restrictions. When creating a config for a future month, make sure there are no existing configs for that RepricingConfig.effective_invoice_month. The following restrictions are for creating configs in the current month. * This functionality is reserved for recovering from an erroneous config, and should not be used for regular business cases. * The new config will not modify exports used with other configs. Changes to the config may be immediate, but may take up to 24 hours. * There is a limit of ten configs for any ChannelPartner or RepricingConfig.effective_invoice_month. * The contained ChannelPartnerRepricingConfig.repricing_config vaule must be different from the value used in the current config for a ChannelPartner. Possible Error Codes: * PERMISSION_DENIED: If the account making the request and the account being queried are different. * INVALID_ARGUMENT: Missing or invalid required parameters in the request. Also displays if the updated config is for the current month or past months. * NOT_FOUND: The ChannelPartnerRepricingConfig specified does not exist or is not associated with the given account. * INTERNAL: Any non-user error related to technical issues in the backend. In this case, contact Cloud Channel support. Return Value: If successful, the updated ChannelPartnerRepricingConfig resource, otherwise returns an error.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ChannelPartnerRepricingConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelPartnerRepricingConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 channel_partner_link_id: Optional[pulumi.Input[str]] = None,
                 repricing_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudChannelV1RepricingConfigArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelPartnerRepricingConfigArgs.__new__(ChannelPartnerRepricingConfigArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if channel_partner_link_id is None and not opts.urn:
                raise TypeError("Missing required property 'channel_partner_link_id'")
            __props__.__dict__["channel_partner_link_id"] = channel_partner_link_id
            if repricing_config is None and not opts.urn:
                raise TypeError("Missing required property 'repricing_config'")
            __props__.__dict__["repricing_config"] = repricing_config
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(ChannelPartnerRepricingConfig, __self__).__init__(
            'google-native:cloudchannel/v1:ChannelPartnerRepricingConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ChannelPartnerRepricingConfig':
        """
        Get an existing ChannelPartnerRepricingConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChannelPartnerRepricingConfigArgs.__new__(ChannelPartnerRepricingConfigArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["repricing_config"] = None
        __props__.__dict__["update_time"] = None
        return ChannelPartnerRepricingConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name of the ChannelPartnerRepricingConfig. Format: accounts/{account_id}/channelPartnerLinks/{channel_partner_id}/channelPartnerRepricingConfigs/{id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="repricingConfig")
    def repricing_config(self) -> pulumi.Output['outputs.GoogleCloudChannelV1RepricingConfigResponse']:
        """
        The configuration for bill modifications made by a reseller before sending it to ChannelPartner.
        """
        return pulumi.get(self, "repricing_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Timestamp of an update to the repricing rule. If `update_time` is after RepricingConfig.effective_invoice_month then it indicates this was set mid-month.
        """
        return pulumi.get(self, "update_time")

