# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    def __init__(__self__, create_time=None, description=None, expire_time=None, labels=None, managed=None, name=None, pem_certificate=None, san_dnsnames=None, scope=None, self_managed=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if managed and not isinstance(managed, dict):
            raise TypeError("Expected argument 'managed' to be a dict")
        pulumi.set(__self__, "managed", managed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pem_certificate and not isinstance(pem_certificate, str):
            raise TypeError("Expected argument 'pem_certificate' to be a str")
        pulumi.set(__self__, "pem_certificate", pem_certificate)
        if san_dnsnames and not isinstance(san_dnsnames, list):
            raise TypeError("Expected argument 'san_dnsnames' to be a list")
        pulumi.set(__self__, "san_dnsnames", san_dnsnames)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if self_managed and not isinstance(self_managed, dict):
            raise TypeError("Expected argument 'self_managed' to be a dict")
        pulumi.set(__self__, "self_managed", self_managed)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation timestamp of a Certificate.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        One or more paragraphs of text description of a certificate.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The expiry timestamp of a Certificate.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Set of labels associated with a Certificate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def managed(self) -> 'outputs.ManagedCertificateResponse':
        """
        If set, contains configuration and state of a managed certificate.
        """
        return pulumi.get(self, "managed")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-defined name of the certificate. Certificate names must be unique globally and match pattern `projects/*/locations/*/certificates/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> str:
        """
        The PEM-encoded certificate chain.
        """
        return pulumi.get(self, "pem_certificate")

    @property
    @pulumi.getter(name="sanDnsnames")
    def san_dnsnames(self) -> Sequence[str]:
        """
        The list of Subject Alternative Names of dnsName type defined in the certificate (see RFC 5280 4.2.1.6). Managed certificates that haven't been provisioned yet have this field populated with a value of the managed.domains field.
        """
        return pulumi.get(self, "san_dnsnames")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Immutable. The scope of the certificate.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> 'outputs.SelfManagedCertificateResponse':
        """
        If set, defines data of a self-managed certificate.
        """
        return pulumi.get(self, "self_managed")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last update timestamp of a Certificate.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            create_time=self.create_time,
            description=self.description,
            expire_time=self.expire_time,
            labels=self.labels,
            managed=self.managed,
            name=self.name,
            pem_certificate=self.pem_certificate,
            san_dnsnames=self.san_dnsnames,
            scope=self.scope,
            self_managed=self.self_managed,
            update_time=self.update_time)


def get_certificate(certificate_id: Optional[str] = None,
                    location: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Gets details of a single Certificate.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:certificatemanager/v1:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        expire_time=__ret__.expire_time,
        labels=__ret__.labels,
        managed=__ret__.managed,
        name=__ret__.name,
        pem_certificate=__ret__.pem_certificate,
        san_dnsnames=__ret__.san_dnsnames,
        scope=__ret__.scope,
        self_managed=__ret__.self_managed,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_certificate)
def get_certificate_output(certificate_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Gets details of a single Certificate.
    """
    ...
