# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ArgumentResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'AvroOptionsResponse',
    'BiEngineReasonResponse',
    'BiEngineStatisticsResponse',
    'BigQueryModelTrainingResponse',
    'BigtableColumnFamilyResponse',
    'BigtableColumnResponse',
    'BigtableOptionsResponse',
    'BindingResponse',
    'BqmlIterationResultResponse',
    'BqmlTrainingRunResponse',
    'BqmlTrainingRunTrainingOptionsResponse',
    'CloneDefinitionResponse',
    'ClusteringResponse',
    'ConnectionPropertyResponse',
    'CsvOptionsResponse',
    'DatasetAccessEntryResponse',
    'DatasetAccessItemResponse',
    'DatasetReferenceResponse',
    'DatasetTagsItemResponse',
    'DestinationTablePropertiesResponse',
    'DmlStatisticsResponse',
    'EncryptionConfigurationResponse',
    'ErrorProtoResponse',
    'ExplainQueryStageResponse',
    'ExplainQueryStepResponse',
    'ExprResponse',
    'ExternalDataConfigurationResponse',
    'GoogleSheetsOptionsResponse',
    'HivePartitioningOptionsResponse',
    'IterationResultResponse',
    'JobConfigurationExtractResponse',
    'JobConfigurationLoadResponse',
    'JobConfigurationQueryResponse',
    'JobConfigurationResponse',
    'JobConfigurationTableCopyResponse',
    'JobReferenceResponse',
    'JobStatistics2ReservationUsageItemResponse',
    'JobStatistics2Response',
    'JobStatistics3Response',
    'JobStatistics4Response',
    'JobStatistics5Response',
    'JobStatisticsReservationUsageItemResponse',
    'JobStatisticsResponse',
    'JobStatusResponse',
    'MaterializedViewDefinitionResponse',
    'MlStatisticsResponse',
    'ModelDefinitionModelOptionsResponse',
    'ModelDefinitionResponse',
    'ModelReferenceResponse',
    'ParquetOptionsResponse',
    'QueryParameterResponse',
    'QueryParameterTypeResponse',
    'QueryParameterTypeStructTypesItemResponse',
    'QueryParameterValueResponse',
    'QueryTimelineSampleResponse',
    'RangePartitioningRangeResponse',
    'RangePartitioningResponse',
    'RemoteFunctionOptionsResponse',
    'RoutineReferenceResponse',
    'RowAccessPolicyReferenceResponse',
    'RowLevelSecurityStatisticsResponse',
    'ScriptStackFrameResponse',
    'ScriptStatisticsResponse',
    'SessionInfoResponse',
    'SnapshotDefinitionResponse',
    'StandardSqlDataTypeResponse',
    'StandardSqlFieldResponse',
    'StandardSqlStructTypeResponse',
    'StandardSqlTableTypeResponse',
    'StreamingbufferResponse',
    'TableFieldSchemaCategoriesResponse',
    'TableFieldSchemaPolicyTagsResponse',
    'TableFieldSchemaResponse',
    'TableReferenceResponse',
    'TableSchemaResponse',
    'TimePartitioningResponse',
    'TransactionInfoResponse',
    'UserDefinedFunctionResourceResponse',
    'ViewDefinitionResponse',
]

@pulumi.output_type
class ArgumentResponse(dict):
    """
    Input/output argument of a function or a stored procedure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argumentKind":
            suggest = "argument_kind"
        elif key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArgumentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArgumentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArgumentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 argument_kind: str,
                 data_type: 'outputs.StandardSqlDataTypeResponse',
                 mode: str,
                 name: str):
        """
        Input/output argument of a function or a stored procedure.
        :param str argument_kind: Optional. Defaults to FIXED_TYPE.
        :param 'StandardSqlDataTypeResponse' data_type: Required unless argument_kind = ANY_TYPE.
        :param str mode: Optional. Specifies whether the argument is input or output. Can be set for procedures only.
        :param str name: Optional. The name of this argument. Can be absent for function return argument.
        """
        pulumi.set(__self__, "argument_kind", argument_kind)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="argumentKind")
    def argument_kind(self) -> str:
        """
        Optional. Defaults to FIXED_TYPE.
        """
        return pulumi.get(self, "argument_kind")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> 'outputs.StandardSqlDataTypeResponse':
        """
        Required unless argument_kind = ANY_TYPE.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Optional. Specifies whether the argument is input or output. Can be set for procedures only.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. The name of this argument. Can be absent for function return argument.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class AvroOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useAvroLogicalTypes":
            suggest = "use_avro_logical_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvroOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvroOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvroOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_avro_logical_types: bool):
        """
        :param bool use_avro_logical_types: [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> bool:
        """
        [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        return pulumi.get(self, "use_avro_logical_types")


@pulumi.output_type
class BiEngineReasonResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        :param str code: High-level BI Engine reason for partial or disabled acceleration.
        :param str message: Free form human-readable reason for partial or disabled acceleration.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        High-level BI Engine reason for partial or disabled acceleration.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Free form human-readable reason for partial or disabled acceleration.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class BiEngineStatisticsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biEngineMode":
            suggest = "bi_engine_mode"
        elif key == "biEngineReasons":
            suggest = "bi_engine_reasons"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BiEngineStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BiEngineStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BiEngineStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bi_engine_mode: str,
                 bi_engine_reasons: Sequence['outputs.BiEngineReasonResponse']):
        """
        :param str bi_engine_mode: Specifies which mode of BI Engine acceleration was performed (if any).
        :param Sequence['BiEngineReasonResponse'] bi_engine_reasons: In case of DISABLED or PARTIAL bi_engine_mode, these contain the explanatory reasons as to why BI Engine could not accelerate. In case the full query was accelerated, this field is not populated.
        """
        pulumi.set(__self__, "bi_engine_mode", bi_engine_mode)
        pulumi.set(__self__, "bi_engine_reasons", bi_engine_reasons)

    @property
    @pulumi.getter(name="biEngineMode")
    def bi_engine_mode(self) -> str:
        """
        Specifies which mode of BI Engine acceleration was performed (if any).
        """
        return pulumi.get(self, "bi_engine_mode")

    @property
    @pulumi.getter(name="biEngineReasons")
    def bi_engine_reasons(self) -> Sequence['outputs.BiEngineReasonResponse']:
        """
        In case of DISABLED or PARTIAL bi_engine_mode, these contain the explanatory reasons as to why BI Engine could not accelerate. In case the full query was accelerated, this field is not populated.
        """
        return pulumi.get(self, "bi_engine_reasons")


@pulumi.output_type
class BigQueryModelTrainingResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentIteration":
            suggest = "current_iteration"
        elif key == "expectedTotalIterations":
            suggest = "expected_total_iterations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigQueryModelTrainingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigQueryModelTrainingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigQueryModelTrainingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_iteration: int,
                 expected_total_iterations: str):
        """
        :param int current_iteration: [Output-only, Beta] Index of current ML training iteration. Updated during create model query job to show job progress.
        :param str expected_total_iterations: [Output-only, Beta] Expected number of iterations for the create model query job specified as num_iterations in the input query. The actual total number of iterations may be less than this number due to early stop.
        """
        pulumi.set(__self__, "current_iteration", current_iteration)
        pulumi.set(__self__, "expected_total_iterations", expected_total_iterations)

    @property
    @pulumi.getter(name="currentIteration")
    def current_iteration(self) -> int:
        """
        [Output-only, Beta] Index of current ML training iteration. Updated during create model query job to show job progress.
        """
        return pulumi.get(self, "current_iteration")

    @property
    @pulumi.getter(name="expectedTotalIterations")
    def expected_total_iterations(self) -> str:
        """
        [Output-only, Beta] Expected number of iterations for the create model query job specified as num_iterations in the input query. The actual total number of iterations may be less than this number due to early stop.
        """
        return pulumi.get(self, "expected_total_iterations")


@pulumi.output_type
class BigtableColumnFamilyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familyId":
            suggest = "family_id"
        elif key == "onlyReadLatest":
            suggest = "only_read_latest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigtableColumnFamilyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigtableColumnFamilyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigtableColumnFamilyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Sequence['outputs.BigtableColumnResponse'],
                 encoding: str,
                 family_id: str,
                 only_read_latest: bool,
                 type: str):
        """
        :param Sequence['BigtableColumnResponse'] columns: [Optional] Lists of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as .. Other columns can be accessed as a list through .Column field.
        :param str encoding: [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
        :param str family_id: Identifier of the column family.
        :param bool only_read_latest: [Optional] If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
        :param str type: [Optional] The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "family_id", family_id)
        pulumi.set(__self__, "only_read_latest", only_read_latest)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.BigtableColumnResponse']:
        """
        [Optional] Lists of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as .. Other columns can be accessed as a list through .Column field.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="familyId")
    def family_id(self) -> str:
        """
        Identifier of the column family.
        """
        return pulumi.get(self, "family_id")

    @property
    @pulumi.getter(name="onlyReadLatest")
    def only_read_latest(self) -> bool:
        """
        [Optional] If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
        """
        return pulumi.get(self, "only_read_latest")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        [Optional] The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BigtableColumnResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldName":
            suggest = "field_name"
        elif key == "onlyReadLatest":
            suggest = "only_read_latest"
        elif key == "qualifierEncoded":
            suggest = "qualifier_encoded"
        elif key == "qualifierString":
            suggest = "qualifier_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigtableColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigtableColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigtableColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding: str,
                 field_name: str,
                 only_read_latest: bool,
                 qualifier_encoded: str,
                 qualifier_string: str,
                 type: str):
        """
        :param str encoding: [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
        :param str field_name: [Optional] If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
        :param bool only_read_latest: [Optional] If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
        :param str qualifier_encoded: [Required] Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifier_string field. Otherwise, a base-64 encoded value must be set to qualifier_encoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as field_name.
        :param str type: [Optional] The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
        """
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "only_read_latest", only_read_latest)
        pulumi.set(__self__, "qualifier_encoded", qualifier_encoded)
        pulumi.set(__self__, "qualifier_string", qualifier_string)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> str:
        """
        [Optional] If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter(name="onlyReadLatest")
    def only_read_latest(self) -> bool:
        """
        [Optional] If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
        """
        return pulumi.get(self, "only_read_latest")

    @property
    @pulumi.getter(name="qualifierEncoded")
    def qualifier_encoded(self) -> str:
        """
        [Required] Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifier_string field. Otherwise, a base-64 encoded value must be set to qualifier_encoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as field_name.
        """
        return pulumi.get(self, "qualifier_encoded")

    @property
    @pulumi.getter(name="qualifierString")
    def qualifier_string(self) -> str:
        return pulumi.get(self, "qualifier_string")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        [Optional] The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BigtableOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnFamilies":
            suggest = "column_families"
        elif key == "ignoreUnspecifiedColumnFamilies":
            suggest = "ignore_unspecified_column_families"
        elif key == "readRowkeyAsString":
            suggest = "read_rowkey_as_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigtableOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigtableOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigtableOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_families: Sequence['outputs.BigtableColumnFamilyResponse'],
                 ignore_unspecified_column_families: bool,
                 read_rowkey_as_string: bool):
        """
        :param Sequence['BigtableColumnFamilyResponse'] column_families: [Optional] List of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.
        :param bool ignore_unspecified_column_families: [Optional] If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
        :param bool read_rowkey_as_string: [Optional] If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
        """
        pulumi.set(__self__, "column_families", column_families)
        pulumi.set(__self__, "ignore_unspecified_column_families", ignore_unspecified_column_families)
        pulumi.set(__self__, "read_rowkey_as_string", read_rowkey_as_string)

    @property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> Sequence['outputs.BigtableColumnFamilyResponse']:
        """
        [Optional] List of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.
        """
        return pulumi.get(self, "column_families")

    @property
    @pulumi.getter(name="ignoreUnspecifiedColumnFamilies")
    def ignore_unspecified_column_families(self) -> bool:
        """
        [Optional] If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
        """
        return pulumi.get(self, "ignore_unspecified_column_families")

    @property
    @pulumi.getter(name="readRowkeyAsString")
    def read_rowkey_as_string(self) -> bool:
        """
        [Optional] If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
        """
        return pulumi.get(self, "read_rowkey_as_string")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BqmlIterationResultResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationMs":
            suggest = "duration_ms"
        elif key == "evalLoss":
            suggest = "eval_loss"
        elif key == "learnRate":
            suggest = "learn_rate"
        elif key == "trainingLoss":
            suggest = "training_loss"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BqmlIterationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BqmlIterationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BqmlIterationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_ms: str,
                 eval_loss: float,
                 index: int,
                 learn_rate: float,
                 training_loss: float):
        """
        :param str duration_ms: [Output-only, Beta] Time taken to run the training iteration in milliseconds.
        :param float eval_loss: [Output-only, Beta] Eval loss computed on the eval data at the end of the iteration. The eval loss is used for early stopping to avoid overfitting. No eval loss if eval_split_method option is specified as no_split or auto_split with input data size less than 500 rows.
        :param int index: [Output-only, Beta] Index of the ML training iteration, starting from zero for each training run.
        :param float learn_rate: [Output-only, Beta] Learning rate used for this iteration, it varies for different training iterations if learn_rate_strategy option is not constant.
        :param float training_loss: [Output-only, Beta] Training loss computed on the training data at the end of the iteration. The training loss function is defined by model type.
        """
        pulumi.set(__self__, "duration_ms", duration_ms)
        pulumi.set(__self__, "eval_loss", eval_loss)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "learn_rate", learn_rate)
        pulumi.set(__self__, "training_loss", training_loss)

    @property
    @pulumi.getter(name="durationMs")
    def duration_ms(self) -> str:
        """
        [Output-only, Beta] Time taken to run the training iteration in milliseconds.
        """
        return pulumi.get(self, "duration_ms")

    @property
    @pulumi.getter(name="evalLoss")
    def eval_loss(self) -> float:
        """
        [Output-only, Beta] Eval loss computed on the eval data at the end of the iteration. The eval loss is used for early stopping to avoid overfitting. No eval loss if eval_split_method option is specified as no_split or auto_split with input data size less than 500 rows.
        """
        return pulumi.get(self, "eval_loss")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        [Output-only, Beta] Index of the ML training iteration, starting from zero for each training run.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="learnRate")
    def learn_rate(self) -> float:
        """
        [Output-only, Beta] Learning rate used for this iteration, it varies for different training iterations if learn_rate_strategy option is not constant.
        """
        return pulumi.get(self, "learn_rate")

    @property
    @pulumi.getter(name="trainingLoss")
    def training_loss(self) -> float:
        """
        [Output-only, Beta] Training loss computed on the training data at the end of the iteration. The training loss function is defined by model type.
        """
        return pulumi.get(self, "training_loss")


@pulumi.output_type
class BqmlTrainingRunResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iterationResults":
            suggest = "iteration_results"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "trainingOptions":
            suggest = "training_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BqmlTrainingRunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BqmlTrainingRunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BqmlTrainingRunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iteration_results: Sequence['outputs.BqmlIterationResultResponse'],
                 start_time: str,
                 state: str,
                 training_options: 'outputs.BqmlTrainingRunTrainingOptionsResponse'):
        """
        :param Sequence['BqmlIterationResultResponse'] iteration_results: [Output-only, Beta] List of each iteration results.
        :param str start_time: [Output-only, Beta] Training run start time in milliseconds since the epoch.
        :param str state: [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run successfully completed. CANCELLED: Training run cancelled by the user.
        :param 'BqmlTrainingRunTrainingOptionsResponse' training_options: [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
        """
        pulumi.set(__self__, "iteration_results", iteration_results)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "training_options", training_options)

    @property
    @pulumi.getter(name="iterationResults")
    def iteration_results(self) -> Sequence['outputs.BqmlIterationResultResponse']:
        """
        [Output-only, Beta] List of each iteration results.
        """
        return pulumi.get(self, "iteration_results")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        [Output-only, Beta] Training run start time in milliseconds since the epoch.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run successfully completed. CANCELLED: Training run cancelled by the user.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trainingOptions")
    def training_options(self) -> 'outputs.BqmlTrainingRunTrainingOptionsResponse':
        """
        [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
        """
        return pulumi.get(self, "training_options")


@pulumi.output_type
class BqmlTrainingRunTrainingOptionsResponse(dict):
    """
    [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "earlyStop":
            suggest = "early_stop"
        elif key == "l1Reg":
            suggest = "l1_reg"
        elif key == "l2Reg":
            suggest = "l2_reg"
        elif key == "learnRate":
            suggest = "learn_rate"
        elif key == "learnRateStrategy":
            suggest = "learn_rate_strategy"
        elif key == "lineSearchInitLearnRate":
            suggest = "line_search_init_learn_rate"
        elif key == "maxIteration":
            suggest = "max_iteration"
        elif key == "minRelProgress":
            suggest = "min_rel_progress"
        elif key == "warmStart":
            suggest = "warm_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BqmlTrainingRunTrainingOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BqmlTrainingRunTrainingOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BqmlTrainingRunTrainingOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 early_stop: bool,
                 l1_reg: float,
                 l2_reg: float,
                 learn_rate: float,
                 learn_rate_strategy: str,
                 line_search_init_learn_rate: float,
                 max_iteration: str,
                 min_rel_progress: float,
                 warm_start: bool):
        """
        [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
        """
        pulumi.set(__self__, "early_stop", early_stop)
        pulumi.set(__self__, "l1_reg", l1_reg)
        pulumi.set(__self__, "l2_reg", l2_reg)
        pulumi.set(__self__, "learn_rate", learn_rate)
        pulumi.set(__self__, "learn_rate_strategy", learn_rate_strategy)
        pulumi.set(__self__, "line_search_init_learn_rate", line_search_init_learn_rate)
        pulumi.set(__self__, "max_iteration", max_iteration)
        pulumi.set(__self__, "min_rel_progress", min_rel_progress)
        pulumi.set(__self__, "warm_start", warm_start)

    @property
    @pulumi.getter(name="earlyStop")
    def early_stop(self) -> bool:
        return pulumi.get(self, "early_stop")

    @property
    @pulumi.getter(name="l1Reg")
    def l1_reg(self) -> float:
        return pulumi.get(self, "l1_reg")

    @property
    @pulumi.getter(name="l2Reg")
    def l2_reg(self) -> float:
        return pulumi.get(self, "l2_reg")

    @property
    @pulumi.getter(name="learnRate")
    def learn_rate(self) -> float:
        return pulumi.get(self, "learn_rate")

    @property
    @pulumi.getter(name="learnRateStrategy")
    def learn_rate_strategy(self) -> str:
        return pulumi.get(self, "learn_rate_strategy")

    @property
    @pulumi.getter(name="lineSearchInitLearnRate")
    def line_search_init_learn_rate(self) -> float:
        return pulumi.get(self, "line_search_init_learn_rate")

    @property
    @pulumi.getter(name="maxIteration")
    def max_iteration(self) -> str:
        return pulumi.get(self, "max_iteration")

    @property
    @pulumi.getter(name="minRelProgress")
    def min_rel_progress(self) -> float:
        return pulumi.get(self, "min_rel_progress")

    @property
    @pulumi.getter(name="warmStart")
    def warm_start(self) -> bool:
        return pulumi.get(self, "warm_start")


@pulumi.output_type
class CloneDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseTableReference":
            suggest = "base_table_reference"
        elif key == "cloneTime":
            suggest = "clone_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloneDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloneDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloneDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_table_reference: 'outputs.TableReferenceResponse',
                 clone_time: str):
        """
        :param 'TableReferenceResponse' base_table_reference: [Required] Reference describing the ID of the table that was cloned.
        :param str clone_time: [Required] The time at which the base table was cloned. This value is reported in the JSON response using RFC3339 format.
        """
        pulumi.set(__self__, "base_table_reference", base_table_reference)
        pulumi.set(__self__, "clone_time", clone_time)

    @property
    @pulumi.getter(name="baseTableReference")
    def base_table_reference(self) -> 'outputs.TableReferenceResponse':
        """
        [Required] Reference describing the ID of the table that was cloned.
        """
        return pulumi.get(self, "base_table_reference")

    @property
    @pulumi.getter(name="cloneTime")
    def clone_time(self) -> str:
        """
        [Required] The time at which the base table was cloned. This value is reported in the JSON response using RFC3339 format.
        """
        return pulumi.get(self, "clone_time")


@pulumi.output_type
class ClusteringResponse(dict):
    def __init__(__self__, *,
                 fields: Sequence[str]):
        """
        :param Sequence[str] fields: [Repeated] One or more fields on which data should be clustered. Only top-level, non-repeated, simple-type fields are supported. When you cluster a table using multiple columns, the order of columns you specify is important. The order of the specified columns determines the sort order of the data.
        """
        pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Sequence[str]:
        """
        [Repeated] One or more fields on which data should be clustered. Only top-level, non-repeated, simple-type fields are supported. When you cluster a table using multiple columns, the order of columns you specify is important. The order of the specified columns determines the sort order of the data.
        """
        return pulumi.get(self, "fields")


@pulumi.output_type
class ConnectionPropertyResponse(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: [Required] Name of the connection property to set.
        :param str value: [Required] Value of the connection property.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        [Required] Name of the connection property to set.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        [Required] Value of the connection property.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CsvOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowJaggedRows":
            suggest = "allow_jagged_rows"
        elif key == "allowQuotedNewlines":
            suggest = "allow_quoted_newlines"
        elif key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "nullMarker":
            suggest = "null_marker"
        elif key == "skipLeadingRows":
            suggest = "skip_leading_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsvOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsvOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsvOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_jagged_rows: bool,
                 allow_quoted_newlines: bool,
                 encoding: str,
                 field_delimiter: str,
                 null_marker: str,
                 quote: str,
                 skip_leading_rows: str):
        """
        :param bool allow_jagged_rows: [Optional] Indicates if BigQuery should accept rows that are missing trailing optional columns. If true, BigQuery treats missing trailing columns as null values. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
        :param bool allow_quoted_newlines: [Optional] Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        :param str encoding: [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        :param str field_delimiter: [Optional] The separator for fields in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        :param str null_marker: [Optional] An custom string that will represent a NULL value in CSV import data.
        :param str quote: [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param str skip_leading_rows: [Optional] The number of rows at the top of a CSV file that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "field_delimiter", field_delimiter)
        pulumi.set(__self__, "null_marker", null_marker)
        pulumi.set(__self__, "quote", quote)
        pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> bool:
        """
        [Optional] Indicates if BigQuery should accept rows that are missing trailing optional columns. If true, BigQuery treats missing trailing columns as null values. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> bool:
        """
        [Optional] Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> str:
        """
        [Optional] The separator for fields in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="nullMarker")
    def null_marker(self) -> str:
        """
        [Optional] An custom string that will represent a NULL value in CSV import data.
        """
        return pulumi.get(self, "null_marker")

    @property
    @pulumi.getter
    def quote(self) -> str:
        """
        [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return pulumi.get(self, "quote")

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> str:
        """
        [Optional] The number of rows at the top of a CSV file that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return pulumi.get(self, "skip_leading_rows")


@pulumi.output_type
class DatasetAccessEntryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTypes":
            suggest = "target_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessEntryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessEntryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessEntryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: 'outputs.DatasetReferenceResponse',
                 target_types: Sequence[str]):
        """
        :param 'DatasetReferenceResponse' dataset: [Required] The dataset this entry applies to.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "target_types", target_types)

    @property
    @pulumi.getter
    def dataset(self) -> 'outputs.DatasetReferenceResponse':
        """
        [Required] The dataset this entry applies to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="targetTypes")
    def target_types(self) -> Sequence[str]:
        return pulumi.get(self, "target_types")


@pulumi.output_type
class DatasetAccessItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupByEmail":
            suggest = "group_by_email"
        elif key == "iamMember":
            suggest = "iam_member"
        elif key == "specialGroup":
            suggest = "special_group"
        elif key == "userByEmail":
            suggest = "user_by_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: 'outputs.DatasetAccessEntryResponse',
                 domain: str,
                 group_by_email: str,
                 iam_member: str,
                 role: str,
                 routine: 'outputs.RoutineReferenceResponse',
                 special_group: str,
                 user_by_email: str,
                 view: 'outputs.TableReferenceResponse'):
        """
        :param 'DatasetAccessEntryResponse' dataset: [Pick one] A grant authorizing all resources of a particular type in a particular dataset access to this dataset. Only views are supported for now. The role field is not required when this field is set. If that dataset is deleted and re-created, its access needs to be granted again via an update operation.
        :param str domain: [Pick one] A domain to grant access to. Any users signed in with the domain specified will be granted the specified access. Example: "example.com". Maps to IAM policy member "domain:DOMAIN".
        :param str group_by_email: [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member "group:GROUP".
        :param str iam_member: [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
        :param str role: [Required] An IAM role ID that should be granted to the user, group, or domain specified in this access entry. The following legacy mappings will be applied: OWNER  roles/bigquery.dataOwner WRITER  roles/bigquery.dataEditor READER  roles/bigquery.dataViewer This field will accept any of the above formats, but will return only the legacy format. For example, if you set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
        :param 'RoutineReferenceResponse' routine: [Pick one] A routine from a different dataset to grant access to. Queries executed against that routine will have read access to views/tables/routines in this dataset. Only UDF is supported for now. The role field is not required when this field is set. If that routine is updated by any user, access to the routine needs to be granted again via an update operation.
        :param str special_group: [Pick one] A special group to grant access to. Possible values include: projectOwners: Owners of the enclosing project. projectReaders: Readers of the enclosing project. projectWriters: Writers of the enclosing project. allAuthenticatedUsers: All authenticated BigQuery users. Maps to similarly-named IAM members.
        :param str user_by_email: [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
        :param 'TableReferenceResponse' view: [Pick one] A view from a different dataset to grant access to. Queries executed against that view will have read access to tables in this dataset. The role field is not required when this field is set. If that view is updated by any user, access to the view needs to be granted again via an update operation.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "group_by_email", group_by_email)
        pulumi.set(__self__, "iam_member", iam_member)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "routine", routine)
        pulumi.set(__self__, "special_group", special_group)
        pulumi.set(__self__, "user_by_email", user_by_email)
        pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def dataset(self) -> 'outputs.DatasetAccessEntryResponse':
        """
        [Pick one] A grant authorizing all resources of a particular type in a particular dataset access to this dataset. Only views are supported for now. The role field is not required when this field is set. If that dataset is deleted and re-created, its access needs to be granted again via an update operation.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        [Pick one] A domain to grant access to. Any users signed in with the domain specified will be granted the specified access. Example: "example.com". Maps to IAM policy member "domain:DOMAIN".
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> str:
        """
        [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member "group:GROUP".
        """
        return pulumi.get(self, "group_by_email")

    @property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> str:
        """
        [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
        """
        return pulumi.get(self, "iam_member")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        [Required] An IAM role ID that should be granted to the user, group, or domain specified in this access entry. The following legacy mappings will be applied: OWNER  roles/bigquery.dataOwner WRITER  roles/bigquery.dataEditor READER  roles/bigquery.dataViewer This field will accept any of the above formats, but will return only the legacy format. For example, if you set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def routine(self) -> 'outputs.RoutineReferenceResponse':
        """
        [Pick one] A routine from a different dataset to grant access to. Queries executed against that routine will have read access to views/tables/routines in this dataset. Only UDF is supported for now. The role field is not required when this field is set. If that routine is updated by any user, access to the routine needs to be granted again via an update operation.
        """
        return pulumi.get(self, "routine")

    @property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> str:
        """
        [Pick one] A special group to grant access to. Possible values include: projectOwners: Owners of the enclosing project. projectReaders: Readers of the enclosing project. projectWriters: Writers of the enclosing project. allAuthenticatedUsers: All authenticated BigQuery users. Maps to similarly-named IAM members.
        """
        return pulumi.get(self, "special_group")

    @property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> str:
        """
        [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
        """
        return pulumi.get(self, "user_by_email")

    @property
    @pulumi.getter
    def view(self) -> 'outputs.TableReferenceResponse':
        """
        [Pick one] A view from a different dataset to grant access to. Queries executed against that view will have read access to tables in this dataset. The role field is not required when this field is set. If that view is updated by any user, access to the view needs to be granted again via an update operation.
        """
        return pulumi.get(self, "view")


@pulumi.output_type
class DatasetReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project: str):
        """
        :param str dataset_id: [Required] A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param str project: [Optional] The ID of the project containing this dataset.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        [Required] A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        [Optional] The ID of the project containing this dataset.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class DatasetTagsItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValue":
            suggest = "tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetTagsItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetTagsItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetTagsItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_key: str,
                 tag_value: str):
        """
        :param str tag_key: [Required] The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is org id.
        :param str tag_value: [Required] Friendly short name of the tag value, e.g. "production".
        """
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> str:
        """
        [Required] The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is org id.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> str:
        """
        [Required] Friendly short name of the tag value, e.g. "production".
        """
        return pulumi.get(self, "tag_value")


@pulumi.output_type
class DestinationTablePropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"
        elif key == "friendlyName":
            suggest = "friendly_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DestinationTablePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DestinationTablePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DestinationTablePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 expiration_time: str,
                 friendly_name: str,
                 labels: Mapping[str, str]):
        """
        :param str description: [Optional] The description for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current description is provided, the job will fail.
        :param str expiration_time: [Internal] This field is for Google internal use only.
        :param str friendly_name: [Optional] The friendly name for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current friendly name is provided, the job will fail.
        :param Mapping[str, str] labels: [Optional] The labels associated with this table. You can use these to organize and group your tables. This will only be used if the destination table is newly created. If the table already exists and labels are different than the current labels are provided, the job will fail.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        [Optional] The description for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current description is provided, the job will fail.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        [Internal] This field is for Google internal use only.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        [Optional] The friendly name for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current friendly name is provided, the job will fail.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        [Optional] The labels associated with this table. You can use these to organize and group your tables. This will only be used if the destination table is newly created. If the table already exists and labels are different than the current labels are provided, the job will fail.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class DmlStatisticsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deletedRowCount":
            suggest = "deleted_row_count"
        elif key == "insertedRowCount":
            suggest = "inserted_row_count"
        elif key == "updatedRowCount":
            suggest = "updated_row_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DmlStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DmlStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DmlStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deleted_row_count: str,
                 inserted_row_count: str,
                 updated_row_count: str):
        """
        :param str deleted_row_count: Number of deleted Rows. populated by DML DELETE, MERGE and TRUNCATE statements.
        :param str inserted_row_count: Number of inserted Rows. Populated by DML INSERT and MERGE statements.
        :param str updated_row_count: Number of updated Rows. Populated by DML UPDATE and MERGE statements.
        """
        pulumi.set(__self__, "deleted_row_count", deleted_row_count)
        pulumi.set(__self__, "inserted_row_count", inserted_row_count)
        pulumi.set(__self__, "updated_row_count", updated_row_count)

    @property
    @pulumi.getter(name="deletedRowCount")
    def deleted_row_count(self) -> str:
        """
        Number of deleted Rows. populated by DML DELETE, MERGE and TRUNCATE statements.
        """
        return pulumi.get(self, "deleted_row_count")

    @property
    @pulumi.getter(name="insertedRowCount")
    def inserted_row_count(self) -> str:
        """
        Number of inserted Rows. Populated by DML INSERT and MERGE statements.
        """
        return pulumi.get(self, "inserted_row_count")

    @property
    @pulumi.getter(name="updatedRowCount")
    def updated_row_count(self) -> str:
        """
        Number of updated Rows. Populated by DML UPDATE and MERGE statements.
        """
        return pulumi.get(self, "updated_row_count")


@pulumi.output_type
class EncryptionConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: [Optional] Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        [Optional] Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ErrorProtoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "debugInfo":
            suggest = "debug_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorProtoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorProtoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorProtoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 debug_info: str,
                 location: str,
                 message: str,
                 reason: str):
        """
        :param str debug_info: Debugging information. This property is internal to Google and should not be used.
        :param str location: Specifies where the error occurred, if present.
        :param str message: A human-readable description of the error.
        :param str reason: A short error code that summarizes the error.
        """
        pulumi.set(__self__, "debug_info", debug_info)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="debugInfo")
    def debug_info(self) -> str:
        """
        Debugging information. This property is internal to Google and should not be used.
        """
        return pulumi.get(self, "debug_info")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies where the error occurred, if present.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable description of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A short error code that summarizes the error.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ExplainQueryStageResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completedParallelInputs":
            suggest = "completed_parallel_inputs"
        elif key == "computeMsAvg":
            suggest = "compute_ms_avg"
        elif key == "computeMsMax":
            suggest = "compute_ms_max"
        elif key == "computeRatioAvg":
            suggest = "compute_ratio_avg"
        elif key == "computeRatioMax":
            suggest = "compute_ratio_max"
        elif key == "endMs":
            suggest = "end_ms"
        elif key == "inputStages":
            suggest = "input_stages"
        elif key == "parallelInputs":
            suggest = "parallel_inputs"
        elif key == "readMsAvg":
            suggest = "read_ms_avg"
        elif key == "readMsMax":
            suggest = "read_ms_max"
        elif key == "readRatioAvg":
            suggest = "read_ratio_avg"
        elif key == "readRatioMax":
            suggest = "read_ratio_max"
        elif key == "recordsRead":
            suggest = "records_read"
        elif key == "recordsWritten":
            suggest = "records_written"
        elif key == "shuffleOutputBytes":
            suggest = "shuffle_output_bytes"
        elif key == "shuffleOutputBytesSpilled":
            suggest = "shuffle_output_bytes_spilled"
        elif key == "slotMs":
            suggest = "slot_ms"
        elif key == "startMs":
            suggest = "start_ms"
        elif key == "waitMsAvg":
            suggest = "wait_ms_avg"
        elif key == "waitMsMax":
            suggest = "wait_ms_max"
        elif key == "waitRatioAvg":
            suggest = "wait_ratio_avg"
        elif key == "waitRatioMax":
            suggest = "wait_ratio_max"
        elif key == "writeMsAvg":
            suggest = "write_ms_avg"
        elif key == "writeMsMax":
            suggest = "write_ms_max"
        elif key == "writeRatioAvg":
            suggest = "write_ratio_avg"
        elif key == "writeRatioMax":
            suggest = "write_ratio_max"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExplainQueryStageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExplainQueryStageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExplainQueryStageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completed_parallel_inputs: str,
                 compute_ms_avg: str,
                 compute_ms_max: str,
                 compute_ratio_avg: float,
                 compute_ratio_max: float,
                 end_ms: str,
                 input_stages: Sequence[str],
                 name: str,
                 parallel_inputs: str,
                 read_ms_avg: str,
                 read_ms_max: str,
                 read_ratio_avg: float,
                 read_ratio_max: float,
                 records_read: str,
                 records_written: str,
                 shuffle_output_bytes: str,
                 shuffle_output_bytes_spilled: str,
                 slot_ms: str,
                 start_ms: str,
                 status: str,
                 steps: Sequence['outputs.ExplainQueryStepResponse'],
                 wait_ms_avg: str,
                 wait_ms_max: str,
                 wait_ratio_avg: float,
                 wait_ratio_max: float,
                 write_ms_avg: str,
                 write_ms_max: str,
                 write_ratio_avg: float,
                 write_ratio_max: float):
        """
        :param str completed_parallel_inputs: Number of parallel input segments completed.
        :param str compute_ms_avg: Milliseconds the average shard spent on CPU-bound tasks.
        :param str compute_ms_max: Milliseconds the slowest shard spent on CPU-bound tasks.
        :param float compute_ratio_avg: Relative amount of time the average shard spent on CPU-bound tasks.
        :param float compute_ratio_max: Relative amount of time the slowest shard spent on CPU-bound tasks.
        :param str end_ms: Stage end time represented as milliseconds since epoch.
        :param Sequence[str] input_stages: IDs for stages that are inputs to this stage.
        :param str name: Human-readable name for stage.
        :param str parallel_inputs: Number of parallel input segments to be processed.
        :param str read_ms_avg: Milliseconds the average shard spent reading input.
        :param str read_ms_max: Milliseconds the slowest shard spent reading input.
        :param float read_ratio_avg: Relative amount of time the average shard spent reading input.
        :param float read_ratio_max: Relative amount of time the slowest shard spent reading input.
        :param str records_read: Number of records read into the stage.
        :param str records_written: Number of records written by the stage.
        :param str shuffle_output_bytes: Total number of bytes written to shuffle.
        :param str shuffle_output_bytes_spilled: Total number of bytes written to shuffle and spilled to disk.
        :param str slot_ms: Slot-milliseconds used by the stage.
        :param str start_ms: Stage start time represented as milliseconds since epoch.
        :param str status: Current status for the stage.
        :param Sequence['ExplainQueryStepResponse'] steps: List of operations within the stage in dependency order (approximately chronological).
        :param str wait_ms_avg: Milliseconds the average shard spent waiting to be scheduled.
        :param str wait_ms_max: Milliseconds the slowest shard spent waiting to be scheduled.
        :param float wait_ratio_avg: Relative amount of time the average shard spent waiting to be scheduled.
        :param float wait_ratio_max: Relative amount of time the slowest shard spent waiting to be scheduled.
        :param str write_ms_avg: Milliseconds the average shard spent on writing output.
        :param str write_ms_max: Milliseconds the slowest shard spent on writing output.
        :param float write_ratio_avg: Relative amount of time the average shard spent on writing output.
        :param float write_ratio_max: Relative amount of time the slowest shard spent on writing output.
        """
        pulumi.set(__self__, "completed_parallel_inputs", completed_parallel_inputs)
        pulumi.set(__self__, "compute_ms_avg", compute_ms_avg)
        pulumi.set(__self__, "compute_ms_max", compute_ms_max)
        pulumi.set(__self__, "compute_ratio_avg", compute_ratio_avg)
        pulumi.set(__self__, "compute_ratio_max", compute_ratio_max)
        pulumi.set(__self__, "end_ms", end_ms)
        pulumi.set(__self__, "input_stages", input_stages)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parallel_inputs", parallel_inputs)
        pulumi.set(__self__, "read_ms_avg", read_ms_avg)
        pulumi.set(__self__, "read_ms_max", read_ms_max)
        pulumi.set(__self__, "read_ratio_avg", read_ratio_avg)
        pulumi.set(__self__, "read_ratio_max", read_ratio_max)
        pulumi.set(__self__, "records_read", records_read)
        pulumi.set(__self__, "records_written", records_written)
        pulumi.set(__self__, "shuffle_output_bytes", shuffle_output_bytes)
        pulumi.set(__self__, "shuffle_output_bytes_spilled", shuffle_output_bytes_spilled)
        pulumi.set(__self__, "slot_ms", slot_ms)
        pulumi.set(__self__, "start_ms", start_ms)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "wait_ms_avg", wait_ms_avg)
        pulumi.set(__self__, "wait_ms_max", wait_ms_max)
        pulumi.set(__self__, "wait_ratio_avg", wait_ratio_avg)
        pulumi.set(__self__, "wait_ratio_max", wait_ratio_max)
        pulumi.set(__self__, "write_ms_avg", write_ms_avg)
        pulumi.set(__self__, "write_ms_max", write_ms_max)
        pulumi.set(__self__, "write_ratio_avg", write_ratio_avg)
        pulumi.set(__self__, "write_ratio_max", write_ratio_max)

    @property
    @pulumi.getter(name="completedParallelInputs")
    def completed_parallel_inputs(self) -> str:
        """
        Number of parallel input segments completed.
        """
        return pulumi.get(self, "completed_parallel_inputs")

    @property
    @pulumi.getter(name="computeMsAvg")
    def compute_ms_avg(self) -> str:
        """
        Milliseconds the average shard spent on CPU-bound tasks.
        """
        return pulumi.get(self, "compute_ms_avg")

    @property
    @pulumi.getter(name="computeMsMax")
    def compute_ms_max(self) -> str:
        """
        Milliseconds the slowest shard spent on CPU-bound tasks.
        """
        return pulumi.get(self, "compute_ms_max")

    @property
    @pulumi.getter(name="computeRatioAvg")
    def compute_ratio_avg(self) -> float:
        """
        Relative amount of time the average shard spent on CPU-bound tasks.
        """
        return pulumi.get(self, "compute_ratio_avg")

    @property
    @pulumi.getter(name="computeRatioMax")
    def compute_ratio_max(self) -> float:
        """
        Relative amount of time the slowest shard spent on CPU-bound tasks.
        """
        return pulumi.get(self, "compute_ratio_max")

    @property
    @pulumi.getter(name="endMs")
    def end_ms(self) -> str:
        """
        Stage end time represented as milliseconds since epoch.
        """
        return pulumi.get(self, "end_ms")

    @property
    @pulumi.getter(name="inputStages")
    def input_stages(self) -> Sequence[str]:
        """
        IDs for stages that are inputs to this stage.
        """
        return pulumi.get(self, "input_stages")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Human-readable name for stage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parallelInputs")
    def parallel_inputs(self) -> str:
        """
        Number of parallel input segments to be processed.
        """
        return pulumi.get(self, "parallel_inputs")

    @property
    @pulumi.getter(name="readMsAvg")
    def read_ms_avg(self) -> str:
        """
        Milliseconds the average shard spent reading input.
        """
        return pulumi.get(self, "read_ms_avg")

    @property
    @pulumi.getter(name="readMsMax")
    def read_ms_max(self) -> str:
        """
        Milliseconds the slowest shard spent reading input.
        """
        return pulumi.get(self, "read_ms_max")

    @property
    @pulumi.getter(name="readRatioAvg")
    def read_ratio_avg(self) -> float:
        """
        Relative amount of time the average shard spent reading input.
        """
        return pulumi.get(self, "read_ratio_avg")

    @property
    @pulumi.getter(name="readRatioMax")
    def read_ratio_max(self) -> float:
        """
        Relative amount of time the slowest shard spent reading input.
        """
        return pulumi.get(self, "read_ratio_max")

    @property
    @pulumi.getter(name="recordsRead")
    def records_read(self) -> str:
        """
        Number of records read into the stage.
        """
        return pulumi.get(self, "records_read")

    @property
    @pulumi.getter(name="recordsWritten")
    def records_written(self) -> str:
        """
        Number of records written by the stage.
        """
        return pulumi.get(self, "records_written")

    @property
    @pulumi.getter(name="shuffleOutputBytes")
    def shuffle_output_bytes(self) -> str:
        """
        Total number of bytes written to shuffle.
        """
        return pulumi.get(self, "shuffle_output_bytes")

    @property
    @pulumi.getter(name="shuffleOutputBytesSpilled")
    def shuffle_output_bytes_spilled(self) -> str:
        """
        Total number of bytes written to shuffle and spilled to disk.
        """
        return pulumi.get(self, "shuffle_output_bytes_spilled")

    @property
    @pulumi.getter(name="slotMs")
    def slot_ms(self) -> str:
        """
        Slot-milliseconds used by the stage.
        """
        return pulumi.get(self, "slot_ms")

    @property
    @pulumi.getter(name="startMs")
    def start_ms(self) -> str:
        """
        Stage start time represented as milliseconds since epoch.
        """
        return pulumi.get(self, "start_ms")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status for the stage.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.ExplainQueryStepResponse']:
        """
        List of operations within the stage in dependency order (approximately chronological).
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="waitMsAvg")
    def wait_ms_avg(self) -> str:
        """
        Milliseconds the average shard spent waiting to be scheduled.
        """
        return pulumi.get(self, "wait_ms_avg")

    @property
    @pulumi.getter(name="waitMsMax")
    def wait_ms_max(self) -> str:
        """
        Milliseconds the slowest shard spent waiting to be scheduled.
        """
        return pulumi.get(self, "wait_ms_max")

    @property
    @pulumi.getter(name="waitRatioAvg")
    def wait_ratio_avg(self) -> float:
        """
        Relative amount of time the average shard spent waiting to be scheduled.
        """
        return pulumi.get(self, "wait_ratio_avg")

    @property
    @pulumi.getter(name="waitRatioMax")
    def wait_ratio_max(self) -> float:
        """
        Relative amount of time the slowest shard spent waiting to be scheduled.
        """
        return pulumi.get(self, "wait_ratio_max")

    @property
    @pulumi.getter(name="writeMsAvg")
    def write_ms_avg(self) -> str:
        """
        Milliseconds the average shard spent on writing output.
        """
        return pulumi.get(self, "write_ms_avg")

    @property
    @pulumi.getter(name="writeMsMax")
    def write_ms_max(self) -> str:
        """
        Milliseconds the slowest shard spent on writing output.
        """
        return pulumi.get(self, "write_ms_max")

    @property
    @pulumi.getter(name="writeRatioAvg")
    def write_ratio_avg(self) -> float:
        """
        Relative amount of time the average shard spent on writing output.
        """
        return pulumi.get(self, "write_ratio_avg")

    @property
    @pulumi.getter(name="writeRatioMax")
    def write_ratio_max(self) -> float:
        """
        Relative amount of time the slowest shard spent on writing output.
        """
        return pulumi.get(self, "write_ratio_max")


@pulumi.output_type
class ExplainQueryStepResponse(dict):
    def __init__(__self__, *,
                 kind: str,
                 substeps: Sequence[str]):
        """
        :param str kind: Machine-readable operation type.
        :param Sequence[str] substeps: Human-readable stage descriptions.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "substeps", substeps)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Machine-readable operation type.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def substeps(self) -> Sequence[str]:
        """
        Human-readable stage descriptions.
        """
        return pulumi.get(self, "substeps")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ExternalDataConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avroOptions":
            suggest = "avro_options"
        elif key == "bigtableOptions":
            suggest = "bigtable_options"
        elif key == "connectionId":
            suggest = "connection_id"
        elif key == "csvOptions":
            suggest = "csv_options"
        elif key == "decimalTargetTypes":
            suggest = "decimal_target_types"
        elif key == "googleSheetsOptions":
            suggest = "google_sheets_options"
        elif key == "hivePartitioningOptions":
            suggest = "hive_partitioning_options"
        elif key == "ignoreUnknownValues":
            suggest = "ignore_unknown_values"
        elif key == "maxBadRecords":
            suggest = "max_bad_records"
        elif key == "parquetOptions":
            suggest = "parquet_options"
        elif key == "sourceFormat":
            suggest = "source_format"
        elif key == "sourceUris":
            suggest = "source_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalDataConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalDataConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalDataConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autodetect: bool,
                 avro_options: 'outputs.AvroOptionsResponse',
                 bigtable_options: 'outputs.BigtableOptionsResponse',
                 compression: str,
                 connection_id: str,
                 csv_options: 'outputs.CsvOptionsResponse',
                 decimal_target_types: Sequence[str],
                 google_sheets_options: 'outputs.GoogleSheetsOptionsResponse',
                 hive_partitioning_options: 'outputs.HivePartitioningOptionsResponse',
                 ignore_unknown_values: bool,
                 max_bad_records: int,
                 parquet_options: 'outputs.ParquetOptionsResponse',
                 schema: 'outputs.TableSchemaResponse',
                 source_format: str,
                 source_uris: Sequence[str]):
        """
        :param bool autodetect: Try to detect schema and format options automatically. Any option specified explicitly will be honored.
        :param 'AvroOptionsResponse' avro_options: Additional properties to set if sourceFormat is set to Avro.
        :param 'BigtableOptionsResponse' bigtable_options: [Optional] Additional options if sourceFormat is set to BIGTABLE.
        :param str compression: [Optional] The compression type of the data source. Possible values include GZIP and NONE. The default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        :param str connection_id: [Optional, Trusted Tester] Connection for external data source.
        :param 'CsvOptionsResponse' csv_options: Additional properties to set if sourceFormat is set to CSV.
        :param Sequence[str] decimal_target_types: [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        :param 'GoogleSheetsOptionsResponse' google_sheets_options: [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
        :param 'HivePartitioningOptionsResponse' hive_partitioning_options: [Optional] Options to configure hive partitioning support.
        :param bool ignore_unknown_values: [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is ignored. Avro: This setting is ignored.
        :param int max_bad_records: [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV, JSON, and Google Sheets. The default value is 0, which requires that all records are valid. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        :param 'ParquetOptionsResponse' parquet_options: Additional properties to set if sourceFormat is set to Parquet.
        :param 'TableSchemaResponse' schema: [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
        :param str source_format: [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
        :param Sequence[str] source_uris: [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        pulumi.set(__self__, "autodetect", autodetect)
        pulumi.set(__self__, "avro_options", avro_options)
        pulumi.set(__self__, "bigtable_options", bigtable_options)
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "csv_options", csv_options)
        pulumi.set(__self__, "decimal_target_types", decimal_target_types)
        pulumi.set(__self__, "google_sheets_options", google_sheets_options)
        pulumi.set(__self__, "hive_partitioning_options", hive_partitioning_options)
        pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        pulumi.set(__self__, "max_bad_records", max_bad_records)
        pulumi.set(__self__, "parquet_options", parquet_options)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "source_format", source_format)
        pulumi.set(__self__, "source_uris", source_uris)

    @property
    @pulumi.getter
    def autodetect(self) -> bool:
        """
        Try to detect schema and format options automatically. Any option specified explicitly will be honored.
        """
        return pulumi.get(self, "autodetect")

    @property
    @pulumi.getter(name="avroOptions")
    def avro_options(self) -> 'outputs.AvroOptionsResponse':
        """
        Additional properties to set if sourceFormat is set to Avro.
        """
        return pulumi.get(self, "avro_options")

    @property
    @pulumi.getter(name="bigtableOptions")
    def bigtable_options(self) -> 'outputs.BigtableOptionsResponse':
        """
        [Optional] Additional options if sourceFormat is set to BIGTABLE.
        """
        return pulumi.get(self, "bigtable_options")

    @property
    @pulumi.getter
    def compression(self) -> str:
        """
        [Optional] The compression type of the data source. Possible values include GZIP and NONE. The default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        """
        [Optional, Trusted Tester] Connection for external data source.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> 'outputs.CsvOptionsResponse':
        """
        Additional properties to set if sourceFormat is set to CSV.
        """
        return pulumi.get(self, "csv_options")

    @property
    @pulumi.getter(name="decimalTargetTypes")
    def decimal_target_types(self) -> Sequence[str]:
        """
        [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        """
        return pulumi.get(self, "decimal_target_types")

    @property
    @pulumi.getter(name="googleSheetsOptions")
    def google_sheets_options(self) -> 'outputs.GoogleSheetsOptionsResponse':
        """
        [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
        """
        return pulumi.get(self, "google_sheets_options")

    @property
    @pulumi.getter(name="hivePartitioningOptions")
    def hive_partitioning_options(self) -> 'outputs.HivePartitioningOptionsResponse':
        """
        [Optional] Options to configure hive partitioning support.
        """
        return pulumi.get(self, "hive_partitioning_options")

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> bool:
        """
        [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is ignored. Avro: This setting is ignored.
        """
        return pulumi.get(self, "ignore_unknown_values")

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> int:
        """
        [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV, JSON, and Google Sheets. The default value is 0, which requires that all records are valid. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        """
        return pulumi.get(self, "max_bad_records")

    @property
    @pulumi.getter(name="parquetOptions")
    def parquet_options(self) -> 'outputs.ParquetOptionsResponse':
        """
        Additional properties to set if sourceFormat is set to Parquet.
        """
        return pulumi.get(self, "parquet_options")

    @property
    @pulumi.getter
    def schema(self) -> 'outputs.TableSchemaResponse':
        """
        [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> str:
        """
        [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
        """
        return pulumi.get(self, "source_format")

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> Sequence[str]:
        """
        [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        return pulumi.get(self, "source_uris")


@pulumi.output_type
class GoogleSheetsOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skipLeadingRows":
            suggest = "skip_leading_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleSheetsOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleSheetsOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleSheetsOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: str,
                 skip_leading_rows: str):
        """
        :param str range: [Optional] Range of a sheet to query from. Only used when non-empty. Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id For example: sheet1!A1:B20
        :param str skip_leading_rows: [Optional] The number of rows at the top of a sheet that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows that should be skipped. When autodetect is on, behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        pulumi.set(__self__, "range", range)
        pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter
    def range(self) -> str:
        """
        [Optional] Range of a sheet to query from. Only used when non-empty. Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id For example: sheet1!A1:B20
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> str:
        """
        [Optional] The number of rows at the top of a sheet that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows that should be skipped. When autodetect is on, behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return pulumi.get(self, "skip_leading_rows")


@pulumi.output_type
class HivePartitioningOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requirePartitionFilter":
            suggest = "require_partition_filter"
        elif key == "sourceUriPrefix":
            suggest = "source_uri_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HivePartitioningOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HivePartitioningOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HivePartitioningOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: str,
                 require_partition_filter: bool,
                 source_uri_prefix: str):
        """
        :param str mode: [Optional] When set, what mode of hive partitioning to use when reading data. The following modes are supported. (1) AUTO: automatically infer partition key name(s) and type(s). (2) STRINGS: automatically infer partition key name(s). All types are interpreted as strings. (3) CUSTOM: partition key schema is encoded in the source URI prefix. Not all storage formats support hive partitioning. Requesting hive partitioning on an unsupported format will lead to an error. Currently supported types include: AVRO, CSV, JSON, ORC and Parquet.
        :param bool require_partition_filter: [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified. Note that this field should only be true when creating a permanent external table or querying a temporary external table. Hive-partitioned loads with requirePartitionFilter explicitly set to true will fail.
        :param str source_uri_prefix: [Optional] When hive partition detection is requested, a common prefix for all source uris should be supplied. The prefix must end immediately before the partition key encoding begins. For example, consider files following this data layout. gs://bucket/path_to_table/dt=2019-01-01/country=BR/id=7/file.avro gs://bucket/path_to_table/dt=2018-12-31/country=CA/id=3/file.avro When hive partitioning is requested with either AUTO or STRINGS detection, the common prefix can be either of gs://bucket/path_to_table or gs://bucket/path_to_table/ (trailing slash does not matter).
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        pulumi.set(__self__, "source_uri_prefix", source_uri_prefix)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        [Optional] When set, what mode of hive partitioning to use when reading data. The following modes are supported. (1) AUTO: automatically infer partition key name(s) and type(s). (2) STRINGS: automatically infer partition key name(s). All types are interpreted as strings. (3) CUSTOM: partition key schema is encoded in the source URI prefix. Not all storage formats support hive partitioning. Requesting hive partitioning on an unsupported format will lead to an error. Currently supported types include: AVRO, CSV, JSON, ORC and Parquet.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> bool:
        """
        [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified. Note that this field should only be true when creating a permanent external table or querying a temporary external table. Hive-partitioned loads with requirePartitionFilter explicitly set to true will fail.
        """
        return pulumi.get(self, "require_partition_filter")

    @property
    @pulumi.getter(name="sourceUriPrefix")
    def source_uri_prefix(self) -> str:
        """
        [Optional] When hive partition detection is requested, a common prefix for all source uris should be supplied. The prefix must end immediately before the partition key encoding begins. For example, consider files following this data layout. gs://bucket/path_to_table/dt=2019-01-01/country=BR/id=7/file.avro gs://bucket/path_to_table/dt=2018-12-31/country=CA/id=3/file.avro When hive partitioning is requested with either AUTO or STRINGS detection, the common prefix can be either of gs://bucket/path_to_table or gs://bucket/path_to_table/ (trailing slash does not matter).
        """
        return pulumi.get(self, "source_uri_prefix")


@pulumi.output_type
class IterationResultResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationMs":
            suggest = "duration_ms"
        elif key == "evalLoss":
            suggest = "eval_loss"
        elif key == "learnRate":
            suggest = "learn_rate"
        elif key == "trainingLoss":
            suggest = "training_loss"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IterationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IterationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IterationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_ms: str,
                 eval_loss: float,
                 index: int,
                 learn_rate: float,
                 training_loss: float):
        """
        :param str duration_ms: Time taken to run the iteration in milliseconds.
        :param float eval_loss: Loss computed on the eval data at the end of iteration.
        :param int index: Index of the iteration, 0 based.
        :param float learn_rate: Learn rate used for this iteration.
        :param float training_loss: Loss computed on the training data at the end of iteration.
        """
        pulumi.set(__self__, "duration_ms", duration_ms)
        pulumi.set(__self__, "eval_loss", eval_loss)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "learn_rate", learn_rate)
        pulumi.set(__self__, "training_loss", training_loss)

    @property
    @pulumi.getter(name="durationMs")
    def duration_ms(self) -> str:
        """
        Time taken to run the iteration in milliseconds.
        """
        return pulumi.get(self, "duration_ms")

    @property
    @pulumi.getter(name="evalLoss")
    def eval_loss(self) -> float:
        """
        Loss computed on the eval data at the end of iteration.
        """
        return pulumi.get(self, "eval_loss")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        Index of the iteration, 0 based.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="learnRate")
    def learn_rate(self) -> float:
        """
        Learn rate used for this iteration.
        """
        return pulumi.get(self, "learn_rate")

    @property
    @pulumi.getter(name="trainingLoss")
    def training_loss(self) -> float:
        """
        Loss computed on the training data at the end of iteration.
        """
        return pulumi.get(self, "training_loss")


@pulumi.output_type
class JobConfigurationExtractResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFormat":
            suggest = "destination_format"
        elif key == "destinationUri":
            suggest = "destination_uri"
        elif key == "destinationUris":
            suggest = "destination_uris"
        elif key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "printHeader":
            suggest = "print_header"
        elif key == "sourceModel":
            suggest = "source_model"
        elif key == "sourceTable":
            suggest = "source_table"
        elif key == "useAvroLogicalTypes":
            suggest = "use_avro_logical_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigurationExtractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigurationExtractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigurationExtractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression: str,
                 destination_format: str,
                 destination_uri: str,
                 destination_uris: Sequence[str],
                 field_delimiter: str,
                 print_header: bool,
                 source_model: 'outputs.ModelReferenceResponse',
                 source_table: 'outputs.TableReferenceResponse',
                 use_avro_logical_types: bool):
        """
        :param str compression: [Optional] The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default value is NONE. DEFLATE and SNAPPY are only supported for Avro. Not applicable when extracting models.
        :param str destination_format: [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON, PARQUET or AVRO for tables and ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV. The default value for models is ML_TF_SAVED_MODEL.
        :param str destination_uri: [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The fully-qualified Google Cloud Storage URI where the extracted table should be written.
        :param Sequence[str] destination_uris: [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        :param str field_delimiter: [Optional] Delimiter to use between fields in the exported data. Default is ','. Not applicable when extracting models.
        :param bool print_header: [Optional] Whether to print out a header row in the results. Default is true. Not applicable when extracting models.
        :param 'ModelReferenceResponse' source_model: A reference to the model being exported.
        :param 'TableReferenceResponse' source_table: A reference to the table being exported.
        :param bool use_avro_logical_types: [Optional] If destinationFormat is set to "AVRO", this flag indicates whether to enable extracting applicable column types (such as TIMESTAMP) to their corresponding AVRO logical types (timestamp-micros), instead of only using their raw types (avro-long). Not applicable when extracting models.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "destination_format", destination_format)
        pulumi.set(__self__, "destination_uri", destination_uri)
        pulumi.set(__self__, "destination_uris", destination_uris)
        pulumi.set(__self__, "field_delimiter", field_delimiter)
        pulumi.set(__self__, "print_header", print_header)
        pulumi.set(__self__, "source_model", source_model)
        pulumi.set(__self__, "source_table", source_table)
        pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter
    def compression(self) -> str:
        """
        [Optional] The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default value is NONE. DEFLATE and SNAPPY are only supported for Avro. Not applicable when extracting models.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="destinationFormat")
    def destination_format(self) -> str:
        """
        [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON, PARQUET or AVRO for tables and ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV. The default value for models is ML_TF_SAVED_MODEL.
        """
        return pulumi.get(self, "destination_format")

    @property
    @pulumi.getter(name="destinationUri")
    def destination_uri(self) -> str:
        """
        [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The fully-qualified Google Cloud Storage URI where the extracted table should be written.
        """
        return pulumi.get(self, "destination_uri")

    @property
    @pulumi.getter(name="destinationUris")
    def destination_uris(self) -> Sequence[str]:
        """
        [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        """
        return pulumi.get(self, "destination_uris")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> str:
        """
        [Optional] Delimiter to use between fields in the exported data. Default is ','. Not applicable when extracting models.
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="printHeader")
    def print_header(self) -> bool:
        """
        [Optional] Whether to print out a header row in the results. Default is true. Not applicable when extracting models.
        """
        return pulumi.get(self, "print_header")

    @property
    @pulumi.getter(name="sourceModel")
    def source_model(self) -> 'outputs.ModelReferenceResponse':
        """
        A reference to the model being exported.
        """
        return pulumi.get(self, "source_model")

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> 'outputs.TableReferenceResponse':
        """
        A reference to the table being exported.
        """
        return pulumi.get(self, "source_table")

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> bool:
        """
        [Optional] If destinationFormat is set to "AVRO", this flag indicates whether to enable extracting applicable column types (such as TIMESTAMP) to their corresponding AVRO logical types (timestamp-micros), instead of only using their raw types (avro-long). Not applicable when extracting models.
        """
        return pulumi.get(self, "use_avro_logical_types")


@pulumi.output_type
class JobConfigurationLoadResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowJaggedRows":
            suggest = "allow_jagged_rows"
        elif key == "allowQuotedNewlines":
            suggest = "allow_quoted_newlines"
        elif key == "createDisposition":
            suggest = "create_disposition"
        elif key == "decimalTargetTypes":
            suggest = "decimal_target_types"
        elif key == "destinationEncryptionConfiguration":
            suggest = "destination_encryption_configuration"
        elif key == "destinationTable":
            suggest = "destination_table"
        elif key == "destinationTableProperties":
            suggest = "destination_table_properties"
        elif key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "hivePartitioningOptions":
            suggest = "hive_partitioning_options"
        elif key == "ignoreUnknownValues":
            suggest = "ignore_unknown_values"
        elif key == "jsonExtension":
            suggest = "json_extension"
        elif key == "maxBadRecords":
            suggest = "max_bad_records"
        elif key == "nullMarker":
            suggest = "null_marker"
        elif key == "parquetOptions":
            suggest = "parquet_options"
        elif key == "preserveAsciiControlCharacters":
            suggest = "preserve_ascii_control_characters"
        elif key == "projectionFields":
            suggest = "projection_fields"
        elif key == "rangePartitioning":
            suggest = "range_partitioning"
        elif key == "schemaInline":
            suggest = "schema_inline"
        elif key == "schemaInlineFormat":
            suggest = "schema_inline_format"
        elif key == "schemaUpdateOptions":
            suggest = "schema_update_options"
        elif key == "skipLeadingRows":
            suggest = "skip_leading_rows"
        elif key == "sourceFormat":
            suggest = "source_format"
        elif key == "sourceUris":
            suggest = "source_uris"
        elif key == "timePartitioning":
            suggest = "time_partitioning"
        elif key == "useAvroLogicalTypes":
            suggest = "use_avro_logical_types"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigurationLoadResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigurationLoadResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigurationLoadResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_jagged_rows: bool,
                 allow_quoted_newlines: bool,
                 autodetect: bool,
                 clustering: 'outputs.ClusteringResponse',
                 create_disposition: str,
                 decimal_target_types: Sequence[str],
                 destination_encryption_configuration: 'outputs.EncryptionConfigurationResponse',
                 destination_table: 'outputs.TableReferenceResponse',
                 destination_table_properties: 'outputs.DestinationTablePropertiesResponse',
                 encoding: str,
                 field_delimiter: str,
                 hive_partitioning_options: 'outputs.HivePartitioningOptionsResponse',
                 ignore_unknown_values: bool,
                 json_extension: str,
                 max_bad_records: int,
                 null_marker: str,
                 parquet_options: 'outputs.ParquetOptionsResponse',
                 preserve_ascii_control_characters: bool,
                 projection_fields: Sequence[str],
                 quote: str,
                 range_partitioning: 'outputs.RangePartitioningResponse',
                 schema: 'outputs.TableSchemaResponse',
                 schema_inline: str,
                 schema_inline_format: str,
                 schema_update_options: Sequence[str],
                 skip_leading_rows: int,
                 source_format: str,
                 source_uris: Sequence[str],
                 time_partitioning: 'outputs.TimePartitioningResponse',
                 use_avro_logical_types: bool,
                 write_disposition: str):
        """
        :param bool allow_jagged_rows: [Optional] Accept rows that are missing trailing optional columns. The missing values are treated as nulls. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        :param bool allow_quoted_newlines: Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        :param bool autodetect: [Optional] Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        :param 'ClusteringResponse' clustering: [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        :param str create_disposition: [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        :param Sequence[str] decimal_target_types: [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        :param 'EncryptionConfigurationResponse' destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys).
        :param 'TableReferenceResponse' destination_table: [Required] The destination table to load the data into.
        :param 'DestinationTablePropertiesResponse' destination_table_properties: [Beta] [Optional] Properties with which to create the destination table if it is new.
        :param str encoding: [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        :param str field_delimiter: [Optional] The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character. To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        :param 'HivePartitioningOptionsResponse' hive_partitioning_options: [Optional] Options to configure hive partitioning support.
        :param bool ignore_unknown_values: [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
        :param str json_extension: [Optional] If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON. For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited GeoJSON: set to GEOJSON.
        :param int max_bad_records: [Optional] The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV and JSON. The default value is 0, which requires that all records are valid.
        :param str null_marker: [Optional] Specifies a string that represents a null value in a CSV file. For example, if you specify "\\N", BigQuery interprets "\\N" as a null value when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as an empty value.
        :param 'ParquetOptionsResponse' parquet_options: [Optional] Options to configure parquet support.
        :param bool preserve_ascii_control_characters: [Optional] Preserves the embedded ASCII control characters (the first 32 characters in the ASCII-table, from '\\x00' to '\\x1F') when loading from CSV. Only applicable to CSV, ignored for other formats.
        :param Sequence[str] projection_fields: If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup. Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties. If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        :param str quote: [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param 'RangePartitioningResponse' range_partitioning: [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        :param 'TableSchemaResponse' schema: [Optional] The schema for the destination table. The schema can be omitted if the destination table already exists, or if you're loading data from Google Cloud Datastore.
        :param str schema_inline: [Deprecated] The inline schema. For CSV schemas, specify as "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER, baz:FLOAT".
        :param str schema_inline_format: [Deprecated] The format of the schemaInline property.
        :param Sequence[str] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param int skip_leading_rows: [Optional] The number of rows at the top of a CSV file that BigQuery will skip when loading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        :param str source_format: [Optional] The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default value is CSV.
        :param Sequence[str] source_uris: [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        :param 'TimePartitioningResponse' time_partitioning: Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        :param bool use_avro_logical_types: [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        :param str write_disposition: [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_APPEND. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        pulumi.set(__self__, "autodetect", autodetect)
        pulumi.set(__self__, "clustering", clustering)
        pulumi.set(__self__, "create_disposition", create_disposition)
        pulumi.set(__self__, "decimal_target_types", decimal_target_types)
        pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        pulumi.set(__self__, "destination_table", destination_table)
        pulumi.set(__self__, "destination_table_properties", destination_table_properties)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "field_delimiter", field_delimiter)
        pulumi.set(__self__, "hive_partitioning_options", hive_partitioning_options)
        pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        pulumi.set(__self__, "json_extension", json_extension)
        pulumi.set(__self__, "max_bad_records", max_bad_records)
        pulumi.set(__self__, "null_marker", null_marker)
        pulumi.set(__self__, "parquet_options", parquet_options)
        pulumi.set(__self__, "preserve_ascii_control_characters", preserve_ascii_control_characters)
        pulumi.set(__self__, "projection_fields", projection_fields)
        pulumi.set(__self__, "quote", quote)
        pulumi.set(__self__, "range_partitioning", range_partitioning)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "schema_inline", schema_inline)
        pulumi.set(__self__, "schema_inline_format", schema_inline_format)
        pulumi.set(__self__, "schema_update_options", schema_update_options)
        pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)
        pulumi.set(__self__, "source_format", source_format)
        pulumi.set(__self__, "source_uris", source_uris)
        pulumi.set(__self__, "time_partitioning", time_partitioning)
        pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)
        pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> bool:
        """
        [Optional] Accept rows that are missing trailing optional columns. The missing values are treated as nulls. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> bool:
        """
        Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @property
    @pulumi.getter
    def autodetect(self) -> bool:
        """
        [Optional] Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        """
        return pulumi.get(self, "autodetect")

    @property
    @pulumi.getter
    def clustering(self) -> 'outputs.ClusteringResponse':
        """
        [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        """
        return pulumi.get(self, "clustering")

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> str:
        """
        [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "create_disposition")

    @property
    @pulumi.getter(name="decimalTargetTypes")
    def decimal_target_types(self) -> Sequence[str]:
        """
        [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        """
        return pulumi.get(self, "decimal_target_types")

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> 'outputs.EncryptionConfigurationResponse':
        """
        Custom encryption configuration (e.g., Cloud KMS keys).
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> 'outputs.TableReferenceResponse':
        """
        [Required] The destination table to load the data into.
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="destinationTableProperties")
    def destination_table_properties(self) -> 'outputs.DestinationTablePropertiesResponse':
        """
        [Beta] [Optional] Properties with which to create the destination table if it is new.
        """
        return pulumi.get(self, "destination_table_properties")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> str:
        """
        [Optional] The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character. To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="hivePartitioningOptions")
    def hive_partitioning_options(self) -> 'outputs.HivePartitioningOptionsResponse':
        """
        [Optional] Options to configure hive partitioning support.
        """
        return pulumi.get(self, "hive_partitioning_options")

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> bool:
        """
        [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
        """
        return pulumi.get(self, "ignore_unknown_values")

    @property
    @pulumi.getter(name="jsonExtension")
    def json_extension(self) -> str:
        """
        [Optional] If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON. For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited GeoJSON: set to GEOJSON.
        """
        return pulumi.get(self, "json_extension")

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> int:
        """
        [Optional] The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV and JSON. The default value is 0, which requires that all records are valid.
        """
        return pulumi.get(self, "max_bad_records")

    @property
    @pulumi.getter(name="nullMarker")
    def null_marker(self) -> str:
        """
        [Optional] Specifies a string that represents a null value in a CSV file. For example, if you specify "\\N", BigQuery interprets "\\N" as a null value when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as an empty value.
        """
        return pulumi.get(self, "null_marker")

    @property
    @pulumi.getter(name="parquetOptions")
    def parquet_options(self) -> 'outputs.ParquetOptionsResponse':
        """
        [Optional] Options to configure parquet support.
        """
        return pulumi.get(self, "parquet_options")

    @property
    @pulumi.getter(name="preserveAsciiControlCharacters")
    def preserve_ascii_control_characters(self) -> bool:
        """
        [Optional] Preserves the embedded ASCII control characters (the first 32 characters in the ASCII-table, from '\\x00' to '\\x1F') when loading from CSV. Only applicable to CSV, ignored for other formats.
        """
        return pulumi.get(self, "preserve_ascii_control_characters")

    @property
    @pulumi.getter(name="projectionFields")
    def projection_fields(self) -> Sequence[str]:
        """
        If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup. Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties. If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        """
        return pulumi.get(self, "projection_fields")

    @property
    @pulumi.getter
    def quote(self) -> str:
        """
        [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return pulumi.get(self, "quote")

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> 'outputs.RangePartitioningResponse':
        """
        [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "range_partitioning")

    @property
    @pulumi.getter
    def schema(self) -> 'outputs.TableSchemaResponse':
        """
        [Optional] The schema for the destination table. The schema can be omitted if the destination table already exists, or if you're loading data from Google Cloud Datastore.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="schemaInline")
    def schema_inline(self) -> str:
        """
        [Deprecated] The inline schema. For CSV schemas, specify as "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER, baz:FLOAT".
        """
        return pulumi.get(self, "schema_inline")

    @property
    @pulumi.getter(name="schemaInlineFormat")
    def schema_inline_format(self) -> str:
        """
        [Deprecated] The format of the schemaInline property.
        """
        return pulumi.get(self, "schema_inline_format")

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Sequence[str]:
        """
        Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> int:
        """
        [Optional] The number of rows at the top of a CSV file that BigQuery will skip when loading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        """
        return pulumi.get(self, "skip_leading_rows")

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> str:
        """
        [Optional] The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default value is CSV.
        """
        return pulumi.get(self, "source_format")

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> Sequence[str]:
        """
        [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        return pulumi.get(self, "source_uris")

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> 'outputs.TimePartitioningResponse':
        """
        Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "time_partitioning")

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> bool:
        """
        [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        return pulumi.get(self, "use_avro_logical_types")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> str:
        """
        [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_APPEND. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class JobConfigurationQueryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLargeResults":
            suggest = "allow_large_results"
        elif key == "connectionProperties":
            suggest = "connection_properties"
        elif key == "createDisposition":
            suggest = "create_disposition"
        elif key == "createSession":
            suggest = "create_session"
        elif key == "defaultDataset":
            suggest = "default_dataset"
        elif key == "destinationEncryptionConfiguration":
            suggest = "destination_encryption_configuration"
        elif key == "destinationTable":
            suggest = "destination_table"
        elif key == "flattenResults":
            suggest = "flatten_results"
        elif key == "maximumBillingTier":
            suggest = "maximum_billing_tier"
        elif key == "maximumBytesBilled":
            suggest = "maximum_bytes_billed"
        elif key == "parameterMode":
            suggest = "parameter_mode"
        elif key == "preserveNulls":
            suggest = "preserve_nulls"
        elif key == "queryParameters":
            suggest = "query_parameters"
        elif key == "rangePartitioning":
            suggest = "range_partitioning"
        elif key == "schemaUpdateOptions":
            suggest = "schema_update_options"
        elif key == "tableDefinitions":
            suggest = "table_definitions"
        elif key == "timePartitioning":
            suggest = "time_partitioning"
        elif key == "useLegacySql":
            suggest = "use_legacy_sql"
        elif key == "useQueryCache":
            suggest = "use_query_cache"
        elif key == "userDefinedFunctionResources":
            suggest = "user_defined_function_resources"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigurationQueryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigurationQueryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigurationQueryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_large_results: bool,
                 clustering: 'outputs.ClusteringResponse',
                 connection_properties: Sequence['outputs.ConnectionPropertyResponse'],
                 create_disposition: str,
                 create_session: bool,
                 default_dataset: 'outputs.DatasetReferenceResponse',
                 destination_encryption_configuration: 'outputs.EncryptionConfigurationResponse',
                 destination_table: 'outputs.TableReferenceResponse',
                 flatten_results: bool,
                 maximum_billing_tier: int,
                 maximum_bytes_billed: str,
                 parameter_mode: str,
                 preserve_nulls: bool,
                 priority: str,
                 query: str,
                 query_parameters: Sequence['outputs.QueryParameterResponse'],
                 range_partitioning: 'outputs.RangePartitioningResponse',
                 schema_update_options: Sequence[str],
                 table_definitions: Mapping[str, str],
                 time_partitioning: 'outputs.TimePartitioningResponse',
                 use_legacy_sql: bool,
                 use_query_cache: bool,
                 user_defined_function_resources: Sequence['outputs.UserDefinedFunctionResourceResponse'],
                 write_disposition: str):
        """
        :param bool allow_large_results: [Optional] If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance. Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed. However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        :param 'ClusteringResponse' clustering: [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        :param Sequence['ConnectionPropertyResponse'] connection_properties: Connection properties.
        :param str create_disposition: [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        :param bool create_session: If true, creates a new session, where session id will be a server generated random id. If false, runs query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-session mode.
        :param 'DatasetReferenceResponse' default_dataset: [Optional] Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
        :param 'EncryptionConfigurationResponse' destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys).
        :param 'TableReferenceResponse' destination_table: [Optional] Describes the table where the query results should be stored. If not present, a new table will be created to store the results. This property must be set for large results that exceed the maximum response size.
        :param bool flatten_results: [Optional] If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results. allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        :param int maximum_billing_tier: [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge). If unspecified, this will be set to your project default.
        :param str maximum_bytes_billed: [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge). If unspecified, this will be set to your project default.
        :param str parameter_mode: Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        :param bool preserve_nulls: [Deprecated] This property is deprecated.
        :param str priority: [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH. The default value is INTERACTIVE.
        :param str query: [Required] SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        :param Sequence['QueryParameterResponse'] query_parameters: Query parameters for standard SQL queries.
        :param 'RangePartitioningResponse' range_partitioning: [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        :param Sequence[str] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the query job. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param Mapping[str, str] table_definitions: [Optional] If querying an external data source outside of BigQuery, describes the data format, location and other properties of the data source. By defining these properties, the data source can then be queried as if it were a standard BigQuery table.
        :param 'TimePartitioningResponse' time_partitioning: Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        :param bool use_legacy_sql: Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true. If set to false, the query will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be run as if flattenResults is false.
        :param bool use_query_cache: [Optional] Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified. The default value is true.
        :param Sequence['UserDefinedFunctionResourceResponse'] user_defined_function_resources: Describes user-defined function resources used in the query.
        :param str write_disposition: [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        pulumi.set(__self__, "allow_large_results", allow_large_results)
        pulumi.set(__self__, "clustering", clustering)
        pulumi.set(__self__, "connection_properties", connection_properties)
        pulumi.set(__self__, "create_disposition", create_disposition)
        pulumi.set(__self__, "create_session", create_session)
        pulumi.set(__self__, "default_dataset", default_dataset)
        pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        pulumi.set(__self__, "destination_table", destination_table)
        pulumi.set(__self__, "flatten_results", flatten_results)
        pulumi.set(__self__, "maximum_billing_tier", maximum_billing_tier)
        pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        pulumi.set(__self__, "parameter_mode", parameter_mode)
        pulumi.set(__self__, "preserve_nulls", preserve_nulls)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_parameters", query_parameters)
        pulumi.set(__self__, "range_partitioning", range_partitioning)
        pulumi.set(__self__, "schema_update_options", schema_update_options)
        pulumi.set(__self__, "table_definitions", table_definitions)
        pulumi.set(__self__, "time_partitioning", time_partitioning)
        pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)
        pulumi.set(__self__, "use_query_cache", use_query_cache)
        pulumi.set(__self__, "user_defined_function_resources", user_defined_function_resources)
        pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="allowLargeResults")
    def allow_large_results(self) -> bool:
        """
        [Optional] If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance. Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed. However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        """
        return pulumi.get(self, "allow_large_results")

    @property
    @pulumi.getter
    def clustering(self) -> 'outputs.ClusteringResponse':
        """
        [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        """
        return pulumi.get(self, "clustering")

    @property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> Sequence['outputs.ConnectionPropertyResponse']:
        """
        Connection properties.
        """
        return pulumi.get(self, "connection_properties")

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> str:
        """
        [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "create_disposition")

    @property
    @pulumi.getter(name="createSession")
    def create_session(self) -> bool:
        """
        If true, creates a new session, where session id will be a server generated random id. If false, runs query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-session mode.
        """
        return pulumi.get(self, "create_session")

    @property
    @pulumi.getter(name="defaultDataset")
    def default_dataset(self) -> 'outputs.DatasetReferenceResponse':
        """
        [Optional] Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
        """
        return pulumi.get(self, "default_dataset")

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> 'outputs.EncryptionConfigurationResponse':
        """
        Custom encryption configuration (e.g., Cloud KMS keys).
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> 'outputs.TableReferenceResponse':
        """
        [Optional] Describes the table where the query results should be stored. If not present, a new table will be created to store the results. This property must be set for large results that exceed the maximum response size.
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="flattenResults")
    def flatten_results(self) -> bool:
        """
        [Optional] If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results. allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        """
        return pulumi.get(self, "flatten_results")

    @property
    @pulumi.getter(name="maximumBillingTier")
    def maximum_billing_tier(self) -> int:
        """
        [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge). If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_billing_tier")

    @property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> str:
        """
        [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge). If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @property
    @pulumi.getter(name="parameterMode")
    def parameter_mode(self) -> str:
        """
        Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        """
        return pulumi.get(self, "parameter_mode")

    @property
    @pulumi.getter(name="preserveNulls")
    def preserve_nulls(self) -> bool:
        """
        [Deprecated] This property is deprecated.
        """
        return pulumi.get(self, "preserve_nulls")

    @property
    @pulumi.getter
    def priority(self) -> str:
        """
        [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH. The default value is INTERACTIVE.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        [Required] SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Sequence['outputs.QueryParameterResponse']:
        """
        Query parameters for standard SQL queries.
        """
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> 'outputs.RangePartitioningResponse':
        """
        [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "range_partitioning")

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Sequence[str]:
        """
        Allows the schema of the destination table to be updated as a side effect of the query job. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @property
    @pulumi.getter(name="tableDefinitions")
    def table_definitions(self) -> Mapping[str, str]:
        """
        [Optional] If querying an external data source outside of BigQuery, describes the data format, location and other properties of the data source. By defining these properties, the data source can then be queried as if it were a standard BigQuery table.
        """
        return pulumi.get(self, "table_definitions")

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> 'outputs.TimePartitioningResponse':
        """
        Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "time_partitioning")

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> bool:
        """
        Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true. If set to false, the query will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be run as if flattenResults is false.
        """
        return pulumi.get(self, "use_legacy_sql")

    @property
    @pulumi.getter(name="useQueryCache")
    def use_query_cache(self) -> bool:
        """
        [Optional] Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified. The default value is true.
        """
        return pulumi.get(self, "use_query_cache")

    @property
    @pulumi.getter(name="userDefinedFunctionResources")
    def user_defined_function_resources(self) -> Sequence['outputs.UserDefinedFunctionResourceResponse']:
        """
        Describes user-defined function resources used in the query.
        """
        return pulumi.get(self, "user_defined_function_resources")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> str:
        """
        [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class JobConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dryRun":
            suggest = "dry_run"
        elif key == "jobTimeoutMs":
            suggest = "job_timeout_ms"
        elif key == "jobType":
            suggest = "job_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy: 'outputs.JobConfigurationTableCopyResponse',
                 dry_run: bool,
                 extract: 'outputs.JobConfigurationExtractResponse',
                 job_timeout_ms: str,
                 job_type: str,
                 labels: Mapping[str, str],
                 load: 'outputs.JobConfigurationLoadResponse',
                 query: 'outputs.JobConfigurationQueryResponse'):
        """
        :param 'JobConfigurationTableCopyResponse' copy: [Pick one] Copies a table.
        :param bool dry_run: [Optional] If set, don't actually run this job. A valid query will return a mostly empty response with some processing statistics, while an invalid query will return the same error it would if it wasn't a dry run. Behavior of non-query jobs is undefined.
        :param 'JobConfigurationExtractResponse' extract: [Pick one] Configures an extract job.
        :param str job_timeout_ms: [Optional] Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param str job_type: The type of the job. Can be QUERY, LOAD, EXTRACT, COPY or UNKNOWN.
        :param Mapping[str, str] labels: The labels associated with this job. You can use these to organize and group your jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
        :param 'JobConfigurationLoadResponse' load: [Pick one] Configures a load job.
        :param 'JobConfigurationQueryResponse' query: [Pick one] Configures a query job.
        """
        pulumi.set(__self__, "copy", copy)
        pulumi.set(__self__, "dry_run", dry_run)
        pulumi.set(__self__, "extract", extract)
        pulumi.set(__self__, "job_timeout_ms", job_timeout_ms)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "load", load)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def copy(self) -> 'outputs.JobConfigurationTableCopyResponse':
        """
        [Pick one] Copies a table.
        """
        return pulumi.get(self, "copy")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> bool:
        """
        [Optional] If set, don't actually run this job. A valid query will return a mostly empty response with some processing statistics, while an invalid query will return the same error it would if it wasn't a dry run. Behavior of non-query jobs is undefined.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter
    def extract(self) -> 'outputs.JobConfigurationExtractResponse':
        """
        [Pick one] Configures an extract job.
        """
        return pulumi.get(self, "extract")

    @property
    @pulumi.getter(name="jobTimeoutMs")
    def job_timeout_ms(self) -> str:
        """
        [Optional] Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        """
        return pulumi.get(self, "job_timeout_ms")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        The type of the job. Can be QUERY, LOAD, EXTRACT, COPY or UNKNOWN.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The labels associated with this job. You can use these to organize and group your jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def load(self) -> 'outputs.JobConfigurationLoadResponse':
        """
        [Pick one] Configures a load job.
        """
        return pulumi.get(self, "load")

    @property
    @pulumi.getter
    def query(self) -> 'outputs.JobConfigurationQueryResponse':
        """
        [Pick one] Configures a query job.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class JobConfigurationTableCopyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createDisposition":
            suggest = "create_disposition"
        elif key == "destinationEncryptionConfiguration":
            suggest = "destination_encryption_configuration"
        elif key == "destinationExpirationTime":
            suggest = "destination_expiration_time"
        elif key == "destinationTable":
            suggest = "destination_table"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "sourceTable":
            suggest = "source_table"
        elif key == "sourceTables":
            suggest = "source_tables"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfigurationTableCopyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfigurationTableCopyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfigurationTableCopyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_disposition: str,
                 destination_encryption_configuration: 'outputs.EncryptionConfigurationResponse',
                 destination_expiration_time: Any,
                 destination_table: 'outputs.TableReferenceResponse',
                 operation_type: str,
                 source_table: 'outputs.TableReferenceResponse',
                 source_tables: Sequence['outputs.TableReferenceResponse'],
                 write_disposition: str):
        """
        :param str create_disposition: [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        :param 'EncryptionConfigurationResponse' destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys).
        :param Any destination_expiration_time: [Optional] The time when the destination table expires. Expired tables will be deleted and their storage reclaimed.
        :param 'TableReferenceResponse' destination_table: [Required] The destination table
        :param str operation_type: [Optional] Supported operation types in table copy job.
        :param 'TableReferenceResponse' source_table: [Pick one] Source table to copy.
        :param Sequence['TableReferenceResponse'] source_tables: [Pick one] Source tables to copy.
        :param str write_disposition: [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        pulumi.set(__self__, "create_disposition", create_disposition)
        pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        pulumi.set(__self__, "destination_expiration_time", destination_expiration_time)
        pulumi.set(__self__, "destination_table", destination_table)
        pulumi.set(__self__, "operation_type", operation_type)
        pulumi.set(__self__, "source_table", source_table)
        pulumi.set(__self__, "source_tables", source_tables)
        pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> str:
        """
        [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "create_disposition")

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> 'outputs.EncryptionConfigurationResponse':
        """
        Custom encryption configuration (e.g., Cloud KMS keys).
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @property
    @pulumi.getter(name="destinationExpirationTime")
    def destination_expiration_time(self) -> Any:
        """
        [Optional] The time when the destination table expires. Expired tables will be deleted and their storage reclaimed.
        """
        return pulumi.get(self, "destination_expiration_time")

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> 'outputs.TableReferenceResponse':
        """
        [Required] The destination table
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> str:
        """
        [Optional] Supported operation types in table copy job.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> 'outputs.TableReferenceResponse':
        """
        [Pick one] Source table to copy.
        """
        return pulumi.get(self, "source_table")

    @property
    @pulumi.getter(name="sourceTables")
    def source_tables(self) -> Sequence['outputs.TableReferenceResponse']:
        """
        [Pick one] Source tables to copy.
        """
        return pulumi.get(self, "source_tables")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> str:
        """
        [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class JobReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: str,
                 location: str,
                 project: str):
        """
        :param str job_id: [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param str location: The geographic location of the job. See details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
        :param str project: [Required] The ID of the project containing this job.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geographic location of the job. See details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        [Required] The ID of the project containing this job.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class JobStatistics2ReservationUsageItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slotMs":
            suggest = "slot_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatistics2ReservationUsageItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatistics2ReservationUsageItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatistics2ReservationUsageItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 slot_ms: str):
        """
        :param str name: Reservation name or "unreserved" for on-demand resources usage.
        :param str slot_ms: Slot-milliseconds the job spent in the given reservation.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "slot_ms", slot_ms)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Reservation name or "unreserved" for on-demand resources usage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="slotMs")
    def slot_ms(self) -> str:
        """
        Slot-milliseconds the job spent in the given reservation.
        """
        return pulumi.get(self, "slot_ms")


@pulumi.output_type
class JobStatistics2Response(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "biEngineStatistics":
            suggest = "bi_engine_statistics"
        elif key == "billingTier":
            suggest = "billing_tier"
        elif key == "cacheHit":
            suggest = "cache_hit"
        elif key == "ddlAffectedRowAccessPolicyCount":
            suggest = "ddl_affected_row_access_policy_count"
        elif key == "ddlDestinationTable":
            suggest = "ddl_destination_table"
        elif key == "ddlOperationPerformed":
            suggest = "ddl_operation_performed"
        elif key == "ddlTargetDataset":
            suggest = "ddl_target_dataset"
        elif key == "ddlTargetRoutine":
            suggest = "ddl_target_routine"
        elif key == "ddlTargetRowAccessPolicy":
            suggest = "ddl_target_row_access_policy"
        elif key == "ddlTargetTable":
            suggest = "ddl_target_table"
        elif key == "dmlStats":
            suggest = "dml_stats"
        elif key == "estimatedBytesProcessed":
            suggest = "estimated_bytes_processed"
        elif key == "mlStatistics":
            suggest = "ml_statistics"
        elif key == "modelTraining":
            suggest = "model_training"
        elif key == "modelTrainingCurrentIteration":
            suggest = "model_training_current_iteration"
        elif key == "modelTrainingExpectedTotalIteration":
            suggest = "model_training_expected_total_iteration"
        elif key == "numDmlAffectedRows":
            suggest = "num_dml_affected_rows"
        elif key == "queryPlan":
            suggest = "query_plan"
        elif key == "referencedRoutines":
            suggest = "referenced_routines"
        elif key == "referencedTables":
            suggest = "referenced_tables"
        elif key == "reservationUsage":
            suggest = "reservation_usage"
        elif key == "statementType":
            suggest = "statement_type"
        elif key == "totalBytesBilled":
            suggest = "total_bytes_billed"
        elif key == "totalBytesProcessed":
            suggest = "total_bytes_processed"
        elif key == "totalBytesProcessedAccuracy":
            suggest = "total_bytes_processed_accuracy"
        elif key == "totalPartitionsProcessed":
            suggest = "total_partitions_processed"
        elif key == "totalSlotMs":
            suggest = "total_slot_ms"
        elif key == "undeclaredQueryParameters":
            suggest = "undeclared_query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatistics2Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatistics2Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatistics2Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bi_engine_statistics: 'outputs.BiEngineStatisticsResponse',
                 billing_tier: int,
                 cache_hit: bool,
                 ddl_affected_row_access_policy_count: str,
                 ddl_destination_table: 'outputs.TableReferenceResponse',
                 ddl_operation_performed: str,
                 ddl_target_dataset: 'outputs.DatasetReferenceResponse',
                 ddl_target_routine: 'outputs.RoutineReferenceResponse',
                 ddl_target_row_access_policy: 'outputs.RowAccessPolicyReferenceResponse',
                 ddl_target_table: 'outputs.TableReferenceResponse',
                 dml_stats: 'outputs.DmlStatisticsResponse',
                 estimated_bytes_processed: str,
                 ml_statistics: 'outputs.MlStatisticsResponse',
                 model_training: 'outputs.BigQueryModelTrainingResponse',
                 model_training_current_iteration: int,
                 model_training_expected_total_iteration: str,
                 num_dml_affected_rows: str,
                 query_plan: Sequence['outputs.ExplainQueryStageResponse'],
                 referenced_routines: Sequence['outputs.RoutineReferenceResponse'],
                 referenced_tables: Sequence['outputs.TableReferenceResponse'],
                 reservation_usage: Sequence['outputs.JobStatistics2ReservationUsageItemResponse'],
                 schema: 'outputs.TableSchemaResponse',
                 statement_type: str,
                 timeline: Sequence['outputs.QueryTimelineSampleResponse'],
                 total_bytes_billed: str,
                 total_bytes_processed: str,
                 total_bytes_processed_accuracy: str,
                 total_partitions_processed: str,
                 total_slot_ms: str,
                 undeclared_query_parameters: Sequence['outputs.QueryParameterResponse']):
        """
        :param 'BiEngineStatisticsResponse' bi_engine_statistics: BI Engine specific Statistics. [Output-only] BI Engine specific Statistics.
        :param int billing_tier: Billing tier for the job.
        :param bool cache_hit: Whether the query result was fetched from the query cache.
        :param str ddl_affected_row_access_policy_count: [Preview] The number of row access policies affected by a DDL statement. Present only for DROP ALL ROW ACCESS POLICIES queries.
        :param 'TableReferenceResponse' ddl_destination_table: The DDL destination table. Present only for ALTER TABLE RENAME TO queries. Note that ddl_target_table is used just for its type information.
        :param str ddl_operation_performed: The DDL operation performed, possibly dependent on the pre-existence of the DDL target. Possible values (new values might be added in the future): "CREATE": The query created the DDL target. "SKIP": No-op. Example cases: the query is CREATE TABLE IF NOT EXISTS while the table already exists, or the query is DROP TABLE IF EXISTS while the table does not exist. "REPLACE": The query replaced the DDL target. Example case: the query is CREATE OR REPLACE TABLE, and the table already exists. "DROP": The query deleted the DDL target.
        :param 'DatasetReferenceResponse' ddl_target_dataset: The DDL target dataset. Present only for CREATE/ALTER/DROP SCHEMA queries.
        :param 'RoutineReferenceResponse' ddl_target_routine: The DDL target routine. Present only for CREATE/DROP FUNCTION/PROCEDURE queries.
        :param 'RowAccessPolicyReferenceResponse' ddl_target_row_access_policy: [Preview] The DDL target row access policy. Present only for CREATE/DROP ROW ACCESS POLICY queries.
        :param 'TableReferenceResponse' ddl_target_table: The DDL target table. Present only for CREATE/DROP TABLE/VIEW and DROP ALL ROW ACCESS POLICIES queries.
        :param 'DmlStatisticsResponse' dml_stats: Detailed statistics for DML statements Present only for DML statements INSERT, UPDATE, DELETE or TRUNCATE.
        :param str estimated_bytes_processed: The original estimate of bytes processed for the job.
        :param 'MlStatisticsResponse' ml_statistics: Statistics of a BigQuery ML training job.
        :param 'BigQueryModelTrainingResponse' model_training: [Output-only, Beta] Information about create model query job progress.
        :param int model_training_current_iteration: [Output-only, Beta] Deprecated; do not use.
        :param str model_training_expected_total_iteration: [Output-only, Beta] Deprecated; do not use.
        :param str num_dml_affected_rows: The number of rows affected by a DML statement. Present only for DML statements INSERT, UPDATE or DELETE.
        :param Sequence['ExplainQueryStageResponse'] query_plan: Describes execution plan for the query.
        :param Sequence['RoutineReferenceResponse'] referenced_routines: Referenced routines (persistent user-defined functions and stored procedures) for the job.
        :param Sequence['TableReferenceResponse'] referenced_tables: Referenced tables for the job. Queries that reference more than 50 tables will not have a complete list.
        :param Sequence['JobStatistics2ReservationUsageItemResponse'] reservation_usage: Job resource usage breakdown by reservation.
        :param 'TableSchemaResponse' schema: The schema of the results. Present only for successful dry run of non-legacy SQL queries.
        :param str statement_type: The type of query statement, if valid. Possible values (new values might be added in the future): "SELECT": SELECT query. "INSERT": INSERT query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "UPDATE": UPDATE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "DELETE": DELETE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "MERGE": MERGE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "ALTER_TABLE": ALTER TABLE query. "ALTER_VIEW": ALTER VIEW query. "ASSERT": ASSERT condition AS 'description'. "CREATE_FUNCTION": CREATE FUNCTION query. "CREATE_MODEL": CREATE [OR REPLACE] MODEL ... AS SELECT ... . "CREATE_PROCEDURE": CREATE PROCEDURE query. "CREATE_TABLE": CREATE [OR REPLACE] TABLE without AS SELECT. "CREATE_TABLE_AS_SELECT": CREATE [OR REPLACE] TABLE ... AS SELECT ... . "CREATE_VIEW": CREATE [OR REPLACE] VIEW ... AS SELECT ... . "DROP_FUNCTION" : DROP FUNCTION query. "DROP_PROCEDURE": DROP PROCEDURE query. "DROP_TABLE": DROP TABLE query. "DROP_VIEW": DROP VIEW query.
        :param Sequence['QueryTimelineSampleResponse'] timeline: [Beta] Describes a timeline of job execution.
        :param str total_bytes_billed: Total bytes billed for the job.
        :param str total_bytes_processed: Total bytes processed for the job.
        :param str total_bytes_processed_accuracy: For dry-run jobs, totalBytesProcessed is an estimate and this field specifies the accuracy of the estimate. Possible values can be: UNKNOWN: accuracy of the estimate is unknown. PRECISE: estimate is precise. LOWER_BOUND: estimate is lower bound of what the query would cost. UPPER_BOUND: estimate is upper bound of what the query would cost.
        :param str total_partitions_processed: Total number of partitions processed from all partitioned tables referenced in the job.
        :param str total_slot_ms: Slot-milliseconds for the job.
        :param Sequence['QueryParameterResponse'] undeclared_query_parameters: Standard SQL only: list of undeclared query parameters detected during a dry run validation.
        """
        pulumi.set(__self__, "bi_engine_statistics", bi_engine_statistics)
        pulumi.set(__self__, "billing_tier", billing_tier)
        pulumi.set(__self__, "cache_hit", cache_hit)
        pulumi.set(__self__, "ddl_affected_row_access_policy_count", ddl_affected_row_access_policy_count)
        pulumi.set(__self__, "ddl_destination_table", ddl_destination_table)
        pulumi.set(__self__, "ddl_operation_performed", ddl_operation_performed)
        pulumi.set(__self__, "ddl_target_dataset", ddl_target_dataset)
        pulumi.set(__self__, "ddl_target_routine", ddl_target_routine)
        pulumi.set(__self__, "ddl_target_row_access_policy", ddl_target_row_access_policy)
        pulumi.set(__self__, "ddl_target_table", ddl_target_table)
        pulumi.set(__self__, "dml_stats", dml_stats)
        pulumi.set(__self__, "estimated_bytes_processed", estimated_bytes_processed)
        pulumi.set(__self__, "ml_statistics", ml_statistics)
        pulumi.set(__self__, "model_training", model_training)
        pulumi.set(__self__, "model_training_current_iteration", model_training_current_iteration)
        pulumi.set(__self__, "model_training_expected_total_iteration", model_training_expected_total_iteration)
        pulumi.set(__self__, "num_dml_affected_rows", num_dml_affected_rows)
        pulumi.set(__self__, "query_plan", query_plan)
        pulumi.set(__self__, "referenced_routines", referenced_routines)
        pulumi.set(__self__, "referenced_tables", referenced_tables)
        pulumi.set(__self__, "reservation_usage", reservation_usage)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "statement_type", statement_type)
        pulumi.set(__self__, "timeline", timeline)
        pulumi.set(__self__, "total_bytes_billed", total_bytes_billed)
        pulumi.set(__self__, "total_bytes_processed", total_bytes_processed)
        pulumi.set(__self__, "total_bytes_processed_accuracy", total_bytes_processed_accuracy)
        pulumi.set(__self__, "total_partitions_processed", total_partitions_processed)
        pulumi.set(__self__, "total_slot_ms", total_slot_ms)
        pulumi.set(__self__, "undeclared_query_parameters", undeclared_query_parameters)

    @property
    @pulumi.getter(name="biEngineStatistics")
    def bi_engine_statistics(self) -> 'outputs.BiEngineStatisticsResponse':
        """
        BI Engine specific Statistics. [Output-only] BI Engine specific Statistics.
        """
        return pulumi.get(self, "bi_engine_statistics")

    @property
    @pulumi.getter(name="billingTier")
    def billing_tier(self) -> int:
        """
        Billing tier for the job.
        """
        return pulumi.get(self, "billing_tier")

    @property
    @pulumi.getter(name="cacheHit")
    def cache_hit(self) -> bool:
        """
        Whether the query result was fetched from the query cache.
        """
        return pulumi.get(self, "cache_hit")

    @property
    @pulumi.getter(name="ddlAffectedRowAccessPolicyCount")
    def ddl_affected_row_access_policy_count(self) -> str:
        """
        [Preview] The number of row access policies affected by a DDL statement. Present only for DROP ALL ROW ACCESS POLICIES queries.
        """
        return pulumi.get(self, "ddl_affected_row_access_policy_count")

    @property
    @pulumi.getter(name="ddlDestinationTable")
    def ddl_destination_table(self) -> 'outputs.TableReferenceResponse':
        """
        The DDL destination table. Present only for ALTER TABLE RENAME TO queries. Note that ddl_target_table is used just for its type information.
        """
        return pulumi.get(self, "ddl_destination_table")

    @property
    @pulumi.getter(name="ddlOperationPerformed")
    def ddl_operation_performed(self) -> str:
        """
        The DDL operation performed, possibly dependent on the pre-existence of the DDL target. Possible values (new values might be added in the future): "CREATE": The query created the DDL target. "SKIP": No-op. Example cases: the query is CREATE TABLE IF NOT EXISTS while the table already exists, or the query is DROP TABLE IF EXISTS while the table does not exist. "REPLACE": The query replaced the DDL target. Example case: the query is CREATE OR REPLACE TABLE, and the table already exists. "DROP": The query deleted the DDL target.
        """
        return pulumi.get(self, "ddl_operation_performed")

    @property
    @pulumi.getter(name="ddlTargetDataset")
    def ddl_target_dataset(self) -> 'outputs.DatasetReferenceResponse':
        """
        The DDL target dataset. Present only for CREATE/ALTER/DROP SCHEMA queries.
        """
        return pulumi.get(self, "ddl_target_dataset")

    @property
    @pulumi.getter(name="ddlTargetRoutine")
    def ddl_target_routine(self) -> 'outputs.RoutineReferenceResponse':
        """
        The DDL target routine. Present only for CREATE/DROP FUNCTION/PROCEDURE queries.
        """
        return pulumi.get(self, "ddl_target_routine")

    @property
    @pulumi.getter(name="ddlTargetRowAccessPolicy")
    def ddl_target_row_access_policy(self) -> 'outputs.RowAccessPolicyReferenceResponse':
        """
        [Preview] The DDL target row access policy. Present only for CREATE/DROP ROW ACCESS POLICY queries.
        """
        return pulumi.get(self, "ddl_target_row_access_policy")

    @property
    @pulumi.getter(name="ddlTargetTable")
    def ddl_target_table(self) -> 'outputs.TableReferenceResponse':
        """
        The DDL target table. Present only for CREATE/DROP TABLE/VIEW and DROP ALL ROW ACCESS POLICIES queries.
        """
        return pulumi.get(self, "ddl_target_table")

    @property
    @pulumi.getter(name="dmlStats")
    def dml_stats(self) -> 'outputs.DmlStatisticsResponse':
        """
        Detailed statistics for DML statements Present only for DML statements INSERT, UPDATE, DELETE or TRUNCATE.
        """
        return pulumi.get(self, "dml_stats")

    @property
    @pulumi.getter(name="estimatedBytesProcessed")
    def estimated_bytes_processed(self) -> str:
        """
        The original estimate of bytes processed for the job.
        """
        return pulumi.get(self, "estimated_bytes_processed")

    @property
    @pulumi.getter(name="mlStatistics")
    def ml_statistics(self) -> 'outputs.MlStatisticsResponse':
        """
        Statistics of a BigQuery ML training job.
        """
        return pulumi.get(self, "ml_statistics")

    @property
    @pulumi.getter(name="modelTraining")
    def model_training(self) -> 'outputs.BigQueryModelTrainingResponse':
        """
        [Output-only, Beta] Information about create model query job progress.
        """
        return pulumi.get(self, "model_training")

    @property
    @pulumi.getter(name="modelTrainingCurrentIteration")
    def model_training_current_iteration(self) -> int:
        """
        [Output-only, Beta] Deprecated; do not use.
        """
        return pulumi.get(self, "model_training_current_iteration")

    @property
    @pulumi.getter(name="modelTrainingExpectedTotalIteration")
    def model_training_expected_total_iteration(self) -> str:
        """
        [Output-only, Beta] Deprecated; do not use.
        """
        return pulumi.get(self, "model_training_expected_total_iteration")

    @property
    @pulumi.getter(name="numDmlAffectedRows")
    def num_dml_affected_rows(self) -> str:
        """
        The number of rows affected by a DML statement. Present only for DML statements INSERT, UPDATE or DELETE.
        """
        return pulumi.get(self, "num_dml_affected_rows")

    @property
    @pulumi.getter(name="queryPlan")
    def query_plan(self) -> Sequence['outputs.ExplainQueryStageResponse']:
        """
        Describes execution plan for the query.
        """
        return pulumi.get(self, "query_plan")

    @property
    @pulumi.getter(name="referencedRoutines")
    def referenced_routines(self) -> Sequence['outputs.RoutineReferenceResponse']:
        """
        Referenced routines (persistent user-defined functions and stored procedures) for the job.
        """
        return pulumi.get(self, "referenced_routines")

    @property
    @pulumi.getter(name="referencedTables")
    def referenced_tables(self) -> Sequence['outputs.TableReferenceResponse']:
        """
        Referenced tables for the job. Queries that reference more than 50 tables will not have a complete list.
        """
        return pulumi.get(self, "referenced_tables")

    @property
    @pulumi.getter(name="reservationUsage")
    def reservation_usage(self) -> Sequence['outputs.JobStatistics2ReservationUsageItemResponse']:
        """
        Job resource usage breakdown by reservation.
        """
        return pulumi.get(self, "reservation_usage")

    @property
    @pulumi.getter
    def schema(self) -> 'outputs.TableSchemaResponse':
        """
        The schema of the results. Present only for successful dry run of non-legacy SQL queries.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="statementType")
    def statement_type(self) -> str:
        """
        The type of query statement, if valid. Possible values (new values might be added in the future): "SELECT": SELECT query. "INSERT": INSERT query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "UPDATE": UPDATE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "DELETE": DELETE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "MERGE": MERGE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "ALTER_TABLE": ALTER TABLE query. "ALTER_VIEW": ALTER VIEW query. "ASSERT": ASSERT condition AS 'description'. "CREATE_FUNCTION": CREATE FUNCTION query. "CREATE_MODEL": CREATE [OR REPLACE] MODEL ... AS SELECT ... . "CREATE_PROCEDURE": CREATE PROCEDURE query. "CREATE_TABLE": CREATE [OR REPLACE] TABLE without AS SELECT. "CREATE_TABLE_AS_SELECT": CREATE [OR REPLACE] TABLE ... AS SELECT ... . "CREATE_VIEW": CREATE [OR REPLACE] VIEW ... AS SELECT ... . "DROP_FUNCTION" : DROP FUNCTION query. "DROP_PROCEDURE": DROP PROCEDURE query. "DROP_TABLE": DROP TABLE query. "DROP_VIEW": DROP VIEW query.
        """
        return pulumi.get(self, "statement_type")

    @property
    @pulumi.getter
    def timeline(self) -> Sequence['outputs.QueryTimelineSampleResponse']:
        """
        [Beta] Describes a timeline of job execution.
        """
        return pulumi.get(self, "timeline")

    @property
    @pulumi.getter(name="totalBytesBilled")
    def total_bytes_billed(self) -> str:
        """
        Total bytes billed for the job.
        """
        return pulumi.get(self, "total_bytes_billed")

    @property
    @pulumi.getter(name="totalBytesProcessed")
    def total_bytes_processed(self) -> str:
        """
        Total bytes processed for the job.
        """
        return pulumi.get(self, "total_bytes_processed")

    @property
    @pulumi.getter(name="totalBytesProcessedAccuracy")
    def total_bytes_processed_accuracy(self) -> str:
        """
        For dry-run jobs, totalBytesProcessed is an estimate and this field specifies the accuracy of the estimate. Possible values can be: UNKNOWN: accuracy of the estimate is unknown. PRECISE: estimate is precise. LOWER_BOUND: estimate is lower bound of what the query would cost. UPPER_BOUND: estimate is upper bound of what the query would cost.
        """
        return pulumi.get(self, "total_bytes_processed_accuracy")

    @property
    @pulumi.getter(name="totalPartitionsProcessed")
    def total_partitions_processed(self) -> str:
        """
        Total number of partitions processed from all partitioned tables referenced in the job.
        """
        return pulumi.get(self, "total_partitions_processed")

    @property
    @pulumi.getter(name="totalSlotMs")
    def total_slot_ms(self) -> str:
        """
        Slot-milliseconds for the job.
        """
        return pulumi.get(self, "total_slot_ms")

    @property
    @pulumi.getter(name="undeclaredQueryParameters")
    def undeclared_query_parameters(self) -> Sequence['outputs.QueryParameterResponse']:
        """
        Standard SQL only: list of undeclared query parameters detected during a dry run validation.
        """
        return pulumi.get(self, "undeclared_query_parameters")


@pulumi.output_type
class JobStatistics3Response(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badRecords":
            suggest = "bad_records"
        elif key == "inputFileBytes":
            suggest = "input_file_bytes"
        elif key == "inputFiles":
            suggest = "input_files"
        elif key == "outputBytes":
            suggest = "output_bytes"
        elif key == "outputRows":
            suggest = "output_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatistics3Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatistics3Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatistics3Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_records: str,
                 input_file_bytes: str,
                 input_files: str,
                 output_bytes: str,
                 output_rows: str):
        """
        :param str bad_records: The number of bad records encountered. Note that if the job has failed because of more bad records encountered than the maximum allowed in the load job configuration, then this number can be less than the total number of bad records present in the input data.
        :param str input_file_bytes: Number of bytes of source data in a load job.
        :param str input_files: Number of source files in a load job.
        :param str output_bytes: Size of the loaded data in bytes. Note that while a load job is in the running state, this value may change.
        :param str output_rows: Number of rows imported in a load job. Note that while an import job is in the running state, this value may change.
        """
        pulumi.set(__self__, "bad_records", bad_records)
        pulumi.set(__self__, "input_file_bytes", input_file_bytes)
        pulumi.set(__self__, "input_files", input_files)
        pulumi.set(__self__, "output_bytes", output_bytes)
        pulumi.set(__self__, "output_rows", output_rows)

    @property
    @pulumi.getter(name="badRecords")
    def bad_records(self) -> str:
        """
        The number of bad records encountered. Note that if the job has failed because of more bad records encountered than the maximum allowed in the load job configuration, then this number can be less than the total number of bad records present in the input data.
        """
        return pulumi.get(self, "bad_records")

    @property
    @pulumi.getter(name="inputFileBytes")
    def input_file_bytes(self) -> str:
        """
        Number of bytes of source data in a load job.
        """
        return pulumi.get(self, "input_file_bytes")

    @property
    @pulumi.getter(name="inputFiles")
    def input_files(self) -> str:
        """
        Number of source files in a load job.
        """
        return pulumi.get(self, "input_files")

    @property
    @pulumi.getter(name="outputBytes")
    def output_bytes(self) -> str:
        """
        Size of the loaded data in bytes. Note that while a load job is in the running state, this value may change.
        """
        return pulumi.get(self, "output_bytes")

    @property
    @pulumi.getter(name="outputRows")
    def output_rows(self) -> str:
        """
        Number of rows imported in a load job. Note that while an import job is in the running state, this value may change.
        """
        return pulumi.get(self, "output_rows")


@pulumi.output_type
class JobStatistics4Response(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationUriFileCounts":
            suggest = "destination_uri_file_counts"
        elif key == "inputBytes":
            suggest = "input_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatistics4Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatistics4Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatistics4Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_uri_file_counts: Sequence[str],
                 input_bytes: str):
        """
        :param Sequence[str] destination_uri_file_counts: Number of files per destination URI or URI pattern specified in the extract configuration. These values will be in the same order as the URIs specified in the 'destinationUris' field.
        :param str input_bytes: Number of user bytes extracted into the result. This is the byte count as computed by BigQuery for billing purposes.
        """
        pulumi.set(__self__, "destination_uri_file_counts", destination_uri_file_counts)
        pulumi.set(__self__, "input_bytes", input_bytes)

    @property
    @pulumi.getter(name="destinationUriFileCounts")
    def destination_uri_file_counts(self) -> Sequence[str]:
        """
        Number of files per destination URI or URI pattern specified in the extract configuration. These values will be in the same order as the URIs specified in the 'destinationUris' field.
        """
        return pulumi.get(self, "destination_uri_file_counts")

    @property
    @pulumi.getter(name="inputBytes")
    def input_bytes(self) -> str:
        """
        Number of user bytes extracted into the result. This is the byte count as computed by BigQuery for billing purposes.
        """
        return pulumi.get(self, "input_bytes")


@pulumi.output_type
class JobStatistics5Response(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copiedLogicalBytes":
            suggest = "copied_logical_bytes"
        elif key == "copiedRows":
            suggest = "copied_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatistics5Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatistics5Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatistics5Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copied_logical_bytes: str,
                 copied_rows: str):
        """
        :param str copied_logical_bytes: Number of logical bytes copied to the destination table.
        :param str copied_rows: Number of rows copied to the destination table.
        """
        pulumi.set(__self__, "copied_logical_bytes", copied_logical_bytes)
        pulumi.set(__self__, "copied_rows", copied_rows)

    @property
    @pulumi.getter(name="copiedLogicalBytes")
    def copied_logical_bytes(self) -> str:
        """
        Number of logical bytes copied to the destination table.
        """
        return pulumi.get(self, "copied_logical_bytes")

    @property
    @pulumi.getter(name="copiedRows")
    def copied_rows(self) -> str:
        """
        Number of rows copied to the destination table.
        """
        return pulumi.get(self, "copied_rows")


@pulumi.output_type
class JobStatisticsReservationUsageItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slotMs":
            suggest = "slot_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatisticsReservationUsageItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatisticsReservationUsageItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatisticsReservationUsageItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 slot_ms: str):
        """
        :param str name: Reservation name or "unreserved" for on-demand resources usage.
        :param str slot_ms: Slot-milliseconds the job spent in the given reservation.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "slot_ms", slot_ms)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Reservation name or "unreserved" for on-demand resources usage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="slotMs")
    def slot_ms(self) -> str:
        """
        Slot-milliseconds the job spent in the given reservation.
        """
        return pulumi.get(self, "slot_ms")


@pulumi.output_type
class JobStatisticsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionRatio":
            suggest = "completion_ratio"
        elif key == "creationTime":
            suggest = "creation_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "numChildJobs":
            suggest = "num_child_jobs"
        elif key == "parentJobId":
            suggest = "parent_job_id"
        elif key == "quotaDeferments":
            suggest = "quota_deferments"
        elif key == "reservationId":
            suggest = "reservation_id"
        elif key == "reservationUsage":
            suggest = "reservation_usage"
        elif key == "rowLevelSecurityStatistics":
            suggest = "row_level_security_statistics"
        elif key == "scriptStatistics":
            suggest = "script_statistics"
        elif key == "sessionInfo":
            suggest = "session_info"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "totalBytesProcessed":
            suggest = "total_bytes_processed"
        elif key == "totalSlotMs":
            suggest = "total_slot_ms"
        elif key == "transactionInfo":
            suggest = "transaction_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_ratio: float,
                 copy: 'outputs.JobStatistics5Response',
                 creation_time: str,
                 end_time: str,
                 extract: 'outputs.JobStatistics4Response',
                 load: 'outputs.JobStatistics3Response',
                 num_child_jobs: str,
                 parent_job_id: str,
                 query: 'outputs.JobStatistics2Response',
                 quota_deferments: Sequence[str],
                 reservation_id: str,
                 reservation_usage: Sequence['outputs.JobStatisticsReservationUsageItemResponse'],
                 row_level_security_statistics: 'outputs.RowLevelSecurityStatisticsResponse',
                 script_statistics: 'outputs.ScriptStatisticsResponse',
                 session_info: 'outputs.SessionInfoResponse',
                 start_time: str,
                 total_bytes_processed: str,
                 total_slot_ms: str,
                 transaction_info: 'outputs.TransactionInfoResponse'):
        """
        :param float completion_ratio: [TrustedTester] [Output-only] Job progress (0.0 -> 1.0) for LOAD and EXTRACT jobs.
        :param 'JobStatistics5Response' copy: Statistics for a copy job.
        :param str creation_time: Creation time of this job, in milliseconds since the epoch. This field will be present on all jobs.
        :param str end_time: End time of this job, in milliseconds since the epoch. This field will be present whenever a job is in the DONE state.
        :param 'JobStatistics4Response' extract: Statistics for an extract job.
        :param 'JobStatistics3Response' load: Statistics for a load job.
        :param str num_child_jobs: Number of child jobs executed.
        :param str parent_job_id: If this is a child job, the id of the parent.
        :param 'JobStatistics2Response' query: Statistics for a query job.
        :param Sequence[str] quota_deferments: Quotas which delayed this job's start time.
        :param str reservation_id: Name of the primary reservation assigned to this job. Note that this could be different than reservations reported in the reservation usage field if parent reservations were used to execute this job.
        :param Sequence['JobStatisticsReservationUsageItemResponse'] reservation_usage: Job resource usage breakdown by reservation.
        :param 'RowLevelSecurityStatisticsResponse' row_level_security_statistics: [Preview] Statistics for row-level security. Present only for query and extract jobs.
        :param 'ScriptStatisticsResponse' script_statistics: Statistics for a child job of a script.
        :param 'SessionInfoResponse' session_info: [Preview] Information of the session if this job is part of one.
        :param str start_time: Start time of this job, in milliseconds since the epoch. This field will be present when the job transitions from the PENDING state to either RUNNING or DONE.
        :param str total_bytes_processed: [Deprecated] Use the bytes processed in the query statistics instead.
        :param str total_slot_ms: Slot-milliseconds for the job.
        :param 'TransactionInfoResponse' transaction_info: [Alpha] Information of the multi-statement transaction if this job is part of one.
        """
        pulumi.set(__self__, "completion_ratio", completion_ratio)
        pulumi.set(__self__, "copy", copy)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "extract", extract)
        pulumi.set(__self__, "load", load)
        pulumi.set(__self__, "num_child_jobs", num_child_jobs)
        pulumi.set(__self__, "parent_job_id", parent_job_id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "quota_deferments", quota_deferments)
        pulumi.set(__self__, "reservation_id", reservation_id)
        pulumi.set(__self__, "reservation_usage", reservation_usage)
        pulumi.set(__self__, "row_level_security_statistics", row_level_security_statistics)
        pulumi.set(__self__, "script_statistics", script_statistics)
        pulumi.set(__self__, "session_info", session_info)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "total_bytes_processed", total_bytes_processed)
        pulumi.set(__self__, "total_slot_ms", total_slot_ms)
        pulumi.set(__self__, "transaction_info", transaction_info)

    @property
    @pulumi.getter(name="completionRatio")
    def completion_ratio(self) -> float:
        """
        [TrustedTester] [Output-only] Job progress (0.0 -> 1.0) for LOAD and EXTRACT jobs.
        """
        return pulumi.get(self, "completion_ratio")

    @property
    @pulumi.getter
    def copy(self) -> 'outputs.JobStatistics5Response':
        """
        Statistics for a copy job.
        """
        return pulumi.get(self, "copy")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of this job, in milliseconds since the epoch. This field will be present on all jobs.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End time of this job, in milliseconds since the epoch. This field will be present whenever a job is in the DONE state.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def extract(self) -> 'outputs.JobStatistics4Response':
        """
        Statistics for an extract job.
        """
        return pulumi.get(self, "extract")

    @property
    @pulumi.getter
    def load(self) -> 'outputs.JobStatistics3Response':
        """
        Statistics for a load job.
        """
        return pulumi.get(self, "load")

    @property
    @pulumi.getter(name="numChildJobs")
    def num_child_jobs(self) -> str:
        """
        Number of child jobs executed.
        """
        return pulumi.get(self, "num_child_jobs")

    @property
    @pulumi.getter(name="parentJobId")
    def parent_job_id(self) -> str:
        """
        If this is a child job, the id of the parent.
        """
        return pulumi.get(self, "parent_job_id")

    @property
    @pulumi.getter
    def query(self) -> 'outputs.JobStatistics2Response':
        """
        Statistics for a query job.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="quotaDeferments")
    def quota_deferments(self) -> Sequence[str]:
        """
        Quotas which delayed this job's start time.
        """
        return pulumi.get(self, "quota_deferments")

    @property
    @pulumi.getter(name="reservationId")
    def reservation_id(self) -> str:
        """
        Name of the primary reservation assigned to this job. Note that this could be different than reservations reported in the reservation usage field if parent reservations were used to execute this job.
        """
        return pulumi.get(self, "reservation_id")

    @property
    @pulumi.getter(name="reservationUsage")
    def reservation_usage(self) -> Sequence['outputs.JobStatisticsReservationUsageItemResponse']:
        """
        Job resource usage breakdown by reservation.
        """
        return pulumi.get(self, "reservation_usage")

    @property
    @pulumi.getter(name="rowLevelSecurityStatistics")
    def row_level_security_statistics(self) -> 'outputs.RowLevelSecurityStatisticsResponse':
        """
        [Preview] Statistics for row-level security. Present only for query and extract jobs.
        """
        return pulumi.get(self, "row_level_security_statistics")

    @property
    @pulumi.getter(name="scriptStatistics")
    def script_statistics(self) -> 'outputs.ScriptStatisticsResponse':
        """
        Statistics for a child job of a script.
        """
        return pulumi.get(self, "script_statistics")

    @property
    @pulumi.getter(name="sessionInfo")
    def session_info(self) -> 'outputs.SessionInfoResponse':
        """
        [Preview] Information of the session if this job is part of one.
        """
        return pulumi.get(self, "session_info")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time of this job, in milliseconds since the epoch. This field will be present when the job transitions from the PENDING state to either RUNNING or DONE.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="totalBytesProcessed")
    def total_bytes_processed(self) -> str:
        """
        [Deprecated] Use the bytes processed in the query statistics instead.
        """
        return pulumi.get(self, "total_bytes_processed")

    @property
    @pulumi.getter(name="totalSlotMs")
    def total_slot_ms(self) -> str:
        """
        Slot-milliseconds for the job.
        """
        return pulumi.get(self, "total_slot_ms")

    @property
    @pulumi.getter(name="transactionInfo")
    def transaction_info(self) -> 'outputs.TransactionInfoResponse':
        """
        [Alpha] Information of the multi-statement transaction if this job is part of one.
        """
        return pulumi.get(self, "transaction_info")


@pulumi.output_type
class JobStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorResult":
            suggest = "error_result"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_result: 'outputs.ErrorProtoResponse',
                 errors: Sequence['outputs.ErrorProtoResponse'],
                 state: str):
        """
        :param 'ErrorProtoResponse' error_result: Final error result of the job. If present, indicates that the job has completed and was unsuccessful.
        :param Sequence['ErrorProtoResponse'] errors: The first errors encountered during the running of the job. The final message includes the number of errors that caused the process to stop. Errors here do not necessarily mean that the job has completed or was unsuccessful.
        :param str state: Running state of the job.
        """
        pulumi.set(__self__, "error_result", error_result)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="errorResult")
    def error_result(self) -> 'outputs.ErrorProtoResponse':
        """
        Final error result of the job. If present, indicates that the job has completed and was unsuccessful.
        """
        return pulumi.get(self, "error_result")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ErrorProtoResponse']:
        """
        The first errors encountered during the running of the job. The final message includes the number of errors that caused the process to stop. Errors here do not necessarily mean that the job has completed or was unsuccessful.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Running state of the job.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MaterializedViewDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableRefresh":
            suggest = "enable_refresh"
        elif key == "lastRefreshTime":
            suggest = "last_refresh_time"
        elif key == "maxStaleness":
            suggest = "max_staleness"
        elif key == "refreshIntervalMs":
            suggest = "refresh_interval_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaterializedViewDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaterializedViewDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaterializedViewDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_refresh: bool,
                 last_refresh_time: str,
                 max_staleness: str,
                 query: str,
                 refresh_interval_ms: str):
        """
        :param bool enable_refresh: [Optional] [TrustedTester] Enable automatic refresh of the materialized view when the base table is updated. The default value is "true".
        :param str last_refresh_time: [TrustedTester] The time when this materialized view was last modified, in milliseconds since the epoch.
        :param str max_staleness: [Optional] Max staleness of data that could be returned when materizlized view is queried (formatted as Google SQL Interval type).
        :param str query: [Required] A query whose result is persisted.
        :param str refresh_interval_ms: [Optional] [TrustedTester] The maximum frequency at which this materialized view will be refreshed. The default value is "1800000" (30 minutes).
        """
        pulumi.set(__self__, "enable_refresh", enable_refresh)
        pulumi.set(__self__, "last_refresh_time", last_refresh_time)
        pulumi.set(__self__, "max_staleness", max_staleness)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "refresh_interval_ms", refresh_interval_ms)

    @property
    @pulumi.getter(name="enableRefresh")
    def enable_refresh(self) -> bool:
        """
        [Optional] [TrustedTester] Enable automatic refresh of the materialized view when the base table is updated. The default value is "true".
        """
        return pulumi.get(self, "enable_refresh")

    @property
    @pulumi.getter(name="lastRefreshTime")
    def last_refresh_time(self) -> str:
        """
        [TrustedTester] The time when this materialized view was last modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_refresh_time")

    @property
    @pulumi.getter(name="maxStaleness")
    def max_staleness(self) -> str:
        """
        [Optional] Max staleness of data that could be returned when materizlized view is queried (formatted as Google SQL Interval type).
        """
        return pulumi.get(self, "max_staleness")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        [Required] A query whose result is persisted.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="refreshIntervalMs")
    def refresh_interval_ms(self) -> str:
        """
        [Optional] [TrustedTester] The maximum frequency at which this materialized view will be refreshed. The default value is "1800000" (30 minutes).
        """
        return pulumi.get(self, "refresh_interval_ms")


@pulumi.output_type
class MlStatisticsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iterationResults":
            suggest = "iteration_results"
        elif key == "maxIterations":
            suggest = "max_iterations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MlStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MlStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MlStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iteration_results: Sequence['outputs.IterationResultResponse'],
                 max_iterations: str):
        """
        :param Sequence['IterationResultResponse'] iteration_results: Results for all completed iterations.
        :param str max_iterations: Maximum number of iterations specified as max_iterations in the 'CREATE MODEL' query. The actual number of iterations may be less than this number due to early stop.
        """
        pulumi.set(__self__, "iteration_results", iteration_results)
        pulumi.set(__self__, "max_iterations", max_iterations)

    @property
    @pulumi.getter(name="iterationResults")
    def iteration_results(self) -> Sequence['outputs.IterationResultResponse']:
        """
        Results for all completed iterations.
        """
        return pulumi.get(self, "iteration_results")

    @property
    @pulumi.getter(name="maxIterations")
    def max_iterations(self) -> str:
        """
        Maximum number of iterations specified as max_iterations in the 'CREATE MODEL' query. The actual number of iterations may be less than this number due to early stop.
        """
        return pulumi.get(self, "max_iterations")


@pulumi.output_type
class ModelDefinitionModelOptionsResponse(dict):
    """
    [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lossType":
            suggest = "loss_type"
        elif key == "modelType":
            suggest = "model_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelDefinitionModelOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelDefinitionModelOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelDefinitionModelOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 labels: Sequence[str],
                 loss_type: str,
                 model_type: str):
        """
        [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "loss_type", loss_type)
        pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter
    def labels(self) -> Sequence[str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lossType")
    def loss_type(self) -> str:
        return pulumi.get(self, "loss_type")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        return pulumi.get(self, "model_type")


@pulumi.output_type
class ModelDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelOptions":
            suggest = "model_options"
        elif key == "trainingRuns":
            suggest = "training_runs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_options: 'outputs.ModelDefinitionModelOptionsResponse',
                 training_runs: Sequence['outputs.BqmlTrainingRunResponse']):
        """
        :param 'ModelDefinitionModelOptionsResponse' model_options: [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
        :param Sequence['BqmlTrainingRunResponse'] training_runs: [Output-only, Beta] Information about ml training runs, each training run comprises of multiple iterations and there may be multiple training runs for the model if warm start is used or if a user decides to continue a previously cancelled query.
        """
        pulumi.set(__self__, "model_options", model_options)
        pulumi.set(__self__, "training_runs", training_runs)

    @property
    @pulumi.getter(name="modelOptions")
    def model_options(self) -> 'outputs.ModelDefinitionModelOptionsResponse':
        """
        [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
        """
        return pulumi.get(self, "model_options")

    @property
    @pulumi.getter(name="trainingRuns")
    def training_runs(self) -> Sequence['outputs.BqmlTrainingRunResponse']:
        """
        [Output-only, Beta] Information about ml training runs, each training run comprises of multiple iterations and there may be multiple training runs for the model if warm start is used or if a user decides to continue a previously cancelled query.
        """
        return pulumi.get(self, "training_runs")


@pulumi.output_type
class ModelReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "modelId":
            suggest = "model_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 model_id: str,
                 project: str):
        """
        :param str dataset_id: [Required] The ID of the dataset containing this model.
        :param str model_id: [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param str project: [Required] The ID of the project containing this model.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        [Required] The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        [Required] The ID of the project containing this model.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ParquetOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableListInference":
            suggest = "enable_list_inference"
        elif key == "enumAsString":
            suggest = "enum_as_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParquetOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParquetOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParquetOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_list_inference: bool,
                 enum_as_string: bool):
        """
        :param bool enable_list_inference: [Optional] Indicates whether to use schema inference specifically for Parquet LIST logical type.
        :param bool enum_as_string: [Optional] Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        pulumi.set(__self__, "enable_list_inference", enable_list_inference)
        pulumi.set(__self__, "enum_as_string", enum_as_string)

    @property
    @pulumi.getter(name="enableListInference")
    def enable_list_inference(self) -> bool:
        """
        [Optional] Indicates whether to use schema inference specifically for Parquet LIST logical type.
        """
        return pulumi.get(self, "enable_list_inference")

    @property
    @pulumi.getter(name="enumAsString")
    def enum_as_string(self) -> bool:
        """
        [Optional] Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        return pulumi.get(self, "enum_as_string")


@pulumi.output_type
class QueryParameterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterType":
            suggest = "parameter_type"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 parameter_type: 'outputs.QueryParameterTypeResponse',
                 parameter_value: 'outputs.QueryParameterValueResponse'):
        """
        :param str name: [Optional] If unset, this is a positional parameter. Otherwise, should be unique within a query.
        :param 'QueryParameterTypeResponse' parameter_type: [Required] The type of this parameter.
        :param 'QueryParameterValueResponse' parameter_value: [Required] The value of this parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        [Optional] If unset, this is a positional parameter. Otherwise, should be unique within a query.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> 'outputs.QueryParameterTypeResponse':
        """
        [Required] The type of this parameter.
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> 'outputs.QueryParameterValueResponse':
        """
        [Required] The value of this parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class QueryParameterTypeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arrayType":
            suggest = "array_type"
        elif key == "structTypes":
            suggest = "struct_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryParameterTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryParameterTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryParameterTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 array_type: 'outputs.QueryParameterTypeResponse',
                 struct_types: Sequence['outputs.QueryParameterTypeStructTypesItemResponse'],
                 type: str):
        """
        :param 'QueryParameterTypeResponse' array_type: [Optional] The type of the array's elements, if this is an array.
        :param Sequence['QueryParameterTypeStructTypesItemResponse'] struct_types: [Optional] The types of the fields of this struct, in order, if this is a struct.
        :param str type: [Required] The top level type of this field.
        """
        pulumi.set(__self__, "array_type", array_type)
        pulumi.set(__self__, "struct_types", struct_types)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="arrayType")
    def array_type(self) -> 'outputs.QueryParameterTypeResponse':
        """
        [Optional] The type of the array's elements, if this is an array.
        """
        return pulumi.get(self, "array_type")

    @property
    @pulumi.getter(name="structTypes")
    def struct_types(self) -> Sequence['outputs.QueryParameterTypeStructTypesItemResponse']:
        """
        [Optional] The types of the fields of this struct, in order, if this is a struct.
        """
        return pulumi.get(self, "struct_types")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        [Required] The top level type of this field.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class QueryParameterTypeStructTypesItemResponse(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 type: 'outputs.QueryParameterTypeResponse'):
        """
        :param str description: [Optional] Human-oriented description of the field.
        :param str name: [Optional] The name of this field.
        :param 'QueryParameterTypeResponse' type: [Required] The type of this field.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        [Optional] Human-oriented description of the field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        [Optional] The name of this field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'outputs.QueryParameterTypeResponse':
        """
        [Required] The type of this field.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class QueryParameterValueResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arrayValues":
            suggest = "array_values"
        elif key == "structValues":
            suggest = "struct_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryParameterValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryParameterValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryParameterValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 array_values: Sequence['outputs.QueryParameterValueResponse'],
                 struct_values: Mapping[str, str],
                 value: str):
        """
        :param Sequence['QueryParameterValueResponse'] array_values: [Optional] The array values, if this is an array type.
        :param Mapping[str, str] struct_values: [Optional] The struct field values, in order of the struct type's declaration.
        :param str value: [Optional] The value of this value, if a simple scalar type.
        """
        pulumi.set(__self__, "array_values", array_values)
        pulumi.set(__self__, "struct_values", struct_values)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="arrayValues")
    def array_values(self) -> Sequence['outputs.QueryParameterValueResponse']:
        """
        [Optional] The array values, if this is an array type.
        """
        return pulumi.get(self, "array_values")

    @property
    @pulumi.getter(name="structValues")
    def struct_values(self) -> Mapping[str, str]:
        """
        [Optional] The struct field values, in order of the struct type's declaration.
        """
        return pulumi.get(self, "struct_values")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        [Optional] The value of this value, if a simple scalar type.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class QueryTimelineSampleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeUnits":
            suggest = "active_units"
        elif key == "completedUnits":
            suggest = "completed_units"
        elif key == "elapsedMs":
            suggest = "elapsed_ms"
        elif key == "pendingUnits":
            suggest = "pending_units"
        elif key == "totalSlotMs":
            suggest = "total_slot_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryTimelineSampleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryTimelineSampleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryTimelineSampleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_units: str,
                 completed_units: str,
                 elapsed_ms: str,
                 pending_units: str,
                 total_slot_ms: str):
        """
        :param str active_units: Total number of units currently being processed by workers. This does not correspond directly to slot usage. This is the largest value observed since the last sample.
        :param str completed_units: Total parallel units of work completed by this query.
        :param str elapsed_ms: Milliseconds elapsed since the start of query execution.
        :param str pending_units: Total parallel units of work remaining for the active stages.
        :param str total_slot_ms: Cumulative slot-ms consumed by the query.
        """
        pulumi.set(__self__, "active_units", active_units)
        pulumi.set(__self__, "completed_units", completed_units)
        pulumi.set(__self__, "elapsed_ms", elapsed_ms)
        pulumi.set(__self__, "pending_units", pending_units)
        pulumi.set(__self__, "total_slot_ms", total_slot_ms)

    @property
    @pulumi.getter(name="activeUnits")
    def active_units(self) -> str:
        """
        Total number of units currently being processed by workers. This does not correspond directly to slot usage. This is the largest value observed since the last sample.
        """
        return pulumi.get(self, "active_units")

    @property
    @pulumi.getter(name="completedUnits")
    def completed_units(self) -> str:
        """
        Total parallel units of work completed by this query.
        """
        return pulumi.get(self, "completed_units")

    @property
    @pulumi.getter(name="elapsedMs")
    def elapsed_ms(self) -> str:
        """
        Milliseconds elapsed since the start of query execution.
        """
        return pulumi.get(self, "elapsed_ms")

    @property
    @pulumi.getter(name="pendingUnits")
    def pending_units(self) -> str:
        """
        Total parallel units of work remaining for the active stages.
        """
        return pulumi.get(self, "pending_units")

    @property
    @pulumi.getter(name="totalSlotMs")
    def total_slot_ms(self) -> str:
        """
        Cumulative slot-ms consumed by the query.
        """
        return pulumi.get(self, "total_slot_ms")


@pulumi.output_type
class RangePartitioningRangeResponse(dict):
    """
    [TrustedTester] [Required] Defines the ranges for range partitioning.
    """
    def __init__(__self__, *,
                 end: str,
                 interval: str,
                 start: str):
        """
        [TrustedTester] [Required] Defines the ranges for range partitioning.
        :param str end: [TrustedTester] [Required] The end of range partitioning, exclusive.
        :param str interval: [TrustedTester] [Required] The width of each interval.
        :param str start: [TrustedTester] [Required] The start of range partitioning, inclusive.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        [TrustedTester] [Required] The end of range partitioning, exclusive.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def interval(self) -> str:
        """
        [TrustedTester] [Required] The width of each interval.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        [TrustedTester] [Required] The start of range partitioning, inclusive.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class RangePartitioningResponse(dict):
    def __init__(__self__, *,
                 field: str,
                 range: 'outputs.RangePartitioningRangeResponse'):
        """
        :param str field: [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
        :param 'RangePartitioningRangeResponse' range: [TrustedTester] [Required] Defines the ranges for range partitioning.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def range(self) -> 'outputs.RangePartitioningRangeResponse':
        """
        [TrustedTester] [Required] Defines the ranges for range partitioning.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class RemoteFunctionOptionsResponse(dict):
    """
    Options for a remote user-defined function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchingRows":
            suggest = "max_batching_rows"
        elif key == "userDefinedContext":
            suggest = "user_defined_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemoteFunctionOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemoteFunctionOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemoteFunctionOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection: str,
                 endpoint: str,
                 max_batching_rows: str,
                 user_defined_context: Mapping[str, str]):
        """
        Options for a remote user-defined function.
        :param str connection: Fully qualified name of the user-provided connection object which holds the authentication information to send requests to the remote service. projects/{project_id}/locations/{location_id}/connections/{connection_id}
        :param str endpoint: Endpoint of the user-provided remote service (e.g. a function url in Google Cloud Functions).
        :param str max_batching_rows: Max number of rows in each batch sent to the remote service. If absent or if 0, it means no limit.
        :param Mapping[str, str] user_defined_context: User-defined context as a set of key/value pairs, which will be sent as function invocation context together with batched arguments in the requests to the remote service. The total number of bytes of keys and values must be less than 8KB.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "max_batching_rows", max_batching_rows)
        pulumi.set(__self__, "user_defined_context", user_defined_context)

    @property
    @pulumi.getter
    def connection(self) -> str:
        """
        Fully qualified name of the user-provided connection object which holds the authentication information to send requests to the remote service. projects/{project_id}/locations/{location_id}/connections/{connection_id}
        """
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint of the user-provided remote service (e.g. a function url in Google Cloud Functions).
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="maxBatchingRows")
    def max_batching_rows(self) -> str:
        """
        Max number of rows in each batch sent to the remote service. If absent or if 0, it means no limit.
        """
        return pulumi.get(self, "max_batching_rows")

    @property
    @pulumi.getter(name="userDefinedContext")
    def user_defined_context(self) -> Mapping[str, str]:
        """
        User-defined context as a set of key/value pairs, which will be sent as function invocation context together with batched arguments in the requests to the remote service. The total number of bytes of keys and values must be less than 8KB.
        """
        return pulumi.get(self, "user_defined_context")


@pulumi.output_type
class RoutineReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "routineId":
            suggest = "routine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutineReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutineReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutineReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project: str,
                 routine_id: str):
        """
        :param str dataset_id: [Required] The ID of the dataset containing this routine.
        :param str project: [Required] The ID of the project containing this routine.
        :param str routine_id: [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "routine_id", routine_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        [Required] The ID of the dataset containing this routine.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        [Required] The ID of the project containing this routine.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> str:
        """
        [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "routine_id")


@pulumi.output_type
class RowAccessPolicyReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "policyId":
            suggest = "policy_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RowAccessPolicyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RowAccessPolicyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RowAccessPolicyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 policy_id: str,
                 project: str,
                 table_id: str):
        """
        :param str dataset_id: [Required] The ID of the dataset containing this row access policy.
        :param str policy_id: [Required] The ID of the row access policy. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param str project: [Required] The ID of the project containing this row access policy.
        :param str table_id: [Required] The ID of the table containing this row access policy.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        [Required] The ID of the dataset containing this row access policy.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        """
        [Required] The ID of the row access policy. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        [Required] The ID of the project containing this row access policy.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        [Required] The ID of the table containing this row access policy.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class RowLevelSecurityStatisticsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rowLevelSecurityApplied":
            suggest = "row_level_security_applied"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RowLevelSecurityStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RowLevelSecurityStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RowLevelSecurityStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 row_level_security_applied: bool):
        """
        :param bool row_level_security_applied: [Preview] Whether any accessed data was protected by row access policies.
        """
        pulumi.set(__self__, "row_level_security_applied", row_level_security_applied)

    @property
    @pulumi.getter(name="rowLevelSecurityApplied")
    def row_level_security_applied(self) -> bool:
        """
        [Preview] Whether any accessed data was protected by row access policies.
        """
        return pulumi.get(self, "row_level_security_applied")


@pulumi.output_type
class ScriptStackFrameResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endColumn":
            suggest = "end_column"
        elif key == "endLine":
            suggest = "end_line"
        elif key == "procedureId":
            suggest = "procedure_id"
        elif key == "startColumn":
            suggest = "start_column"
        elif key == "startLine":
            suggest = "start_line"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptStackFrameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptStackFrameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptStackFrameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_column: int,
                 end_line: int,
                 procedure_id: str,
                 start_column: int,
                 start_line: int,
                 text: str):
        """
        :param int end_column: One-based end column.
        :param int end_line: One-based end line.
        :param str procedure_id: Name of the active procedure, empty if in a top-level script.
        :param int start_column: One-based start column.
        :param int start_line: One-based start line.
        :param str text: Text of the current statement/expression.
        """
        pulumi.set(__self__, "end_column", end_column)
        pulumi.set(__self__, "end_line", end_line)
        pulumi.set(__self__, "procedure_id", procedure_id)
        pulumi.set(__self__, "start_column", start_column)
        pulumi.set(__self__, "start_line", start_line)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="endColumn")
    def end_column(self) -> int:
        """
        One-based end column.
        """
        return pulumi.get(self, "end_column")

    @property
    @pulumi.getter(name="endLine")
    def end_line(self) -> int:
        """
        One-based end line.
        """
        return pulumi.get(self, "end_line")

    @property
    @pulumi.getter(name="procedureId")
    def procedure_id(self) -> str:
        """
        Name of the active procedure, empty if in a top-level script.
        """
        return pulumi.get(self, "procedure_id")

    @property
    @pulumi.getter(name="startColumn")
    def start_column(self) -> int:
        """
        One-based start column.
        """
        return pulumi.get(self, "start_column")

    @property
    @pulumi.getter(name="startLine")
    def start_line(self) -> int:
        """
        One-based start line.
        """
        return pulumi.get(self, "start_line")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Text of the current statement/expression.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class ScriptStatisticsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationKind":
            suggest = "evaluation_kind"
        elif key == "stackFrames":
            suggest = "stack_frames"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_kind: str,
                 stack_frames: Sequence['outputs.ScriptStackFrameResponse']):
        """
        :param str evaluation_kind: Whether this child job was a statement or expression.
        :param Sequence['ScriptStackFrameResponse'] stack_frames: Stack trace showing the line/column/procedure name of each frame on the stack at the point where the current evaluation happened. The leaf frame is first, the primary script is last. Never empty.
        """
        pulumi.set(__self__, "evaluation_kind", evaluation_kind)
        pulumi.set(__self__, "stack_frames", stack_frames)

    @property
    @pulumi.getter(name="evaluationKind")
    def evaluation_kind(self) -> str:
        """
        Whether this child job was a statement or expression.
        """
        return pulumi.get(self, "evaluation_kind")

    @property
    @pulumi.getter(name="stackFrames")
    def stack_frames(self) -> Sequence['outputs.ScriptStackFrameResponse']:
        """
        Stack trace showing the line/column/procedure name of each frame on the stack at the point where the current evaluation happened. The leaf frame is first, the primary script is last. Never empty.
        """
        return pulumi.get(self, "stack_frames")


@pulumi.output_type
class SessionInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionId":
            suggest = "session_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SessionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SessionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SessionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 session_id: str):
        """
        :param str session_id: // [Preview] Id of the session.
        """
        pulumi.set(__self__, "session_id", session_id)

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> str:
        """
        // [Preview] Id of the session.
        """
        return pulumi.get(self, "session_id")


@pulumi.output_type
class SnapshotDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseTableReference":
            suggest = "base_table_reference"
        elif key == "snapshotTime":
            suggest = "snapshot_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_table_reference: 'outputs.TableReferenceResponse',
                 snapshot_time: str):
        """
        :param 'TableReferenceResponse' base_table_reference: [Required] Reference describing the ID of the table that was snapshot.
        :param str snapshot_time: [Required] The time at which the base table was snapshot. This value is reported in the JSON response using RFC3339 format.
        """
        pulumi.set(__self__, "base_table_reference", base_table_reference)
        pulumi.set(__self__, "snapshot_time", snapshot_time)

    @property
    @pulumi.getter(name="baseTableReference")
    def base_table_reference(self) -> 'outputs.TableReferenceResponse':
        """
        [Required] Reference describing the ID of the table that was snapshot.
        """
        return pulumi.get(self, "base_table_reference")

    @property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> str:
        """
        [Required] The time at which the base table was snapshot. This value is reported in the JSON response using RFC3339 format.
        """
        return pulumi.get(self, "snapshot_time")


@pulumi.output_type
class StandardSqlDataTypeResponse(dict):
    """
    The data type of a variable such as a function argument. Examples include: * INT64: `{"typeKind": "INT64"}` * ARRAY: { "typeKind": "ARRAY", "arrayElementType": {"typeKind": "STRING"} } * STRUCT>: { "typeKind": "STRUCT", "structType": { "fields": [ { "name": "x", "type": {"typeKind: "STRING"} }, { "name": "y", "type": { "typeKind": "ARRAY", "arrayElementType": {"typekind": "DATE"} } } ] } }
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arrayElementType":
            suggest = "array_element_type"
        elif key == "structType":
            suggest = "struct_type"
        elif key == "typeKind":
            suggest = "type_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSqlDataTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSqlDataTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSqlDataTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 array_element_type: 'outputs.StandardSqlDataTypeResponse',
                 struct_type: 'outputs.StandardSqlStructTypeResponse',
                 type_kind: str):
        """
        The data type of a variable such as a function argument. Examples include: * INT64: `{"typeKind": "INT64"}` * ARRAY: { "typeKind": "ARRAY", "arrayElementType": {"typeKind": "STRING"} } * STRUCT>: { "typeKind": "STRUCT", "structType": { "fields": [ { "name": "x", "type": {"typeKind: "STRING"} }, { "name": "y", "type": { "typeKind": "ARRAY", "arrayElementType": {"typekind": "DATE"} } } ] } }
        :param 'StandardSqlDataTypeResponse' array_element_type: The type of the array's elements, if type_kind = "ARRAY".
        :param 'StandardSqlStructTypeResponse' struct_type: The fields of this struct, in order, if type_kind = "STRUCT".
        :param str type_kind: The top level type of this field. Can be any standard SQL data type (e.g., "INT64", "DATE", "ARRAY").
        """
        pulumi.set(__self__, "array_element_type", array_element_type)
        pulumi.set(__self__, "struct_type", struct_type)
        pulumi.set(__self__, "type_kind", type_kind)

    @property
    @pulumi.getter(name="arrayElementType")
    def array_element_type(self) -> 'outputs.StandardSqlDataTypeResponse':
        """
        The type of the array's elements, if type_kind = "ARRAY".
        """
        return pulumi.get(self, "array_element_type")

    @property
    @pulumi.getter(name="structType")
    def struct_type(self) -> 'outputs.StandardSqlStructTypeResponse':
        """
        The fields of this struct, in order, if type_kind = "STRUCT".
        """
        return pulumi.get(self, "struct_type")

    @property
    @pulumi.getter(name="typeKind")
    def type_kind(self) -> str:
        """
        The top level type of this field. Can be any standard SQL data type (e.g., "INT64", "DATE", "ARRAY").
        """
        return pulumi.get(self, "type_kind")


@pulumi.output_type
class StandardSqlFieldResponse(dict):
    """
    A field or a column.
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'outputs.StandardSqlDataTypeResponse'):
        """
        A field or a column.
        :param str name: Optional. The name of this field. Can be absent for struct fields.
        :param 'StandardSqlDataTypeResponse' type: Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION statement can omit the return type; in this case the output parameter does not have this "type" field).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. The name of this field. Can be absent for struct fields.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'outputs.StandardSqlDataTypeResponse':
        """
        Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION statement can omit the return type; in this case the output parameter does not have this "type" field).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StandardSqlStructTypeResponse(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.StandardSqlFieldResponse']):
        pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.StandardSqlFieldResponse']:
        return pulumi.get(self, "fields")


@pulumi.output_type
class StandardSqlTableTypeResponse(dict):
    """
    A table type
    """
    def __init__(__self__, *,
                 columns: Sequence['outputs.StandardSqlFieldResponse']):
        """
        A table type
        :param Sequence['StandardSqlFieldResponse'] columns: The columns in this table type
        """
        pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.StandardSqlFieldResponse']:
        """
        The columns in this table type
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class StreamingbufferResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "estimatedBytes":
            suggest = "estimated_bytes"
        elif key == "estimatedRows":
            suggest = "estimated_rows"
        elif key == "oldestEntryTime":
            suggest = "oldest_entry_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingbufferResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingbufferResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingbufferResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 estimated_bytes: str,
                 estimated_rows: str,
                 oldest_entry_time: str):
        """
        :param str estimated_bytes: A lower-bound estimate of the number of bytes currently in the streaming buffer.
        :param str estimated_rows: A lower-bound estimate of the number of rows currently in the streaming buffer.
        :param str oldest_entry_time: Contains the timestamp of the oldest entry in the streaming buffer, in milliseconds since the epoch, if the streaming buffer is available.
        """
        pulumi.set(__self__, "estimated_bytes", estimated_bytes)
        pulumi.set(__self__, "estimated_rows", estimated_rows)
        pulumi.set(__self__, "oldest_entry_time", oldest_entry_time)

    @property
    @pulumi.getter(name="estimatedBytes")
    def estimated_bytes(self) -> str:
        """
        A lower-bound estimate of the number of bytes currently in the streaming buffer.
        """
        return pulumi.get(self, "estimated_bytes")

    @property
    @pulumi.getter(name="estimatedRows")
    def estimated_rows(self) -> str:
        """
        A lower-bound estimate of the number of rows currently in the streaming buffer.
        """
        return pulumi.get(self, "estimated_rows")

    @property
    @pulumi.getter(name="oldestEntryTime")
    def oldest_entry_time(self) -> str:
        """
        Contains the timestamp of the oldest entry in the streaming buffer, in milliseconds since the epoch, if the streaming buffer is available.
        """
        return pulumi.get(self, "oldest_entry_time")


@pulumi.output_type
class TableFieldSchemaCategoriesResponse(dict):
    """
    [Optional] The categories attached to this field, used for field-level access control.
    """
    def __init__(__self__, *,
                 names: Sequence[str]):
        """
        [Optional] The categories attached to this field, used for field-level access control.
        :param Sequence[str] names: A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most 5 categories are allowed.
        """
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most 5 categories are allowed.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class TableFieldSchemaPolicyTagsResponse(dict):
    def __init__(__self__, *,
                 names: Sequence[str]):
        """
        :param Sequence[str] names: A list of category resource names. For example, "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
        """
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of category resource names. For example, "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class TableFieldSchemaResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValueExpression":
            suggest = "default_value_expression"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "policyTags":
            suggest = "policy_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableFieldSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableFieldSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableFieldSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: 'outputs.TableFieldSchemaCategoriesResponse',
                 collation: str,
                 default_value_expression: str,
                 description: str,
                 fields: Sequence['outputs.TableFieldSchemaResponse'],
                 max_length: str,
                 mode: str,
                 name: str,
                 policy_tags: 'outputs.TableFieldSchemaPolicyTagsResponse',
                 precision: str,
                 scale: str,
                 type: str):
        """
        :param 'TableFieldSchemaCategoriesResponse' categories: [Optional] The categories attached to this field, used for field-level access control.
        :param str collation: Optional. Collation specification of the field. It only can be set on string type field.
        :param str default_value_expression: Optional. A SQL expression to specify the default value for this field. It can only be set for top level fields (columns). You can use struct or array expression to specify default value for the entire struct or array. The valid SQL expressions are: - Literals for all data types, including STRUCT and ARRAY. - Following functions: - CURRENT_TIMESTAMP - CURRENT_TIME - CURRENT_DATE - CURRENT_DATETIME - GENERATE_UUID - RAND - SESSION_USER - ST_GEOGPOINT - Struct or array composed with the above allowed functions, for example, [CURRENT_DATE(), DATE '2020-01-01']
        :param str description: [Optional] The field description. The maximum length is 1,024 characters.
        :param Sequence['TableFieldSchemaResponse'] fields: [Optional] Describes the nested schema fields if the type property is set to RECORD.
        :param str max_length: [Optional] Maximum length of values of this field for STRINGS or BYTES. If max_length is not specified, no maximum length constraint is imposed on this field. If type = "STRING", then max_length represents the maximum UTF-8 length of strings in this field. If type = "BYTES", then max_length represents the maximum number of bytes in this field. It is invalid to set this field if type ≠ "STRING" and ≠ "BYTES".
        :param str mode: [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default value is NULLABLE.
        :param str name: [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and must start with a letter or underscore. The maximum length is 300 characters.
        :param str precision: [Optional] Precision (maximum number of total digits in base 10) and scale (maximum number of digits in the fractional part in base 10) constraints for values of this field for NUMERIC or BIGNUMERIC. It is invalid to set precision or scale if type ≠ "NUMERIC" and ≠ "BIGNUMERIC". If precision and scale are not specified, no value range constraint is imposed on this field insofar as values are permitted by the type. Values of this NUMERIC or BIGNUMERIC field must be in this range when: - Precision (P) and scale (S) are specified: [-10P-S + 10-S, 10P-S - 10-S] - Precision (P) is specified but not scale (and thus scale is interpreted to be equal to zero): [-10P + 1, 10P - 1]. Acceptable values for precision and scale if both are specified: - If type = "NUMERIC": 1 ≤ precision - scale ≤ 29 and 0 ≤ scale ≤ 9. - If type = "BIGNUMERIC": 1 ≤ precision - scale ≤ 38 and 0 ≤ scale ≤ 38. Acceptable values for precision if only precision is specified but not scale (and thus scale is interpreted to be equal to zero): - If type = "NUMERIC": 1 ≤ precision ≤ 29. - If type = "BIGNUMERIC": 1 ≤ precision ≤ 38. If scale is specified but not precision, then it is invalid.
        :param str scale: [Optional] See documentation for precision.
        :param str type: [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as INTEGER), FLOAT, FLOAT64 (same as FLOAT), NUMERIC, BIGNUMERIC, BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE, TIME, DATETIME, INTERVAL, RECORD (where RECORD indicates that the field contains a nested schema) or STRUCT (same as RECORD).
        """
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "default_value_expression", default_value_expression)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "max_length", max_length)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy_tags", policy_tags)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "scale", scale)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def categories(self) -> 'outputs.TableFieldSchemaCategoriesResponse':
        """
        [Optional] The categories attached to this field, used for field-level access control.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def collation(self) -> str:
        """
        Optional. Collation specification of the field. It only can be set on string type field.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="defaultValueExpression")
    def default_value_expression(self) -> str:
        """
        Optional. A SQL expression to specify the default value for this field. It can only be set for top level fields (columns). You can use struct or array expression to specify default value for the entire struct or array. The valid SQL expressions are: - Literals for all data types, including STRUCT and ARRAY. - Following functions: - CURRENT_TIMESTAMP - CURRENT_TIME - CURRENT_DATE - CURRENT_DATETIME - GENERATE_UUID - RAND - SESSION_USER - ST_GEOGPOINT - Struct or array composed with the above allowed functions, for example, [CURRENT_DATE(), DATE '2020-01-01']
        """
        return pulumi.get(self, "default_value_expression")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        [Optional] The field description. The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.TableFieldSchemaResponse']:
        """
        [Optional] Describes the nested schema fields if the type property is set to RECORD.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> str:
        """
        [Optional] Maximum length of values of this field for STRINGS or BYTES. If max_length is not specified, no maximum length constraint is imposed on this field. If type = "STRING", then max_length represents the maximum UTF-8 length of strings in this field. If type = "BYTES", then max_length represents the maximum number of bytes in this field. It is invalid to set this field if type ≠ "STRING" and ≠ "BYTES".
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default value is NULLABLE.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and must start with a letter or underscore. The maximum length is 300 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyTags")
    def policy_tags(self) -> 'outputs.TableFieldSchemaPolicyTagsResponse':
        return pulumi.get(self, "policy_tags")

    @property
    @pulumi.getter
    def precision(self) -> str:
        """
        [Optional] Precision (maximum number of total digits in base 10) and scale (maximum number of digits in the fractional part in base 10) constraints for values of this field for NUMERIC or BIGNUMERIC. It is invalid to set precision or scale if type ≠ "NUMERIC" and ≠ "BIGNUMERIC". If precision and scale are not specified, no value range constraint is imposed on this field insofar as values are permitted by the type. Values of this NUMERIC or BIGNUMERIC field must be in this range when: - Precision (P) and scale (S) are specified: [-10P-S + 10-S, 10P-S - 10-S] - Precision (P) is specified but not scale (and thus scale is interpreted to be equal to zero): [-10P + 1, 10P - 1]. Acceptable values for precision and scale if both are specified: - If type = "NUMERIC": 1 ≤ precision - scale ≤ 29 and 0 ≤ scale ≤ 9. - If type = "BIGNUMERIC": 1 ≤ precision - scale ≤ 38 and 0 ≤ scale ≤ 38. Acceptable values for precision if only precision is specified but not scale (and thus scale is interpreted to be equal to zero): - If type = "NUMERIC": 1 ≤ precision ≤ 29. - If type = "BIGNUMERIC": 1 ≤ precision ≤ 38. If scale is specified but not precision, then it is invalid.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def scale(self) -> str:
        """
        [Optional] See documentation for precision.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as INTEGER), FLOAT, FLOAT64 (same as FLOAT), NUMERIC, BIGNUMERIC, BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE, TIME, DATETIME, INTERVAL, RECORD (where RECORD indicates that the field contains a nested schema) or STRUCT (same as RECORD).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project: str,
                 table_id: str):
        """
        :param str dataset_id: [Required] The ID of the dataset containing this table.
        :param str project: [Required] The ID of the project containing this table.
        :param str table_id: [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        [Required] The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        [Required] The ID of the project containing this table.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class TableSchemaResponse(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.TableFieldSchemaResponse']):
        """
        :param Sequence['TableFieldSchemaResponse'] fields: Describes the fields in a table.
        """
        pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.TableFieldSchemaResponse']:
        """
        Describes the fields in a table.
        """
        return pulumi.get(self, "fields")


@pulumi.output_type
class TimePartitioningResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationMs":
            suggest = "expiration_ms"
        elif key == "requirePartitionFilter":
            suggest = "require_partition_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimePartitioningResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimePartitioningResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimePartitioningResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_ms: str,
                 field: str,
                 require_partition_filter: bool,
                 type: str):
        """
        :param str expiration_ms: [Optional] Number of milliseconds for which to keep the storage for partitions in the table. The storage in a partition will have an expiration time of its partition time plus this value.
        :param str field: [Beta] [Optional] If not set, the table is partitioned by pseudo column, referenced via either '_PARTITIONTIME' as TIMESTAMP type, or '_PARTITIONDATE' as DATE type. If field is specified, the table is instead partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        :param str type: [Required] The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively. When the type is not specified, the default behavior is DAY.
        """
        pulumi.set(__self__, "expiration_ms", expiration_ms)
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> str:
        """
        [Optional] Number of milliseconds for which to keep the storage for partitions in the table. The storage in a partition will have an expiration time of its partition time plus this value.
        """
        return pulumi.get(self, "expiration_ms")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        [Beta] [Optional] If not set, the table is partitioned by pseudo column, referenced via either '_PARTITIONTIME' as TIMESTAMP type, or '_PARTITIONDATE' as DATE type. If field is specified, the table is instead partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> bool:
        return pulumi.get(self, "require_partition_filter")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        [Required] The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively. When the type is not specified, the default behavior is DAY.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TransactionInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transactionId":
            suggest = "transaction_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransactionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransactionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransactionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transaction_id: str):
        """
        :param str transaction_id: // [Alpha] Id of the transaction.
        """
        pulumi.set(__self__, "transaction_id", transaction_id)

    @property
    @pulumi.getter(name="transactionId")
    def transaction_id(self) -> str:
        """
        // [Alpha] Id of the transaction.
        """
        return pulumi.get(self, "transaction_id")


@pulumi.output_type
class UserDefinedFunctionResourceResponse(dict):
    """
    This is used for defining User Defined Function (UDF) resources only when using legacy SQL. Users of Standard SQL should leverage either DDL (e.g. CREATE [TEMPORARY] FUNCTION ... ) or the Routines API to define UDF resources. For additional information on migrating, see: https://cloud.google.com/bigquery/docs/reference/standard-sql/migrating-from-legacy-sql#differences_in_user-defined_javascript_functions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inlineCode":
            suggest = "inline_code"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserDefinedFunctionResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserDefinedFunctionResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserDefinedFunctionResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline_code: str,
                 resource_uri: str):
        """
        This is used for defining User Defined Function (UDF) resources only when using legacy SQL. Users of Standard SQL should leverage either DDL (e.g. CREATE [TEMPORARY] FUNCTION ... ) or the Routines API to define UDF resources. For additional information on migrating, see: https://cloud.google.com/bigquery/docs/reference/standard-sql/migrating-from-legacy-sql#differences_in_user-defined_javascript_functions
        :param str inline_code: [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        :param str resource_uri: [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        pulumi.set(__self__, "inline_code", inline_code)
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="inlineCode")
    def inline_code(self) -> str:
        """
        [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        """
        return pulumi.get(self, "inline_code")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        """
        [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class ViewDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useExplicitColumnNames":
            suggest = "use_explicit_column_names"
        elif key == "useLegacySql":
            suggest = "use_legacy_sql"
        elif key == "userDefinedFunctionResources":
            suggest = "user_defined_function_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ViewDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ViewDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ViewDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: str,
                 use_explicit_column_names: bool,
                 use_legacy_sql: bool,
                 user_defined_function_resources: Sequence['outputs.UserDefinedFunctionResourceResponse']):
        """
        :param str query: [Required] A query that BigQuery executes when the view is referenced.
        :param bool use_explicit_column_names: True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1, c2) AS ...' syntax. Can only be set using BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/
        :param bool use_legacy_sql: Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ Queries and views that reference this view must use the same flag value.
        :param Sequence['UserDefinedFunctionResourceResponse'] user_defined_function_resources: Describes user-defined function resources used in the query.
        """
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "use_explicit_column_names", use_explicit_column_names)
        pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)
        pulumi.set(__self__, "user_defined_function_resources", user_defined_function_resources)

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        [Required] A query that BigQuery executes when the view is referenced.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="useExplicitColumnNames")
    def use_explicit_column_names(self) -> bool:
        """
        True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1, c2) AS ...' syntax. Can only be set using BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/
        """
        return pulumi.get(self, "use_explicit_column_names")

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> bool:
        """
        Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ Queries and views that reference this view must use the same flag value.
        """
        return pulumi.get(self, "use_legacy_sql")

    @property
    @pulumi.getter(name="userDefinedFunctionResources")
    def user_defined_function_resources(self) -> Sequence['outputs.UserDefinedFunctionResourceResponse']:
        """
        Describes user-defined function resources used in the query.
        """
        return pulumi.get(self, "user_defined_function_resources")


