# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetSpecResult',
    'AwaitableGetSpecResult',
    'get_spec',
    'get_spec_output',
]

@pulumi.output_type
class GetSpecResult:
    def __init__(__self__, annotations=None, contents=None, create_time=None, description=None, filename=None, hash=None, labels=None, mime_type=None, name=None, revision_create_time=None, revision_id=None, revision_update_time=None, size_bytes=None, source_uri=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if contents and not isinstance(contents, str):
            raise TypeError("Expected argument 'contents' to be a str")
        pulumi.set(__self__, "contents", contents)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filename and not isinstance(filename, str):
            raise TypeError("Expected argument 'filename' to be a str")
        pulumi.set(__self__, "filename", filename)
        if hash and not isinstance(hash, str):
            raise TypeError("Expected argument 'hash' to be a str")
        pulumi.set(__self__, "hash", hash)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if mime_type and not isinstance(mime_type, str):
            raise TypeError("Expected argument 'mime_type' to be a str")
        pulumi.set(__self__, "mime_type", mime_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if revision_create_time and not isinstance(revision_create_time, str):
            raise TypeError("Expected argument 'revision_create_time' to be a str")
        pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)
        if revision_update_time and not isinstance(revision_update_time, str):
            raise TypeError("Expected argument 'revision_update_time' to be a str")
        pulumi.set(__self__, "revision_update_time", revision_update_time)
        if size_bytes and not isinstance(size_bytes, int):
            raise TypeError("Expected argument 'size_bytes' to be a int")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if source_uri and not isinstance(source_uri, str):
            raise TypeError("Expected argument 'source_uri' to be a str")
        pulumi.set(__self__, "source_uri", source_uri)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Annotations attach non-identifying metadata to resources. Annotation keys and values are less restricted than those of labels, but should be generally used for small values of broad interest. Larger, topic- specific metadata should be stored in Artifacts.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def contents(self) -> str:
        """
        Input only. The contents of the spec. Provided by API callers when specs are created or updated. To access the contents of a spec, use GetApiSpecContents.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation timestamp; when the spec resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A detailed description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filename(self) -> str:
        """
        A possibly-hierarchical name used to refer to the spec from other specs.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter
    def hash(self) -> str:
        """
        A SHA-256 hash of the spec's contents. If the spec is gzipped, this is the hash of the uncompressed spec.
        """
        return pulumi.get(self, "hash")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels attach identifying metadata to resources. Identifying metadata can be used to filter list operations. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one resource (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "apigeeregistry.googleapis.com/" and cannot be changed.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        A style (format) descriptor for this spec that is specified as a Media Type (https://en.wikipedia.org/wiki/Media_type). Possible values include "application/vnd.apigee.proto", "application/vnd.apigee.openapi", and "application/vnd.apigee.graphql", with possible suffixes representing compression types. These hypothetical names are defined in the vendor tree defined in RFC6838 (https://tools.ietf.org/html/rfc6838) and are not final. Content types can specify compression. Currently only GZip compression is supported (indicated with "+gzip").
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> str:
        """
        Revision creation timestamp; when the represented revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Immutable. The revision ID of the spec. A new revision is committed whenever the spec contents are changed. The format is an 8-character hexadecimal string.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter(name="revisionUpdateTime")
    def revision_update_time(self) -> str:
        """
        Last update timestamp: when the represented revision was last modified.
        """
        return pulumi.get(self, "revision_update_time")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> int:
        """
        The size of the spec file in bytes. If the spec is gzipped, this is the size of the uncompressed spec.
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> str:
        """
        The original source URI of the spec (if one exists). This is an external location that can be used for reference purposes but which may not be authoritative since this external resource may change after the spec is retrieved.
        """
        return pulumi.get(self, "source_uri")


class AwaitableGetSpecResult(GetSpecResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpecResult(
            annotations=self.annotations,
            contents=self.contents,
            create_time=self.create_time,
            description=self.description,
            filename=self.filename,
            hash=self.hash,
            labels=self.labels,
            mime_type=self.mime_type,
            name=self.name,
            revision_create_time=self.revision_create_time,
            revision_id=self.revision_id,
            revision_update_time=self.revision_update_time,
            size_bytes=self.size_bytes,
            source_uri=self.source_uri)


def get_spec(api_id: Optional[str] = None,
             location: Optional[str] = None,
             project: Optional[str] = None,
             spec_id: Optional[str] = None,
             version_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpecResult:
    """
    GetApiSpec returns a specified spec.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['specId'] = spec_id
    __args__['versionId'] = version_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigeeregistry/v1:getSpec', __args__, opts=opts, typ=GetSpecResult).value

    return AwaitableGetSpecResult(
        annotations=__ret__.annotations,
        contents=__ret__.contents,
        create_time=__ret__.create_time,
        description=__ret__.description,
        filename=__ret__.filename,
        hash=__ret__.hash,
        labels=__ret__.labels,
        mime_type=__ret__.mime_type,
        name=__ret__.name,
        revision_create_time=__ret__.revision_create_time,
        revision_id=__ret__.revision_id,
        revision_update_time=__ret__.revision_update_time,
        size_bytes=__ret__.size_bytes,
        source_uri=__ret__.source_uri)


@_utilities.lift_output_func(get_spec)
def get_spec_output(api_id: Optional[pulumi.Input[str]] = None,
                    location: Optional[pulumi.Input[str]] = None,
                    project: Optional[pulumi.Input[Optional[str]]] = None,
                    spec_id: Optional[pulumi.Input[str]] = None,
                    version_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSpecResult]:
    """
    GetApiSpec returns a specified spec.
    """
    ...
